# $Id$
#-------------------------------------------------------------------------------
# プラグイン用共通Makefile
#
#-------------------------------------------------------------------------------
# プラグインライブラリはこのMakefile を必ずinclude すること。
#
# 個々のMakefile で定義可能な変数
# ============================================
#	NAME         : プラグインの基本名称 (MUST)
#	SDKDIR       : プラグインSDKのトップディレクトリパス (MUST)
#	(残りはrules.mk 参照)
#
# 個々のMakefile で再定義可能なするターゲット
# ============================================
#	INSTALL_TARGETS   : make install のターゲット (MUST)
#	UNINSTALL_TARGETS : make uninstall のターゲット (MUST)
#
#-------------------------------------------------------------------------------

# default target
all: all-local

# include common makefile
include $(SDKDIR)/build/rules.mk

#--------------------------------------
# Define values for plugin
#--------------------------------------
PLUGINDIR = $(PLUGINBASEDIR)/$(NAME)
PROGRAM = tfspm_$(NAME).la
STOBJS = $(PROGRAM:.la=.a)
SOOBJS = $(PROGRAM:.la=.so)

ifndef INSTALL_TARGETS
INSTALL_TARGETS = install-plugin
endif

ifndef UNINSTALL_TARGETS
UNINSTALL_TARGETS = uninstall-plugin
endif

#--------------------------------------
# Build target
#--------------------------------------
all-local: x-all $(PROGRAM) conf/plugin.xml

$(PROGRAM): $(OBJS)
	@if test "x$(PLUGINTYPE)" != "xscript"; then \
		$(DLL_LINK) -rpath $(PLUGINDIR) $(LOBJS) ;\
	fi ;

conf/plugin.xml: conf/plugin.xml.in
	@cat $< | sed -e 's:@prefix@:$(SDKDIR):g' > $@

#--------------------------------------
# Install target
#--------------------------------------
install: all $(INSTALL_TARGETS)

install-plugin:
	@if test ! -d $(DESTDIR)$(PLUGINDIR) ; then \
		$(INSTALL) -m 755 -d $(DESTDIR)$(PLUGINDIR) ; \
	fi ; \
	if test ! -d $(DESTDIR)$(PLUGINDIR) ; then \
		$(INSTALL) -m 755 -d $(DESTDIR)$(PLUGINDIR) ; \
	fi ; \
	if test ! -d $(DESTDIR)$(PLUGINDIR)/conf; then \
		$(INSTALL) -m 755 -d $(DESTDIR)$(PLUGINDIR)/conf ; \
	fi ; \
	if test ! -d $(DESTDIR)$(PLUGINDIR)/cgi-bin; then \
		$(INSTALL) -m 755 -d $(DESTDIR)$(PLUGINDIR)/cgi-bin ; \
	fi ; \
	if test ! -d $(DESTDIR)$(PLUGINDIR)/uploads; then \
		$(INSTALL) -m 755 -d $(DESTDIR)$(PLUGINDIR)/uploads ; \
	fi ; \
	if test "x$(PLUGINTYPE)" != "xscript"; then \
		$(LIBTOOL) --mode=install cp $(PROGRAM) $(DESTDIR)$(PLUGINDIR) ; \
		$(RM) -f $(DESTDIR)$(PLUGINDIR)/$(PROGRAM) $(DESTDIR)$(PLUGINDIR)/$(STOBJS) ; \
	fi ; \
	if test ! -f $(DESTDIR)$(PLUGINDIR)/plugin.xml; then \
		$(LIBTOOL) --mode=install cp conf/plugin.xml $(DESTDIR)$(PLUGINDIR) ; \
	fi

#--------------------------------------
# Uninstall library
#--------------------------------------
uninstall: $(UNINSTALL_TARGETS)

uninstall-plugin:
	@$(RM) -f $(DESTDIR)$(PLUGINDIR)/$(SOOBJS) $(DESTDIR)$(PLUGINDIR)/plugin.xml

.PHONY: all all-local \
		install install-plugin uninstall uninstall-plugin

