# $Id$
#-------------------------------------------------------------------------------
# 共通Makefile
#
#-------------------------------------------------------------------------------
#
# 呼び出し元Makefile で定義可能な変数
# ============================================
#	SOURCES      : ソースコード(*.c) のファイル名(スペースで区切って複数指定可能) (MUST)
#	SDKDIR       : プラグインSDKのトップディレクトリパス (MUST)
#	VERSION_INFO : 共有ライブラリのlibtoolバージョン番号 (CURRENT:REVISION:AGE)
#	CFLAGS       : コンパイラフラグ
#	CPPFLAGS     : コンパイルフラグ
#	INCLUDES     : include するヘッダファイルのパス
#	LDFLAGS      : リンカフラグ
#	LIBS         : リンカフラグ (-L/xxxx -lxxxx)
#	RLIBS        : 実行時検索パス (-R/xxxx)
#
#	EXTRA_CLEAN     : make clean でクリアしたい特別なファイル
#	EXTRA_DISTCLEAN : make distclean でクリアしたい特別なファイル
#
#-------------------------------------------------------------------------------

# include defined values
include $(SDKDIR)/build/config_vars.mk

#--------------------------------------
# Define values for plugin
#--------------------------------------
OBJS  = $(SOURCES:.c=.$(EXT))
LOBJS = $(SOURCES:.c=.lo)

#--------------------------------------
# Compile and Link options
#--------------------------------------
ALL_CFLAGS   = $(EXTRA_CFLAGS) $(CFLAGS) $(DEFAULT_CFLAGS)
ALL_CPPFLAGS = $(DEFS) $(EXTRA_CPPFLAGS) $(CPPFLAGS) $(DEFAULT_CPPFLAGS)
ALL_INCLUDES = $(INCLUDES) $(EXTRA_INCLUDES)
ALL_LDFLAGS  = $(EXTRA_LDFLAGS) $(LDFLAGS)
ALL_LIBS     = $(EXTRA_LIBS) $(LIBS)
ALL_RLIBS    = $(EXTRA_RLIBS) $(RLIBS)

#--------------------------------------
# Compile commands
#--------------------------------------
COMPILE    = $(CC) $(ALL_CFLAGS) $(ALL_CPPFLAGS) $(ALL_INCLUDES)
DL_COMPILE = $(LIBTOOL) --mode=compile $(COMPILE) -prefer-pic -c $< && touch $@
ST_COMPILE = $(LIBTOOL) --mode=compile $(COMPILE) -prefer-non-pic -static -c $< && touch $@

#--------------------------------------
# Link commands
#--------------------------------------
DLL_LINK = $(LIBTOOL) --mode=link $(COMPILE) -export-dynamic -module -avoid-version $(ALL_LDFLAGS) $(ALL_LIBS) $(ALL_RLIBS) -o $@
LIB_LINK = $(LIBTOOL) --mode=link $(COMPILE) -version-info $(VERSION_INFO) $(ALL_LDFLAGS) $(ALL_LIBS) $(ALL_RLIBS) -o $@
BIN_LINK = $(LIBTOOL) --mode=link $(COMPILE) $(ALL_LDFLAGS) $(ALL_LIBS) $(ALL_RLIBS) -o $@

#--------------------------------------
# Build target
#--------------------------------------
x-all:
	@if test ! -s $(DEPS); then \
		$(MAKE) depend ; \
	fi ; \

depend:
	@if test -n "`find . -name '*.c' -print 2>/dev/null`"; then \
		$(CC) -MM $(ALL_CPPFLAGS) $(ALL_INCLUDES) $(SOURCES) | sed -e '1s|\.o:|.$(EXT):|' > $(DEPS) || true; \
	fi

#--------------------------------------
# Cleanup target
#--------------------------------------
clean:
	$(RM) -f *.o *.lo *.$(EXT) *.a *.la $(EXTRA_CLEAN) $(PROGRAM) $(PROGRAM)
	$(RM) -rf .libs

distclean: clean
	$(RM) -f config.log config.status config.cache configure Makefile $(EXTRA_DISTCLEAN) $(DEPS)
	$(RM) -rf autom4te-2.53.cache autom4te.cache


#--------------------------------------
# Default target rule
#--------------------------------------
.SUFFIXES:
.SUFFIXES: .c .lo .o .$(EXT)

.c.o:
	$(COMPILE) -c $<

.c.lo:
	$(ST_COMPILE)

.c.$(EXT):
	$(DL_COMPILE)


#--------------------------------------
# Dependencies
#--------------------------------------
sinclude  $(DEPS)

.PHONY: x-all depend clean distclean

