dnl ----------------------------------------------------------------------------
dnl $Id$
dnl
dnl Autoconf macros for tfsplugin
dnl ----------------------------------------------------------------------------

dnl ----------------------------------------------------------------------------
dnl TFS_CHECK_PROGS
dnl 
dnl check programs using tfsconfigd server
dnl ----------------------------------------------------------------------------
AC_DEFUN([TFS_CHECK_PROGS],[

AC_PROG_CC
AC_PROG_CPP
AC_PATH_PROG(RM, rm)
AC_PATH_PROG(MV, mv)
AC_CHECK_PROGS(AWK, [gawk, awk])
AC_PATH_PROG(LIBTOOL, libtool)
AC_CHECK_PROGS(INSTALL, [ginstall install])

dnl search gmake
AC_CHECK_PROGS(MAKE, [gmake make gnumake])

dnl check make program
gnu_compatible=`$ac_cv_prog_MAKE --version 2>&1 | grep "GNU[ ]*Make"`
if test "${gnu_compatible:-unset}" = unset; then
	AC_MSG_ERROR(GNU Make not found. Please install GNU Make.)
fi
])dnl

dnl ----------------------------------------------------------------------------
dnl TFS_SUBDIR_CONFIG
dnl     $1 : sub package directory (ex: db/pg)
dnl     $2 : the argument of configure
dnl ----------------------------------------------------------------------------
AC_DEFUN([TFS_SUBDIR_CONFIG], [

AC_CACHE_SAVE

echo "* configuring package in $1 now"
popdir=`pwd`
cd $1

if test ! -f configure; then
    autoconf
fi

if test "$enable_debug" = "yes"; then
    ./configure --prefix=${prefix} $2 --enable-debug --cache-file=$popdir/config.cache
else
    ./configure --prefix=${prefix} $2 --cache-file=$popdir/config.cache
fi
RETVAL=$?
if test "$RETVAL" = "0"; then
    tfs_subdir_list="$tfs_subdir_list $1"
	AC_MSG_RESULT([* $1 configured properly])
else
	AC_MSG_ERROR([* configure failed for $1])
fi

cd $popdir

AC_CACHE_LOAD
AC_SUBST(tfs_subdir_list)
])dnl

dnl ----------------------------------------------------------------------------
dnl TFS_APACHE_DIR
dnl
dnl get the path of apache installed directory (no check)
dnl ----------------------------------------------------------------------------
AC_DEFUN([TFS_APACHE_DIR],[
AC_ARG_WITH(apache,
        [  --with-apache=DIR       Apache server directory [[/usr/local/teamfile/www]] ],,
        [with_apache="no"])

AC_MSG_CHECKING(for Apache directory)

if test "$with_apache" = "no"; then
	apache_dir="/usr/local/teamfile/www"
else
	apache_dir=$with_apache
fi

AC_SUBST(apache_dir)
])dnl

