# $Id$
#-------------------------------------------------------------------------------
# TeamFileサーバプラグインSDK用共通 Makefile
#
#-------------------------------------------------------------------------------
# SDKライブラリ及びツールはこのMakefile を必ずinclude すること.
# プラグインはinclude 不可.
#
# 個々のMakefile で定義可能な変数
# ============================================
#   PROGRAM      : ビルド、インストールターゲットライブラリ (MUST)
#	SDKDIR       : プラグインSDKのトップディレクトリパス (MUST)
#	(残りはrules.mk 参照)
#
# 個々のMakefile で再定義可能なするターゲット
# ============================================
#	INSTALL_TARGETS   : make install のターゲット (MUST)
#	UNINSTALL_TARGETS : make uninstall のターゲット (MUST)
#
#-------------------------------------------------------------------------------
# default target
all: all-local

# include common makefile
include $(SDKDIR)/build/rules.mk

#--------------------------------------
# Define values for plugin
#--------------------------------------
STOBJS = $(PROGRAM:.la=.a)
SOOBJS = $(PROGRAM:.la=.so)

#--------------------------------------
# Build target
#--------------------------------------
all-local: x-all $(PROGRAM)

#--------------------------------------
# install target
#--------------------------------------
install: all $(INSTALL_TARGETS)

install-library:
	@if test ! -d $(DESTDIR)$(SDKLIBDIR); then \
		$(INSTALL) -m 755 -d $(DESTDIR)$(SDKLIBDIR) ; \
	fi ; \
	$(LIBTOOL) --mode=install cp $(PROGRAM) $(DESTDIR)$(SDKLIBDIR) ; \
	cat $(DESTDIR)$(SDKLIBDIR)/$(PROGRAM) | \
		sed -e 's:-L[\/a-zA-Z0-9_\.$$-][\/a-zA-Z0-9_\.$\-]*\.libs:-L$(SDKLIBDIR):' \
		    -e 's:-L[\/a-zA-Z0-9_\.$$-][\/a-zA-Z0-9_\.$\-]*\.libs::g' \
		> $(DESTDIR)$(SDKLIBDIR)/$(PROGRAM).tmp && \
	$(MV) $(DESTDIR)$(SDKLIBDIR)/$(PROGRAM).tmp $(DESTDIR)$(SDKLIBDIR)/$(PROGRAM) ; \
	$(RM) -f $(DESTDIR)$(SDKLIBDIR)/$(STOBJS)

install-execution:
	@if test ! -d $(DESTDIR)$(SDKBINDIR); then \
		$(INSTALL) -m 755 -d $(DESTDIR)$(SDKBINDIR) ; \
	fi ; \
	$(LIBTOOL) --mode=install cp $(PROGRAM) $(DESTDIR)$(SDKBINDIR)

#--------------------------------------
# uninstall library
#--------------------------------------
uninstall: $(UNINSTALL_TARGETS)

uninstall-library:
	@if test -f $(DESTDIR)$(SDKLIBDIR)/$(PROGRAM); then \
		 $(LIBTOOL) --mode=uninstall $(RM) $(DESTDIR)$(SDKLIBDIR)/$(PROGRAM); \
	fi

uninstall-execution:
	@if test -f $(DESTDIR)$(SDKBINDIR)/$(PROGRAM); then \
		rm -f $(DESTDIR)$(SDKBINDIR)/$(PROGRAM) ; \
	fi

.PHONY: all all-local install install-library \
		uninstall uninstall-library install-execution uninstall-execution

