/**
 * $Id$
 *
 * TeamFileプラグインSDK用ヘッダファイル(型宣言など)
 */
#if defined(TFSP_CORE_PRIVATE) && defined(TFSP_PLUGIN_PRIVATE)
# error "You defined TFSP_CORE_PRIVATE and TFSP_PLUGIN_PRIVATE at the same time."
#elif !defined(TFSP_CORE_PRIVATE) && !defined(TFSP_PLUGIN_PRIVATE)
# error "You did not define TFSP_CORE_PRIVATE or TFSP_PLUGIN_PRIVATE."
#endif

#ifndef INCLUDE_TFSP_H
#define INCLUDE_TFSP_H

#include "tfs.h"
#include "tfs_common.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*------------------------------------------------------------------------------
  Fixed values and Define Macro
  ----------------------------------------------------------------------------*/
#ifdef TFSP_CORE_PRIVATE
#undef TFSP_PLUGIN_PRIVATE
#endif	/* TFSP_CORE_PRIVATE */

#ifdef TFSP_PLUGIN_PRIVATE
#undef TFSP_CORE_PRIVATE
#endif	/* TFSP_PLUGIN_PRIVATE */

/**
 * プラグインインターフェースのバージョン番号
 */
#ifndef TFSP_MAJOR_VERSION
#define TFSP_MAJOR_VERSION 0
#endif	/* TFSP_MAJOR_VERSION */

#ifndef TFSP_MINOR_VERSION
#define TFSP_MINOR_VERSION 0
#endif	/* TFSP_MINOR_VERSION */

#ifndef TFSP_PATCH_VERSION
#define TFSP_PATCH_VERSION 1
#endif	/* TFSP_PATCH_VERSION */

/**
 * プラグイン用インターフェース構造体の名前
 * (note) この名前は、ccipherなどの具象インターフェースの
 *        インスタンスに付けてください.
 */
#define TFSP_INTERFACE_HANDLER	TFSP_INTERFACE_HANDLER

/*------------------------------------------------------------------------------
  Declare structure/enum
  ----------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------
  Define structure/enum
  ----------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif

#endif	/* INCLUDE_TFSP_H */

