/**
 * $Id$
 *
 * TeamFileプラグインSDK用ヘッダファイル (決め事)
 *
 * [ 役割 ]
 *   基本的には世の中全ての事象は決め事かもしれないけど、ここでは
 *   特にTeamFile の外部仕様によって範囲が狭められた(決められた)事象を
 *   定義します. コンフィグに近いイメージです.
 *   例えば、オペレーションの種類とかフォルダの種類とか.
 *   TeamFile という枠がなければ存在しないか、リミットの無い項目になるはず.
 */
#ifndef INCLUDE_TFSP_SPEC_H
#define INCLUDE_TFSP_SPEC_H

#include "tfsp.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*------------------------------------------------------------------------------
  Fixed values and Define Macro
  ----------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------
  Define structure/enum
  ----------------------------------------------------------------------------*/
typedef enum tfsp_type_operation  tfsp_type_operation;
typedef enum tfsp_type_folder     tfsp_type_folder;

/**
 * オペレーションの種類
 */
enum tfsp_type_operation {
	TFSP_OPTYPE_UNKNOWN = 0,  /* (未分類) */
	TFSP_OPTYPE_NEWPUT,       /* 新規アップロード       */
	TFSP_OPTYPE_UPDATEPUT,    /* 上書きアップロード     */
	TFSP_OPTYPE_RENAME,       /* 名前変更               */
	TFSP_OPTYPE_MOVE,         /* 階層移動               */
	TFSP_OPTYPE_DUPLICATE,    /* 複製(同一階層内コピー) */
	TFSP_OPTYPE_COPY,         /* 階層間コピー           */
};

/**
 * フォルダ種別
 */
enum tfsp_type_folder {
	TFSP_FLTYPE_UNKNOWN = 0,  /* (未分類) */
	TFSP_FLTYPE_GROUP1,       /* グループフォルダより下 */
	TFSP_FLTYPE_GROUP2,
	TFSP_FLTYPE_GROUPTRASH1,  /* グループごみ箱の下 */
	TFSP_FLTYPE_GROUPTRASH2,
	TFSP_FLTYPE_USER1,        /* ユーザフォルダの下 */
	TFSP_FLTYPE_USER2,
	TFSP_FLTYPE_USERTRASH1,   /* ユーザごみ箱の下 */
	TFSP_FLTYPE_USERTRASH2,
	TFSP_FLTYPE_DB1,          /* linkdbsearch結果フォルダの下 */
	TFSP_FLTYPE_DB2,
	TFSP_FLTYPE_DBSH1,        /* 共有フォルダの下 */
	TFSP_FLTYPE_DBSH2,
};

#ifdef __cplusplus
}
#endif


#endif	/* INCLUDE_TFSP_SPEC_H */

