/**
 * $Id$
 *
 * 汎用ユーティリティ(型宣言など)
 *
 * [ 役割 ]
 *   * プラグインSDK及び各プラグイン、TeamFile本体に基本的なデータ操作方法を提供する
 *   * 共通化可能な煩雑なglibc のライブラリコールをラップする
 * (note)
 *   TeamFileプラグインSDK の一部に含まれていますが、独立で存在可能なライブラリです.
 */
#ifndef INCLUDE_TFS_H
#define INCLUDE_TFS_H

#ifndef INCLUDE_CONFIG_H
#define INCLUDE_CONFIG_H
#include "config.h"
#endif	/* INCLUDE_CONFIG_H */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*------------------------------------------------------------------------------
  Fixed values and Define Macro
  ----------------------------------------------------------------------------*/
#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#if HAVE_STDINT_H
#include <stdint.h>
#endif

#if HAVE_UNISTD_H
#include <unistd.h>
#endif

/**
 * 関数が存在するかどうかを示す定義値
 */

/**
 * 型サイズ、型フォーマットの定義
 */
typedef short          tfs_int16_t;
typedef unsigned short tfs_uint16_t;

typedef int          tfs_int32_t;
typedef unsigned int tfs_uint32_t;

typedef long long          tfs_int64_t;
typedef unsigned long long tfs_uint64_t;

typedef size_t  tfs_size_t;
typedef ssize_t tfs_ssize_t;
typedef off_t   tfs_off_t;

#define TFS_SIZEOF_VOIDP 4
#define TFS_INT64_C(val) INT64_C(val)

/* printf フォーマット */
#define TFS_INT64_T_FMT   "lld"
#define TFS_UINT64_T_FMT  "llu"
#define TFS_SSIZE_T_FMT   "d"
#define TFS_SIZE_T_FMT    "d"
#define TFS_OFF_T_FMT     TFS_INT64_T_FMT
#define TFS_PID_T_FMT     "d"

/**
 * Public 関数の宣言に使用するマクロ
 */
#if !defined(WIN32)
#define TFS_DECLARE(type)            type
#define TFS_DECLARE_NONSTD(type)     type
#define TFS_DECLARE_DATA
#elif defined(TFS_DECLARE_STATIC)
#define TFS_DECLARE(type)            type __stdcall
#define TFS_DECLARE_NONSTD(type)     type
#define TFS_DECLARE_DATA
#elif defined(TFS_DECLARE_EXPORT)
#define TFS_DECLARE(type)            __declspec(dllexport) type __stdcall
#define TFS_DECLARE_NONSTD(type)     __declspec(dllexport) type
#define TFS_DECLARE_DATA             __declspec(dllexport)
#else
#define TFS_DECLARE(type)            __declspec(dllimport) type __stdcall
#define TFS_DECLARE_NONSTD(type)     __declspec(dllimport) type
#define TFS_DECLARE_DATA             __declspec(dllimport)
#endif


#ifdef __cplusplus
}
#endif

#endif	/* INCLUDE_TFS_H */

