#------------------------------------------------------------------------------
# $Id$
#------------------------------------------------------------------------------
# Common perl utility
#
# Copyright (c) 2006 COMPUTER HI-TECH INC., All rights reserved.
#------------------------------------------------------------------------------
package TF::CommonUtils;

require 5.008_000;

use strict;
use utf8;
use Encode;

my $MSGTABLE_ja = {
					mPTitle1 => 'エラーが発生しました',
					mPMsg1 => '予期しない問題が発生しました',
					mErrUrlAccess => 'このURLにはアクセスできません。もう一度アクセス先をお確かめ下さい',
					mErrFileOpen => 'テンプレートを開くことができませんでした。',
					mPWaitMsg      => '送信中です。しばらくお待ち下さい。',
					mPBackPage1    => "自動的に表示されない場合には",
					mPBackPage2    => "こちら</A>をクリックして下さい。",
				};

my $MSGTABLE_en = {
					mPTitle1 => 'Error',
					mPMsg1   => 'Unexpected error found.',
					mErrUrlAccess => 'You can not this URL. Please check the URL.',
					mErrFileOpen => 'Can not open template file.',
					mPWaitMsg      => 'Sending data. Please wait for a while.',
					mPBackPage1    => "Please click ",
					mPBackPage2    => "here</A> if this page is not reloaded automatically.",
				};
my $DEFAULT_LANGPARAM = $ENV{'TF_LANGPARAM'} || 'ja';

#
# Show error window to mainPane.
#
sub showErrorPage {
	my $msg   = shift || undef;
	my $lang  = shift || $$DEFAULT_LANGPARAM;
	my $MSGTABLE = &getMsgTable($lang);

	&showMessagePage($msg, $lang, $MSGTABLE->{mPTitle1});
}

#
# Show message window to mainPane.
#
sub showMessagePage {

	my $msg   = shift || undef;
	my $lang  = shift || $DEFAULT_LANGPARAM;
	my $title = shift || undef;

	my $MSGTABLE = &getMsgTable($lang);
	if ($msg) {
		$msg = &decodeUTF8($msg);
	}
	else {
		$msg = $MSGTABLE->{mPMsg1};
	}
	if (!$title) {
		$title = $MSGTABLE->{mPTitle1};
	}

	$msg = &escapeHTML($msg, 0);
	$title = &escapeHTML($title, 0);

	print <<"_END_";
Content-type: text/html; charset=UTF-8\n\n
<HTML>
<HEAD> 
<META http-equiv="Content-Type" content="text/html; charset=UTF-8">
<link rel="stylesheet" type="text/css" media="screen" href="/css/teamfile/style.css" />
<TITLE>$title</TITLE>
</HEAD>
<BODY>
<table cellspacing="0">
<tr>
<td id="mainFrameWindow">
<div class="windowTitle">$title</div>
<div class="windowContent">
<table cellspacing="0">
	<tr><td id="mainFrameWindowItem"><P>$msg</P></td></tr>
</table>
</div>
</td>
</tr>
</table>
</BODY>
</HTML>
_END_
	return;
}

#
# Show "Can not access this uri" message.
#
sub showAccessDeny {
	my $lang = &getLangPriority();
	my $MSGTABLE = &getMsgTable($lang);

	&showErrorPage($MSGTABLE->{mErrUrlAccess}, $lang);
}

#
# Show "Can not open template file" message.
#
sub showTemplateOpenErr {
	my $lang = shift || $DEFAULT_LANGPARAM;
	my $MSGTABLE = &getMsgTable($lang);

	&showErrorPage($MSGTABLE->{mErrFileOpen}, $lang);
}

#
# Redirect another page
#
sub redirectPage {
	my $backurl = shift || undef;
	my $lang    = shift || $DEFAULT_LANGPARAM;

	my $MSGTABLE = &getMsgTable($lang);
	if ($backurl) {
		print <<"_END_";
Content-type: text/html; charset=UTF-8\n\n
<html>
<head>
<link rel="stylesheet" type="text/css" media="screen" href="/css/teamfile/style.css" />
</head>
<body onLoad="location.href='$backurl'">
<table border="0">
<tr><td><p style="font-size: 12pt;">$MSGTABLE->{mPWaitMsg}</p></td></tr>
<tr><td><p style="font-size: 12pt;">$MSGTABLE->{mPBackPage1}<A href='$backurl'>$MSGTABLE->{mPBackPage2}</p></td></tr>
</table>
</body>
</html>
_END_
	}
};

#
# escape HTML string
#
sub escapeHTML {
	my ($str, $replace_white) = @_;
	if (!$str) {
		return;
	}

	$str =~ s/\&/\&amp;/g;
	$str =~ s/\</\&lt;/g;
	$str =~ s/\>/\&gt;/g;
	if ($replace_white) {
		$str =~ s/\ /\&nbsp;/g;
	}
	$str =~ s/\"/\&quot;/g;
	$str =~ s/\'/&#39;/g;

	return $str;
}

#
# escape js parameter string
#
sub escapeJSParam {
	my ($str) = @_;

	$str =~ s/\\/\\\\/g;
	$str =~ s/\"/\\\"/g;
	$str =~ s/\'/\\\'/g;
	$str =~ s/\//\\\//g;
	$str =~ s/</\\x3c/g;
	$str =~ s/>/\\x3e/g;
	$str =~ s/\r/\\r/g;
	$str =~ s/\n/\\n/g;

	return $str;
}

#
# decode UTF8
#
sub decodeUTF8 {
	my ($str) = @_;
	if (Encode::is_utf8($str)) {
		return $str;
	}
	return Encode::decode_utf8($str);
}

#
#
#
sub getLangPriority {
	my $LANGPARAM = $ENV{'TF_LANGPARAM'} || $DEFAULT_LANGPARAM;
	return $LANGPARAM;
}

#
# Append "CGI user-agent id" to USER-AGENT string and Get this value.
#
# @param string User-Agent header value
# @return string
#
sub getCgiUserAgent {
	my $ua = shift || $ENV{'HTTP_USER_AGENT'};

	if (!$ua) {
		return 'Mozilla/4.0 (compatible; PerlRedirecter)';
	}

	return $ua . ' PerlRedirecter';
}

#
# Get CGI connect SCHEMA and PORT, URL_PREFIX ($schema://127.0.0.1:$port)
#
sub getCgiConnectInfo {
	my $port    = $ENV{'TF_SYSCGI_CONNECT_PORT'};
	my $schema  = $ENV{'TF_SYSCGI_CONNECT_SCHEMA'};
	my $USE_SSL = $ENV{'HTTPS'} || 'off';
	my $dynamic_schema  = ($USE_SSL eq "on") ? 'https' : 'http';
	my $dynamic_port    = $ENV{'SERVER_PORT'} || '80';
	my $url_prefix = undef;

	if (!$schema) {
		$schema = $dynamic_schema;
	}

	if (!$port) {
		$port = $dynamic_port;
	}

	if (!$port or $port == 80 or $port == 443) {
		$url_prefix = $schema . '://127.0.0.1';
	}
	else {
		$url_prefix = $schema . '://127.0.0.1:' . $port;
	}

	return ($schema, $port, $url_prefix);
}

#
# encipher numeric value
#
sub encipherNumericValue {
	my ($num) = @_;

	$num =~ tr/0123456789/FJwmEhckaz/;
	return $num;
}

#
#  decipher numeric value
#
sub decipherNumericValue {
	my ($str) = @_;

	$str =~ tr/FJwmEhckaz/0123456789/;
	return $str;
}

#
# escape regular expression strings
#
sub escapeRegularExpression {
	my ($str) = @_;
	if (!$str) {
		return '';
	}

	$str =~ s/\(/\\(/g;
	$str =~ s/\)/\\)/g;
	$str =~ s/\[/\\[/g;
	$str =~ s/\]/\\]/g;
	$str =~ s/\./\\./g;
	$str =~ s/\*/\\*/g;
	$str =~ s/\?/\\?/g;
	$str =~ s/\+/\\+/g;
	$str =~ s/\^/\\^/g;
	$str =~ s/\$/\\\$/g;
	$str =~ s/\|/\\|/g;
	$str =~ s/\{/\\{/g;
	$str =~ s/\}/\\}/g;

	return $str;
}

sub formatTime {
    my $epoch = shift || time;
	my $lang  = shift || 'ja';
	my $disptime = shift || 0;

	my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($epoch);
	$year += 1900;
	$mon += 1;
	my @wdays = ();

	if ($lang eq 'ja') {
		@wdays = ("日", "月", "火", "水", "木", "金", "土");
	}
	else {
		@wdays = ("Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat");
	}

	my $ret = sprintf("%04d/%02d/%02d(%s)", $year, $mon, $mday, $wdays[$wday]);
	if ($disptime) {
		$ret .= sprintf(" %02d:%02d:%02d",  $hour, $min, $sec);
	}
	
	return $ret;
}

#
# mail validate
#
sub isMailAddress {
	my $str = shift || return(undef);

	if ($str =~ /^([a-zA-Z0-9\.\-\/_]{1,})@([a-zA-Z0-9\.\-\/_]{1,})\.([a-zA-Z0-9\.\-\/_]{1,})$/ ) { 
		return(1);
	}
	return(0);
}

# (private)
sub getMsgTable {
	my $lang = shift || $DEFAULT_LANGPARAM;

	return ($lang eq 'ja') ? $MSGTABLE_ja : $MSGTABLE_en;
}

# End of module
1;
