#------------------------------------------------------------------------------
# $Id$
#------------------------------------------------------------------------------
# Copylight (c) 2008 COMPUTER HI-TEC INC., All rights reserved.
#
#	このファイルの一部または全部をライセンスされたマシン以外で使用したり、
#	TeamFile以外の製品で使用したりすることを禁じます。
#------------------------------------------------------------------------------
package TF::GroupList;

use strict;
use utf8;
use LWP::UserAgent;
use HTTP::Request::Common qw(POST);
use XML::DOM;
use TF::XMLUtils;
use Time::Local;

#
# Constructor
#
sub new  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $self_ref = { };
    return bless $self_ref, $class;
}

#
# makeSureItem GROUPID
#
sub makeSureItem {
	my $this = shift;
	my $groupid = shift || die;

	if( exists $this->{$groupid} ) {
		return 0;
	}
	else {
    	$this->{$groupid} = {
								state => {
											hasGroup => 0,
										},
    							name => "",
							};
		return 1;
	}
}

#
# queryGroupList BASEURL,USERID,PASSWORD[,GROUPID]
#
sub queryGroupList {
	my $this = shift;
	my $baseurl = shift || die;
	my $userid = shift || '';
	my $passwd = shift || '';
	my $groupid= shift || '';

	my $ua  = LWP::UserAgent->new(ssl_opts => {verify_hostname => 0});
	my $req = HTTP::Request->new;

	$req->uri($baseurl . "/.management/GROUP/");
	$req->method("SEARCH");
	$req->protocol("HTTP/1.1");
	$req->authorization_basic($userid, $passwd);
	if ($groupid) {
		$req->content("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?><D:searchrequest xmlns:D=\"DAV:\" xmlns:TF=\"http://www.teamfile.com/DTD/TF/\"><TF:groupinformationsearch><TF:groupid>$groupid</TF:groupid><TF:detaillist/></TF:groupinformationsearch></D:searchrequest>");
	}
	else {
		$req->content("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?><D:searchrequest xmlns:D=\"DAV:\" xmlns:TF=\"http://www.teamfile.com/DTD/TF/\"><TF:groupinformationsearch><TF:detaillist/></TF:groupinformationsearch></D:searchrequest>");
	}
	$ua->agent(TF::CommonUtils::getCgiUserAgent());

	my $res = $ua->request($req);

	if( $res->is_success ) {
		my $data = $res->content();
		$this->parseGroupInfo($data);
	}
	else {
		print STDERR "GroupList.pm: queryGroupList failed" . $res->status_line;
	}
	return $res->code;
}

#
# queryGroupTreeList BASEURL,USERID,PASSWORD[,GROUPID]
#
sub queryGroupTreeList {
	my $this = shift;
	my $baseurl = shift || die;
	my $userid = shift || '';
	my $passwd = shift || '';
	my $groupid= shift || '';

	my $ua  = LWP::UserAgent->new(ssl_opts => {verify_hostname => 0});
	my $req = HTTP::Request->new;

	$req->uri($baseurl . "/.management/GROUP/");
	$req->method("SEARCH");
	$req->protocol("HTTP/1.1");
	$req->authorization_basic($userid, $passwd);
	if ($groupid) {
		$req->content("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?><D:searchrequest xmlns:D=\"DAV:\" xmlns:TF=\"http://www.teamfile.com/DTD/TF/\"><TF:groupinformationsearch><TF:groupid>$groupid</TF:groupid><TF:treelist/></TF:groupinformationsearch></D:searchrequest>");
	}
	else {
		$req->content("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?><D:searchrequest xmlns:D=\"DAV:\" xmlns:TF=\"http://www.teamfile.com/DTD/TF/\"><TF:groupinformationsearch><TF:treelist/></TF:groupinformationsearch></D:searchrequest>");
	}
	$ua->agent(TF::CommonUtils::getCgiUserAgent());

	my $res = $ua->request($req);

	if( $res->is_success ) {
		my $data = $res->content();
		$this->parseGroupInfo($data);
	}
	return $res->code;
}


#
# queryAvailableGroupList BASEURL,USERID,PASSWORD
#
sub queryAvailableGroupList {
	my $this = shift;
	my $baseurl = shift || die;
	my $userid = shift || '';
	my $passwd = shift || '';

	my $ua  = LWP::UserAgent->new(ssl_opts => {verify_hostname => 0});
	my $req = HTTP::Request->new;

	$req->uri($baseurl . "/.management/USER/");
	$req->method("SEARCH");
	$req->protocol("HTTP/1.1");
	$req->authorization_basic($userid, $passwd);
	$req->content("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?><D:searchrequest xmlns:D=\"DAV:\" xmlns:TF=\"http://www.teamfile.com/DTD/TF/\"><TF:userinformationsearch><TF:userid>$userid</TF:userid><TF:availablegroup/></TF:userinformationsearch></D:searchrequest>");

	$ua->agent(TF::CommonUtils::getCgiUserAgent());

	my $res = $ua->request($req);

	if( $res->is_success ) {
		my $data = $res->content();
		$this->parseGroupInfo($data);
	}
	return $res->code;
}

#
# queryGroup BASEURL,USERID,PASSWORD,GROUPID
#
sub queryGroup {
	my $this = shift;
	my $baseurl = shift || die;
	my $userid = shift || '';
	my $passwd = shift || '';
	my $groupid= shift || '';

	my $ua  = LWP::UserAgent->new(ssl_opts => {verify_hostname => 0});
	my $req = HTTP::Request->new;

	$req->uri($baseurl . "/.management/GROUP/");
	$req->method("SEARCH");
	$req->protocol("HTTP/1.1");
	$req->authorization_basic($userid, $passwd);
	$req->content("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?><D:searchrequest xmlns:D=\"DAV:\" xmlns:TF=\"http://www.teamfile.com/DTD/TF/\"><TF:groupinformationsearch><TF:groupid>$groupid</TF:groupid><TF:content/></TF:groupinformationsearch></D:searchrequest>");
	$ua->agent(TF::CommonUtils::getCgiUserAgent());

	my $res = $ua->request($req);

	if( $res->is_success ) {
		my $data = $res->content();
		$this->parseGroupInfo($data);
	}
	return $res->code;
}

#
# queryGroupforcoluri BASEURL,USERID,PASSWORD,GROUPID
#
sub queryGroupforcoluri {
	my $this = shift;
	my $baseurl = shift || die;
	my $userid = shift || '';
	my $passwd = shift || '';
	my $groupcoluri= shift || '';

	my $ua  = LWP::UserAgent->new(ssl_opts => {verify_hostname => 0});
	my $req = HTTP::Request->new;

	$req->uri($baseurl . "/.management/GROUP/");
	$req->method("SEARCH");
	$req->protocol("HTTP/1.1");
	$req->authorization_basic($userid, $passwd);
	$req->content("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?><D:searchrequest xmlns:D=\"DAV:\" xmlns:TF=\"http://www.teamfile.com/DTD/TF/\"><TF:groupinformationsearch><TF:groupcollectionuri>$groupcoluri</TF:groupcollectionuri><TF:content/></TF:groupinformationsearch></D:searchrequest>");
	$ua->agent(TF::CommonUtils::getCgiUserAgent());

	my $res = $ua->request($req);

	if( $res->is_success ) {
		my $data = $res->content();
		$this->parseGroupInfo($data);
	}
	return $res->code;
}

#
# parseGroupInfo DATA
#
sub parseGroupInfo {
	my $this = shift;
	my $data = shift || die;

	my $xml = new XML::DOM::Parser;
	my $doc = $xml->parse($data);

	for my $elem ( $doc->getElementsByTagName("TF:groupinfo") )  {
		my $groupid = TF::XMLUtils::getText($elem, "TF:groupid");
		my $name = TF::XMLUtils::getText($elem, "TF:name");
		my $grpcoluri = TF::XMLUtils::getText($elem, "TF:groupcollectionuri");
		my $creationdt= TF::XMLUtils::getText($elem, "TF:creationdt");
		my $ownerid   = TF::XMLUtils::getText($elem, "TF:ownerid");
		my $ownername = TF::XMLUtils::getText($elem, "TF:ownername");
		my $childcount = TF::XMLUtils::getText($elem, "TF:childcount");
		my $grpcomment = TF::XMLUtils::getText($elem, "TF:comment");
		if( $groupid ) {
			$this->makeSureItem($groupid);
			$this->{$groupid}->{name} = $name;
			$this->{$groupid}->{grpcoluri} = $grpcoluri;
			$this->{$groupid}->{state}->{hasGroup} = 1;
			if ($creationdt =~ /(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2})Z/) {
				$this->{$groupid}->{creationdt} = timegm($6,$5,$4,$3,$2 - 1,$1 - 1900);
			}
			$this->{$groupid}->{ownerid}   = $ownerid;
			$this->{$groupid}->{ownername} = $ownername;

			$this->{$groupid}->{childcount} = $childcount;

			$this->{$groupid}->{comment} = $grpcomment;

			$this->{$groupid}->{c_write} = 0;
			$this->{$groupid}->{c_oplog} = 0;
			$this->{$groupid}->{c_showprop} = 0;
			$this->{$groupid}->{active} = 1;

			my $nodelist = $elem->getElementsByTagName("TF:constraints");
			if ( $nodelist ) {
				my $constraints = $nodelist->item(0);
				if ( $constraints ) {
					for my $node ($constraints->getChildNodes) {

						if ($node->getNodeName eq "TF:write") {
							$this->{$groupid}->{c_write} = 1;
						}
						elsif ($node->getNodeName eq "TF:operationlog") {
							$this->{$groupid}->{c_oplog} = 1;
						}
						elsif ($node->getNodeName eq "TF:showproperty") {
							$this->{$groupid}->{c_showprop} = 1;
						}
					}
				}
			}
			my $state = $elem->getElementsByTagName("TF:state");
			if ( $state ) {
				my $active = $state->item(0);
				if ( $active ) {
					for my $node ($active->getChildNodes) {

						if ($node->getNodeName eq "TF:active") {
							$this->{$groupid}->{active} = 1;
						}
						elsif ($node->getNodeName eq "TF:inactive") {
							$this->{$groupid}->{active} = 0;
						}
					}
				}
			}
		}
	}
}

#
# getIDList
#
sub getIDList {
	my $this = shift;

	return sort { $this->getName($a) cmp $this->getName($b) } keys %$this;
}

#
# getName GROUPID
#
sub getName {
	my $this = shift;
	my $id = shift || die;

	return $this->{$id}->{name};
}

#
# isExist GROUPID
#
sub isExist {
	my $this = shift;
	my $id = shift || die;

	return exists $this->{$id};
}
	
#
# hasGroupItem GROUPID
#
sub hasGroupItem {
	my $this = shift;
	my $id = shift || die;

	if( ! exists $this->{$id} ) {
		return 0;
	}

	return $this->{$id}->{state}->{hasGroup};
}

#
# delete GROUPID
#
sub delete {
	my $this = shift;
	my $id = shift || die;

	if( exists $this->{$id} ) {
		delete $this->{$id};
		return 1;
	}
	else {
		return 0;
	}
}

#
# hasWriteConstraints GROUPID
#
sub hasWriteConstraints {
	my $this = shift;
	my $id = shift || die;

	if( ! exists $this->{$id} ) {
		return 0;
	}

	return $this->{$id}->{c_write};
}

#
# hasOplogConstraints GROUPID
#
sub hasOplogConstraints {
	my $this = shift;
	my $id = shift || die;

	if( ! exists $this->{$id} ) {
		return 0;
	}

	return $this->{$id}->{c_oplog};
}

#
# hasShowpropConstraints GROUPID
#
sub hasShowpropConstraints {
	my $this = shift;
	my $id = shift || die;

	if( ! exists $this->{$id} ) {
		return 0;
	}

	return $this->{$id}->{c_showprop};
}

#
# getGroupFolderUri GROUPID
#
sub getGroupFolderUri {
	my $this = shift;
	my $id = shift || die;

	return $this->{$id}->{grpcoluri};
}

#
# getGroupFolderName GROUPID, LOCATION_NAME
# (note)
#   The return-value was encoded utf-8.
#
sub getGroupFolderName {
	my $this = shift;
	my $id = shift || die "The id was missing.";
	my $lcname = shift || die "The lcname was missing";

	my $foldername = undef;
	my $grpcoluri = $this->{$id}->{grpcoluri};
	if (!$grpcoluri) {
		$foldername = $this->{$id}->{name};
		utf8::encode($foldername);

		return $this->{$id}->{name};
	}

	if ($grpcoluri =~ /\/$lcname\/Group%20Folder\/([^\/]+)\//) {
		# Use uri encode
		$foldername = $1;
		utf8::encode($foldername);

		$foldername =~ tr/+/ /;
		$foldername =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	}
	else {
		$foldername = $this->{$id}->{name};
		utf8::encode($foldername);
	}

	return $foldername;
}

#
# getGroupCreationDt GROUPID
#
sub getGroupCreationDt {
	my $this = shift;
	my $id = shift || die;

	return $this->{$id}->{creationdt};
}

#
# isActive GROUPID
#
sub isActive {
	my $this = shift;
	my $id = shift || die;

	return $this->{$id}->{active};
}

#
# getOwnerId GROUPID
#
sub getOwnerId {
	my $this = shift;
	my $id = shift || die;

	return $this->{$id}->{ownerid};
}

#
# getOwnerName GROUPID
#
sub getOwnerName {
	my $this = shift;
	my $id = shift || die;

	return $this->{$id}->{ownername};
}
#
# getChildCount GROUPID
#
sub getChildCount {
	my $this = shift;
	my $id = shift || die;

	return $this->{$id}->{childcount};
}

#
# getComment GROUPID
#
sub getComment {
	my $this = shift;
	my $id = shift || die;

	return $this->{$id}->{comment};
}

# End of module
1;
