#------------------------------------------------------------------------------
# $Id$
#------------------------------------------------------------------------------
#	排他処理用モジュール
#
#	my $lock = TF::SingleLock->new('lockdir',600);
#	if( ! $lock->waitForLocking(20) ) {
#		die "Timeout!";
#	}
#
# Copyright (c) 2006 COMPUTER HI-TECH INC., All rights reserved.
#------------------------------------------------------------------------------
package TF::SingleLock;

require 5.008_000;

use strict;
use utf8;

#
#	TF::SingleLock->new [lockdir[,validfor]]
#
sub new {
	my $self = shift || die;
	my $type = ref($self) || $self;
	my $lockdir = shift || '.lock';		# ロックディレクトリ
	my $validfor = shift || 60;		# ロックディレクトリの有効期間

	#
	# 有効期間の過ぎたロックディレクトリを消す
	#
	my @lockstat = stat $lockdir;
	my $curtime = time;
	if( @lockstat ) {
		if( ($lockstat[10] + $validfor) < $curtime ) {
			rmdir $lockdir;
		}
	}

	#
	# ロックディレクトリを作成する
	#
	my $lockowner = 0;
	my $locked = 0;
	if( mkdir $lockdir ) {
		$lockowner = 1;
		$locked = 1;
	}
	else
	{
		if( stat $lockdir ) {
			$locked = 1;
		}
	}

	my $this = {	lockdir => $lockdir,
					lockowner => $lockowner,
					locked => $locked,			};
	return bless $this, $type;
}

#
#	デストラクタ
#
sub DESTROY {
	&release(@_);
}

#
#	isLocked
#
sub isLocked {
	my $this = shift || die;
	return $this->{locked};
}

#
#	isLockowner
#
sub isLockowner {
	my $this = shift || die;
	return $this->{lockowner};
}

#
#	waitForLocking [timeout]
#
sub waitForLocking {
	my $this = shift || die;
	my $timeout = shift || 10;
	if( $this->{lockowner} ) {
		return 1;
	}

	for( my $count = 0; $count < $timeout; $count++ ) {
		if( mkdir $this->{lockdir} ) {
			$this->{lockowner} = 1;
			$this->{locked} = 1;
			return 1;
		}
		sleep(1);
	}

	return 0;
}

#
# release lock
#
sub release {
	my $this = shift || die;
	if ( $this->{lockowner} && stat $this->{lockdir} ) {
		rmdir $this->{lockdir};
	}
}

# End of module
1;
