#------------------------------------------------------------------------------
# $Id$
#------------------------------------------------------------------------------
# Copylight (c) 2006-2008 COMPUTER HI-TEC INC., All rights reserved.
#
#	このファイルの一部または全部をライセンスされたマシン以外で使用したり、
#	TeamFile以外の製品で使用したりすることを禁じます。
#------------------------------------------------------------------------------
package TF::SysMsgx;

use strict;
use utf8;
use LWP::UserAgent;
use HTTP::Request::Common qw(POST);
use XML::DOM;
use TF::XMLUtils;
use Time::Local;

#
# Constructor
#
sub new  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $self_ref = { };
    return bless $self_ref, $class;
}

sub querySysMsg {
	my $this = shift;
	my $baseurl = shift || die;
	my $userid = shift || '';
	my $passwd = shift || '';
	my $type   = shift || "currentmsg";
	my $msgid = shift || undef;
	my $reqlang = shift || undef;

	my $ua  = LWP::UserAgent->new(ssl_opts => {verify_hostname => 0});
	my $req = HTTP::Request->new;

	$req->uri($baseurl . "/.management/MSG/");
	$req->method("SEARCH");
	$req->protocol("HTTP/1.1");
	$req->authorization_basic($userid, $passwd);
	$req->header("Accept-Language" => $reqlang);

	my $content; 

	if ($type eq 'content') {
		$content = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?><D:searchrequest xmlns:D=\"DAV:\" xmlns:TF=\"http://www.teamfile.com/DTD/TF/\"><TF:sysmsginformationsearch><TF:$type/><TF:msgid>$msgid</TF:msgid></TF:sysmsginformationsearch></D:searchrequest>";
	}
	else {
		$content = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?><D:searchrequest xmlns:D=\"DAV:\" xmlns:TF=\"http://www.teamfile.com/DTD/TF/\"><TF:sysmsginformationsearch><TF:$type/></TF:sysmsginformationsearch></D:searchrequest>";
	}

	$req->content($content);
	$ua->agent(TF::CommonUtils::getCgiUserAgent());

	my $res = $ua->request($req);

	if( $res->is_success ) {
		my $data = $res->content();
		$this->parseSysMsgInfo($data);
	}

	return $res->code;

}

#
# parseSysmsgInfo DATA
#
sub parseSysMsgInfo {
	my $this = shift;
	my $data = shift || die;

	my $xml = new XML::DOM::Parser;
	my $doc = $xml->parse($data);

	for my $elem ( $doc->getElementsByTagName("TF:sysmsginfo") ) {
		my $msgid  = TF::XMLUtils::getText($elem, "TF:msgid");
		my $subject= TF::XMLUtils::getText($elem, "TF:subject");
		my $msgtxt = TF::XMLUtils::getText($elem, "TF:msgtxt");
		my $lang   = TF::XMLUtils::getText($elem, "TF:lang");
		my $scope  = TF::XMLUtils::getText($elem, "TF:scope");
		my $creationdt  = TF::XMLUtils::getText($elem, "TF:creationdt");
		my $updatedt   = TF::XMLUtils::getText($elem, "TF:updatedt");
		my $active = $elem->getElementsByTagName("TF:active");
		if ( $msgid ) {
			$this->{$msgid}->{msgtxt}     = $msgtxt;
			$this->{$msgid}->{subject}    = $subject;
			$this->{$msgid}->{lang}       = $lang;
			$this->{$msgid}->{scope}      = $scope;
			if ($creationdt && $creationdt =~ /(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2})Z/) {
				$this->{$msgid}->{creationdt} = timegm($6,$5,$4,$3,$2 - 1,$1 - 1900);

			}
			if ($updatedt =~ /(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2})Z/) {
				$this->{$msgid}->{updatedt} = timegm($6,$5,$4,$3,$2 - 1,$1 - 1900);
			}
			$this->{$msgid}->{active} = ($active && $active->getLength) ? 1 : 0;
		}
	}
	
}

sub insertSysMsg {
	my $this = shift;
	my $url  = shift;
	my $user = shift;
	my $pass = shift;
	my $msg  = shift;
	my $lang = shift;
	my $scope = shift;
	my $subject = shift;
	my $active = shift;

	my $msgid = time(); #msgidの生成

	my $ua  = LWP::UserAgent->new(ssl_opts => {verify_hostname => 0});
	my $req = HTTP::Request->new;

	#--------------------
	# MKCOL
	#--------------------

	$req->uri($url . "/.management/MSG/" . $msgid);
	$req->method("MKCOL");
	$req->protocol("HTTP/1.1");
	$req->authorization_basic($user, $pass);

	my $content = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?><D:propertyupdate xmlns:D=\"DAV:\" xmlns:TF=\"http://www.teamfile.com/DTD/TF/\"><D:set><D:prop><TF:sysmsgdiscovery><TF:sysmsginfo><TF:msgid>$msgid</TF:msgid><TF:msgtxt><![CDATA[$msg]]></TF:msgtxt>";
	
	if ($active && $active eq 'on') { $content .= "<TF:active/>"; }
	if ($lang) { $content .= "<TF:lang>$lang</TF:lang>" ; }
	
	$content .= "<TF:subject><![CDATA[$subject]]></TF:subject></TF:sysmsginfo></TF:sysmsgdiscovery></D:prop></D:set></D:propertyupdate>";

	$req->content($content);
	$ua->agent(TF::CommonUtils::getCgiUserAgent());
	my $res = $ua->request($req);
	my $data = $res->content();

	# error
	if (!$res->is_success) {

	}

	$res->code;
}

sub updateSysMsg {
	my $this = shift;
	my $url  = shift;
	my $user = shift;
	my $pass = shift;
	my $msgid= shift;
	my $msg  = shift;
	my $lang = shift;
	my $scope = shift;
	my $subject = shift;
	my $active = shift;

	my $ua  = LWP::UserAgent->new(ssl_opts => {verify_hostname => 0});
	my $req = HTTP::Request->new;

	my $content = undef;

	my $retcode = undef;

	$req->uri($url . "/.management/MSG/" . $msgid);
	$req->method("PROPPATCH");
	$req->protocol("HTTP/1.1");
	$req->authorization_basic($user, $pass);

	$content = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?><D:propertyupdate xmlns:D=\"DAV:\" xmlns:TF=\"http://www.teamfile.com/DTD/TF/\"><D:set><D:prop><TF:sysmsgdiscovery><TF:sysmsginfo><TF:msgtxt><![CDATA[$msg]]></TF:msgtxt>";
	
	if ($lang) { $content .= "<TF:lang>$lang</TF:lang>"; }
	if ($active && $active eq 'on') { $content .= "<TF:active/>"; }
	
	$content .= "<TF:subject><![CDATA[$subject]]></TF:subject></TF:sysmsginfo></TF:sysmsgdiscovery></D:prop></D:set></D:propertyupdate>";

	$req->content($content);
	$ua->agent(TF::CommonUtils::getCgiUserAgent());

	my $res = $ua->request($req);
	my $data = $res->content();

	# multi status 
	if ($res->is_success) {
		my $xml = new XML::DOM::Parser;
		my $doc = $xml->parse($data);
		my $e   = $doc->getElementsByTagName("D:status");
		my $node = $e->item(0);
		my $str = $node->toString();
		my ($p, $c, $m) = split(/ /, $str);

		if ($c) {
			$retcode = $c;
		}
		else {
			# failed
			$retcode = '500';
		}
	}
	else {
		# failed
		$retcode = $res->code;
	}

	return $retcode;
}

sub deleteSysmsg()
{
	my $this = shift;
	my $url  = shift;
	my $user = shift;
	my $pass = shift;
	my $msgid= shift || undef;

	my $ua  = LWP::UserAgent->new(ssl_opts => {verify_hostname => 0});
	my $req = HTTP::Request->new;

	if (!$msgid) { return 500; }

	$req->uri($url . "/.management/MSG/" . $msgid);
	$req->method("DELETE");
	$req->protocol("HTTP/1.1");
	$req->authorization_basic($user, $pass);

	$ua->agent(TF::CommonUtils::getCgiUserAgent());
	my $res = $ua->request($req);

	return $res->code;
}

sub getIDList {
	my $this = shift;

	return sort { $b cmp $a } keys %$this;
}

sub getMsg {
	my $this = shift;
	my $id = shift || die;

	return $this->{$id}->{msgtxt};
}

sub getSubject {
	my $this = shift;
	my $id = shift || die;

	return $this->{$id}->{subject};
}

sub getCreationdt
{
	my $this = shift;
	my $id = shift || die;

	return $this->{$id}->{creationdt};
}

sub getUpdatedt {
	my $this = shift;
	my $id = shift || die;

	return $this->{$id}->{updatedt};
}

sub isActive {
	my $this = shift;
	my $id = shift || die;

	return $this->{$id}->{active};
}

sub getLang {
	my $this = shift;
	my $id = shift || die;

	return $this->{$id}->{lang};
}

sub isExists {
	my $this = shift;
	my $id = shift || die;

	return exists $this->{$id};
}	

# End of module
1;
