#------------------------------------------------------------------------------
# $Id$
#------------------------------------------------------------------------------
# XML Utility
#
# Copyright (c) 2006 COMPUTER HI-TECH INC., All rights reserved.
#------------------------------------------------------------------------------
package TF::XMLUtils;

use strict;
use utf8;
use XML::DOM;

#
# getText XML::DOM::Node, NODENAME, [xml:lang]
#
sub getText {
	my $doc      = shift || undef;
	my $nodename = shift || undef;
	my $lang     = shift || undef;

	if (!$doc || !$nodename) {
		return undef;
	}

	my $nodelist = $doc->getElementsByTagName($nodename);
	if ($nodelist) {
		my $node;
		my $alang;
		for (my $i = 0; $i < $nodelist->getLength; $i++) {
			$node  = $nodelist->item($i);
			$alang = $node->getAttribute('xml:lang');
			if($node) {
				my $data  = $node->getFirstChild();
				if ($data) {
					if (!$lang || !$alang) {
						return $data->getNodeValue;
					}
					if ($lang eq $alang) {
						return $data->getNodeValue;
					}
				}
			}
		}
	}
	return undef;
}

#
# appendTextElement XML::DOM::Document, XML::DOM::Element, NODENAME, VALUE
#
sub appendTextElement {
	my $doc = shift || undef;
	my $elem = shift || undef;
	my $nodename = shift || undef;
	my $value = shift || '';

	if (!$doc || !$elem || !$nodename) {
		return undef;
	}

	my $e = $doc->createElement($nodename);
	my $t = $doc->createTextNode($value);
	$e->appendChild($t);
	$elem->appendChild($e);
}

#
# appendCDATATextElement XML::DOM::Document, XML::DOM::Element, NODENAME, VALUE
#
sub appendCDATATextElement {
	my $doc = shift || undef;
	my $elem = shift || undef;
	my $nodename = shift || undef;
	my $value = shift || '';

	if (!$doc || !$elem || !$nodename) {
		return undef;
	}

	my $e = $doc->createElement($nodename);
	my $c = $doc->createCDATASection($value);
	$e->appendChild($c);
	$elem->appendChild($e);
}

# End of module
1;
