/* 
   Http status line infomation container
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavHttpStatus.h 132 2005-06-24 09:09:43Z komat $
*/

#ifndef ONION_HEADER_DAVHTTPSTATUS_H
#define ONION_HEADER_DAVHTTPSTATUS_H 1

#include <onion/OnionCfg.h>

/** <code>CDavHttpStatus</code> is an internal member of 
 * <code>CDavRequest</code>.
 * It is used to parse status line of each HTTP response and hold 
 * relevant infomation.
 */
OI_BEGIN_CLASSEXPORT

class OI_EXPORT CDavHttpStatus
{
 public:
  CDavHttpStatus();
  ~CDavHttpStatus();
  void Clear();
  OI_RESULT Parse(const char* pszBuf);
 public:
  int m_nMajorVersion;
  int m_nMinorVersion;
  int m_nCode;
  int m_nCodeClass;
  OI_STRING_A m_strReason;
};

OI_END_CLASSEXPORT

#endif /*ONION_HEADER_DAVHTTPSTATUS_H*/
