/* 
   Variable length buffer
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavMemBuffer.h 132 2005-06-24 09:09:43Z komat $
*/

#ifndef ONION_HEADER_DAVMEMBUFFER_H
#define ONION_HEADER_DAVMEMBUFFER_H 1

#include <onion/OnionCfg.h>

/** Variable length buffer
 *
 */
OI_BEGIN_CLASSEXPORT

class OI_EXPORT CDavMemBuffer
{
 public:
  CDavMemBuffer(size_t unInitSize = OI_MEMBUF_INITSIZE,
		size_t unSizeLimit = OI_MEMBUF_SIZELIMIT,
		size_t unIncrSize = OI_MEMBUF_INCRSIZE);
  ~CDavMemBuffer();
  void Clear();
  size_t GetBufferSize();
  size_t GetDataSize();
  size_t GetIncrementSize();
  size_t Write(const void* pyData, size_t unDataLen);
  const void* GetData();
  size_t SetIncrementSize(size_t unNewSize);
 private:
  size_t grow(size_t unNewSize);
  bool ensureCapacity(size_t unWriteSize);
 public:
  OI_STRING_A m_strContentType;
 private:
  size_t m_unBufLen;
  size_t m_unDataLen;
  size_t m_unIncrSize;
  size_t m_unSizeLimit;
  void* m_pyBufHead;
};

OI_END_CLASSEXPORT

#endif /*ONION_HEADER_DAVMEMBUFFER_H*/
