/* 
   Http response body infomation container
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>
   Copyright (C) 1999-2002, Joe Orton <joe@manyfish.co.uk>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavResponseBody.h 132 2005-06-24 09:09:43Z komat $
*/

#ifndef ONION_HEADER_DAVRESPONSEBODY_H
#define ONION_HEADER_DAVRESPONSEBODY_H 1

#include <onion/OnionCfg.h>

#ifdef HAVE_LIBZ
#include <zlib.h>
#include <onion/ResponseHeaderHandler.h>
#endif /*HAVE_LIBZ*/

//forward declarations
class CDavRequest;
class CDavSocket;
class CDavResponseBody;

#ifdef HAVE_LIBZ

typedef struct tagOIGZHEADER {
  OI_BYTE ID1;
  OI_BYTE ID2;
  OI_BYTE CM;
  OI_BYTE FLAG;
  OI_BYTE MTIME;
  OI_BYTE XFL;
  OI_BYTE OS;
} OIGZHEADER;

OI_BEGIN_CLASSEXPORT

class OI_EXPORT CDavZReader
{
 public:
  CDavZReader(CDavResponseBody* pBody);
  ~CDavZReader();
  size_t SetBufferSize(size_t unNewSize);
  OI_RESULT Read(char* pszBuf, size_t unBufLen, size_t* punReadLen);
 private:
  OI_RESULT init();
  OI_RESULT parseHeader();
  OI_RESULT readBody(OI_BYTE* pBuf, size_t unBufLen, size_t* punReadLen);
 private:
  bool m_bInitialized;
  bool m_bEOF;
  bool m_bStreamEnd;
  CDavResponseBody* m_pBody;

  size_t m_unBufferSize;
  OIGZHEADER m_stHeader;
  OI_BYTE* m_pBuffer;
  z_stream m_Zstream;

  OI_BYTE m_yFooter[8];
  uLong m_ulChecksum;
};

OI_END_CLASSEXPORT

OI_BEGIN_CLASSEXPORT

class OI_EXPORT CHandlerCEncoding : public CResponseHeaderHandler
{
 public:
  CHandlerCEncoding(CDavResponseBody* pBody);
  ~CHandlerCEncoding();
  virtual OI_RESULT Execute(CDavRequest* pReq, OI_STRLIST_A& vecValues);
  virtual const char* GetHeaderName();
 private:
  CDavResponseBody* m_pBody;
};

OI_END_CLASSEXPORT

#endif /*HAVE_LIBZ*/

/** Internal interface used by CRDavRequest
 *
 */
OI_BEGIN_CLASSEXPORT

class OI_EXPORT CDavResponseBody
{
#ifdef HAVE_LIBZ
  friend class CDavZReader;
#endif /*HAVE_LIBZ*/
 public:
  CDavResponseBody(CDavRequest* pReq, CDavSocket* pSocket);
  virtual ~CDavResponseBody();
  void Reset();
  OI_RESULT Read(char* pszBuf, size_t unBufLen, size_t* punReadLen);
  size_t Read(unsigned char* toFill, size_t maxToRead);
 protected:
  OI_RESULT read(char* pszBuf, size_t unBufLen, size_t* punReadLen);
  size_t read(unsigned char* toFill, size_t maxToRead);
 public:
  OI_RSP_MODE m_enuMode;
  OI_STRING_A m_strContentType;
  OI_RESULT m_enuLastErr;
  unsigned int m_unChunkNo;
  OI_SIZE_T m_unReadLen;
  OI_SIZE_T m_unChunkLeft;
  OI_SIZE_T m_unChunkLen;
  OI_SIZE_T m_unBodyLeft;
  OI_SIZE_T m_unBodyLen;
  bool m_bEOF;
#ifdef HAVE_LIBZ
  bool m_bCompressed;
 protected:
  CDavZReader* m_pZreader;
#endif /*HAVE_LIBZ*/
 private:
  char* m_pszLocalBuf;	//local buffer
  CDavRequest* m_pReq;
  CDavSocket* m_pSocket;
};

OI_END_CLASSEXPORT

#endif /*ONION_HEADER_DAVRESPONSEBODY_H*/
