/* 
   SSL certificate
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>
   Copyright (C) 2002-2004, Joe Orton <joe@manyfish.co.uk>
   Copyright (C) 1999-2000 Tommi Komulainen <Tommi.Komulainen@iki.fi>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavSSLCertificate.h 132 2005-06-24 09:09:43Z komat $
*/

#ifndef ONION_HEADER_DAVSSLCERTIFICATE_H
#define ONION_HEADER_DAVSSLCERTIFICATE_H 1

#include <onion/OnionCfg.h>
#include <onion/DavSSLDName.h>
#include <onion/DavSSLCertificateData.h>

OI_BEGIN_CLASSEXPORT

class OI_EXPORT CDavSSLCertificate
{
  friend class CDavWorkSession;
  friend class CDavSSLCertificateList;
 public:
  CDavSSLCertificate();
  CDavSSLCertificate(const CDavSSLCertificate& master);
  CDavSSLCertificate(X509* pX509, unsigned long ulFailures = 0);
  ~CDavSSLCertificate();
  void Attach(X509* pX509);
  X509* Detach();
  CDavSSLCertificate& operator=(const CDavSSLCertificate& master);
  CDavSSLCertificate& operator=(X509* pX509);
  bool operator ==(const CDavSSLCertificate& other);
  bool operator ==(const X509* pOther);

  bool Load(BIO* pBIO, OI_SSL_CRTENC enuEncoding);
  bool Load(const char* pszPath,
	    OI_SSL_CRTENC enuEncoding = ENC_CRT_PEM);
  bool Load(void* pvData,
	    unsigned int unLen,
	    OI_SSL_CRTENC enuEncoding = ENC_CRT_PEM);
  void Clear();
  void Save(const char* pszPath,
	    OI_SSL_CRTENC enuEncoding = ENC_CRT_PEM);
  bool Export(CDavSSLCertificateData& dataOut,
	      OI_SSL_CRTENC enuEncoding = ENC_CRT_PEM);

  bool GetSerialNumber(OI_STRING_A& strOut);
  bool GetPublicKey(OI_STRING_A& strOut);
  bool GetPublicKeyInfo(OIPKEYINFO *pKeyInfo);
  bool GetIssuer(CDavSSLDName& dnOut);
  bool GetSubject(CDavSSLDName& dnOut);
  bool GetSignature(OI_STRING_A& strOut);
  bool GetSignatureAlgorithm(OI_SSL_PKEYALG& algOut); /*subject to change*/
  unsigned long GetSubjectHash();
  time_t GetNotBefore();
  time_t GetNotAfter();
  long GetVersion();
  X509* GetX509();

  bool IsIssuedBy(CDavSSLDName& dnIssuer);
  bool IsSelfSigned();
  int Compare(CDavSSLCertificate& crtOther);
  int CompareSubject(CDavSSLCertificate& crtOther);

 public:
  unsigned long m_ulFailures;

 private:
  X509*	m_pX509;
};

OI_END_CLASSEXPORT

#endif /*ONION_HEADER_DAVSSLCERTIFICATE_H*/
