/* 
   Distinguish name of SSL certificates
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavSSLDName.h 132 2005-06-24 09:09:43Z komat $
*/

#ifndef ONION_HEADER_DAVSSLDNAME_H
#define ONION_HEADER_DAVSSLDNAME_H 1

#include <onion/OnionCfg.h>
#include <onion/DavSSLDNameField.h>
#include <openssl/ssl.h>
#include <map>

//forward declaration
class CDavSSLDNameField;

OI_BEGIN_CLASSEXPORT

class OI_EXPORT CDavSSLDName
{
  friend class CDavSSLCertificate;
 private:
  typedef std::map<OI_STRING_A, CDavSSLDNameField> DNAMEFIELDS;
 public:
  CDavSSLDName();
  CDavSSLDName(const X509_NAME* pName);
  ~CDavSSLDName();
  bool ParseDName(X509_NAME* pName);
  unsigned int GetFieldCount();
  const CDavSSLDNameField* GetField(const char* pszName);
  const CDavSSLDNameField* GetFirstField(OI_STRING_A& strName);
  const CDavSSLDNameField* GetNextField(OI_STRING_A& strName);
  const CDavSSLDNameField* operator[](const char* pszName);
  CDavSSLDName& operator =(const CDavSSLDName& master);
  bool operator ==(const CDavSSLDName& other);
  bool operator ==(const X509_NAME* pOther);
  void Clear();

  bool OneLine(OI_STRING_A& strOut);
 private:
  X509_NAME* m_pX509Name;
  DNAMEFIELDS m_mapFields;
  DNAMEFIELDS::iterator m_itrCurrent;
};

OI_END_CLASSEXPORT

#endif /*ONION_HEADER_DAVSSLDNAME_H*/
