/* 
   Configration to handle different kinds of servers
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavServerPolicy.h 132 2005-06-24 09:09:43Z komat $
*/

#ifndef ONION_HEADER_DAVSERVERPOLICY_H
#define ONION_HEADER_DAVSERVERPOLICY_H 1

#include <onion/OnionCfg.h>
#include <onion/DavXmlBuffer.h>
#include <xercesc/dom/DOM.hpp>
#include <xercesc/parsers/XercesDOMParser.hpp>

//forward declarations
class CDavWorkSession;

/**Container of server policy.
 * 
 */
OI_BEGIN_CLASSEXPORT

class OI_EXPORT CDavServerPolicy
{
 public:
  CDavServerPolicy(void);
  ~CDavServerPolicy(void);
  void Reset();
  void WriteDefaultConfig(const char* pszPath);
  bool Load(const char* pszPath);
  bool Load(CDavXmlBuffer* pXmlBuffer);
  void Save(const char* pszPath);
  OI_RESULT CheckResponse(CDavWorkSession* pSession,
			  const char* pszServerString,
			  const char* pszRequest,
			  int nStatus,
			  const char* pszContentType,
			  OIOPERATION *pOperation);
 private:
  bool secureConfig();
  void generateDefault();
  bool initConfig();
  XNS(DOMElement)* appendElement(XNS(DOMElement)* pParent,
				 const XMLCh* pszName);
  XNS(DOMElement)* appendMethod(XNS(DOMElement)* pParent,
				const XMLCh* pszMethod,
				const XMLCh* pszDefaultOp,
				const XMLCh* pszDefaultErr);
  XNS(DOMElement)* appendStatus(XNS(DOMElement)* pParent,
				const XMLCh* pszStatus,
				const XMLCh* pszChkBody,
				const XMLCh* pszDefErr,
				const XMLCh* pszDefOp);
  XNS(DOMElement)* appendCType(XNS(DOMElement)* pParent,
			       const XMLCh* pszType,
			       const XMLCh* pszErrCode,
			       const XMLCh* pszOpCode);
 private:
  bool m_bReady;

  XNS(DOMDocument)* m_pConfig;
  XNS(DOMElement)* m_pRoot;
  XNS(DOMElement)* m_pDefaultMethods;
  XNS(DOMElement)* m_pDefaultStatuses;

  /*
  XNS(XercesDOMParser)*	m_pParser;
  XNS(ErrorHandler)* m_pErrHandler;
  */
  CDavXmlBuffer m_xbfConfig;

  enum OI_OPCODE m_enuOpCode;
  enum OI_RESULT m_enuError;

  //strings
  const XMLCh* m_pszCType;
  const XMLCh* m_pszType;
  const XMLCh* m_pszErrCode;
  const XMLCh* m_pszOpCode;
  const XMLCh* m_pszChkBody;
  const XMLCh* m_pszDefErr;
  const XMLCh* m_pszDefOp;
  const XMLCh* m_pszDefaultOp;
  const XMLCh* m_pszDefaultErr;
};

OI_END_CLASSEXPORT

#endif /*ONION_HEADER_DAVSERVERPOLICY_H*/
