/* 
   Container of XML nodes
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: DavXmlBuffer.h 132 2005-06-24 09:09:43Z komat $
*/

#ifndef ONION_HEADER_DAVXMLBUFFER_H
#define ONION_HEADER_DAVXMLBUFFER_H 1

#include <onion/OnionCfg.h>
#include <xercesc/dom/DOMElement.hpp>
#include <xercesc/dom/DOMDocument.hpp>

OI_BEGIN_CLASSEXPORT

class OI_EXPORT CDavXmlBuffer
{
 public:
  CDavXmlBuffer(const char* pszDocName = OI_XMLCACHE_DOCNAME);
  ~CDavXmlBuffer();
  void Clear();
  void AppendChild(XNS(DOMElement)* pElement);
  XNS(DOMDocument)* GetDocument();
  bool ImportDocument(XNS(DOMDocument)* pDoc);
  XNS(DOMNode)* ImportNode(XNS(DOMNode)* pNode);
  bool SaveAs(const char* pszPath);
  bool Load(const char* pszPath);
  bool Load(const char* pszContent, unsigned int unLen, bool bAdopt = false);
  CDavXmlBuffer& operator=(CDavXmlBuffer& master);
 private:
  OI_STRING_A m_strDocName;
  XNS(DOMDocument)* m_pDoc;
 private:
  void initDocument();
};

OI_END_CLASSEXPORT

#endif /*ONION_HEADER_DAVXMLBUFFER_H*/
