/* 
   Definitions of onion library
   Copyright (C) 2003-2004, Lei Jiang <sledge10@hotmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   $Id: OnionDef.h 132 2005-06-24 09:09:43Z komat $
*/

#ifndef ONION_HEADER_ONIONDEF_H
#define ONION_HEADER_ONIONDEF_H 1

#ifndef NULL
#define NULL 0
#endif /* NULL */

#define OI_GENBUFSIZE 1024
#define OI_LINEBUFSIZE 512

//debug
#ifdef _DEBUG
#  define OI_ASSERT(x) assert(x)
#  define OI_VERIFY(x) OI_ASSERT(x)
#  ifdef WIN32
#    define OI_DEBUG ATLTRACE
#  else
#    define OI_DEBUG OnionDebugOutput
#  endif /*WIN32*/
#else
#  define OI_ASSERT(x)	((void)0)
#  define OI_VERIFY(x)	(x)
#  define OI_DEBUG	if(0)OnionDebugOutput
#endif /*_DEBUG*/


#define OI_DEBUG_SILENT 0x00000001
#define OI_DEBUG_FLUSH	0x00000002


//the Xerces namespace stuff
#if defined(XERCES_HAS_CPP_NAMESPACE)
#  define XNS(name) XERCES_CPP_NAMESPACE::name
#else
#  define XNS(name) name
#endif /*XERCES_HAS_CPP_NAMESPACE*/

//http
#define OI_EXP_100_LEN		1024
#define OI_MAX_HDR_LEN		8192
#define OI_MAX_HDR_FLD		100

#define OI_METHOD_CONNECT	"CONNECT"
#define OI_METHOD_COPY		"COPY"
#define OI_METHOD_DELETE	"DELETE"
#define OI_METHOD_GET		"GET"
#define OI_METHOD_LOCK		"LOCK"
#define OI_METHOD_MKCOL		"MKCOL"
#define OI_METHOD_MOVE		"MOVE"
#define OI_METHOD_OPTIONS	"OPTIONS"
#define OI_METHOD_POST		"POST"
#define OI_METHOD_PROPFIND	"PROPFIND"
#define OI_METHOD_PROPPATCH	"PROPPATCH"
#define OI_METHOD_PUT		"PUT"
#define OI_METHOD_UNLOCK	"UNLOCK"
#define OI_METHOD_SEARCH	"SEARCH"
#define OI_METHOD_HEAD		"HEAD"

//request header names
#define OI_REQHDR_AUTH		"Authorization"
#define OI_REQHDR_CONTENTTYPE	"Content-Type"
#define OI_REQHDR_DEPTH		"Depth"
#define OI_REQHDR_DESTINATION	"Destination"
#define OI_REQHDR_IF		"If"
#define OI_REQHDR_LOCKTOKEN	"Lock-Token"
#define OI_REQHDR_OVERWRITE	"Overwrite"
#define OI_REQHDR_PROXYAUTH	"Proxy-Authorization"
#define OI_REQHDR_PROXYCONN	"Proxy-Connection"
#define OI_REQHDR_RANGE		"Range"
#define OI_REQHDR_TIMEOUT	"Timeout"

//response header names
#define OI_RSPHDR_ALLOW		"Allow"
#define OI_RSPHDR_AUTH		"WWW-Authenticate"
#define OI_RSPHDR_AUTHINFO	"Authentication-Info"
#define OI_RSPHDR_CENCODING	"Content-Encoding"
#define OI_RSPHDR_CLENGTH	"Content-Length"
#define OI_RSPHDR_CRANGE	"Content-Range"
#define OI_RSPHDR_CONN		"Connection"
#define OI_RSPHDR_CTYPE		"Content-Type"
#define OI_RSPHDR_DASL		"DASL"
#define OI_RSPHDR_DAV		"DAV"
#define OI_RSPHDR_KEEPALIVE	"Keep-Alive"
#define OI_RSPHDR_LOCATION	"Location"
#define OI_RSPHDR_MSV		"MS-Author-Via"
#define OI_RSPHDR_PROXYAUTH	"Proxy-Authenticate"
#define OI_RSPHDR_PROXYAUTHINFO	"Proxy-Authentication-Info"
#define OI_RSPHDR_PROXYCONN	"Proxy-Connection"
#define OI_RSPHDR_SERVER	"Server"
#define OI_RSPHDR_TE		"Transfer-Encoding"

//socket
#define OI_SOCKBUFSIZE		4096
#define OI_SOCK_VER_MINOR	2
#define OI_SOCK_VER_MAJOR	2
#define OI_SOCK_TIMEOUTSEC	120
#define OI_SOCK_MAXTIMEOUTSEC	120
#define OI_SOCK_MAXRETRY	3


//xml
#define OI_MAX_ELEM_LEN		256
#define OI_XMLCACHE_DOCNAME	"Onion_Xml_Cache"
#define OI_XMLPOLICY_DOCNAME	"Onion_Default_Policy"
#define OI_XML_NSURI		"http://www.w3.org/2000/xmlns/"
#define OI_XML_DAVNAMESPACE	"DAV:"
#define OI_XML_CUTELEMENT	"response"
#define OI_XML_CUTELEMENT_LOCK	"activelock"
#define OI_XML_COPYDOCNAME	"D:propertybehavior"
#define OI_XML_LOCKDOCNAME	"D:lockinfo"
#define OI_XML_MOVEDOCNAME	"D:propertybehavior"
#define OI_XML_PROPFINDDOCNAME	"D:propfind"
#define OI_XML_PROPPATCHDOCNAME	"D:propertyupdate"
#define OI_XML_SEARCHDOCNAME	"D:searchrequest"
#define OI_XML_DEFAULTLOCKOWNER	"foo@bar.com"

//dav resource node parse
#define OI_RNP_RESOURCETYPE	0x00000001
#define OI_RNP_DISPLAYNAME	0x00000002
#define OI_RNP_CONTENTLENGTH	0x00000004
#define OI_RNP_LASTMODIFIED	0x00000008
#define OI_RNP_CREATIONDATE	0x00000010
#define OI_RNP_ETAG		0x00000020
#define OI_RNP_CONTENTTYPE	0x00000040
#define OI_RNP_CONTENTLANGUAGE	0x00000080
#define OI_RNP_CLASS1		0x000000ff


#define OI_RNP_EXTRAPROPERTIES	0x00100000

#define OI_RNP_EXCLUSIVELOCK	0x02000000
#define OI_RNP_SHAREDLOCK	0x04000000
#define OI_RNP_LOCK		0x06000000
#define OI_RNP_ELOCKSUPPORTED	0x00010000
#define OI_RNP_SLOCKSUPPORTED	0x00020000
#define OI_RNP_LOCKSUPPORTED	0x00030000

#define OI_RNP_QUOTA		0x00000200
#define OI_RNP_QUOTAUSED	0x00000400

#define OI_RNP_EVERYTHING	0x060306ff
#define OI_RNP_CONVENTIONAL	0x0603003f


//Lock Infomation Valid Flags
#define OI_LIVF_TYPE		0x00000001
#define OI_LIVF_SCOPE		0x00000002
#define OI_LIVF_DEPTH		0x00000004
#define OI_LIVF_TOKEN		0x00000008
#define OI_LIVF_TIMEOUT		0x00000010
#define OI_LIVF_OWNER		0x00000020
#define OI_LIVF_ALL		0x0000003f


//ssl certificate problems
#define OI_SSL_ERR_UNABLE_TO_GET_ISSUER_CERT		0x00000001
#define OI_SSL_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE	0x00000002
#define OI_SSL_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY	0x00000004
#define OI_SSL_ERR_CERT_SIGNATURE_FAILURE		0x00000008
#define OI_SSL_ERR_CERT_NOT_YET_VALID			0x00000010
#define OI_SSL_ERR_CERT_HAS_EXPIRED			0x00000020
#define OI_SSL_ERR_OUT_OF_MEM				0x00000040
#define OI_SSL_ERR_DEPTH_ZERO_SELF_SIGNED_CERT		0x00000080
#define OI_SSL_ERR_SELF_SIGNED_CERT_IN_CHAIN		0x00000100
#define OI_SSL_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY	0x00000200
#define OI_SSL_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE	0x00000400
#define OI_SSL_ERR_CERT_CHAIN_TOO_LONG			0x00000800
#define OI_SSL_ERR_CERT_REVOKED				0x00001000
#define OI_SSL_ERR_INVALID_CA				0x00002000
#define OI_SSL_ERR_PATH_LENGTH_EXCEEDED			0x00004000
#define OI_SSL_ERR_INVALID_PURPOSE			0x00008000
#define OI_SSL_ERR_CERT_UNTRUSTED			0x00010000
#define OI_SSL_ERR_CERT_REJECTED			0x00020000
#define OI_SSL_ERR_SUBJECT_ISSUER_MISMATCH		0x00040000
#define OI_SSL_ERR_AKID_SKID_MISMATCH			0x00080000
#define OI_SSL_ERR_AKID_ISSUER_SERIAL_MISMATCH		0x00100000
#define OI_SSL_ERR_KEYUSAGE_NO_CERTSIGN			0x00200000

//various formats

/* ISO8601: 2001-01-01T12:30:00Z */
/* RFC1123: Sun, 06 Nov 1994 08:49:37 GMT */
/* RFC850:  Sunday, 06-Nov-94 08:49:37 GMT */
/* asctime: Wed Jun 30 21:49:08 1993 */
/* RFC2459:	Sep 9 23:59:59 2004 GMT */
#define OI_TIMEFORMAT_ISO8601_Z "%04d-%02d-%02dT%02d:%02d:%lfZ"
#define OI_TIMEFORMAT_ISO8601_M "%04d-%02d-%02dT%02d:%02d:%lf-%02d:%02d"
#define OI_TIMEFORMAT_ISO8601_P "%04d-%02d-%02dT%02d:%02d:%lf+%02d:%02d"

#define OI_TIMEFORMAT_RFC1123	"%3s, %02d %3s %4d %02d:%02d:%02d GMT"
#define OI_TIMEFORMAT_RFC1036	"%9s, %2d-%3s-%2d %2d:%2d:%2d GMT"
#define OI_TIMEFORMAT_ASC	"%3s %3s %2d %2d:%2d:%2d %4d"
#define OI_TIMEFORMAT_RFC2459	"%3s %d %02d:%02d:%02d %4d GMT"


//memory buffer
#define OI_MEMBUF_INITSIZE	4096
#define OI_MEMBUF_INCRSIZE	4096
#define OI_MEMBUF_SIZELIMIT	4*1024*1024


//export
#ifdef SHAREDLIB
#	if defined(_MSC_VER)
#		define OI_EXPORT __declspec( dllexport )
#		define OI_BEGIN_CLASSEXPORT	__pragma( warning( disable: 4251 ) )
#		define OI_END_CLASSEXPORT	__pragma( warning( default: 4251 ) )
#		define OI_BEGIN_CPPFUNCTIONEXPORT
#		define OI_END_CPPFUNCTIONEXPORT
#		define OI_BEGIN_CFUNCTIONEXPORT	extern "C" {
#		define OI_END_CFUNCTIONEXPORT	}
#	elif defined(__MWERKS__)
#		define OI_EXPORT
#		define OI_BEGIN_CLASSEXPORT	_Pragma("export on")
#		define OI_END_CLASSEXPORT	_Pragma("export off")
#		define OI_BEGIN_CPPFUNCTIONEXPORT		_Pragma("export on")
#		define OI_END_CPPFUNCTIONEXPORT	_Pragma("export off")
#		define OI_BEGIN_CFUNCTIONEXPORT	_Pragma("export on")	\
										extern "C" {
#		define OI_END_CFUNCTIONEXPORT	}	\
										_Pragma("export off")
#	endif
#endif /*SHAREDLIB*/
#ifndef OI_EXPORT
#	define OI_EXPORT
#endif
#ifndef OI_BEGIN_CLASSEXPORT
#		define OI_BEGIN_CLASSEXPORT
#endif
#ifndef OI_END_CLASSEXPORT
#		define OI_END_CLASSEXPORT
#endif
#ifndef OI_BEGIN_CPPFUNCTIONEXPORT
#		define OI_BEGIN_CPPFUNCTIONEXPORT
#endif
#ifndef OI_END_CPPFUNCTIONEXPORT
#		define OI_END_CPPFUNCTIONEXPORT
#endif
#ifndef OI_BEGIN_CFUNCTIONEXPORT
#		define OI_BEGIN_CFUNCTIONEXPORT
#endif
#ifndef OI_END_CFUNCTIONEXPORT
#		define OI_END_CFUNCTIONEXPORT
#endif


#endif /*ONION_HEADER_ONIONDEF_H*/
