#!/bin/sh
#
# $Id$
#--------------------------------------------------------
# Create setupfile script using "teamfile.ini" file.
#
#--------------------------------------------------------

# filelist (They  MUST be ".org" prefix)
if test -n "${SQLDATA_ROOT}"; then
	FILE_LIST="${SQLDATA_ROOT}/createdata.sql.org ${SQLDATA_ROOT}/createindex.sql.org ${SQLDATA_ROOT}/createseq.sql.org ${SQLDATA_ROOT}/createtable.sql.org"
else
	FILE_LIST="createdata.sql.org createindex.sql.org createseq.sql.org createtable.sql.org"
fi

# Check for echo -n vs echo \c
if echo '\c' | grep -s c >/dev/null 2>&1 ; then
        ECHO_N="echo -n"
        ECHO_C=""
else
        ECHO_N="echo"
        ECHO_C='\c'
fi

#--------------------
# select operation
#--------------------
case "$1" in
	-f)
		if test ! -f "$2"; then
			echo "Inifile is not specified or not exist."
			exit 1
		else
			inifilename=$2
		fi

		is_silent=0
		if test "$3" = "-s"; then
			is_silent=1
		fi

		# load ".ini" file
		. "$2"
		TF_ROOT_URI="`echo /${TF_ROOT_URI} | sed -e 's:[/]\{2,\}:/:g'`"
		if test "${TF_ROOT_URI}" != "/"; then
			TF_ROOT_URI="`echo ${TF_ROOT_URI} | sed -e 's:/$::'`"
			rtdispname=`echo "X${TF_ROOT_URI}" | sed -e '1s:^X::' -e 's:^.*/::'`
		else
			rtdispname=""
		fi
		rsdepth1=`echo ${TF_ROOT_URI} | sed -e 's:[^/]::g' | awk '{ print length($1) }'`
		rsdepth2=`expr $rsdepth1 + 1`
		rsdepth3=`expr $rsdepth1 + 2`

		if test "${TF_AUTODELETE}" = "on"; then
			pt_enable_autodelete="--@@enable_autodelete--"
		else
			pt_enable_autodelete="@@enable_autodelete--"
		fi

		if test "${is_silent}" = "0"; then
			# show ".ini" entry
			echo "------------------------------------------------------------"
			echo "Location                : "${TF_ROOT_URI}
			echo "System Quota MaxSize    : "${TF_SYSQUOTA_MAX_BITES}
			echo "System Quota MaxResource: "${TF_SYSQUOTA_MAX_FILES}
			echo "Userid      (for admin) : "${TF_ROOT_USER_ID}
			echo "Password    (for admin) : "${TF_ROOT_USER_PWD}
			echo "FullName    (for admin) : "${TF_ROOT_USER_FULLNAME}
			echo "MailAddr    (for admin) : "${TF_ROOT_USER_MAILADDR}
			echo "MaxSize     (for admin) : "${TF_ROOT_USER_MAXSIZE}
			echo "MaxResource (for admin) : "${TF_ROOT_USER_MAXRES}
			echo "Repository DB type      : "${TF_DB_PROVIDER}
			echo "Repository DB name      : "${TF_DB_NAME}
			echo "Repository DB user      : "${TF_DB_USER_NAME}
			echo "Repository DB password  : "${TF_DB_USER_PWD}
			echo "Repository DB id        : "${TF_DB_ID_NAME}
			echo "Repository DB hostname  : "${TF_DB_HOST_NAME}
			echo "Repository DB port      : "${TF_DB_PORT_NO}
			$ECHO_N "The URI of groupfolder  : "$ECHO_C
			if test "${TF_DB_GRPSYNCURI}" = "on"; then
				echo "same Group Name"
				grpuriseg="grp_name_vc"
			else
				echo "different from Group Name"
				grpuriseg="grp_rs_id_c"
			fi
			echo "------------------------------------------------------------"
			$ECHO_N "Do you want to create setupfiles using these values ? (y/n) : "$ECHO_C
			read ANS1
			if test "${ANS1}" != "y"; then
				echo "OK, aborted."
				exit 2
			fi
		fi

		# Get GMT time.
		gmttime=`date -u '+%Y-%m-%dT%H:%M:%SZ'`

		# Loop files and string substitution.
		for f in ${FILE_LIST};
		do
			fname=`echo ${f} | sed -e 's/\.org//g'`
			cat ${f} | \
			sed -e 's|@@rturi|'"${TF_ROOT_URI}"'|g' \
			    -e 's|@@rtuserid|'"${TF_ROOT_USER_ID}"'|g' \
			    -e 's|@@rtuserpwd|'"${TF_ROOT_USER_PWD}"'|g' \
			    -e 's|@@rtuserfullname|'"${TF_ROOT_USER_FULLNAME}"'|g' \
			    -e 's|@@rtusermailaddr|'"${TF_ROOT_USER_MAILADDR}"'|g' \
			    -e 's|@@rtusermaxsize|'"${TF_ROOT_USER_MAXSIZE}"'|g' \
			    -e 's|@@rtusermaxres|'"${TF_ROOT_USER_MAXRES}"'|g' \
			    -e 's|@@dbprovider|'"${TF_DB_PROVIDER}"'|g' \
			    -e 's|@@dbidname|'"${TF_DB_ID_NAME}"'|g' \
			    -e 's|@@gmttime|'"${gmttime}"'|g' \
			    -e 's|@@grpuriseg|'"${grpuriseg}"'|g' \
			    -e 's|@@rtdispname|'"${rtdispname}"'|g' \
			    -e 's|@@rsdepth1|'"${rsdepth1}"'|g' \
			    -e 's|@@rsdepth2|'"${rsdepth2}"'|g' \
			    -e 's|@@rsdepth3|'"${rsdepth3}"'|g' \
			    -e 's|@@sysqtmaxbytes|'"${TF_SYSQUOTA_MAX_BITES}"'|g' \
			    -e 's|@@sysqtmaxfiles|'"${TF_SYSQUOTA_MAX_FILES}"'|g' \
			    -e 's|@@sysexecuserid|'"${TF_SYSEXEC_USER}"'|g' \
			    -e 's|@@sysexecuserpw|'"${TF_SYSEXEC_USERPW}"'|g' \
				-e 's|@@guestuserid|'"${TF_GUEST_USER}"'|g' \
				-e 's|@@guestuserpw|'"${TF_GUEST_USERPW}"'|g' \
				-e 's|'"${pt_enable_autodelete}"'||g' \
			    > ${fname}
			RETVAL=$?
			if test "${RETVAL}" != 0; then
				exit ${RETVAL}
			fi
		done
		echo "ok"
		;;
	-d)
		for f in ${FILE_LIST};
		do
			fname=`echo ${f} | sed -e 's/\.org//g'`
			[ -f ${fname} ] && rm ${fname}
		done
		echo "ok"
		;;
	*)
		echo "Usage: $0 { -f xxx.ini | -d } { -s }"
		;;
esac

exit 0

