#!/bin/sh

# $Id:$
#
# user storage alignment tool 
# Copyright (c) 2023 BAYBITS LLC, TeamFile team All rights reserved.

#------------------
# set env
#------------------
function usage {
	echo "usage: ajuststg.sh db_xxxxx"
	exit 1
}

if test -d "${TF_HOME}"; then
	MT_FUNCTION_HOME="${TF_HOME}/bin"
	MT_FUNCTION="${MT_FUNCTION_HOME}/mt-lib"
else
	if test -f "./mt-lib"; then
		MT_FUNCTION_HOME="."
	else
		MT_FUNCTION_HOME="/usr/local/teamfile/www/bin"
	fi
	MT_FUNCTION="${MT_FUNCTION_HOME}/mt-lib"
fi

if test ! -f ${MT_FUNCTION}; then
	echo "The configuration script \"${MT_FUNCTION}\" was missing. Please check it."
	exit 1
fi

# read functions and configuration
. ${MT_FUNCTION}

dbname=
if test $# -ne 1; then
	usage
fi

dbname=$1
dbuser=tfdbuser

UPDUSERS=
${PSQL} -U${dbuser} ${dbname} -c "select 1" >/dev/null 2>&1
if [[ $? != 0 ]]; then
	echo "Error: ${dbname} not found";
	exit $?
fi

RES=`${PSQL} -q -U${dbuser} ${dbname} <<_END_
\pset format unaligned
\pset t
begin;
select usr_usr_id_vc,usqt_used_st_bi,usqt_used_res_bi from divy_usr inner join divy_usrdiskquota on divy_usrdiskquota.usqt_usr_id_vc=divy_usr.usr_usr_id_vc and (usr_extended_status_c like '________L_______________________' or usr_admin_mod_i = 1);
end;
_END_
`

TOTAL=0
MISS=0
for line in  $RES
do
	TOTAL=`expr $TOTAL + 1`
	usr=`echo $line | cut -d'|' -f1`
	size=`echo $line | cut -d'|' -f2`

	if test $size -eq "0"; then
		continue
	fi
sum=`${PSQL} -q -U${dbuser} ${dbname} <<_END2_
\pset format unaligned
\pset fieldsep '|'
\pset t
begin;
select sum(rs_get_cont_len_bi) from dav_resource where rs_lastmodifier_usr_id_vc='${usr}';
end;
_END2_
`

	if test $size -ne $sum; then
		UPDUSERS="$UPDUSERS $usr"
		MISS=`expr $MISS + 1`
		echo "$usr :$size - SUM:$sum = `expr $size - $sum`"
	fi
done

if [[ $MISS -gt 0 ]]; then
	while :
	do
		echo -n "Alignment (y/n)? "
		read ans
		case $ans in
			y) break ;;
			n) echo "OK."; exit 0;;
			*)
			;;
		esac
	done
fi

# okey. let's go !!
for u in $UPDUSERS
do
${PSQL} -q -U${dbuser} ${dbname} <<_END3_
\pset format unaligned
\pset fieldsep '|'
\pset t
begin;
update divy_usrdiskquota set usqt_used_st_bi=(select coalesce(sum(rs_get_cont_len_bi),0)  from dav_resource where rs_lastmodifier_usr_id_vc='${u}'),usqt_used_res_bi=(select count(*) from dav_resource where rs_lastmodifier_usr_id_vc='${u}' and rs_get_cont_type_vc not in ('httpd/unix-directory','httpd/trash-directory')) where usqt_usr_id_vc='${u}';
commit;
_END3_

done

echo 'done'

exit 0
