#!/bin/sh
#-------------------------------------------------------------------------------
# $Id$
#
# The TeamFile server license update.
# (note)
#    This script is only called by tfscheduler script.
#
# Copyright (c) 2006,2007 COMPUTER HI-TECH INC., All rights reserved.
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# env setting
#-------------------------------------------------------------------------------
if test -d "${TF_HOME}"; then
	MT_FUNCTION_HOME="${TF_HOME}/www/bin"
	MT_FUNCTION="${MT_FUNCTION_HOME}/mt-lib"
else
	if test -f "./mt-lib"; then
		MT_FUNCTION_HOME="."
	else
		MT_FUNCTION_HOME="/usr/local/teamfile/www/bin"
	fi
	MT_FUNCTION="${MT_FUNCTION_HOME}/mt-lib"
fi

if test ! -f ${MT_FUNCTION}; then
	echo "The configuration script \"${MT_FUNCTION}\" was missing. Please check it."
	exit 1
fi

# read functions and configuration
. ${MT_FUNCTION}

#-------------------------------------------------------------------------------
# Define fixed values
#-------------------------------------------------------------------------------

#
# (note) ここで定義されたファイル名、ディレクトリ名は $apache/cgi-bin/lcuploader で意識しています.
#
LICENSE_TMP_DIR="${TF_CONFDIR}/tmp"
LICENSE_TMP_FILE="${LICENSE_TMP_DIR}/tf_license.conf"
RESTART_FILE="${LICENSE_TMP_DIR}/.restart"

LICENSE_FILE="${TF_CONFDIR}/tf_license.conf"

#-------------------------------------------------------------------------------
# main
#-------------------------------------------------------------------------------

#
# copy temporary license file
#
if test -f "${LICENSE_TMP_FILE}"; then
	cp ${LICENSE_TMP_FILE} ${LICENSE_FILE}
	RETVAL=$?
	if test "${RETVAL}" != 0; then
		echo "Failed to copy license file."
		exit 1
	fi
	rm -f ${LICENSE_TMP_FILE}
fi

#
# Restart TeamFile server
#
if test -r ${RESTART_FILE}; then
	${APACHECTL} restart
	RETVAL=$?
	if test "${RETVAL}" = 0; then
		rm -f ${RESTART_FILE}
	fi
fi

exit 0

