#!/bin/sh

#
# $Id$
# TeamFileよりグループファイルをすべてローカルディスクに配置するスクリプト
# 
# dumpgroup.sh new_teamfile.conf
#

if test -d "${TF_HOME}"; then
	MT_FUNCTION_HOME="${TF_HOME}/bin"
	MT_FUNCTION="${MT_FUNCTION_HOME}/mt-lib"
else
	if test -f "./mt-lib"; then
		MT_FUNCTION_HOME="."
	else
		MT_FUNCTION_HOME="/usr/local/teamfile/www/bin"
	fi
	MT_FUNCTION="${MT_FUNCTION_HOME}/mt-lib"
fi

if test ! -f ${MT_FUNCTION}; then
	echo "The configuration script \"${MT_FUNCTION}\" was missing. Please check it."
	exit 1
fi

# read functions and configuration
. ${MT_FUNCTION}

PSQLOPT="-t -A -F|"
TMPFILE=sqlresult.$$
ERRFILE=error.$$


log() {
	echo "### `date "+%F %T"` $1" 
}

/usr/bin/id -u >/dev/null
if [[ $? -ne 0 ]]; then
	echo "root only"
	exit 1
fi

if [[ $# < 1 ]]; then
	echo "引数にnew_から始まる設定ファイル名が必要です"
	exit 1
fi

# 設定ファイルをパースする
CONFIG_FILE="/usr/local/teamfile/www/conf/conf.d/$1"
if [[ ! -f $CONFIG_FILE ]]; then
	echo "$CONFIG_FILE not found."
	exit 1
fi

parse_locationconf $CONFIG_FILE

log "start"

${TF_HOME}/tfpgsql/bin/psql ${PSQLOPT} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select rs_uri_txt, rs_resourcetype_i ,rs_get_lastmodified_bi,rs_physical_path_txt from dav_resource where rs_uri_txt like '/${ENV_LocationName}/Group Folder/%'  order by rs_uri_txt asc;" >>$TMPFILE

TOTAL=`wc -l $TMPFILE | cut -d' ' -f1`
ERRCNT=0
OLD_IFS=$IFS
IFS="|"
while read url type lastmod path
do
	echo $TOTAL $url
	TOTAL=`expr $TOTAL - 1`
	if [ $type == 1 ];then
		mkdir -p  "."$url
	else
		cp -pr  ${ENV_TfFsRootPath}$path "."$url
		result=$?
		if [ $result != 0 ]; then
			ERRCNT=`expr $ERRCNT + 1`
			echo "copy error code = $result / url = $url" >>$ERRFILE
			continue
		fi

		touch -d "`date "+%F %T" -d @$lastmod`" ${ENV_TfFsRootPath}${path}
		result=$?
		if [ $result != 0 ]; then
			ERRCNT=`expr $ERRCNT + 1`
			echo "lastmodified change error code = $result url = $url">>$ERRFILE
			continue
		fi

	fi

done < $TMPFILE
IFS=$OLD_IFS

echo "error count = $ERRCNT"
### Clean
rm -f $TMPFILE
log "end"
