#!/bin/sh
#
# $Id$
#-------------------------------------------------------
# F-Secure 用ラッパースクリプト
# [ Usage ]
#	./fsav.sh (FileName)
#
#-------------------------------------------------------
FILEPATH="$@"
shift
if test -z "$FILEPATH"; then
	exit 1
fi

#-----------------
# set env
#-----------------
SED="/bin/sed"
RM="/bin/rm"
FILE_CMD="/usr/bin/file"

PDIR=`echo "/$0" | $SED -e 's:/[^/]*$::' -e 's:^/::'`
if test -z "${PDIR}"; then
	PDIR="."
fi
TF_FSAV_CONF_DEFAULT="${PDIR}/tffsav.conf.default"
TF_FSAV_CONF="${PDIR}/tffsav.conf"

# initialize values
TF_FSAV_SCAN_TIMEOUT="0"
TF_FSAV_SCAN_SKIP_MSI="0"
TF_FSAV_SCAN_SKIP_ZIP="0"
TF_FSAV_SCAN_SKIP_GZ="0"
TF_FSAV_SCAN_SKIP_BZ2="0"
TF_FSAV_SCAN_SKIP_LZH="0"
TF_FSAV_SCAN_SKIP_CAB="0"
TF_FSAV_SCAN_LARGEFILE="0"
TF_FSAV_SCAN_FILE_SIZE=0

# read configuration values
if test -f "${TF_FSAV_CONF_DEFAULT}"; then
	. ${TF_FSAV_CONF_DEFAULT}
fi

if test -f "${TF_FSAV_CONF}"; then
	. ${TF_FSAV_CONF}
fi

if test -z "${TF_FSAV_SCAN_TIMEOUT}"; then
	TF_FSAV_SCAN_TIMEOUT=0
fi

if test ${TF_FSAV_SCAN_FILE_SIZE} -gt `ls -l $FILEPATH | awk '{print $5}'`;then
	exit 0
fi

#-----------------
# set cmd
#-----------------
FSAV_ARC_CMD="/usr/bin/fsav --dumb=on --silent=on --archive=on --stoponfirst=on --scantimeout=${TF_FSAV_SCAN_TIMEOUT} --skiplarge=${TF_FSAV_SCAN_LARGEFILE}"
FSAV_NOARC_CMD="/usr/bin/fsav --dumb=on --silent=on --archive=off --stoponfirst=on --scantimeout=${TF_FSAV_SCAN_TIMEOUT} --skiplarge=${TF_FSAV_SCAN_LARGEFILE}"
OUTPUT_FILE=`mktemp /tmp/fsav.out.$$.XXXXXX`
ftype=`$FILE_CMD $FILEPATH | $SED -e 's/^.*:[ ]*//g'`

FSAV_CMD="${FSAV_ARC_CMD}"
case "${ftype}" in
	Microsoft\ Office\ Document*)
		if test "${TF_FSAV_SCAN_SKIP_MSI}" = 1; then
			FSAV_CMD="${FSAV_NOARC_CMD}"
		fi
		;;
	Zip\ archive\ data*)
		if test "${TF_FSAV_SCAN_SKIP_ZIP}" = 1; then
			FSAV_CMD="${FSAV_NOARC_CMD}"
		fi
		;;
	gzip\ compressed\ data*)
		if test "${TF_FSAV_SCAN_SKIP_GZ}" = 1; then
			FSAV_CMD="${FSAV_NOARC_CMD}"
		fi
		;;
	bzip2\ compressed\ data*)
		if test "${TF_FSAV_SCAN_SKIP_BZ2}" = 1; then
			FSAV_CMD="${FSAV_NOARC_CMD}"
		fi
		;;
	LHa*)
		if test "${TF_FSAV_SCAN_SKIP_LZH}" = 1; then
			FSAV_CMD="${FSAV_NOARC_CMD}"
		fi
		;;
	InstallShield\ Cabinet*)
		if test "${TF_FSAV_SCAN_SKIP_CAB}" = 1; then
			FSAV_CMD="${FSAV_NOARC_CMD}"
		fi
		;;
	*)
		FSAV_CMD="${FSAV_ARC_CMD}"
		;;
esac

$FSAV_CMD $FILEPATH 2> ${OUTPUT_FILE} >/dev/null
RETVAL=$?

if test "${RETVAL}" != 0 && test "${RETVAL}" != 3 && test -s ${OUTPUT_FILE}; then
	ERRSTR=`$SED -n -e 's!'"$FILEPATH:"'!!g' -e 's/^[ ][ ]*//g' -e 's/[ ][ ]*$//g' -e '/^ERROR:/p' ${OUTPUT_FILE}`
	case "$ERRSTR" in
		*Password\ protected\ file)
			if test "${RETVAL}" = 9; then
				RETVAL=0
			fi
			;;
		*Scan\ timeout.)
			;;
		*Maximum\ nested\ archives\ encountered.)
			if test "${RETVAL}" = 9; then
				RETVAL=0
			fi
			;;
		*Bad\ archive)
			if test "${RETVAL}" = 9; then
				RETVAL=0
			fi
			;;
	esac
fi

$RM -f ${OUTPUT_FILE}
exit $RETVAL
