#!/bin/sh
#
# $Id$
#-------------------------------------------------------------------------------
# Maintenance Script (for Administrator)
#
# Copyright (c) BAYBITS LLC. All rights reserved.
#-------------------------------------------------------------------------------

#------------------
# Suupport Level
#------------------
SUPPORT_OPLOG_FUNCTION=1

#------------------
# set env
#------------------
if test -d "${TF_HOME}"; then
	MT_FUNCTION_HOME="${TF_HOME}/www/bin"
	MT_FUNCTION="${MT_FUNCTION_HOME}/mt-lib"
else
	if test -f "./mt-lib"; then
		MT_FUNCTION_HOME="."
	else
		MT_FUNCTION_HOME="/usr/local/teamfile/www/bin"
	fi
	MT_FUNCTION="${MT_FUNCTION_HOME}/mt-lib"
fi

if test ! -f ${MT_FUNCTION}; then
	echo "The configuration script \"${MT_FUNCTION}\" was missing. Please check it."
	exit 1
fi

# read functions and configuration
. ${MT_FUNCTION}

# The file path of location configuration template.
DIVY_LOCATION_TEMPLATE_FILE="${TF_CONFDIR}/newlocation_template"

# The file path of default location configuration
DIVY_LOCATION_TEMPLATE_DEFAULT_FILE="${TF_CONFDIR}/newlocation_template.default"

EXCLUSIVE_LOCKFILE="${TMP_BASE_DIR}/maintenance.lock"
TMP_RESULT_FILE="${TMP_BASE_DIR}/tmp_result.txt"

export PGCLIENTENCODING
stty erase 

#
NEWLOCATION_INI=

#---------------
# for MacOSX
#---------------
MPKG_INSTALLED_PKG_ROOT="/Library/Receipts"
MPKG_INSTALLED_PKG_LIST103="mod_dav_tf.pkg apache2.pkg mod_encoding.pkg postgresql.pkg readline.pkg libxslt.pkg"
MPKG_INSTALLED_PKG_LIST102="mod_dav_tf.pkg apache2.pkg mod_encoding.pkg postgresql.pkg readline.pkg libxml2.pkg libxslt.pkg libiconv.pkg"
MPKG_INSTALLED_STARTUP_ROOT="/Library/StartupItems"
MPKG_INSTALLED_STARTUP_LIST="TeamFileServer PostgreSQL"

#---------------
# for Solaris9
#---------------
SPKG_INSTALLED_PKGNAME_LIST="TFmoddavtf TFmodencoding TFapache2 TFpostgres TFopenldap TFsasl"
SPKG_INSTALL_PKG_LIST="cyrus-sasl-2.1.18-sol9-sparc-local.pkg openldap-2.1.30-sol9-sparc-local.pkg postgresql-sol9-sparc-local.pkg apache2.0.52-sol9-sparc-local.pkg mod_encoding-sol9-sparc-local.pkg mod_dav_tf-sol9-sparc-local.pkg"

#---------------
# set trap
#---------------
trap : HUP
trap : INT
trap "exitscript 0" QUIT
trap "exitscript 0" TERM
trap "exitscript 0" KILL

#-----------------------------------------------------------------------
# Show Usage
#-----------------------------------------------------------------------
show_usage() {
	echo "Usage: $0 [-o newlocation -f (newlocation.ini file) [-s]] [-h]"
	echo
	echo "    -o : Type of operation (newlocation)"
	echo "    -f : Configuration file path"
	echo "    -s : Silent mode (no confirm. Be careful)"
	echo

}


#-----------------------------------------------------------------------
#-----------------------------------------------------------------------
wait_enter() {
	echo ""
#	/sbin/getkey -c 5 -m $"Return to main menu ... %d "
	$ECHO_N "Press any key to return ..."$ECHO_C
	read dummy
}

#-----------------------------------------------------------------------
# exit script
#-----------------------------------------------------------------------
exitscript() {
	unlockscript "${EXCLUSIVE_LOCKFILE}"
	exit $1
}

#-----------------------------------------------------------------------
# Build Title Line
#-----------------------------------------------------------------------
build_title_line() {

	TITLE_LINE="---------------------------------------------------"

	# get os type string
	getOsType
	OSTYPE=$?

	# get release number
	own_release=`grep '^# [\$]Id\:' $0 | sed -e 's/[#\$\:]//g' | awk '{ print $3 }'`
	[ "$?" != "0" ] && return 1

	# get version number
	get_package_version_string
	[ "$?" != "0" ] && return 1

	# build string
	TITLE_LINE=`echo "${TITLE_LINE} ${PKG_VERSION_STR}(${own_release}) (${OSTYPE_STR}) " | \
		awk '{ print substr($0,length($0) - 50) }'`
}

#-----------------------------------------------------------------------
# Get product package directory name
#-----------------------------------------------------------------------
PRODUCT_PKG_DIR=""
get_product_pkg_dir() {
	base_pkg_dir="/mnt/cdrom/server/setupfiles"

	if test "${OSTYPE}" = "${OS_LINUX_RH7}"; then
		PRODUCT_PKG_DIR="${base_pkg_dir}/RH7.3"
	elif test "${OSTYPE}" = "${OS_LINUX_RH8}"; then
		PRODUCT_PKG_DIR="${base_pkg_dir}/RH8.0"
	elif test "${OSTYPE}" = "${OS_LINUX_RH9}"; then
		PRODUCT_PKG_DIR="${base_pkg_dir}/RH9.0"
	elif test "${OSTYPE}" = "${OS_LINUX_RHEL3}"; then
		PRODUCT_PKG_DIR="${base_pkg_dir}/RHEL3"
	elif test "${OSTYPE}" = "${OS_LINUX_CENT4}" || test "${OSTYPE}" = "${OS_LINUX_RHEL4}"; then
		PRODUCT_PKG_DIR="/media/cdrecorder/server/setupfiles/RHEL4"
	elif test "${OSTYPE}" = "${OS_LINUX_CENT5}" || test "${OSTYPE}" = "${OS_LINUX_RHEL5}"; then
		PRODUCT_PKG_DIR="/media/cdrecorder/server/setupfiles/RHEL5"
	elif test "${OSTYPE}" = "${OS_LINUX_RHEL6}" || test "${OSTYPE}" = "${OS_LINUX_CENT6}"; then
		PRODUCT_PKG_DIR="/media/cdrecorder/server/setupfiles/RHEL6"
	elif test "${OSTYPE}" = "${OS_LINUX_RHEL7}"; then
		PRODUCT_PKG_DIR="/media/cdrecorder/server/setupfiles/RHEL7"
	elif test "${OSTYPE}" = "${OS_LINUX_RHEL8}"; then
		PRODUCT_PKG_DIR="/media/cdrecorder/server/setupfiles/RHEL8"
	elif test "${OSTYPE}" = "${OS_LINUX_WBEL3}"; then
		PRODUCT_PKG_DIR="${base_pkg_dir}/WBEL3"
	elif test "${OSTYPE}" = "${OS_LINUX_WBEL4}"; then
		PRODUCT_PKG_DIR="${base_pkg_dir}/WBEL4"
	elif test "${OSTYPE}" = "${OS_SOLARIS}"; then
		PRODUCT_PKG_DIR="${base_pkg_dir}/Solaris9"
	fi
}

#-----------------------------------------------------------------------
# get location name from respository database (PostgreSQL only)
# (note)
#    This function set file path to "LOCATION_NAME" env.
# (argument)
#	$1: database name of PostgreSQL
#	$2: database hostname
#	$3: database hostport
#	$4: database access user
#-----------------------------------------------------------------------
LOCATION_NAME=""
get_location_name() {
	pgdbname="$1"
	pghost="$2"
	pgport="$3"
	pguser="$4"

	if test -z "${pgdbname}" || test -z "${pghost}" || test -z "${pgport}" || test -z "${pguser}"; then
		echo "found EMPTY value"
		return 1
	fi

	LOCATION_NAME=`${PSQL} -d ${pgdbname} -h ${pghost} -p ${pgport} -U ${pguser} -c "select rs_uri_txt from dav_resource where rs_depth_i=1 limit 1" 2>/dev/null | sed -n -e 's/[ ]*//g' -e '/[ ]*\/[a-zA-Z0-9]/p'`
}

#-----------------------------------------------------------------------
# Backup setting file and data files
#-----------------------------------------------------------------------
backup_setting_data() {

	BACKUP_BASE_DIR="${TMP_BASE_DIR}/backup_`date +%Y%m%d_%H%M%S`"
	BACKUP_CONF_DIR="${BACKUP_BASE_DIR}/conf"
	BACKUP_BIN_DIR="${BACKUP_BASE_DIR}/binary"
	BACKUP_DATA_DIR="${BACKUP_BASE_DIR}/data"

	# create backup directory
	create_backup_dir ${BACKUP_BASE_DIR}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		if test ${INTERACTIVE} = 1; then
			echo "Failed to create backup base directory."
		fi
		return 1
	fi

	$ECHO_N "Backup configuration ? (y/n) (default: y) : "$ECHO_C
	read ANS
	if test "${ANS}" != 'n'; then
		$ECHO_N "..."$ECHO_C
		backup_configuration ${BACKUP_CONF_DIR}
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			if test ${INTERACTIVE} = 1; then
				echo "Failed to backup files."
			fi
			return 1
		fi
		if test ${INTERACTIVE} = 1; then
			echo "OK. (Backup dir: ${BACKUP_CONF_DIR})"
		fi
	fi

	$ECHO_N "Backup binary files ? (y/n) (default: y) : "$ECHO_C
	read ANS
	if test "${ANS}" != 'n'; then
		$ECHO_N "..."$ECHO_C
		backup_binary ${BACKUP_BIN_DIR}
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to backup files."
			return 1
		fi
		echo "OK. (Backup dir: ${BACKUP_BIN_DIR})"
	fi

	if test "${REPOS_DBTYPE}" = "pg"; then
		$ECHO_N "Backup PostgreSQL Data directory ? (y/n) (default: y) : "$ECHO_C
		read ANS
		if test "${ANS}" != 'n'; then
			$ECHO_N "..."$ECHO_C
			backup_pgdata_directory ${BACKUP_DATA_DIR}
			RETVAL=$?
			if test "${RETVAL}" != "0"; then
				echo "Failed to backup files."
				return 1
			fi
			echo "OK. (Backup dir: ${BACKUP_DATA_DIR})"
		fi
	fi

	return 0
}

#-----------------------------------------------------------------------
# setup db env
# if "NEED_SERVER" is "1", check whether this host is DB server or not.
# if "USE_INIT" is "1", ignore PG cluster data
# if "NO_PGUSER" is "1", skip PGUSER
# if "NO_PGDATABASE" is "1", skip PGDATABASE
#-----------------------------------------------------------------------
setup_dbenv() {

	# check server host
	if test "${NEED_SERVER}" = "1"; then
		# check "PGDATA"
		if test -z "${PGDATA}"; then
			PGDATA="/var/lib/tfpgsql/PGDATA"

			$ECHO_N "Input DB DATA path (default: ${PGDATA}) : "$ECHO_C
			read pg_data
			if test -n "${pg_data}"; then
				PGDATA=`echo ${pg_data}`
			fi
		fi

		if test ! -d "${PGDATA}"; then
			echo "The directory of ${PGDATA} is missing."
			echo "Please check it and whethere THIS host is a DB SERVER."
			return 1
		fi

		if test "${USE_INIT}" != "1"; then
			if test ! -x "${PG_HOME}/bin/initdb"   -o \
				! -x "${PG_HOME}/bin/pg_ctl" -o \
				! -x "${PG_HOME}/bin/postgres" -o \
				! -x "${PGDUMP}"  -o \
				! -x "${PGRESTORE}" -o \
				! -r "${PGDATA}/PG_VERSION" -o \
				! -d "${PGDATA}/base" -o ! -d "${PGDATA}/global" -o \
				! -d "${PGDATA}/pg_clog" -o ! -d "${PGDATA}/pg_xlog" -o \ ; then

				USE_INIT=0
				echo "This host is NOT repository database SERVER."
				echo "Please run this script on repository database SERVER."
				return 1
			fi
		else
			if test ! -x "${PG_HOME}/bin/initdb"   -o \
				! -x "${PG_HOME}/bin/pg_ctl" -o \
				! -x "${PG_HOME}/bin/postgres" -o \
				! -x "${PGDUMP}"  -o \
				! -x "${PGRESTORE}"; then

				USE_INIT=0
				echo "This host is NOT repository database SERVER."
				echo "Please run this script on repository database SERVER."
				return 1
			fi
		fi
	fi

	# check "PGHOST"
	if test -z "${PGHOST}"; then
		PGHOST="localhost"
	fi

	$ECHO_N "Input DB Host (default: ${PGHOST}) : "$ECHO_C
	read pg_host
	if test -z "${pg_host}" -a -z "${PGHOST}"; then
		echo "The value of DB Host is EMPTY."
		return 1
	elif test -z "${pg_host}"; then
		# use defult. (nothing to do)
		export PGHOST
	else
		PGHOST=`echo ${pg_host}`
		export PGHOST
	fi

	# check "PGPORT"
	if test -z "${PGPORT}"; then
		PGPORT="5432"
	fi

	$ECHO_N "Input DB Port (default: ${PGPORT}) : "$ECHO_C
	read pg_port
	if test -z "${pg_port}" -a -z "${PGPORT}"; then
		echo "The value of DB Port is EMPTY."
		return 1
	elif test -z "${pg_port}"; then
		# use defult. (nothing to do)
		export PGPORT
	else
		PGPORT=`echo ${pg_port}`
		export PGPORT
	fi

	# check "PGUSER"
	if test "${NO_PGUSER}" != "1"; then
		$ECHO_N "Input DB User (default: ${PGUSER}) : "$ECHO_C
		read pg_user
		if test -z "${pg_user}" -a -z "${PGUSER}"; then
			echo "The value of DB User is EMPTY."
			NO_PGUSER=0
			return 1
		elif test -z "${pg_user}"; then
			# use defult. (nothing to do)
			export PGUSER
		else
			PGUSER=`echo ${pg_user}`
			export PGUSER
		fi
	fi
	NO_PGUSER=0

	# check "PGDATABASE"
	if test "${NO_PGDATABASE}" != "1"; then
		$ECHO_N "Input DB Name (default: ${PGDATABASE}) : "$ECHO_C
		read pg_database
		if test -z "${pg_database}" -a -z "${PGDATABASE}"; then
			echo "The value of DB Name is EMPTY."
			NO_PGDATABASE=0
			return 1
		elif test -z "${pg_database}"; then
			# use defult. (nothing to do)
			export PGDATABASE
		else
			PGDATABASE=`echo ${pg_database}`
			export PGDATABASE
		fi
	fi
	NO_PGDATABASE=0

	return 0
}

#-------------------------------------------------------------------------------
# Show Starup & Stop menu
#-------------------------------------------------------------------------------
display_startup_menu() {
	clear
	echo " +--------------${TITLE_LINE}---+"
	echo " | [ Start & Stop operation menu ]                                    |"
	echo " |                                                                    |"
	echo " | please select this number.                                         |"
	echo " |                                                                    |"
	echo " | 1  : Start   TeamFile                                [ root only ] |"
	echo " | 2  : Stop    TeamFile                                [ root only ] |"
	echo " | 3  : Restart TeamFile (Stop & Start)                 [ root only ] |"
	echo " | 4  : Reload  TeamFile (graceful)                     [ root only ] |"
	echo " | 5  : Start   Repository DataBase                     [ root only ] |"
	echo " | 6  : Stop    Repository DataBase                     [ root only ] |"
	echo " | 7  : Restart Repository DataBase                     [ root only ] |"
	echo " | 8  : Reload  Repository DataBase                     [ root only ] |"
	echo " |                                                                    |"
	echo " | r  : Return to main menu                                           |"
	echo " | q  : Quit                                                          |"
	echo " +--------------------------------------------------- Start & Stop ---+"
}

show_startup_menu() {
	while [ 1 ];
	do
		display_startup_menu
		$ECHO_N "  Input number : "$ECHO_C
		read ANS
		case "$ANS" in
			1)
				start_teamfile
				wait_enter
				;;
			2)
				stop_teamfile
				wait_enter
				;;
			3)
				restart_teamfile
				wait_enter
				;;
			4)
				reload_teamfile
				wait_enter
				;;
			5)
				start_postgresql
				wait_enter
				;;
			6)
				stop_postgresql
				wait_enter
				;;
			7)
				restart_postgresql
				wait_enter
				;;
			8)
				reload_postgresql
				wait_enter
				;;
			r)
				return
				;;
			q)
				echo "bye"
				exitscript 0
				;;
		esac
	done
}

#--------------------------------------
# Create new Location and Repository database
#--------------------------------------
# (note)
#   oracle の場合はDB・tablespace は作成済みの前提です。(ユーザ作成から)
#
create_location() {
	IS_SILENT="$1"
	LOCATION_INI="$2"
	USE_DEFAULT_FILE=1
	INTERACTIVE_MODE=1
	if test -f "${LOCATION_INI}"; then
		USE_DEFAULT_FILE=0
		INTERACTIVE_MODE=0
	fi

	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${USE_DEFAULT_FILE}" = 1; then
		# read default template configuration
		if test -f ${DIVY_LOCATION_TEMPLATE_DEFAULT_FILE}; then
			. ${DIVY_LOCATION_TEMPLATE_DEFAULT_FILE}
		fi

		# read overwrite configuration
		if test -f ${DIVY_LOCATION_TEMPLATE_FILE}; then
			. ${DIVY_LOCATION_TEMPLATE_FILE}
		fi
	fi

	#------------------------------------
	# Load values
	#------------------------------------
	if test "${INTERACTIVE_MODE}" = 0; then
		. ${LOCATION_INI}
	fi

	#------------------------------------
	# input values
	#------------------------------------

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input Name of Location : "$ECHO_C
		read TF_ROOT_URI
	fi
	if test -z "${TF_ROOT_URI}"; then
		echo "The name of Location is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi
	tmp=`echo ${TF_ROOT_URI} | sed -e 's:/$::'`
	if test -z "${tmp}" || test "${tmp}" = "/"; then
		echo "This server dose not allow '/' Location"
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	TF_ROOT_URI="`echo /${TF_ROOT_URI} | sed -e 's:[/]\{2,\}:/:g' -e '1s:/$::'`"
	displayname=`echo "X${TF_ROOT_URI}" | sed -e '1s/^X//' -e 's%^.*/%%'`

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input System Quota of size (default: ${TF_SYSQUOTA_MAX_BITES}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_SYSQUOTA_MAX_BITES=${tmp}
		fi
	fi
	if test -z "${TF_SYSQUOTA_MAX_BITES}"; then
		echo "System Quota of size is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input System Quota of files (default: ${TF_SYSQUOTA_MAX_FILES}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_SYSQUOTA_MAX_FILES=${tmp}
		fi
	fi
	if test -z "${TF_SYSQUOTA_MAX_FILES}"; then
		echo "System Quota of files is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input Name of Administrator (default: ${TF_ROOT_USER_ID}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_ROOT_USER_ID=${tmp}
		fi
	fi
	if test -z "${TF_ROOT_USER_ID}"; then
		echo "The name of administrator is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Do you encipher and save a password ?[on/off] (default: ${TF_USE_ENCRYPT_USER_PASSWORD}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_USE_ENCRYPT_USER_PASSWORD=${tmp}
		fi
	fi
	if test -z "${TF_USE_ENCRYPT_USER_PASSWORD}"; then
		echo "The encipher-type of storing password is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	TF_ROOT_USER_PWD_PLAIN=
	if test "${TF_USE_ENCRYPT_USER_PASSWORD}" = "off"; then
		if test "${INTERACTIVE_MODE}" = 1; then
			$ECHO_N "Input Password of Administrator (default: ${TF_ROOT_USER_PWD}) : "$ECHO_C
			read tmp
			if test -n "${tmp}"; then
				TF_ROOT_USER_PWD=${tmp}
			fi
		fi
		TF_ROOT_USER_PWD_PLAIN=${TF_ROOT_USER_PWD}
	elif test "${TF_USE_ENCRYPT_USER_PASSWORD}" = "on"; then
		if test "${INTERACTIVE_MODE}" = 1; then
			$ECHO_N "Input PLAINTEXT Password of Administrator (default: ${TF_ROOT_USER_PWD}) : "$ECHO_C
			read tmp
			if test -z "${tmp}"; then
				tmp=${TF_ROOT_USER_PWD}
			fi
			TF_ROOT_USER_PWD_PLAIN=${tmp}
			TF_ROOT_USER_PWD=`$TF_MD5 ${tmp}`
		else
			TF_ROOT_USER_PWD_PLAIN=${TF_ROOT_USER_PWD}
			TF_ROOT_USER_PWD=`$TF_MD5 ${TF_ROOT_USER_PWD}`
		fi
	fi
	if test -z "${TF_ROOT_USER_PWD}"; then
		echo "The password of administrator is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input FullName of Administrator (default: ${TF_ROOT_USER_FULLNAME}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_ROOT_USER_FULLNAME=${tmp}
		fi
	fi
	if test -z "${TF_ROOT_USER_FULLNAME}"; then
		echo "The fullname of administrator is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input MailAddr of Administrator (default: ${TF_ROOT_USER_MAILADDR}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_ROOT_USER_MAILADDR=${tmp}
		fi
	fi
	if test -z "${TF_ROOT_USER_MAILADDR}"; then
		echo "The mailaddr of administrator is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input MaxQuota Size of Administrator (default: ${TF_ROOT_USER_MAXSIZE}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_ROOT_USER_MAXSIZE=${tmp}
		fi
	fi
	if test -z "${TF_ROOT_USER_MAXSIZE}"; then
		echo "The maxquota size of administrator is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi
	# check systemquota limit
	if test "${TF_SYSQUOTA_MAX_BITES}" != "0" && test "${TF_ROOT_USER_MAXSIZE}" != "0" && \
	   test `expr ${TF_SYSQUOTA_MAX_BITES}` -lt `expr ${TF_ROOT_USER_MAXSIZE}`; then
		echo "MaxQuota Size of Administrator is bigger than the System Quota."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input MaxResource of Administrator (default: ${TF_ROOT_USER_MAXRES}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_ROOT_USER_MAXRES=${tmp}
		fi
	fi
	if test -z "${TF_ROOT_USER_MAXRES}"; then
		echo "The maxresource of administrator is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi
	# check systemquota limit
	if test "${TF_SYSQUOTA_MAX_FILES}" != "0" && test "${TF_ROOT_USER_MAXRES}" != "0" && \
	   test `expr ${TF_SYSQUOTA_MAX_FILES}` -lt `expr ${TF_ROOT_USER_MAXRES}`; then
		echo "MaxQuota files of Administrator is bigger than the System Quota."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test -z "${TF_DB_NAME}"; then
		TF_DB_NAME="db_${displayname}"
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input DB Name (default: ${TF_DB_NAME}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_DB_NAME=${tmp}
		fi
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input DB User Name (default: ${TF_DB_USER_NAME}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_DB_USER_NAME=${tmp}
		fi
	fi
	if test -z "${TF_DB_USER_NAME}"; then
		echo "The db user name is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input DB User Password (default: ${TF_DB_USER_PWD}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_DB_USER_PWD=${tmp}
		fi
	fi
	if test -z "${TF_DB_USER_PWD}"; then
		echo "The db user password is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input DB hostname (default: ${TF_DB_HOST_NAME}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_DB_HOST_NAME=${tmp}
		fi
	fi
	if test -z "${TF_DB_HOST_NAME}"; then
		echo "The db hostname is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test -z "${TF_DB_PORT_NO}"; then
		if test "${REPOS_DBTYPE}" = "pg"; then		
			TF_DB_PORT_NO="5432"
		else
			TF_DB_PORT_NO="1521"
		fi
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input DB port (default: ${TF_DB_PORT_NO}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_DB_PORT_NO=${tmp}
		fi
	fi

	# check PostgreSQL Database status
	if test "${REPOS_DBTYPE}" = "pg"; then		
		$ECHO_N "* checking for database status ... "$ECHO_C

		${PSQL} -d template1 -h ${TF_DB_HOST_NAME} -p ${TF_DB_PORT_NO} -U ${PG_ADMIN_USER} -c "select 1" >/dev/null 2>&1
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "NG"
			echo "* Failed to connect repository database."
			echo "* Please check database or input parameter."
			if test "${IS_SILENT}" != 1; then
				wait_enter
			fi
			return 1
		fi

		#------------------------
		# check database tables
		#------------------------
		${PSQL} -d ${TF_DB_NAME} -h ${TF_DB_HOST_NAME} -p ${TF_DB_PORT_NO} -U ${PG_ADMIN_USER} -c "select rs_rs_id_c from dav_resource limit 1" >/dev/null 2>&1
		RETVAL=$?
		if test "${RETVAL}" = "0"; then
			echo "NG"
			echo "* The ${TF_DB_NAME} has already some tables. "
			echo "* Please check it and use UNUSED database name."
			if test "${IS_SILENT}" != 1; then
				wait_enter
			fi
			return 1
		fi
		echo "ok"
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Make the value of group name and the final path segment of group uri be same (on/off/middle) (default: ${TF_DB_GRPSYNCURI}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_DB_GRPSYNCURI=${tmp}
		fi
	fi
	if test -z "${TF_DB_GRPSYNCURI}"; then
		echo "The value (TF_DB_GRPSYNCURI) is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	storage_root="${STORAGE_BASE}/${displayname}"
	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input Storage root path (default: ${storage_root}): "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			storage_root=${tmp}
		fi
	fi

	if test -d ${storage_root}; then
		if test "${INTERACTIVE_MODE}" = 1; then
			$ECHO_N "${storage_root} already exists. Are you quite sure ? (yes/no)"$ECHO_C
			while read tmp
			do
				if test "${tmp}" = "yes"; then
					echo "OK, aborted."
					if test "${IS_SILENT}" != 1; then
						wait_enter
					fi
					return 1
				elif test "${tmp}" = "no"; then
					# ok let's go!!
					break
				else 
					$ECHO_N "Please input yes or no. Are you quite sure?(yes/no):"$ECHO_C
					continue
				fi
			done
		else
			echo "${storage_root} already exists."
			return 1
		fi
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input Max file size limit (default: ${TF_MAX_FILESIZE}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_MAX_FILESIZE=${tmp}
		fi
	fi
	if test -z "${TF_MAX_FILESIZE}"; then
		echo "The max file size is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input Max registrable user number (default: ${TF_MAX_USER_NUMBER}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_MAX_USER_NUMBER=${tmp}
		fi
	fi
	if test -z "${TF_MAX_USER_NUMBER}"; then
		echo "The max registrable user number is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input AutoIndex option (on/off) (default: ${TF_AUTOINDEX}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_AUTOINDEX=${tmp}
		fi
	fi
	if test -z "${TF_AUTOINDEX}"; then
		echo "The autoindex option is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input Showgroup option (on/off) (default: ${TF_SHOWGROUP}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_SHOWGROUP=${tmp}
		fi
	fi
	if test -z "${TF_SHOWGROUP}"; then
		echo "The showgroup option is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input Mail option (on/off) (default: ${TF_ML}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_ML=${tmp}
		fi
	fi
	if test -z "${TF_ML}"; then
		echo "The mail option is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${TF_ML}" = "on"; then
		if test "${INTERACTIVE_MODE}" = 1; then
			$ECHO_N "Input SMTP Hostname (default: ${TF_ML_HOSTNAME}) : "$ECHO_C
			read tmp
			if test -n "${tmp}"; then
				TF_ML_HOSTNAME=${tmp}
			fi
		fi
		if test -z "${TF_ML_HOSTNAME}"; then
			echo "The SMTP hostname is EMPTY."
			if test "${IS_SILENT}" != 1; then
				wait_enter
			fi
			return 1
		fi

		if test "${INTERACTIVE_MODE}" = 1; then
			$ECHO_N "Input SMTP Hostport (default: ${TF_ML_HOSTPORT}) : "$ECHO_C
			read tmp
			if test -n "${tmp}"; then
				TF_ML_HOSTPORT=${tmp}
			fi
		fi
		if test -z "${TF_ML_HOSTPORT}"; then
			echo "The SMTP hostport is EMPTY."
			if test "${IS_SILENT}" != 1; then
				wait_enter
			fi
			return 1
		fi

		if test "${INTERACTIVE_MODE}" = 1; then
			$ECHO_N "Input Mail Encoding Name (default: ${TF_ML_ENCODING}) : "$ECHO_C
			read tmp
			if test -n "${tmp}"; then
				TF_ML_ENCODING=${tmp}
			fi
		fi
		if test -z "${TF_ML_ENCODING}"; then
			echo "The mail encoding is EMPTY."
			if test "${IS_SILENT}" != 1; then
				wait_enter
			fi
			return 1
		fi

		if test "${INTERACTIVE_MODE}" = 1; then
			if test "${TF_ML_SERVERSEND}" = "on"; then
				ml_sender="server"
			elif test "${TF_ML_SERVERSEND}" = "middle"; then
				ml_sender="middle"
			else
				ml_sender="client"
			fi

			$ECHO_N "Input Mail Sender (server/client/middle) (default: ${ml_sender}) : "$ECHO_C
			read tmp
			if test -n "${tmp}"; then
				ml_sender=${tmp}
			fi

			if test "${ml_sender}" = "server"; then
				TF_ML_SERVERSEND="on"
			elif test "${ml_sender}" = "middle"; then
				TF_ML_SERVERSEND="middle"
			else
				TF_ML_SERVERSEND="off"
			fi
		fi
		if test -z "${TF_ML_SERVERSEND}"; then
			echo "The mail-sender is EMPTY."
			if test "${IS_SILENT}" != 1; then
				wait_enter
			fi
			return 1
		fi
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input the name of Virus scanning Engine (off / {name}) (default: ${TF_VSCAN}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_VSCAN=${tmp}
		fi
	fi
	if test -z "${TF_VSCAN}"; then
		echo "The virus scanning engine is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	COMMENT_OUT_TfVscStreamMethod="#"
	COMMENT_OUT_TfVscCmd="#"
	COMMENT_OUT_TfVscHostname="#"
	COMMENT_OUT_TfVscHostport="#"

	if test "${TF_VSCAN}" != "off"; then
		COMMENT_OUT_TfVscStreamMethod=""
		if test "${INTERACTIVE_MODE}" = 1; then
			$ECHO_N "Input virus scanning command line (default: ${TF_VSCAN_CMD}) : "$ECHO_C
			read tmp
			if test -n "${tmp}"; then
				TF_VSCAN_CMD=${tmp}
			fi
		fi
		if test -n "${TF_VSCAN_CMD}"; then
			COMMENT_OUT_TfVscCmd=""
		fi

		if test "${INTERACTIVE_MODE}" = 1; then
			$ECHO_N "Input virus scanning hostname (default: ${TF_VSCAN_HOSTNAME}) : "$ECHO_C
			read tmp
			if test -n "${tmp}"; then
				COMMENT_OUT_TfVscHostname=""
				TF_VSCAN_HOSTNAME=${tmp}
			fi
		else
			# always commented out (unsupported function)
			COMMENT_OUT_TfVscHostname="#"
		fi

		if test "${INTERACTIVE_MODE}" = 1; then
			$ECHO_N "Input virus scanning hostport (default: ${TF_VSCAN_HOSTPORT}) : "$ECHO_C
			read tmp
			if test -n "${tmp}"; then
				COMMENT_OUT_TfVscHostport=""
				TF_VSCAN_HOSTPORT=${tmp}
			fi
		else
			# always commented out (unsupported function)
			COMMENT_OUT_TfVscHostport="#"
		fi
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Do you want to use extended user status ? (on/off) (default: ${TF_EXTENDSERSTATUS}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_EXTENDSERSTATUS=${tmp}
		fi
	fi
	if test -z "${TF_EXTENDSERSTATUS}"; then
		echo "The extended user status option is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Do you want to use Thumbnail function ? (on/off) (default: ${TF_THUMBNAIL}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_THUMBNAIL=${tmp}
		fi
	fi
	if test -z "${TF_THUMBNAIL}"; then
		echo "The thumbnail function is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Do you want to use Password-policy function ? (on/off) (default: ${TF_PASSPOLICY}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_PASSPOLICY=${tmp}
		fi
	fi
	if test -z "${TF_PASSPOLICY}"; then
		echo "The password-policy function is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Do you want to use Log access function ? (on/off) (default: ${TF_LOGACCESS}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_LOGACCESS=${tmp}
		fi
	fi
	if test -z "${TF_LOGACCESS}"; then
		echo "The log-access function is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Do you want to use AutoDelete function ? (on/off) (default: ${TF_AUTODELETE}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_AUTODELETE=${tmp}
		fi
	fi
	if test -z "${TF_AUTODELETE}"; then
		echo "The autodelete function is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${SUPPORT_OPLOG_FUNCTION}" = 1 && test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Do you want to use Operation-Log function ? (on/off) (default: ${TF_LOGOPERATION}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_LOGOPERATION=${tmp}
		fi
	fi
	if test -z "${TF_LOGOPERATION}"; then
		echo "The operation-log function is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Do you want to use Group-Leader function ? (on/off) (default: ${TF_GROUPLEADER}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_GROUPLEADER=${tmp}
		fi
	fi
	if test -z "${TF_GROUPLEADER}"; then
		echo "The Group-Leader function is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Do you want to use Confirm-Reading function ? (on/off) (default: ${TF_CONFIRMREADING}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_CONFIRMREADING=${tmp}
		fi
	fi
	if test -z "${TF_CONFIRMREADING}"; then
		echo "The Confirm-Reading function is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Input the reservation day of Confirm-Reading state. (default: ${TF_CONFIRMREADING_RESERVEDDAY}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_CONFIRMREADING_RESERVEDDAY=${tmp}
		fi
	fi
	if test -z "${TF_CONFIRMREADING_RESERVEDDAY}"; then
		echo "The reservation day of Confirm-Reading is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Do you want to Extened-System Message function?. (default: ${TF_EXTENDSYSMSG}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_EXTENDSYSMSG=${tmp}
		fi
	fi
	if test -z "${TF_EXTENDSYSMSG}"; then
		echo "The Extend-SysMsg function is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Do you want to browser Session  function?. (default: ${TF_USESESSION}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_USESESSION=${tmp}
		fi
	fi
	if test -z "${TF_USESESSION}"; then
		echo "The Use Session function is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Do you want to Failed access control function?. (on/off) (default: ${TF_FAILEDACESSCONTROL}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_FAILEDACESSCONTROL=${tmp}
		fi
	fi
	if test -z "${TF_FAILEDACESSCONTROL}"; then
		echo "The Use Failed access control function is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Do you want to BOX function?. (on/off) (default: ${TF_BOX}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_BOX=${tmp}
		fi
	fi
	if test -z "${TF_BOX}"; then
		echo "The Use BOX function is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Do you want to Upload Policy function?. (on/off) (default: ${TF_USEUPLOADPOLICY}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_USEUPLOADPOLICY=${tmp}
		fi
	fi
	if test -z "${TF_USEUPLOADPOLICY}"; then
		echo "The Use Upload Policy function is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test "${INTERACTIVE_MODE}" = 1; then
		$ECHO_N "Do you wat to Two factor Authentication function?.(on/off) (default: ${TF_TWOFACTORAUTHENTICATION}) : " $ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_TWOFACTORAUTHENTICATION=${tmp}
		fi
	fi
	if test -z "${TF_TWOFACTORAUTHENTICATION}"; then
		echo "The Use Two Factor Authentication function is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	#---------------------------
	# Show inputed data
	#---------------------------
	if test "${TF_DB_GRPSYNCURI}" = "on"; then
		text1="same Group Name"
	elif test "${TF_DB_GRPSYNCURI}" = "middle"; then
		text1="same and unique Group Name"
	else
		text1="different from Group Name"
	fi

	_PMSG="       "
	if test "${TF_USE_ENCRYPT_USER_PASSWORD}" = "on"; then
		_PMSG="(plain)"
	fi

	# check values (without input)
	if test -z "${TF_DB_USE_CONNECTION_POOL}"; then
		echo "The connection-pool setting (TF_DB_USE_CONNECTION_POOL) is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test -z "${TF_ML_NOTIFYACTION}"; then
		echo "The notify-usercreation mail setting (TF_ML_NOTIFYACTION) is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test -z "${TF_ML_ONECLICKURL}"; then
		echo "The attachement uri with mail setting (TF_ML_ONECLICKURL) is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	if test -z "${TF_REQUIREDSSL}"; then
		echo "The requiredssl setting (TF_REQUIREDSSL) is EMPTY."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi
	COMMENT_OUT_SSLRequiredSSL="#"
	if test "${TF_REQUIREDSSL}" = "on"; then
		COMMENT_OUT_SSLRequiredSSL=""
	fi

	COMMENT_OUT_NOTIFYSERVERNAME="#"
	if test -n "${TF_NOTIFYSERVERNAME}"; then
		COMMENT_OUT_NOTIFYSERVERNAME=""
	fi

	COMMENT_OUT_NETACSLIMIT_DENY="#"
	COMMENT_OUT_NETACSLIMIT_ALLOW="#"
	if test "${TF_NETACSLIMIT}" = "on"; then
		if test -z "${TF_NETACSLIMIT_IPMASK}"; then
			echo "The ip-address mask is EMPTY."
			if test "${IS_SILENT}" != 1; then
				wait_enter
			fi
		fi

		if test "${TF_NETACSLIMIT_TYPE}" != "deny" && test "${TF_NETACSLIMIT_TYPE}" != "allow"; then
			echo "The type of network-access-limit is wrong."
			if test "${IS_SILENT}" != 1; then
				wait_enter
			fi
			return 1
		fi

		if test "${TF_NETACSLIMIT_TYPE}" = "deny"; then
			COMMENT_OUT_NETACSLIMIT_DENY=""
		else
			# append "127.0.0.1/32" if "allow".
			TF_NETACSLIMIT_IPMASK="127.0.0.1/32 ${TF_NETACSLIMIT_IPMASK}"
			COMMENT_OUT_NETACSLIMIT_ALLOW=""
		fi
	fi

	if test "${TF_AUTODELETE}" = "on" && test "${TF_USE_ENCRYPT_USER_PASSWORD}" != "off"; then
		USERPW=`$TF_MD5 ${TF_SYSEXEC_USERPW}`
	else
		USERPW="${TF_SYSEXEC_USERPW}"
	fi

	COMMENT_OUT_EXECONCMD="#"
	if test "${TF_EXECENGINE}" = "on" && test -n "${TF_EXECONCMD}"; then
		COMMENT_OUT_EXECONCMD=""
	else
		TF_EXECENGINE="off"
	fi

	COMMENT_OUT_RPROXYUSE="#"
	if test "${TF_RPROXY_USE}" = "on" && test -n "${TF_RPROXY_MATCH}"; then
		COMMENT_OUT_RPROXYUSE=""
	fi

	DISPTEXT_FILE="${TMP_BASE_DIR}/.disptext"

	if test "${IS_SILENT}" != 1; then
		cat - > ${DISPTEXT_FILE} <<_SHOW_INPUTED_DATA1_
------------------------------------------------------------
Location                    : ${TF_ROOT_URI}
RequiredSSL                 : ${TF_REQUIREDSSL}
Notify server name          : ${TF_NOTIFYSERVERNAME}
System Quota MaxSize        : ${TF_SYSQUOTA_MAX_BITES}
System Quota MaxResource    : ${TF_SYSQUOTA_MAX_FILES}
Password encipher           : ${TF_USE_ENCRYPT_USER_PASSWORD}
Userid          (for admin) : ${TF_ROOT_USER_ID}
Password${_PMSG} (for admin) : ${TF_ROOT_USER_PWD_PLAIN}
FullName        (for admin) : ${TF_ROOT_USER_FULLNAME}
MailAddr        (for admin) : ${TF_ROOT_USER_MAILADDR}
MaxSize         (for admin) : ${TF_ROOT_USER_MAXSIZE}
MaxResource     (for admin) : ${TF_ROOT_USER_MAXRES}
Repository DB name          : ${TF_DB_NAME}
Repository DB user          : ${TF_DB_USER_NAME}
Repository DB password      : ${TF_DB_USER_PWD}
Repository DB hostname      : ${TF_DB_HOST_NAME}
Repository DB port          : ${TF_DB_PORT_NO}
Connection pool function    : ${TF_DB_USE_CONNECTION_POOL}
The URI of groupfolder      : ${text1}
Storage Root Path           : ${storage_root}
Max file size limit         : ${TF_MAX_FILESIZE}
Max registrable user        : ${TF_MAX_USER_NUMBER}
Autoindex function          : ${TF_AUTOINDEX}
ShowGroup function          : ${TF_SHOWGROUP}
Mail      function          : ${TF_ML}
_SHOW_INPUTED_DATA1_

		if test "${TF_ML}" = "on"; then
			cat - >> ${DISPTEXT_FILE} <<_SHOW_INPUTED_DATA2_
Mail SMTP hostname          : ${TF_ML_HOSTNAME}
Mail SMTP port              : ${TF_ML_HOSTPORT}
Mail encoding               : ${TF_ML_ENCODING}
Mail sender                 : ${ml_sender}
Mail notify-usercreation    : ${TF_ML_NOTIFYACTION}
Mail one-click-uri          : ${TF_ML_ONECLICKURL}
_SHOW_INPUTED_DATA2_
		fi

		cat - >> ${DISPTEXT_FILE} <<_SHOW_INPUTED_DATA3_
Virus scan engine           : ${TF_VSCAN}
_SHOW_INPUTED_DATA3_

		if test "${TF_VSCAN}" != "off"; then
			cat - >> ${DISPTEXT_FILE} <<_SHOW_INPUTED_DATA4_
Virus scan command line     : ${TF_VSCAN_CMD}
Virus scan hostname         : ${TF_VSCAN_HOSTNAME}
Virus scan port             : ${TF_VSCAN_HOSTPORT}
_SHOW_INPUTED_DATA4_
		fi

		if test "${TF_NETACSLIMIT}" != "off"; then
			cat - >> ${DISPTEXT_FILE} <<_SHOW_INPUTED_DATA5_
IP address limit function   : ${TF_NETACSLIMIT}
IP address limit type       : ${TF_NETACSLIMIT_TYPE}
IP address mask             : ${TF_NETACSLIMIT_IPMASK}
_SHOW_INPUTED_DATA5_
		fi
		cat - >> ${DISPTEXT_FILE} <<_SHOW_INPUTED_DATA6_
Extended user function      : ${TF_EXTENDSERSTATUS}
Thumbnail function          : ${TF_THUMBNAIL}
Password-Policy function    : ${TF_PASSPOLICY}
LogAccess function          : ${TF_LOGACCESS}
AutoDelete function         : ${TF_AUTODELETE}
Operation Log function      : ${TF_LOGOPERATION}
Group Leader function       : ${TF_GROUPLEADER}
Confirm Reading function    : ${TF_CONFIRMREADING}
Confirm Reading ReservedDay : ${TF_CONFIRMREADING_RESERVEDDAY}
Extend SysMsg Function      : ${TF_EXTENDSYSMSG}
Browser Session Function    : ${TF_USESESSION}
Access Control Function     : ${TF_ACCESSCONTROL}
_SHOW_INPUTED_DATA6_
		if test "${TF_FAILEDACESSCONTROL}" != "off"; then
			cat - >> ${DISPTEXT_FILE} <<_SHOW_INPUTED_DATA7_
Failed Access Control Function : ${TF_FAILEDACESSCONTROL}
Failed access count            : ${TF_FAILEDACCESSCOUNT}
Challenge next time            : ${TF_CHALLENGENEXTTIME}
Challenge count                : ${TF_CHALLENGECOUNT}
_SHOW_INPUTED_DATA7_
		fi
		cat - >> ${DISPTEXT_FILE} <<_SHOW_INPUTED_DATA8_
BOX Function(enable shorten)   : ${TF_BOX}
Upload Policy Function         : ${TF_USEUPLOADPOLICY}
Two Factor Auth Function       : ${TF_TWOFACTORAUTHENTICATION}
------------------------------------------------------------
_SHOW_INPUTED_DATA8_

		if  test -n "${TF_BOX}"; then
			GUESTPW=`$TF_MD5 ${TF_GUEST_USERPW}`
		else
			GUESTPW="${TF_GUEST_USERPW}"
		fi

		cat ${DISPTEXT_FILE} | more
		rm -f ${DISPTEXT_FILE}
		while [ 1 ];
		do
			$ECHO_N "Are input values correct ? (y/n) (default: n) : "$ECHO_C
			read tmp
			if test "${tmp}" = "y"; then
				break
			elif test "${tmp}" = "n"; then
				echo "OK, aborted."
				wait_enter
				return 1
			fi
		done
	fi

	# write data to ini file
	INI_FILE="${TMP_BASE_DIR}/tmp_teamfile.ini"

	# fixed values
	TF_DB_PROVIDER="${REPOS_DBTYPE}"
	TF_DB_ID_NAME="${TF_DB_NAME}"

	cat - > ${INI_FILE} <<_SETUPENV_INI_FILE_
TF_ROOT_URI=${TF_ROOT_URI}
TF_SYSQUOTA_MAX_BITES=${TF_SYSQUOTA_MAX_BITES}
TF_SYSQUOTA_MAX_FILES=${TF_SYSQUOTA_MAX_FILES}
TF_ROOT_USER_ID=${TF_ROOT_USER_ID}
TF_ROOT_USER_PWD=${TF_ROOT_USER_PWD}
TF_ROOT_USER_FULLNAME=${TF_ROOT_USER_FULLNAME}
TF_ROOT_USER_MAILADDR=${TF_ROOT_USER_MAILADDR}
TF_ROOT_USER_MAXSIZE=${TF_ROOT_USER_MAXSIZE}
TF_ROOT_USER_MAXRES=${TF_ROOT_USER_MAXRES}
TF_DB_PROVIDER=${TF_DB_PROVIDER}
TF_DB_NAME=${TF_DB_NAME}
TF_DB_USER_NAME=${TF_DB_USER_NAME}
TF_DB_USER_PWD=${TF_DB_USER_PWD}
TF_DB_ID_NAME=${TF_DB_ID_NAME}
TF_DB_HOST_NAME=${TF_DB_HOST_NAME}
TF_DB_PORT_NO=${TF_DB_PORT_NO}
TF_DB_GRPSYNCURI=${TF_DB_GRPSYNCURI}
TF_SYSEXEC_USER=${TF_SYSEXEC_USER}
TF_SYSEXEC_USERPW=${USERPW}
TF_GUEST_USER=${TF_GUEST_USER}
TF_GUEST_USERPW=${TF_GUEST_USERPW}
TF_AUTODELETE=${TF_AUTODELETE}

_SETUPENV_INI_FILE_

	#---------------------------
	# create datafile
	#---------------------------
	echo "* create data file."
	${DDL_ROOT}/setupenv.sh -f ${INI_FILE} -s
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to create data file."
		rm -f ${INI_FILE}
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	# remove temporary file
	rm -f ${INI_FILE}

	#------------------------
	# make storage root
	#------------------------
	if test ! -d ${storage_root}; then
		echo "* create file storage"
		mkdir -p ${storage_root}
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to make directory ${storage_root}. (ret = ${RETVAL})"
			if test "${IS_SILENT}" != 1; then
				wait_enter
			fi
			return 1
		fi
		chown teamfile:teamfile ${storage_root}
		chmod 700 ${storage_root}
	fi

	#----------------------------------------
	# check user and create user and database
	#----------------------------------------
	${PSQL} -d template1 -h ${TF_DB_HOST_NAME} -p ${TF_DB_PORT_NO} -U ${TF_DB_USER_NAME} -c "select 1" >/dev/null 2>&1
	RETVAL=$?
	if  test "${RETVAL}" = "2"; then
		if test "${IS_SILENT}" != 1; then
			# user does not exist
			echo "The ${TF_DB_USER_NAME} user does not exist."
			$ECHO_N "Do you want to create this user ? (y/n) (default: n) : "$ECHO_C
			read ANS
			if test "${ANS}" != "y"; then
				echo "OK, aborted."
				wait_enter
				return 1
			fi
		fi
		echo "* create new database user"
		${PG_HOME}/bin/createuser -D -A -h ${TF_DB_HOST_NAME} -p ${TF_DB_PORT_NO} -U ${PG_ADMIN_USER} ${TF_DB_USER_NAME}
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to create new user ${TF_DB_USER_NAME}. (ret = ${RETVAL})"
			if test "${IS_SILENT}" != 1; then
				wait_enter
			fi
			return 1
		fi

		#------------------
		# set password
		#------------------
		sql="ALTER USER ${TF_DB_USER_NAME} WITH PASSWORD '"${TF_DB_USER_PWD}"'"
		${PSQL} -h ${TF_DB_HOST_NAME} -p ${TF_DB_PORT_NO} -d template1 -U ${PG_ADMIN_USER} -c "BEGIN; ${sql}; COMMIT;"
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to set new user ${TF_DB_USER_NAME} to password. (ret = ${RETVAL})"
			if test "${IS_SILENT}" != 1; then
				wait_enter
			fi
			return 1
		fi
	fi

	#--------------------
	# create database
	#--------------------
	echo "* create new database"
	${PG_HOME}/bin/createdb -O ${TF_DB_USER_NAME} -h ${TF_DB_HOST_NAME} -p ${TF_DB_PORT_NO} -U ${PG_ADMIN_USER} -E UNICODE ${TF_DB_NAME}
	RETVAL=$?
	if test "${RETVAL}" != 0; then
		echo "Failed to create new repository database ${TF_DB_NAME}. (ret = ${RETVAL})"
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	#----------------
	# insert data
	#----------------
	echo "* insert mandatory data into new database"
	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING
	${PSQL} -h ${TF_DB_HOST_NAME} -p ${TF_DB_PORT_NO} -d ${TF_DB_NAME} -U ${TF_DB_USER_NAME} <<_INSERT_DATA_SQL_

	\set ON_ERROR_STOP 0
	\set LO_TRANSACTION "rollback"

	BEGIN;

	\i ${DDL_ROOT}/createtable.sql;

	\i ${DDL_ROOT}/createindex.sql;

	\i ${DDL_ROOT}/createseq.sql;

	\i ${DDL_ROOT}/createdata.sql;

	COMMIT;

_INSERT_DATA_SQL_
	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	RETVAL=$?
	if test "${RETVAL}" != 0; then
		echo "Failed to insert data int new repository database."
		if test "${IS_SILENT}" != 1; then
			wait_enter
		fi
		return 1
	fi

	# write configuration file
	echo "* create configuration file"

	NEW_CONFFILE="new_${displayname}.conf"
	cat - > ${TMP_BASE_DIR}/${NEW_CONFFILE} <<_LOCATION_DATA
<Location ${TF_ROOT_URI}>

	# misc
	#AddDefaultCharset UTF-8
	AddDefaultCharset off
	<IfModule mod_deflate.c>
		AddOutputFilterByType DEFLATE text/html text/xml text/plain
	</IfModule>

${COMMENT_OUT_NOTIFYSERVERNAME}	TfNotifyServerName ${TF_NOTIFYSERVERNAME}
	TfNotifyServerPort ${TF_NOTIFYSERVERPORT}
	TfNotifyServerSchema ${TF_NOTIFYSERVERSCHEMA}

	TfSysCgiConnectPort ${TF_SYSCGI_CONNECT_PORT}
	TfSysCgiConnectSchema ${TF_SYSCGI_CONNECT_SCHEMA}

	<IfDefine SSL>
${COMMENT_OUT_SSLRequiredSSL}		SSLRequireSSL
	</IfDefine>

	# Using Reverse-Proxy server
	TfRProxyUse ${TF_RPROXY_USE}
${COMMENT_OUT_RPROXYUSE}	TfRProxyMatch ${TF_RPROXY_MATCH}
${COMMENT_OUT_RPROXYUSE}	TfRProxySchema ${TF_RPROXY_SCHEMA}
${COMMENT_OUT_RPROXYUSE}	TfRProxyHttpPort ${TF_RPROXY_HTTP_PORT}
${COMMENT_OUT_RPROXYUSE}	TfRProxyHttpsPort ${TF_RPROXY_HTTPS_PORT}

	# mod_dav
	DAV tf
	DavDepthInfinity on

	# auth
	AuthType teamfile
	AuthName "${displayname} Login PassWord."
	<RequireAll>
	  Require tf-user
${COMMENT_OUT_NETACSLIMIT_ALLOW} Require all denied
${COMMENT_OUT_NETACSLIMIT_DENY} Require all granted
	</RequireAll>
	TfAuth on
	TfEncryptPassword ${TF_USE_ENCRYPT_USER_PASSWORD}

	# repository database setting
	TfDbDbmstype ${TF_DB_PROVIDER}
	TfDbHostname ${TF_DB_HOST_NAME}
	TfDbHostport ${TF_DB_PORT_NO}
	TfDbDbname   ${TF_DB_NAME}
	TfDbUsername ${TF_DB_USER_NAME}
	TfDbPassword ${TF_DB_USER_PWD}

	# connction pool setting
	TfDbPool ${TF_DB_USE_CONNECTION_POOL}
	TfDbMinSpareConn 1
	TfDbMaxSpareConn 2

	# resource
	TfFsRootPath ${storage_root}
	TfMaxResourcePerDir 7000
	TfMaxFileSize ${TF_MAX_FILESIZE}
	TfMaxUser ${TF_MAX_USER_NUMBER}

	# Don't change this value into use !!
	TfTrashFolder on
	TfExtendUserStatus ${TF_EXTENDSERSTATUS}

	# SMTP
	TfMail        ${TF_ML}
	TfMlHostname  ${TF_ML_HOSTNAME}
	TfMlHostport  ${TF_ML_HOSTPORT}
	TfMlAdminaddr ${TF_ROOT_USER_MAILADDR}
	TfMlEncoding  ${TF_ML_ENCODING}
	TfMlServerSend ${TF_ML_SERVERSEND}
	TfMlTemplateRoot "${TF_CONFDIR}/mailtemplate"
	TfMlNotifyAction ${TF_ML_NOTIFYACTION}
	TfMlEnableOneClickURL ${TF_ML_ONECLICKURL}
	TfMlEdit ${TF_ML_EDIT}

	# Virus scanning
	TfVscan ${TF_VSCAN}
${COMMENT_OUT_TfVscStreamMethod}	TfVscStreamMethod off
${COMMENT_OUT_TfVscCmd}	TfVscCmd "${TF_VSCAN_CMD}"
${COMMENT_OUT_TfVscHostname}	TfVscHostname ${TF_VSCAN_HOSTNAME}
${COMMENT_OUT_TfVscHostport}	TfVscHostport ${TF_VSCAN_HOSTPORT}

	# LDAP
	# (note)
	#   When you connect SSL-LDAP server, please set the value of "CommonName" to TfLDAPHost.
	#   See "mod_dav_tf.conf" for more details.
	#
	TfLDAP off
	TfLDAPBaseDN "ou=employee, dc=teamfile,dc=com"
	TfLDAPBindDN "cn=Manager, dc=teamfile,dc=com"
	TfLDAPBindPW change_on_install
	TfLDAPAttr   uid
	TfLDAPHost      192.168.0.1
	TfLDAPHostPort  389
	TfLDAPfilter    objectclass=*
	TfLDAPScope     sub
	TfLDAPMapUserAttr uid
	TfLDAPMapPasswordAttr userPassword
	TfLDAPMapFullNameAttr CN
	TfLDAPMapMailAddAttr mail
	TfLDAPMapCommentAttr description
	TfLDAPSyncProperty On
	TfLDAPFoundCreate On
	TfLDAPAllowUser ${TF_ROOT_USER_ID} ${TF_SYSEXEC_USER} ${TF_GUEST_USER}
	#TfLDAPAllowUserRegEx ^[-A-Za-z0-9_.]+@[-A-Za-z0-9_]+[.][-A-Za-z0-9._]+$
	TfLDAPOptions NotUserFolder NotDBFolder NotReposDBFolder UserNotFoundAction=disable NotGroupFolder MaxQuota=1024000

	# TeamFile Autoindex function
	# In case of "On", you can watch a file list and download it via common browser.
	TfAutoIndex	${TF_AUTOINDEX}
	TfStyleSheetRoot "${TF_CONFDIR}/stylesheet"

	# Display group folder via Browser and other WebDAV client
	TfShowGroup ${TF_SHOWGROUP}

	# Make the value of "Group name" and the "final path segment" of Group URI be same.
	#
	# In case of the "TfSyncGroupUri" is "On",
	#	* You COULD NOT make a new group under another group.
	#	* If there is a locked resource under the group,
	#	  the Teamfile server forbid change of the group name. (MOVE operation)
	#
	# In case of the "TfSyncGroupUri" is "Middle",
	#   * You can make a new group under another group.
	#   * You COULD NOT make same name group.
	# (note)
	#	To change this value, you MUST change the repository database.
	#	Please do not change this value into use.
	#
	TfSyncGroupUri ${TF_DB_GRPSYNCURI}

	# Use Thumbnail function
	TfThumbnail ${TF_THUMBNAIL}

	# Use Password-Policy function
	TfPassPolicy ${TF_PASSPOLICY}
#	TfPassPolicyExclusion ip="127.0.0.1/32 192.168.0.1/24" OR uid="root|admin"

	# Use Log access function
	TfLogAccess ${TF_LOGACCESS}

	# Use Autodelete function
	TfAutoDelete ${TF_AUTODELETE}
	TfAutoDeleteAllowIP 127.0.0.1/32

	# Use action-extension command function
	TfExecEngine ${TF_EXECENGINE}
${COMMENT_OUT_EXECONCMD}	TfExecOnCmd "${TF_EXECONCMD}"

	# Use Operation Log function
	TfLogOperation ${TF_LOGOPERATION}

	# Use Group-Leader function
	TfGroupLeader ${TF_GROUPLEADER}

	# Use Confirm-Reading function
	TfConfirmReading ${TF_CONFIRMREADING}
	TfConfirmReadingReservedDay ${TF_CONFIRMREADING_RESERVEDDAY}

	# Use Extend Sysmsg function
	TfExtendSysMsg ${TF_EXTENDSYSMSG}

	# Use browser session function
	TfUseSession ${TF_USESESSION}
	# Session time out (default 0 = INFINITY)
	#TfSessionTimeOut 0

	# Allow Admin networks
#	TfAdminAllowIP 192.168.0.0/24

	# Disable WebFolder
	TfDisableWebFolderLink On

	# Disable change password for browser
#	TfDisableChangePassword on

	# Use Access Control function
	TfAccessControl ${TF_ACCESSCONTROL}
	# allow(default) or deny
	#TfDefaultAccessRule allow

	# Use Failed Access Control function
	TfFailedLoginControl 5 60 3

	# Use BOX function
	TfShortenUrl ${TF_BOX}
	TfBOX ${TF_BOX}

	# Use Upload Policy function
	TfUseUploadPolicy ${TF_USEUPLOADPOLICY}

	# Use Memcached
	TfUseMemcache on
	TfMemcacheServers localhost:18107

	# Use SAML function
	TfUseSAML Off
	#TfSAMLIdPMetaDataPath "/usr/local/teamfile/www/conf/conf.d/saml/meta.xml"
	#TfSAMLXMLPrivateKeyPath "/usr/local/teamfile/www/conf/conf.d/saml/priv.key"
	#TfSAMLXMLPublicCertificatePath "/usr/local/teamfile/www/conf/conf.d/saml/pub.crt"

	# NameID the e-mail address
	#TfSAMLMatchedMailAddr Off

	# Two Factor Authentication function
	TfTwoFactorAuthentication ${TF_TWOFACTORAUTHENTICATION} 
	TfTwoFactorAuthenticationCycle 9 6m
	TfTwoFactorAuthenticationType default
	TfTwoFactorAuthenticationStage box

</Location>
_LOCATION_DATA

	# move $NEW_CONFFILE into $TF_CONFDIR
	if test ! -f "${TF_CONFDIR}/${NEW_CONFFILE}"; then
		mv ${TMP_BASE_DIR}/${NEW_CONFFILE} ${TF_CONFDIR}/
	else
		if test "${IS_SILENT}" != 1; then
			echo "The configuration file \"${TF_CONFDIR}/${NEW_CONFFILE}\" already exists."
			$ECHO_N "Do you want to OVERWRITE it ? (y/n) : "$ECHO_C
			read ANS
			if test "${ANS}" = "y"; then
				rm -f ${TF_CONFDIR}/${NEW_CONFFILE}
				mv ${TMP_BASE_DIR}/${NEW_CONFFILE} ${TF_CONFDIR}/
			else
				echo "The configuration of new location was saved to \"${TMP_BASE_DIR}/${NEW_CONFFILE}\" file."
				echo "Please edit this file because the value of this file is default."
				echo "If you complete it, please copy \"${NEW_CONFFILE}\" "
				echo "under the \"${TF_CONFDIR}/\" and reload TeamFile."
				echo "ok"
				wait_enter
				return 0
			fi
		fi
	fi

	echo ""
	echo "The configuration of new location was saved to \"${TF_CONFDIR}/${NEW_CONFFILE}\" file."
	echo "Please edit this file because the value of this file is default."
	echo "If you complete it, please reload TeamFile."
	echo "ok"
	if test "${IS_SILENT}" != 1; then
		wait_enter
	fi
}

#--------------------------------------
# show repository db
#--------------------------------------
run_frontend() {
	echo ""
	#-------------------
	# setup dbenv
	#-------------------
	NEED_SERVER=0
	setup_dbenv

	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		wait_enter
		return 1
	fi

	# execute command

	PGCLIENTENCODING="UTF8"
	export PGCLIENTENCODING

	${PSQL} -d ${PGDATABASE} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER}

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING
	wait_enter
}

#--------------------------------------
# Show All database List
#
# if "USE_INNER" is "1", skip input data
#--------------------------------------
show_all_database() {
	echo ""

	if test "${USE_INNER}" != "1"; then
		#-------------------
		# setup dbenv
		#-------------------
		NEED_SERVER=0
		NO_PGUSER=1
		NO_PGDATABASE=1

		setup_dbenv

		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			wait_enter
			USE_INNER=0
			return 1
		fi
	fi

	#-------------------
	# show all database
	#-------------------
	echo ""
	echo "* Show All DataBase"

	${PSQL} -l -h ${PGHOST} -p ${PGPORT} -U ${PG_ADMIN_USER}
	RETVAL=$?

	if test "${RETVAL}" != "0"; then
		echo "Failed to get database list. (ret = ${RETVAL})"
		if test "${USE_INNER}" != "1"; then
			wait_enter
		fi
		USE_INNER=0
		return 1
	fi

	if test "${USE_INNER}" != "1"; then
		wait_enter
	fi
	USE_INNER=0
}

#--------------------------------------
# Show All Database User List
#
# if "USE_INNER" is "1", skip input data
#
# (note)
#	このモジュールはoracleに対応していません。
#	oracleの場合はshow_all_databeseを使用してください。
#--------------------------------------
show_all_user() {
	echo ""

	if test "${USE_INNER}" != "1"; then
		#-------------------
		# setup dbenv
		#-------------------
		if test "${REPOS_DBTYPE}" = "pg"; then
			NEED_SERVER=0
			NO_PGDATABASE=1
			NO_PGUSER=1

			setup_dbenv
		fi
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			wait_enter
			USE_INNER=0
			return 1
		fi
	fi

	#-------------------
	# show all user
	#-------------------
	echo ""
	echo "* Show All Users"
	${PSQL} -d template1 -h ${PGHOST} -p ${PGPORT} -U ${PG_ADMIN_USER} -c "select usename from pg_user;"
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to get user list. (ret = ${RETVAL})"
		if test "${USE_INNER}" != "1"; then
			wait_enter
		fi
		USE_INNER=0
		return 1
	fi

	if test "${USE_INNER}" != "1"; then
		wait_enter
	fi
	USE_INNER=0
}

#--------------------------------------
# Drop repository database
# if "NO_MSG" is "1", skip notice msg and wait_enter.
#--------------------------------------
drop_repos_db() {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	if test "${NO_MSG}" != "1"; then
		# notice msg
		$ECHO_N "This operation DELETE a specified repository database. Are you quite sure ? (y/n) "$ECHO_C
		read ANS1
		if test "${ANS1}" != "y"; then
			echo "OK, aborted."
			wait_enter
			return 1
		else
			echo "OK, continue."
		fi
	fi

	# show notice
	STOP_APACHE=0
	isTeamFileRuning
	if test "$?" = "1"; then
		echo "We detect that TeamFile is running."
		echo "We could not delete a database if this database is accessed."
		$ECHO_N "Can you stop TeamFile now ? (y/n) "$ECHO_C
		read ANS
		if test "${ANS}" != "y"; then
			$ECHO_N "Uhm, Do you still perform now ? (y/n) "$ECHO_C
			read ANS
			if test "${ANS}" != "y"; then
				echo "OK, we finish to drop database operation."
				wait_enter
				return 1
			else
				echo "OK, leave it to chance..."
			fi
		else
			${APACHECTL} stop
			RETVAL=$?
			if test "${RETVAL}" != "0"; then
				echo "Failed to stop TeamFile. Sorry."
				wait_enter
				return 1
			fi
			STOP_APACHE=1
		fi
	fi

	#-------------------
	# setup dbenv
	#-------------------
	NEED_SERVER=0
	NO_PGUSER=1
	NO_PGDATABASE=1

	setup_dbenv

	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		if test "${NO_MSG}" != "1"; then
			wait_enter
		fi
		return 1
	fi

	#-------------------
	# show all database
	#-------------------
	echo ""
	USE_INNER=1
	show_all_database

	# input database name
	$ECHO_N "Input DELETE database or schema name (expect template0, template1) : "$ECHO_C
	read dropdbname
	if test -z "${dropdbname}"; then
		echo "Database name is EMPTY !!"
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		if test "${NO_MSG}" != "1"; then
			wait_enter
		fi
		return 1
	fi

	if test "${dropdbname}" = "template0" -o "${dropdbname}" = "template1"; then
		echo "The template0 and template1 database is very IMPORTANT database."
		echo "We could not delete it."
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		if test "${NO_MSG}" != "1"; then
			wait_enter
		fi
		return 1
	fi

	#-------------------
	# execute command
	#-------------------
	${PG_HOME}/bin/dropdb -i -h ${PGHOST} -p ${PGPORT} -U ${PG_ADMIN_USER} ${dropdbname}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		if test "${NO_MSG}" = "1"; then
			# nothing to do.
			return 1
		fi
		echo "Failed to DELETE ${dropdbname}. (ret = ${RETVAL})"
	fi
	if test "${STOP_APACHE}" = "1"; then
		${APACHECTL} start
	fi
	if test "${NO_MSG}" != "1"; then
		wait_enter
	fi
}

#--------------------------------------
# Drop repository database User
#--------------------------------------
drop_repos_dbuser() {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	# notice msg
	$ECHO_N "This operation DELETE a specified user. Are you quite sure ? (y/n) "$ECHO_C
	read ANS1
	if test "${ANS1}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	else
		echo "OK, continue."
	fi

	#-------------------
	# setup dbenv
	#-------------------
	NEED_SERVER=0
	NO_PGUSER=1
	NO_PGDATABASE=1

	setup_dbenv
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		wait_enter
		return 1
	fi

	#-------------------
	# show all user
	#-------------------
	echo ""
	USE_INNER=1
	show_all_user
	echo "Please select these list."

	# input User name
	$ECHO_N "Input DELETE user name (expect postgres) : "$ECHO_C
	read dropdbuser
	if test -z "${dropdbuser}"; then
		echo "User name is EMPTY !!"
		wait_enter
		return 1
	elif test "${dropdbuser}" = "postgres"; then
		echo "The postgres is very IMPORTANT user."
		echo "We could not delete it."
		wait_enter
		return 1
	fi

	#-------------------
	# execute command
	#-------------------
	${PG_HOME}/bin/dropuser -i -h ${PGHOST} -p ${PGPORT} -U ${PG_ADMIN_USER} ${dropdbuser}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to DELETE ${dropdbuser}. (ret = ${RETVAL})"
	fi
	wait_enter
}


#--------------------------------------
# DELETE file storage
#--------------------------------------
drop_file_storage() {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	# notice msg
	$ECHO_N "This operation DELETE a specified file storage. Are you quite sure ? (y/n) "$ECHO_C
	read ANS1
	if test "${ANS1}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	else
		echo "OK, continue."
	fi

	echo "* Search storage path ..."
	search_configuration_files
	for f in ${CONFIGFILE_LIST}; do
		fsrootpath=`grep 'TfFsRootPath' ${f} | sed -e '/^#/d' -e 's/TfFsRootPath//g' -e 's/[ 	]*//g'`
		if test -z "${fsrootpath}"; then
			continue
		fi

		if test -d "${fsrootpath}"; then
			echo "    ${fsrootpath}"
		fi
	done

	# input storage path
	$ECHO_N "Select / Input DELETE storage root path : "$ECHO_C
	read storage_root_path
	if test -z "${storage_root_path}"; then
		echo "The storage path is EMPTY."
		wait_enter
		return 1
	fi

	if test ! -d "${storage_root_path}"; then
		echo "${storage_root_path} is not directory."
		wait_enter
		return 1
	fi

	$ECHO_N "This is your last chance. Is this \"${storage_root_path}\" path correct ? (y/n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	# delete storage root path
	echo "We will delete storage now. Please wait for a while..."
	rm -rf ${storage_root_path}
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "ok"
	else
		echo "NG"
	fi

	wait_enter
}


#--------------------------------------
# Change repository db password
#--------------------------------------
change_repos_dbpassword() {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	# show notice
	STOP_APACHE=0
	isTeamFileRuning
	if test "$?" = "1"; then
		echo "We detect that TeamFile is running."
		echo "We can only change password if this database is NOT accessed."
		$ECHO_N "Can you stop TeamFile now ? (y/n) "$ECHO_C
		read ANS
		if test "${ANS}" != "y"; then
			$ECHO_N "Uhm, Do you still perform now ? (y/n) "$ECHO_C
			read ANS
			if test "${ANS}" != "y"; then
				echo "OK, we finish to change password operation."
				wait_enter
				return 1
			else
				echo "OK, leave it to chance..."
			fi
		else
			${APACHECTL} stop
			RETVAL=$?
			if test "${RETVAL}" != "0"; then
				echo "Failed to stop TeamFile. Sorry."
				wait_enter
				return 1
			fi
			STOP_APACHE=1
		fi
	fi

	#-------------------
	# setup dbenv
	#-------------------
	NEED_SERVER=0
	NO_PGUSER=1
	NO_PGDATABASE=1

	setup_dbenv

	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		wait_enter
		return 1
	fi

	#-------------------
	# show all user
	#-------------------
	USE_INNER=1
	show_all_user

	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		wait_enter
		return 1
	fi

	# input db username
	$ECHO_N "Input or Select db username that changes the password: "$ECHO_C
	read TF_DB_USER_NAME
	if test -z "${TF_DB_USER_NAME}"; then
		echo "Username is EMPTY !!"
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		wait_enter
		return 1
	fi
	PGUSER="`echo ${TF_DB_USER_NAME}`"

	# input new password
	$ECHO_N "Input new db password: "$ECHO_C
	read TF_DB_USER_PWD
	if test -z "${TF_DB_USER_PWD}"; then
		echo "Password is EMPTY !!"
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		wait_enter
		return 1
	fi

	#-------------------
	# execute command
	#-------------------
	sql="ALTER USER ${TF_DB_USER_NAME} WITH PASSWORD '"${TF_DB_USER_PWD}"'"
	${PSQL} -h ${PGHOST} -p ${PGPORT} -d template1 -U ${PG_ADMIN_USER} -c "BEGIN; ${sql}; COMMIT;"
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to set user ${TF_DB_USER_NAME} to new password. (ret = ${RETVAL})"
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		wait_enter
		return 1
	fi

	if test "${STOP_APACHE}" = "1"; then
		${APACHECTL} start
	fi

	echo "Success."

	wait_enter
	return 0
}

#--------------------------------------
# DELETE a location and repository database
#--------------------------------------
delete_location() {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	# show notice msg
	$ECHO_N "This operation DELETE a location data. Are you quite sure ? (y/n) "$ECHO_C
	read ANS1
	if test "${ANS1}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	else
		echo "OK, continue."
	fi

	# check TeamFile status
	isTeamFileRuning
	RETVAL=$?
	if test "${RETVAL}" = "1"; then
		echo "We detect that TeamFile is running."
		echo "You must restart TeamFile before this operation."
		$ECHO_N "Can you stop TeamFile now ? (y/n) "$ECHO_C
		read ANS
		if test "${ANS}" != "y"; then
			echo "OK, we finish to delete a location."
			wait_enter
			return 0
		else
			${APACHECTL} restart
			RETVAL=$?
			if test "${RETVAL}" != "0"; then
				echo "Failed to restart TeamFile. Sorry."
				wait_enter
				return 1
			fi
		fi
	fi

	echo "* Search configuration files ..."
	show_configuration_files
	echo ""
	$ECHO_N "* Please select location configuration file that you want to delete : "$ECHO_C
	read f
	if test -z "${f}"; then
		echo "The path of configuration is EMPTY."
		wait_enter
		return 1
	elif test ! -f "${f}"; then
		echo "The \"${f}\" file did not exists."
		wait_enter
		return 1
	fi

	# parse location config
	parse_locationconf ${f}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to parse configuration file."
		wait_enter
		return 1
	fi

	if test -z "${ENV_LocationName}"; then
		echo "Failed to get location name. Please check configuration file."
		wait_enter
		return 1
	fi

	echo "----------------------------------------"
	echo "* Location          : ${ENV_LocationName}"
	echo "* Storage root path : ${ENV_TfFsRootPath}"
	echo "* Database Name     : ${ENV_TfDbDbname}"
	echo "* Database Host     : ${ENV_TfDbHostname}"
	echo "* Database Port     : ${ENV_TfDbHostport}"
	echo "* Database User     : ${ENV_TfDbUsername}"
	echo "* Database Password : ${ENV_TfDbPassword}"
	echo "----------------------------------------"
	if test -z "${ENV_TfFsRootPath}" || test ! -d "${ENV_TfFsRootPath}"; then
		$ECHO_N "${ENV_TfFsRootPath} is not directory. continue ? (y/n) : "$ECHO_C
		read ANS
		if test "${ANS}" != "y"; then
			echo "OK, abort"
			wait_enter
			return 1
		fi
	fi

	tmp=`echo ${ENV_TfFsRootPath} | sed -e 's:[/]\+:/:g' -e '1s:/$::'`
	if test "${tmp}" = "/"; then
		echo "We could not delete the root directory."
		wait_enter
		return 1
	fi

	if test -z "${ENV_TfDbDbname}"   || test -z "${ENV_TfDbHostname}" || \
	   test -z "${ENV_TfDbHostport}" || test -z "${ENV_TfDbUsername}" || \
	   test -z "${ENV_TfDbPassword}"; then
		echo "Some values were emtpy. Please check configuration file."
		wait_enter
		return 1
	fi
	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	#---------------------------
	# drop repository database
	#---------------------------
	${PG_HOME}/bin/dropdb -i -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${PG_ADMIN_USER} ${ENV_TfDbDbname}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to DROP ${ENV_TfDbDbname}. (ret = ${RETVAL})"
		wait_enter
		return 1
	fi

	# check database
	${PSQL} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${PG_ADMIN_USER} -d ${ENV_TfDbDbname} -c "\d dav_resource" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		# The database was not deleted by operation
		echo "OK, abort"
		wait_enter
		return 1
	fi

	#---------------------------
	# drop repository database user
	#---------------------------
	# checking user whether or not another db owner
	OWNER_CNT=`${PSQL} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${PG_ADMIN_USER} -d template1 -c "select 'COUNT=' || count(*) from pg_database db INNER JOIN pg_user u ON db.datdba = u.usesysid where u.usename='${ENV_TfDbUsername}'" | grep '[ ][ ]*COUNT=' | sed -e 's/[ ][ ]*COUNT=//g'`
	if test "${OWNER_CNT}" = "0"; then
		${PG_HOME}/bin/dropuser -i -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${PG_ADMIN_USER} ${ENV_TfDbUsername}
	fi

	#---------------------------
	# DELETE storage
	#---------------------------
	rm -rf ${ENV_TfFsRootPath}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to DELETE ${ENV_TfFsRootPath}. (ret = ${RETVAL})"
		echo "But database \"${ENV_TfDbDbname}\" was already deleted."
		echo "Please delete storage manually."
		wait_enter
		return 1
	fi

	#---------------------------
	# DELETE autodelete configuration file
	#---------------------------
	remove_autodel_config "${ENV_LocationName}"
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to remove AUTODELETE configuration. (ret = ${RETVAL})"
		echo "Please delete file manually."
	fi

	#---------------------------
	# DELETE configuration file
	#---------------------------
	rm -f ${f}

	echo "Success."
	wait_enter
	return 0
}

#--------------------------------------
# Update system quota
#--------------------------------------
update_system_quota() {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	# show notice msg
	$ECHO_N "This operation UPDATE system quota and LOCK all user's quota. Are you quite sure ? (y/n) "$ECHO_C
	read ANS1
	if test "${ANS1}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	else
		echo "OK, continue."
	fi

	echo "* Search configuration files ..."
	show_configuration_files
	echo ""
	$ECHO_N "* Please select location configuration file that you want to update : "$ECHO_C
	read f
	if test -z "${f}"; then
		echo "The path of configuration is EMPTY."
		wait_enter
		return 1
	elif test ! -f "${f}"; then
		echo "The \"${f}\" file did not exists."
		wait_enter
		return 1
	fi

	# parse location config
	parse_locationconf ${f}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to parse configuration file."
		wait_enter
		return 1
	fi

	if test -z "${ENV_LocationName}"; then
		echo "Failed to get location name. Please check configuration file."
		wait_enter
		return 1
	fi

	echo "----------------------------------------"
	echo "* Location          : ${ENV_LocationName}"
	echo "* Database Name     : ${ENV_TfDbDbname}"
	echo "* Database Host     : ${ENV_TfDbHostname}"
	echo "* Database Port     : ${ENV_TfDbHostport}"
	echo "* Database User     : ${ENV_TfDbUsername}"
	echo "* Database Password : ${ENV_TfDbPassword}"
	echo "----------------------------------------"
	if test -z "${ENV_TfDbDbname}"   || test -z "${ENV_TfDbHostname}" || \
	   test -z "${ENV_TfDbHostport}" || test -z "${ENV_TfDbUsername}" || \
	   test -z "${ENV_TfDbPassword}"; then
		echo "Some values were emtpy. Please check configuration file."
		wait_enter
		return 1
	fi
	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	#---------------------------
	# Check table
	#---------------------------
	${PSQL} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -d ${ENV_TfDbDbname} -U ${ENV_TfDbUsername} -c "\d divy_diskquota" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "The system quota table did not found."
		echo "Could not update system quota entry becase this location is too old."
		wait_enter
		return 1
	fi

	COL_COUNT=`${PSQL} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -d ${ENV_TfDbDbname} -U ${ENV_TfDbUsername} -c "SELECT count(*) FROM divy_diskquota where dkqt_uri_txt='/${ENV_LocationName}'" | sed -n -e '/[ ][ ]*[0-9][0-9]*/p' | sed -e 's/[ ][ ]*//g'`
	if test "${COL_COUNT}" = "0"; then
		echo "The system quota entry did not found."
		echo "Could not update system quota entry becase this location is too old."
		wait_enter
		return 1
	fi

	echo "* Search current system quota data ..."
	${PSQL} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -d ${ENV_TfDbDbname} -U ${ENV_TfDbUsername} -c "SELECT dkqt_max_st_bi AS size_quota, dkqt_max_res_bi AS files_quota FROM divy_diskquota WHERE dkqt_uri_txt='/${ENV_LocationName}'"
	if test "${RETVAL}" != "0"; then
		echo "Failed to get current system quota."
		wait_enter
		return 1
	fi

	$ECHO_N "Continue ? (y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, abort."
		wait_enter
		return 1
	fi

	TF_SYSQUOTA_MAX_BITES=0
	$ECHO_N "Input System Quota of size  (M,G,T,P,E) (default: ${TF_SYSQUOTA_MAX_BITES}) : "$ECHO_C
	read tmp
	if test -n "${tmp}"; then
		TF_SYSQUOTA_MAX_BITES=`echo ${tmp} | sed -e 's/M$/ \* 1024 ^ 2/' -e 's/G$/ \* 1024 ^ 3/' -e 's/T$/ \* 1024 ^ 4/' -e 's/P$/ \* 1024 ^ 5/' -e 's/E$/ \* 1024 ^ 6/'`
	fi

	TF_SYSQUOTA_MAX_FILES=0
	$ECHO_N "Input System Quota of files (default: ${TF_SYSQUOTA_MAX_FILES}) : "$ECHO_C
	read tmp
	if test -n "${tmp}"; then
		TF_SYSQUOTA_MAX_FILES=${tmp}
	fi

	#---------------------------
	# Update repository database
	#---------------------------
	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	${PSQL} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -d ${ENV_TfDbDbname} -U ${ENV_TfDbUsername} <<_UPDATE_DATA_SQL_
	\set ON_ERROR_STOP 0
	\set LO_TRANSACTION "rollback"

	BEGIN;

	UPDATE divy_diskquota
	SET dkqt_max_st_bi = ${TF_SYSQUOTA_MAX_BITES}, dkqt_max_res_bi = ${TF_SYSQUOTA_MAX_FILES}
	WHERE dkqt_uri_txt = '/${ENV_LocationName}' AND dkqt_type_i = 0;

	SELECT dkqt_max_st_bi AS size_suota, dkqt_max_res_bi AS files_quota
	FROM divy_diskquota WHERE dkqt_uri_txt = '/${ENV_LocationName}' AND dkqt_type_i = 0;

	COMMIT;

_UPDATE_DATA_SQL_
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to update SYSTEM QUOTA.(code : ${RETVAL})"
		wait_enter
		return 1
	fi

	echo "Success."
	wait_enter
	return 0
}

#--------------------------------------
# UNLOCK administrator's password
#--------------------------------------
unlock_admin_password() {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	# show notice msg
	$ECHO_N "This operation UNLOCK expired administrator's password. Are you quite sure ? (y/n) "$ECHO_C
	read ANS1
	if test "${ANS1}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	else
		echo "OK, continue."
	fi

	echo "* Search configuration files ..."
	show_configuration_files
	echo ""
	$ECHO_N "* Please select location configuration file that you want to update : "$ECHO_C
	read f
	if test -z "${f}"; then
		echo "The path of configuration is EMPTY."
		wait_enter
		return 1
	elif test ! -f "${f}"; then
		echo "The \"${f}\" file did not exists."
		wait_enter
		return 1
	fi

	# parse location config
	parse_locationconf ${f}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to parse configuration file."
		wait_enter
		return 1
	fi

	if test -z "${ENV_LocationName}"; then
		echo "Failed to get location name. Please check configuration file."
		wait_enter
		return 1
	fi

	echo "----------------------------------------"
	echo "* Location          : ${ENV_LocationName}"
	echo "* Database Name     : ${ENV_TfDbDbname}"
	echo "* Database Host     : ${ENV_TfDbHostname}"
	echo "* Database Port     : ${ENV_TfDbHostport}"
	echo "* Database User     : ${ENV_TfDbUsername}"
	echo "* Database Password : ${ENV_TfDbPassword}"
	echo "----------------------------------------"
	if test -z "${ENV_TfDbDbname}"   || test -z "${ENV_TfDbHostname}" || \
	   test -z "${ENV_TfDbHostport}" || test -z "${ENV_TfDbUsername}" || \
	   test -z "${ENV_TfDbPassword}"; then
		echo "Some values were emtpy. Please check configuration file."
		wait_enter
		return 1
	fi
	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	#---------------------------
	# Get userinfo
	#---------------------------
	${PSQL} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -d ${ENV_TfDbDbname} -U ${ENV_TfDbUsername} -c "select usr_usr_id_vc from divy_usr where usr_admin_mod_i = 1;"
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to get administrator's user information."
		wait_enter
		return 1
	fi

	$ECHO_N "These user were updated. Are you OK ? (y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, abort."
		wait_enter
		return 1
	fi

	NOWTIME=`date '+%s'`
	#---------------------------
	# Update repository database
	#---------------------------
	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	${PSQL} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -d ${ENV_TfDbDbname} -U ${ENV_TfDbUsername} <<_UPDATE_DATA_SQL_
	\set ON_ERROR_STOP 0
	\set LO_TRANSACTION "rollback"

	BEGIN;

	UPDATE divy_passpolicystatus
	SET ps_last_change_bi = ${NOWTIME}
	WHERE ps_usr_usr_id_vc IN (SELECT usr_usr_id_vc FROM divy_usr WHERE usr_admin_mod_i = 1);

	UPDATE divy_passpolicy
	SET pp_probation_i = 1;

	COMMIT;

_UPDATE_DATA_SQL_
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to update user information.(code : ${RETVAL})"
		wait_enter
		return 1
	fi

	echo "Success."
	wait_enter
	return 0
}

change_user_password() {
	echo ""

	# show notice msg
	$ECHO_N "This operation change user password. Are you quite sure ? (y/n) "$ECHO_C
	read ANS1
	if test "${ANS1}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	else
		echo "OK, continue."
	fi

	echo "* Search configuration files ..."
	show_configuration_files
	echo ""
	$ECHO_N "* Please select location configuration file that you want to update : "$ECHO_C
	read f
	if test -z "${f}"; then
		echo "The path of configuration is EMPTY."
		wait_enter
		return 1
	elif test ! -f "${f}"; then
		echo "The \"${f}\" file did not exists."
		wait_enter
		return 1
	fi

	# parse location config
	parse_locationconf ${f}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to parse configuration file."
		wait_enter
		return 1
	fi

	if test -z "${ENV_LocationName}"; then
		echo "Failed to get location name. Please check configuration file."
		wait_enter
		return 1
	fi

	echo "----------------------------------------"
	echo "* Location          : ${ENV_LocationName}"
	echo "* Database Name     : ${ENV_TfDbDbname}"
	echo "* Database Host     : ${ENV_TfDbHostname}"
	echo "* Database Port     : ${ENV_TfDbHostport}"
	echo "* Database User     : ${ENV_TfDbUsername}"
	echo "* Database Password : ${ENV_TfDbPassword}"
	echo "* Encrtypt Password : ${ENV_TfEncryptPassword}"
	echo "----------------------------------------"
	if test -z "${ENV_TfDbDbname}"   || test -z "${ENV_TfDbHostname}" || \
	   test -z "${ENV_TfDbHostport}" || test -z "${ENV_TfDbUsername}" || \
	   test -z "${ENV_TfDbPassword}"; then
		echo "Some values were emtpy. Please check configuration file."
		wait_enter
		return 1
	fi
	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	#---------------------------
	# Get userinfo
	#---------------------------
	USER=""
	while :; do
		$ECHO_N "Please input the user who change the password. (enter is return) "$ECHO_C
		read u
		if test "x${u}" = "x"; then
			echo "OK return menu"
			wait_enter
			return 1
		fi

		USER=`${PSQL} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -d ${ENV_TfDbDbname} -U ${ENV_TfDbUsername} -t -c "select usr_usr_id_vc from divy_usr where usr_usr_id_vc = '${u}';"`
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "SQL Error .."
			wait_enter
			return 1
		fi

		if test "x${USER}" = "x"; then
			echo "user ${u} not found. next input user id."
			wait_enter
		else
			# found !! 
			break
		fi
	done

	$ECHO_N "found user ( ${u} ). Please input change password "$ECHO_C
	read p
	if test "x${p}" = "x"; then
		echo "password is EMPTY."
		wait_enter
		return 1
	fi

	# is encrypt password
	if test "x${ENV_TfEncryptPassword}" = "xon"; then
		p=`$TF_MD5 ${p}`
	fi

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING
	${PSQL} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -d ${ENV_TfDbDbname} -U ${ENV_TfDbUsername} <<_UPDATE_USER_

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		UPDATE divy_usr
		SET usr_passwd_vc=trim('${p}'),
			usr_failed_access_count_i=0,
			usr_extended_status_c = 'a' || substr(usr_extended_status_c, 2)
		WHERE usr_usr_id_vc=trim('${USER}');

		COMMIT;

_UPDATE_USER_
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to update \"divy_usr\" table. (ret =${RETVAL})"
		wait_enter
		return 1
	fi

	echo "Success. userid = \"${USER}\" password = \"${p}\""
	wait_enter
	return 0
}

#-------------------------------------------------------------------------------
# Show management operation menu
#-------------------------------------------------------------------------------
display_management_menu() {
	clear
	echo " +--------------${TITLE_LINE}---+"
	echo " | [ Management operation menu ]                                      |"
	echo " |                                                                    |"
	echo " | please select this number.                                         |"
	echo " |                                                                    |"
	echo " | 1  : Create new Location and Repository database     [ root only ] |"
	echo " | 2  : Run DB frontend                                               |"
	echo " | 3  : Show ALL Database List                                        |"
	echo " | 4  : Show ALL Database-User List                                   |"
	echo " | 5  : DELETE Repository DB          (Be careful)      [ root only ] |"
	echo " | 6  : DELETE Repository DB User     (Be careful)      [ root only ] |"
	echo " | 7  : DELETE File Storage           (Be careful)      [ root only ] |"
	echo " | 8  : CHANGE Database-User Password                   [ root only ] |"
	echo " | 9  : DELETE a Location and Repository database       [ root only ] |"
	echo " | 10 : UPDATE system quota entry     (Be careful)      [ root only ] |"
	echo " | 11 : UNLOCK administrator's password                 [ root only ] |"
	echo " | 12 : CHANGE user password                                          |"
	echo " |                                                                    |"
	echo " | r  : Return to main menu                                           |"
	echo " | q  : Quit                                                          |"
	echo " +----------------------------------------------------- Management ---+"
}

show_management_menu() {
	while [ 1 ];
	do
		display_management_menu
		$ECHO_N "  Input number : "$ECHO_C
		read ANS
		case "$ANS" in
			1)
				create_location
				;;
			2)
				run_frontend
				;;
			3)
				show_all_database
				;;
			4)
				show_all_user
				;;
			5)
				drop_repos_db
				;;
			6)
				drop_repos_dbuser
				;;
			7)
				drop_file_storage
				;;
			8)
				change_repos_dbpassword
				;;
			9)
				delete_location
				;;
			10)
				update_system_quota
				;;
			11)
				unlock_admin_password
				;;
			12)
				change_user_password
				;;
			r)
				return
				;;
			q)
				echo "bye"
				exitscript 0
				;;
		esac
	done
}

#--------------------------------------
# summary storage usage and number of user
#--------------------------------------
summary_storage_and_user() {
	echo ""
	# show notice msg
	$ECHO_N "This operation storage usage and number of users.. Are you quite sure ? (y/n) "$ECHO_C
	read ANS1
	if test "${ANS1}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	else
		echo "OK, continue."
	fi

	search_configuration_files

	echo ""
	printf "%20s  " "location"
	printf "%16s  " "used"
	printf "%10s\n" "users"
	echo   "-----------------------------------------------"

	for f in ${CONFIGFILE_LIST};
	do
		parse_locationconf $f
		if [ -z ${ENV_TfDbUsername} ]; then continue; fi
		usage=`${PSQL} -t -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "SELECT DKQT_USED_ST_BI FROM DIVY_DISKQUOTA;"`

		users=`${PSQL} -t -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "SELECT COUNT(*) FROM DIVY_USR;"`

		dispMaxUser='-'
		if [ ${ENV_TfMaxUser} -ne 0 ]; then
			dispMaxUser=${ENV_TfMaxUser}
		fi

		printf "%20s :" ${ENV_LocationName}
		printf "%'16d  " ${usage}
		printf "%'5d / %5s\n" ${users} ${dispMaxUser}

	done

	wait_enter

}

#-------------------------------------------------------------------------------
# Show enterprize operation menu
#-------------------------------------------------------------------------------
display_enterprize_menu() {

	clear
	echo " +--------------${TITLE_LINE}---+"
	echo " | [ Enterprize operation menu ]                                      |"
	echo " |                                                                    |"
	echo " | please select this number.                                         |"
	echo " |                                                                    |"
	echo " | 1  : All location storage usage and number of users.               |"
	echo " |                                                                    |"
	echo " |                                                                    |"
	echo " |                                                                    |"
	echo " |                                                                    |"
	echo " |                                                                    |"
	echo " |                                                                    |"
	echo " |                                                                    |"
	echo " |                                                                    |"
	echo " | r  : Return to main menu                                           |"
	echo " | q  : Quit                                                          |"
	echo " +----------------------------------------------------- Enterprize ---+"
}

show_enterprize_menu() {
	while [ 1 ];
	do
		display_enterprize_menu
		$ECHO_N "  Input number : "$ECHO_C
		read ANS
		case "$ANS" in
			1)
				summary_storage_and_user
				;;
			r)
				return
				;;
			q)
				echo "bye"
				exitscript 0
				;;
		esac
	done
}

#--------------------------------------
# Backup TeamFile
#--------------------------------------
backup_all() {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi
	BACKUP_PREFIX_DIR="`date +%Y%m%d_%H%M%S`"

	# check backup root
	if test ! -d "${BACKUP_ROOT}"; then
		echo "${BACKUP_ROOT} is missing. Please check it."
		wait_enter
		return 1
	fi

	# show notice
	STOP_APACHE=0
	isTeamFileRuning
	if test "$?" = "1"; then
		echo "We detect that TeamFile is running."
		echo "Of course, We can backup data, but cannot acquire correct data."
		$ECHO_N "Can you stop TeamFile now ? (y/n) "$ECHO_C
		read ANS
		if test "${ANS}" != "y"; then
			$ECHO_N "Uhm, Do you still perform now ? (y/n) "$ECHO_C
			read ANS
			if test "${ANS}" != "y"; then
				echo "OK, we finish to backup operation."
				wait_enter
				return 1
			else
				echo "OK, leave it to chance..."
			fi
		else
			${APACHECTL} stop
			RETVAL=$?
			if test "${RETVAL}" != "0"; then
				echo "Failed to stop TeamFile. Sorry."
				wait_enter
				return 1
			fi
			STOP_APACHE=1
		fi
	fi

	#-------------------
	# setup dbenv
	#-------------------
	NEED_SERVER=0
	NO_PGDATABASE=1

	setup_dbenv

	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		wait_enter
		return 1
	fi

	# search storage all db name
	echo "* Search repository database ..."
	${PSQL} -l -h ${PGHOST} -p ${PGPORT} -U ${PG_ADMIN_USER}

	# input dbname path
	$ECHO_N "Select repository DB name that you want to backup : "$ECHO_C
	read PGDATABASE
	if test -z "${PGDATABASE}"; then
		echo "The name of repository DB is EMPTY."
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		wait_enter
		return 1
	fi

	# search storage root path
	echo "* Search storage root path ..."
	search_configuration_files
	for f in ${CONFIGFILE_LIST}; do
		grep 'TfFsRootPath' ${f} | sed -e '/^#/d' -e 's/TfFsRootPath//g' -e 's/[ ]*//g'
	done

	# input storage path
	$ECHO_N "Select / Input storage root path that you want to backup : "$ECHO_C
	read storage_root_path
	if test -z "${storage_root_path}"; then
		echo "The storage path is EMPTY."
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		wait_enter
		return 1
	fi

	if test ! -d "${storage_root_path}"; then
		echo "${storage_root_path} is not directory."
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		wait_enter
		return 1
	fi

	st_parentdir=`echo "X${storage_root_path}" | sed -e '1s/^X//' -e 's%/[^/]*$%%'`
	st_dirname=`echo ${storage_root_path} | sed -e '1s/^X//' -e 's%^.*/%%'`
	st_backup="${BACKUP_ROOT}/${BACKUP_PREFIX_DIR}/${st_dirname}.bkst.tar"
	db_backup="${BACKUP_ROOT}/${BACKUP_PREFIX_DIR}/${PGDATABASE}.bkdb.dat"
	cf_backup="${BACKUP_ROOT}/${BACKUP_PREFIX_DIR}/${st_dirname}.bkcf.tar"

	# make backup directory
	if test ! -d "${BACKUP_ROOT}/${BACKUP_PREFIX_DIR}"; then
		mkdir -p ${BACKUP_ROOT}/${BACKUP_PREFIX_DIR}
		RETVAL=$?
		if test "${RETVAL}" != "0" || test ! -d "${BACKUP_ROOT}/${BACKUP_PREFIX_DIR}"; then
			echo "Failed to create backup directory ${BACKUP_ROOT}/${BACKUP_PREFIX_DIR}."
			if test "${STOP_APACHE}" = "1"; then
				${APACHECTL} start
			fi
			wait_enter
			return 1
		fi
	fi

	echo "--- start storage backup ---"
	curdir="`pwd`"
	cd ${st_parentdir}
	tar -cf ${st_backup} ${st_dirname}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to backup storage."
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		cd ${curdir}
		rm -rf ${BACKUP_ROOT}/${BACKUP_PREFIX_DIR}
		wait_enter
		return 1
	fi
	echo "--- end storage backup ---"
	cd ${curdir}

	echo "--- start repository backup ---"

	# execute backup
	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	${PGDUMP} -Fc -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} ${PGDATABASE} > ${db_backup}
	RETVAL=$?

	if test "${RETVAL}" != "0"; then
		echo "Failed to backup repository database (ret = ${RETVAL})"
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		rm -rf ${BACKUP_ROOT}/${BACKUP_PREFIX_DIR}
		wait_enter
		return 1
	fi
	echo "--- end repository backup ---"

	echo "--- start configuration backup ---"
	curdir="`pwd`"
	cd ${APACHE_HOME}
	tar -cf ${cf_backup} conf
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to backup configuration."
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		cd ${curdir}
		rm -rf ${BACKUP_ROOT}/${BACKUP_PREFIX_DIR}
		wait_enter
		return 1
	fi
	echo "--- end configuration backup ---"
	cd ${curdir}

	# start apache
	if test "${STOP_APACHE}" = "1"; then
		${APACHECTL} start
	fi

	wait_enter
}

#--------------------------------------
# Restore TeamFile
#--------------------------------------
restore_all() {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	# show notice
	STOP_APACHE=0
	isTeamFileRuning
	if test "$?" = "1"; then
		echo "We detect that TeamFile is running."
		echo "Of course, We can restore repository dabase, "
		echo "but I don't know whether succeed or not."
		$ECHO_N "Can you stop TeamFile now ? (y/n) "$ECHO_C
		read ANS
		if test "${ANS}" != "y"; then
			$ECHO_N "Uhm, Do you still perform now ? (y/n) "$ECHO_C
			read ANS
			if test "${ANS}" != "y"; then
				echo "OK, we finish to restore operation."
				wait_enter
				return 1
			else
				echo "OK, leave it to chance..."
			fi
		else
			${APACHECTL} stop
			RETVAL=$?
			if test "${RETVAL}" != "0"; then
				echo "Failed to stop TeamFile. Sorry."
				wait_enter
				return 1
			fi
			STOP_APACHE=1
		fi
	fi

	#-------------------
	# setup dbenv
	#-------------------
	NEED_SERVER=0
	NO_PGUSER=1
	NO_PGDATABASE=1

	setup_dbenv
	
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		wait_enter
		return 1
	fi

	# search storage root path
	echo "* Search repository database for restore ..."
	${PSQL} -l -h ${PGHOST} -p ${PGPORT} -U ${PG_ADMIN_USER}

	IS_NEWDB=0
	$ECHO_N "Do you want to create new repository database for restore ? (y/n): "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then

		# input dbname path
		$ECHO_N "Select repository DB name that you want to restore (expect template0, template1): "$ECHO_C
		read PGDATABASE
		if test -z "${PGDATABASE}"; then
			echo "The name of repository DB is EMPTY."
			if test "${STOP_APACHE}" = "1"; then
				${APACHECTL} start
			fi
			wait_enter
			return 1
		elif test "${REPOS_DBTYPE}" = "pg"; then
			if test "${PGDATABASE}" = "template1" -o "${PGDATABASE}" = "template0"; then
				echo "You could not restore data to \"template1\" or \"template0\"."
				if test "${STOP_APACHE}" = "1"; then
					${APACHECTL} start
				fi
				wait_enter
				return 1
			fi
		fi
	else
		$ECHO_N "Input new repository DB name : "$ECHO_C
		read PGDATABASE
		if test -z "${PGDATABASE}"; then
			echo "The name of repository DB is EMPTY."
			if test "${STOP_APACHE}" = "1"; then
				${APACHECTL} start
			fi
			wait_enter
			return 1
		fi
		IS_NEWDB=1
	fi

	# search storage backup data
	echo "* Search storage backup data ..."
	echo "--- tar ---"
	find ${BACKUP_ROOT} -name '*.tar' -print
	echo "--- rsync directory ---"
	find ${BACKUP_ROOT} -name '*.bkst' -print

	# input backup file
	restore_method="directory"
	$ECHO_N "Which type do you want to use [tar/directory] (default : ${restore_method}): "$ECHO_C
	read ANS
	if test -n "${ANS}"; then
		restore_method=${ANS}
		if test "${restore_method}" != "tar" -a "${restore_method}" != "directory"; then
			echo "Unknown type (\"${restore_method}\")"
			if test "${STOP_APACHE}" = "1"; then
				${APACHECTL} start
			fi
			wait_enter
			return 1
		fi
	fi

	# "tar" method
	if test "${restore_method}" = "tar"; then
		$ECHO_N "Select / Input storage backup TAR file path : "$ECHO_C
		read st_backup_file
		if test -z "${st_backup_file}"; then
			echo "The storage backup data path is EMPTY."
			if test "${STOP_APACHE}" = "1"; then
				${APACHECTL} start
			fi
			wait_enter
			return 1
		fi

		if test ! -r "${st_backup_file}"; then
			echo "Could not read ${st_backup_file}. Please check it. "
			if test "${STOP_APACHE}" = "1"; then
				${APACHECTL} start
			fi
			wait_enter
			return 1
		fi

		$ECHO_N "* Extract restore path name from \"${st_backup_file}\"."$ECHO_C
		restore_name=`tar tf ${st_backup_file} | awk '{ print $1; exit 0 }'`
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to extract file information from \"${st_backup_file}\"."
			echo "Please check \"${st_backup_file}\" is TAR-formated file."
			if test "${STOP_APACHE}" = "1"; then
				${APACHECTL} start
			fi
			wait_enter
			return 1
		fi
	# "directory" method
	else
		$ECHO_N "Select / Input storage backup directory path : "$ECHO_C
		read st_backup_dir
		if test -z "${st_backup_dir}"; then
			echo "The storage backup directory path is EMPTY."
			if test "${STOP_APACHE}" = "1"; then
				${APACHECTL} start
			fi
			wait_enter
			return 1
		fi

		if test ! -d "${st_backup_dir}"; then
			echo "${st_backup_dir} is not valid directory. Please check it. "
			if test "${STOP_APACHE}" = "1"; then
				${APACHECTL} start
			fi
			wait_enter
			return 1
		fi

		restore_name=`echo X${st_backup_dir} | sed -e '1s/^X//' -e 's%^.*/%%' -e 's/\.bkst$//'`
	fi
	echo "ok"

	# search respository backup data
	echo "* Search repository db backup data ..."	
	find ${BACKUP_ROOT} -name '*.dat' -print

	# input backup file
	$ECHO_N "Select / Input repository db backup data path : "$ECHO_C
	read repos_backup_file
	if test -z "${repos_backup_file}"; then
		echo "The repository db backup data path is EMPTY."
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		wait_enter
		return 1
	fi

	if test ! -r "${repos_backup_file}"; then
		echo "Could not read ${repos_backup_file}. Please check it. "
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		wait_enter
		return 1
	fi

	# extract repository db owner
#	if test "${REPOS_DBTYPE}" = "pg"; then
#		PGUSER=`${PGRESTORE} ${repos_backup_file} | grep 'SET SESSION AUTHORIZATION' | sed -e '/postgres/d' -e 's/SET SESSION AUTHORIZATION//g' -e 's/[ ;]//g' -e "s/'//g"`
#		if test -z "${PGUSER}"; then
#			echo "Failed to extract database owner name from \"${repos_backup_file}\"."
#			echo "The contenct of this file is broken."
#			if test "${STOP_APACHE}" = "1"; then
#				${APACHECTL} start
#			fi
#			wait_enter
#			return 1
#		fi
#	fi

	echo "Confirm: These DB and Storage were overwritten by this operation. "
	echo "    Repository DB Name  : ""${PGDATABASE}"
	echo "    Repository DB Owner : ""${PGUSER}"
	echo "    Storage path        : ""${STORAGE_BASE}/${restore_name}"
	$ECHO_N "Continue ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		wait_enter
		return 1
	fi

	# create dbuser
	if test "${REPOS_DBTYPE}" = "pg"; then
		${PSQL} -d template1 -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "select usename from pg_user where usename='postgres'" >/dev/null 2>&1
		RETVAL=$?
		if test "${RETVAL}" = "2"; then
			# create user
			echo "The export user \"${PGUSER}\" does not exist."
			$ECHO_N "Do you want to create this user ? (y/n) "$ECHO_C
			read ANS
			if test "${ANS}" != "y"; then
				echo "OK, aborted."
				if test "${STOP_APACHE}" = "1"; then
					${APACHECTL} start
				fi
				wait_enter
				return 1
			fi
			echo "* create new database user for export data"
			${PG_HOME}/bin/createuser -D -A -h ${PGHOST} -p ${PGPORT} -U ${PG_ADMIN_USER} ${PGUSER}
			RETVAL=$?
			if test "${RETVAL}" != "0"; then
				echo "Failed to create new user ${PGUSER}. (ret = ${RETVAL})"
				if test "${STOP_APACHE}" = "1"; then
					${APACHECTL} start
				fi
				wait_enter
				return 1
			fi
		fi
	fi

	# create new repository db
	if test "${IS_NEWDB}" = "1"; then
		echo "creating new repository ..."
		${PG_HOME}/bin/createdb -O ${PGUSER} -h ${PGHOST} -p ${PGPORT} -U ${PG_ADMIN_USER} -E UNICODE ${PGDATABASE}
		RETVAL=$?

		if test "${RETVAL}" != 0; then
			echo "Failed to create new repository database ${PGDATABASE}. (ret = ${RETVAL})"
			if test "${STOP_APACHE}" = "1"; then
				${APACHECTL} start
			fi
			wait_enter
			return 1
		fi
	fi

	echo "--- start restore db ---"

	# execute restore
	OPTS=""
	if test "${IS_NEWDB}" != "1"; then
		OPTS="-c"
	fi

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	${PGRESTORE} ${OPTS} -d ${PGDATABASE} -h ${PGHOST} -p ${PGPORT} -U ${PG_ADMIN_USER} -Fc ${repos_backup_file}
	RETVAL=$?

	if test "${RETVAL}" != "0"; then
		echo "Failed to restore repository database (ret = ${RETVAL})"
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		wait_enter
		return 1
	fi
	echo "--- end restore db ---"

	echo "--- start restore storage ---"
	curdir="`pwd`"
	cd ${STORAGE_BASE}
	# "tar" method
	if test "${restore_method}" = "tar"; then
		tar -xf ${st_backup_file}
	# "directory" method
	else
		rsync -av --delete ${st_backup_dir}/* ${STORAGE_BASE}/${restore_name}/
	fi
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to restore storage database (ret = ${RETVAL})"
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		cd ${curdir}
		wait_enter
		return 1
	fi
	echo "--- end restore storage ---"
	cd ${curdir}

	if test "${STOP_APACHE}" = "1"; then
		${APACHECTL} start
	fi

	wait_enter
}

#--------------------------------------
# Export all sql
#--------------------------------------
export_all_sql() {

	# show notice msg
	echo ""
	$ECHO_N "This operation EXPORT ALL sql entry. Are you quite sure ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi
	echo "OK, continue."

	echo "* Search configuration files ..."
	show_configuration_files
	echo ""
	$ECHO_N "* Please select location configuration file that you want to EXPORT : "$ECHO_C
	read f
	if test -z "${f}"; then
		echo "The path of configuration is EMPTY."
		wait_enter
		return 1
	elif test ! -f "${f}"; then
		echo "The \"${f}\" file did not exists."
		wait_enter
		return 1
	fi

	# parse location config
	parse_locationconf ${f}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to parse configuration file."
		wait_enter
		return 1
	fi

	if test -z "${ENV_LocationName}"; then
		echo "Failed to get location name. Please check configuration file."
		wait_enter
		return 1
	fi

	$ECHO_N "* Export data directory (default: ${TMP_BASE_DIR}) : "$ECHO_C
	read sqlbasedir
	if test -z "${sqlbasedir}"; then
		sqlbasedir=${TMP_BASE_DIR}
	fi
	if test ! -d "${sqlbasedir}"; then
		echo "The \"${sqlbasedir}\" is not valid directory. Please check it."
		wait_enter
		return 1
	fi

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	# show information
	echo "----------------------------------------"
	echo "* Location          : ${ENV_LocationName}"
	echo "* Database Name     : ${ENV_TfDbDbname}"
	echo "* Database Host     : ${ENV_TfDbHostname}"
	echo "* Database Port     : ${ENV_TfDbHostport}"
	echo "* Database User     : ${ENV_TfDbUsername}"
	echo "* Database Password : ${ENV_TfDbPassword}"
	echo "* Export base dir   : ${sqlbasedir}"
	echo "* Export target SQL : "
	# get export target sql
	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "SELECT sql_id_c as \"SQL No\", sql_label_name_vc AS \"SQL Name\" FROM divy_sql;" | more
	echo "----------------------------------------"
	if test -z "${ENV_TfDbDbname}"   || test -z "${ENV_TfDbHostname}" || \
	   test -z "${ENV_TfDbHostport}" || test -z "${ENV_TfDbUsername}" || \
	   test -z "${ENV_TfDbPassword}"; then
		echo "Some values were emtpy. Please check configuration file."
		wait_enter
		return 1
	fi
	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	# Export SQL data
	F_SQL1="${sqlbasedir}/sqldump1.dat"
	F_SQL2="${sqlbasedir}/sqldump2.dat"
	F_SQL3="${sqlbasedir}/sqldump3.dat"
	F_SQL4="${sqlbasedir}/sqldump4.dat"

	rm -f ${F_SQL1} ${F_SQL2} ${F_SQL3} ${F_SQL4}

	echo "Exporting sql data. Please wait for a while ..."
	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING
	${PGDUMP} -Fc -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -t "divy_sql" ${ENV_TfDbDbname} > ${F_SQL1}
	RETVAL=$?
	if test "${RETVAL}" != 0; then
		echo "Failed to export divy_sql data.(${RETVAL})"
		wait_enter
		return 1
	fi
	${PGDUMP} -Fc -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -t "divy_sqlcontent" ${ENV_TfDbDbname} > ${F_SQL2}
	RETVAL=$?
	if test "${RETVAL}" != 0; then
		echo "Failed to export divy_sqlcontent data.(${RETVAL})"
		wait_enter
		return 1
	fi
	${PGDUMP} -Fc -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -t "divy_sqldepend" ${ENV_TfDbDbname} > ${F_SQL3}
	RETVAL=$?
	if test "${RETVAL}" != 0; then
		echo "Failed to export divy_sqldepend data.(${RETVAL})"
		wait_enter
		return 1
	fi
	SQL_SEQ_CNT=`${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "SELECT 'COUNT=' || last_value FROM sql_seq" | grep '[ ][ ]*COUNT=' | sed -e 's/[ ][ ]*COUNT=//g'`
	if test -z "${SQL_SEQ_CNT}"; then
		echo "Failed to export sql_seq data.(${RETVAL})"
		wait_enter
		return 1
	fi
	echo "${SQL_SEQ_CNT}" > ${F_SQL4}

	echo "* Success."
	echo "* Exported file : ${F_SQL1}, ${F_SQL2}, ${F_SQL3}, ${F_SQL4}"
	wait_enter
	return 0
}

#--------------------------------------
# Import all sql
#--------------------------------------
import_all_sql() {
	# show notice msg
	$ECHO_N "This operation DELETE and IMPORT ALL sql entry. Are you quite sure ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi
	echo "OK, continue."

	echo "* Search configuration files ..."
	show_configuration_files
	echo ""
	$ECHO_N "* Please select location configuration file that you want to IMPORT : "$ECHO_C
	read f
	if test -z "${f}"; then
		echo "The path of configuration is EMPTY."
		wait_enter
		return 1
	elif test ! -f "${f}"; then
		echo "The \"${f}\" file did not exists."
		wait_enter
		return 1
	fi

	# parse location config
	parse_locationconf ${f}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to parse configuration file."
		wait_enter
		return 1
	fi

	if test -z "${ENV_LocationName}"; then
		echo "Failed to get location name. Please check configuration file."
		wait_enter
		return 1
	fi

	$ECHO_N "* Exported file directory (default: ${TMP_BASE_DIR}) : "$ECHO_C
	read sqlbasedir
	if test -z "${sqlbasedir}"; then
		sqlbasedir=${TMP_BASE_DIR}
	fi
	if test ! -d "${sqlbasedir}"; then
		echo "The \"${sqlbasedir}\" is not valid directory. Please check it."
		wait_enter
		return 1
	fi
	# Import files
	F_SQL1="${sqlbasedir}/sqldump1.dat"
	F_SQL2="${sqlbasedir}/sqldump2.dat"
	F_SQL3="${sqlbasedir}/sqldump3.dat"
	F_SQL4="${sqlbasedir}/sqldump4.dat"
	SQL_LIST="${F_SQL1} ${F_SQL2} ${F_SQL3} ${F_SQL4}"
	for f in ${SQL_LIST};
	do
		if test ! -f ${f}; then
			echo "The exported file \"${f}\" is missing. Please retry EXPORT operation."
			wait_enter
			return 1
		fi
	done

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	# show information
	echo "----------------------------------------"
	echo "* Location          : ${ENV_LocationName}"
	echo "* Database Name     : ${ENV_TfDbDbname}"
	echo "* Database Host     : ${ENV_TfDbHostname}"
	echo "* Database Port     : ${ENV_TfDbHostport}"
	echo "* Database User     : ${ENV_TfDbUsername}"
	echo "* Database Password : ${ENV_TfDbPassword}"
	echo "* Exported file dir : ${sqlbasedir}"
	echo "* Delete SQL        : "
	# get export target sql
	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "SELECT sql_id_c as \"SQL No\", sql_label_name_vc AS \"SQL Name\" FROM divy_sql;" | more
	echo "* A list of SQL which belong to Groups : "
	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "SELECT sql.sql_label_name_vc AS \"SQL Name\", grp.grp_name_vc AS \"Group Name\" FROM divy_sqlmem mem INNER JOIN divy_sql sql ON mem.sqlm_sql_id_c = sql.sql_id_c INNER JOIN divy_grp grp ON mem.sqlm_grp_id_c = grp.grp_grp_id_c ORDER BY sql.sql_label_name_vc, grp.grp_name_vc" | more
	echo "----------------------------------------"
	if test -z "${ENV_TfDbDbname}"   || test -z "${ENV_TfDbHostname}" || \
	   test -z "${ENV_TfDbHostport}" || test -z "${ENV_TfDbUsername}" || \
	   test -z "${ENV_TfDbPassword}"; then
		echo "Some values were emtpy. Please check configuration file."
		wait_enter
		return 1
	fi
	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	echo "Importing sql data. Please wait for a while ..."
	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	IS_DELETE_SQLMEM=0
	SQL_RELT_CNT=`${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "SELECT 'COUNT=' || count(*) as cnt FROM divy_sqlmem"| grep '[ ][ ]*COUNT=' | sed -e 's/[ ][ ]*COUNT=//g'`
	if test `expr "${SQL_RELT_CNT}"` -gt 0; then
		echo ""
		echo "* There were some SQL-GROUP relation. In many case, this is not problem."
		echo "* Please read import-tool's document and determin you delete this sql-relationship."
		$ECHO_N "Are you DELETE this SQL-GROUP relation ? (y/n) (default: n) : "$ECHO_C
		read ANS
		if test "${ANS}" = "y"; then
			echo "* OK, I delete this relationship after all-operation was success."
			IS_DELETE_SQLMEM=1
		else
			echo "* OK, skipped"
		fi
	fi

	SQL_DBMS_CNT=`${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "SELECT 'COUNT=' || count(*) FROM divy_dbms WHERE ds_ds_id_c = '0000'" | grep '[ ][ ]*COUNT=' | sed -e 's/[ ][ ]*COUNT=//g'`

	if test `expr "${SQL_DBMS_CNT}"` = 0; then
		gmttime=`date -u '+%Y-%m-%dT%H:%M:%SZ'`
		${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} <<_INSERT_REPOS_ENTRY_

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		INSERT INTO divy_dbms
		(ds_ds_id_c, ds_type_vc, ds_id_name_vc, ds_hostname_vc, ds_port_i, ds_dbname_vc, ds_username_vc,
		ds_password_vc, ds_db_pool_i, ds_min_spare_conn_i, ds_max_spare_conn_i, ds_comment_vc,
		ds_active_i, ds_regist_c, ds_update_c)
		VALUES
		('0000', '${REPOS_DBTYPE}','${ENV_TfDbDbname}','(dummy)',0,'(dummy)', '(dummy)',
		'(dummy)', 0, 0, 0, 'これはリポジトリ検索用データベースのエントリです。編集することはできません',
		1, '$gmttime', '$gmttime');

		COMMIT;

_INSERT_REPOS_ENTRY_
		RETVAL=$?
		if test "${RETVAL}" != 0; then
			echo "* Failed to insert repository database entry. Please check it. (divy_dbms)"
			echo ""
		else
			echo "* The new dbms entry was inserted. BUT you could not execute new sql until RELOAD or RESTART server."
			echo "* Please RELOAD or RESTART server manually."
			echo ""
		fi
	fi
	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	SQL_SEQ_CNT=`cat ${F_SQL4}`
	SQL_LIST="${F_SQL1} ${F_SQL2} ${F_SQL3}"

	for sql in ${SQL_LIST};
	do
		${PGRESTORE} -c -O -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -Fc ${sql}
		RETVAL=$?
		if test "${RETVAL}" != 0; then
			echo "Failed to import sql (file = ${sql}, ${RETVAL}). This location's sql maybe is broken by this operation. Please check it."
			wait_enter
			return 1
		fi
	done
	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "SELECT setval('sql_seq', $SQL_SEQ_CNT)"
	RETVAL=$?
	if test "${RETVAL}" != 0; then
		echo "Failed to update SQL-seq no. This location's sql-seq is broken by this operation. Please check it."
		wait_enter
		return 1
	fi

	if test "${IS_DELETE_SQLMEM}" = 1; then
		echo "* Deleting SQL-GROUP relationship ..."

		${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} <<_DELETE_SQL_MEM_
		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		DELETE FROM divy_sqlmem;

		COMMIT;

_DELETE_SQL_MEM_
		RETVAL=$?
		if test "${RETVAL}" != 0; then
			echo "Failed to delete SQL-GROUP relation (divy_sqlmem), but continue. Please delete this entry manually."
		fi
	fi
	echo "* Success."
	echo "* Import result"

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING
	# get export target sql
	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "SELECT sql_id_c as \"SQL No\", sql_label_name_vc AS \"SQL Name\" FROM divy_sql;" | more

	if test "${IS_DELETE_SQLMEM}" = 1; then
		echo "* A list of SQL which belong to Groups (DELETED) : "
	else
		echo "* A list of SQL which belong to Groups : "
	fi
	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "SELECT sql.sql_label_name_vc AS \"SQL Name\", grp.grp_name_vc AS \"Group Name\" FROM divy_sqlmem mem INNER JOIN divy_sql sql ON mem.sqlm_sql_id_c = sql.sql_id_c INNER JOIN divy_grp grp ON mem.sqlm_grp_id_c = grp.grp_grp_id_c ORDER BY sql.sql_label_name_vc, grp.grp_name_vc" | more

	wait_enter
	return 0
}

#-------------------------------------------------------------------------------
# Show backup operation menu
#-------------------------------------------------------------------------------
display_backup_menu() {
	clear
	echo " +--------------${TITLE_LINE}---+"
	echo " | [ Backup & Restore operation menu ]                                |"
	echo " |                                                                    |"
	echo " | please select this number.                                         |"
	echo " |                                                                    |"
	echo " | 1  : Backup  TeamFile                                [ root only ] |"
	echo " | 2  : Restore TeamFile                                [ root only ] |"
	echo " | 3  : Export ALL SQL                                                |"
	echo " | 4  : Import ALL SQL                                                |"
	echo " |                                                                    |"
	echo " | r  : Return to main menu                                           |"
	echo " | q  : Quit                                                          |"
	echo " +----------------------------------------------- Backup & Restore ---+"
}

show_backup_menu() {
	while [ 1 ];
	do
		display_backup_menu
		$ECHO_N "  Input number : "$ECHO_C
		read ANS
		case "$ANS" in
			1)
				backup_all
				;;
			2)
				restore_all
				;;
			3)
				export_all_sql
				;;
			4)
				import_all_sql
				;;
			r)
				return
				;;
			q)
				echo "bye"
				exitscript 0
				;;
		esac
	done
}

#--------------------------------------
# Rearrange database storage
#--------------------------------------
optimize_vacuum_db() {

	echo ""

	# show notice
	isTeamFileRuning
	if test "$?" = "1"; then
		echo "We detect that TeamFile is running."
		echo "This operation need to acquire Global LOCK for database."
		echo "So, TeamFile will FREEZE or DEADLOCK while this operation."
		$ECHO_N "Do you still perform now ? (y/n) "$ECHO_C
		read ANS1
		if test "${ANS1}" != "y"; then
			echo "OK, we finish to optimize operation."
			wait_enter
			return 1
		else
			echo "OK, leave it to chance..."
		fi
	fi

	#-------------------
	# setup dbenv
	#-------------------
	if test "${REPOS_DBTYPE}" = "pg"; then
		NO_PGUSER=1
		NEED_SERVER=0

		setup_dbenv
	fi
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		wait_enter
		return 1
	fi

	# vacuum database
	echo "--- start rearrange ---"
	${PGVACUUM} -d ${PGDATABASE} -h ${PGHOST} -p ${PGPORT} -U ${PG_ADMIN_USER} -v -z -f
	echo "--- end rearrange ---"

	wait_enter
}

#--------------------------------------
# Rebuild table Index 
#--------------------------------------
optimize_rebuild_index() {

	echo ""
	# show notice
	isTeamFileRuning
	if test "$?" = "1"; then
		echo "We detect that TeamFile is running."
		echo "This operation need to acquire Global LOCK for database."
		echo "So, TeamFile will FREEZE or DEADLOCK while this operation."
		$ECHO_N "Do you still perform now ? (y/n) "$ECHO_C
		read ANS1
		if test "${ANS1}" != "y"; then
			echo "OK, we finish to optimize operation."
			wait_enter
			return 1
		else
			echo "OK, leave it to chance..."
		fi
	fi

	#-------------------
	# setup dbenv
	#-------------------
	NEED_SERVER=0

	setup_dbenv

	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		wait_enter
		return 1
	fi

	# reindex database
	echo "--- start rebuild index ---"

	# check table
	EXTRA_SQL=""
	EXTRA_SQL2=""
	EXTRA_SQL3=""
	EXTRA_SQL4=""
	EXTRA_SQL5=""
	EXTRA_SQL6=""
	EXTRA_SQL7=""
	EXTRA_SQL8=""
	EXTRA_SQL9=""
	EXTRA_SQL10=""
	EXTRA_SQL11=""

	${PSQL} -d ${PGDATABASE} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "\d divy_diskquota" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		EXTRA_SQL="REINDEX TABLE divy_diskquota;"
	fi

	${PSQL} -d ${PGDATABASE} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "\d divy_trash_info" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		EXTRA_SQL2="REINDEX TABLE divy_trash_info;"
	fi

	${PSQL} -d ${PGDATABASE} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "\d divy_resourcestate" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		EXTRA_SQL3="REINDEX TABLE divy_resourcestate;"
	fi

	${PSQL} -d ${PGDATABASE} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "\d divy_passpolicy" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		EXTRA_SQL4="REINDEX TABLE divy_passpolicy;"
	fi

	${PSQL} -d ${PGDATABASE} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "\d divy_passngword" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		EXTRA_SQL5="REINDEX TABLE divy_passngword;"
	fi

	${PSQL} -d ${PGDATABASE} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "\d divy_passpolicystatus" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		EXTRA_SQL6="REINDEX TABLE divy_passpolicystatus;"
	fi

	${PSQL} -d ${PGDATABASE} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "\d divy_passhistory" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		EXTRA_SQL7="REINDEX TABLE divy_passhistory;"
	fi

	${PSQL} -d ${PGDATABASE} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "\d divy_confirmreading" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		EXTRA_SQL8="REINDEX TABLE divy_confirmreading;"
	fi

	${PSQL} -d ${PGDATABASE} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "\d divy_session" >/dev/null 2>&1
	if test "${RETVAL}" = "0"; then
		EXTRA_SQL9="REINDEX TABLE divy_session;"
	fi

	${PSQL} -d ${PGDATABASE} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "\d divy_box" >/dev/null 2>&1
	if test "${RETVAL}" = "0"; then
		EXTRA_SQL10="REINDEX TABLE divy_box;"
	fi

	${PSQL} -d ${PGDATABASE} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "\d divy_uploadpolicy" >/dev/null 2>&1
	if test "${RETVAL}" = "0"; then
		EXTRA_SQL11="REINDEX TABLE divy_uploadpolicy;"
	fi

	${PSQL} -d ${PGDATABASE} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} <<_REINDEX_TABLES

	\set ON_ERROR_STOP 0
	\set LO_TRANSACTION "rollback"

	BEGIN;

	REINDEX TABLE dav_dead_property;

	REINDEX TABLE dav_link_collection;

	REINDEX TABLE dav_lock;

	REINDEX TABLE dav_namespace;

	REINDEX TABLE dav_resource;

	REINDEX TABLE divy_clmodule;

	REINDEX TABLE divy_dbkey;

	REINDEX TABLE divy_dbms;

	REINDEX TABLE divy_grp;

	REINDEX TABLE divy_grpmem;

	REINDEX TABLE divy_mailwatch;

	REINDEX TABLE divy_sql;

	REINDEX TABLE divy_sqlcontent;

	REINDEX TABLE divy_sqldepend;

	REINDEX TABLE divy_sqlmem;

	REINDEX TABLE divy_sysmsg;

	REINDEX TABLE divy_usr;

	REINDEX TABLE divy_usraccessdeny;

	REINDEX TABLE divy_usrdiskquota;

	${EXTRA_SQL}

	${EXTRA_SQL2}

	${EXTRA_SQL3}

	${EXTRA_SQL4}

	${EXTRA_SQL5}

	${EXTRA_SQL6}

	${EXTRA_SQL7}

	${EXTRA_SQL8}

	${EXTRA_SQL9}

	${EXTRA_SQL10}

	${EXTRA_SQL11}

	commit;

_REINDEX_TABLES
	RETVAL=$?
	echo "--- end rebuild index ---"

	if test "${RETVAL}" != "0"; then
        	echo "Failed to rebuild index (ret =${RETVAL})"
	fi
	wait_enter
}

#-------------------------------------------------------------------------------
# Show Optimize operation menu
#-------------------------------------------------------------------------------
display_optimize_menu() {
	clear
	echo " +--------------${TITLE_LINE}---+"
	echo " | [ Optimize operation menu ]                                        |"
	echo " |                                                                    |"
	echo " | please select this number.                                         |"
	echo " |                                                                    |"
	echo " | 1  : Rearrange database storage (for PostgreSQL)                   |"
	echo " | 2  : Rebuild table Index                                           |"
	echo " |                                                                    |"
	echo " | r  : Return to main menu                                           |"
	echo " | q  : Quit                                                          |"
	echo " +------------------------------------------------------- Optimize ---+"
}

show_optimize_menu() {
	while [ 1 ];
	do
		display_optimize_menu
		$ECHO_N "  Input number : "$ECHO_C
		read ANS
		case "$ANS" in
			1)
				optimize_vacuum_db
				;;
			2)
				optimize_rebuild_index
				;;
			r)
				return
				;;
			q)
				echo "bye"
				exitscript 0
				;;
		esac
	done
}

#--------------------------------------
# Change Storage root path
#--------------------------------------
change_storage_path() {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	# show notice
	STOP_APACHE=0
	isTeamFileRuning
	if test "$?" = "1"; then
		echo "We detect that TeamFile is running."
		$ECHO_N "Do you stop TeamFile now ? (y/n) "$ECHO_C
		read ANS1
		if test "${ANS1}" != "y"; then
			echo "OK, we could not do operation."
			wait_enter
			return 1
		else
			${APACHECTL} stop
			RETVAL=$?
			if test "${RETVAL}" != "0"; then
				echo "Failed to stop TeamFile. Sorry."
				wait_enter
				return 1
			fi
			STOP_APACHE=1
		fi
	fi

	# find list
	echo "* Search TfFsRootPath list ..."
	filelist=""
	search_configuration_files
	for f in ${CONFIGFILE_LIST}; do
		list=`grep 'TfFsRootPath' ${f} | sed -e '/^#/d'`
		if test -z "${list}"; then
			continue
		fi
		echo "[ ${f} ]"
		grep 'TfFsRootPath' ${f} | sed -e '/^#/d'
		filelist=`echo $filelist`" "`echo ${f}`
	done

	# input path
	echo ""
	$ECHO_N "Input the current value of 'TfFsRootPath' : "$ECHO_C
	read srcpath
	if test -z "${srcpath}"; then
		echo "The value is EMPTY."
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		wait_enter
		return 1
	fi

	# check input directory
	if test ! -d ${srcpath}; then
		echo "${srcpath} is not directory."
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		wait_enter
		return 1
	fi

	# search storage root path
	$ECHO_N "* check input value ... "$ECHO_C
	list=""
	found_count=0
	conffile=""
	for f in ${filelist}; do
		list=`grep "TfFsRootPath[ ]*${srcpath}$" ${f} | sed -e '/^#/d'`
		if test -n "${list}"; then
			found_count=`expr ${found_count} + 1`

			if test `expr "${found_count}"` -gt 2; then
				echo "Several entry was found !!"
				if test "${STOP_APACHE}" = "1"; then
					${APACHECTL} start
				fi
				wait_enter
				return 1
			else
				conffile=`echo ${f}`
			fi
		fi
	done
	if test "${found_count}" = "0"; then
		echo "NG. Could not found this value. Please check it."
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		wait_enter
		return 1
	fi
	echo "ok"

	$ECHO_N "Input the destination value of 'TfFsRootPath' : "$ECHO_C
	read dstpath
	if test -z "${dstpath}"; then
		echo "The value is EMPTY."
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		wait_enter
		return 1
	fi

	# check directory
	if test -d ${dstpath}; then
		echo "${dstpath} already exists !!"
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		wait_enter
		return 1
	fi

	# cp storage
	echo "* copy ${srcpath} to ${dstpath}. Please wait for a while..."
	cp -pr ${srcpath} ${dstpath}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to copy ${srcpath} to ${dstpath}."
		if test "${STOP_APACHE}" = "1"; then
			${APACHECTL} start
		fi
		wait_enter
		return 1
	fi

	# change config
	cat ${conffile} | \
	sed -e 's:'"TfFsRootPath[ ]*${srcpath}"':'"TfFsRootPath ${dstpath}"':g' > ${TMP_BASE_DIR}/__tmp__ && \
	mv ${TMP_BASE_DIR}/__tmp__ ${conffile}

	echo "Success."
	echo "Please check \"${dstpath}\" and remove \"${srcpath}\" manually."
	if test "${STOP_APACHE}" = "1"; then
		${APACHECTL} start
	fi

	wait_enter
}

#--------------------------------------
# Setup Trash-Folder function
#--------------------------------------
enable_trashfolder_function() {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	#-------------------
	# setup dbenv
	#-------------------
	NEED_SERVER=0
	NO_PGDATABASE=1

	setup_dbenv
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		wait_enter
		return 1
	fi

	#-------------------
	# show database name
	#-------------------
	USE_INNER=1
	show_all_database
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to get database list."
		wait_enter
		return 1
	fi

	# input db username
	$ECHO_N "Input or Select database or schema name that you want to change : "$ECHO_C
	read trash_reposdbname
	if test -z "${trash_reposdbname}"; then
		echo "Database name is EMPTY !!"
		wait_enter
		return 1
	fi

	# check valid repository database
	echo ""
	echo "Checking for \"${trash_reposdbname}\" repository database ..."

	${PSQL} -d ${trash_reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "select rs_rs_id_c from dav_resource limit 1" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to find valid repository database."
		echo "Please check the name of repository database. (${trash_reposdbname})"
		wait_enter
		return 1
	fi
	echo "OK."

	# check "Trash_Folder" name
	echo "Search \"Trash_Folder\" name ..."

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	${PSQL} -d ${trash_reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "SELECT rs_rs_id_c, rs_uri_txt, rs_dispname_vc FROM dav_resource WHERE rs_uri_txt LIKE '/%/Trash_Folder'"
	RETVAL=$?

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	if test "${RETVAL}" != "0"; then
		echo "Failed to search database.(${trash_reposdbname})"
		wait_enter
		return 1
	fi

	echo "Please watch output string and "
	echo "When you took some entries, You SHOULD NOT execute this script."
	$ECHO_N "Are you OK ? (y/n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, abort."
		wait_enter
		return 1
	fi

	echo "Creating TABLE (divy_trash_info) and Inserting data. Please wait for a while ..."
	gmttime=`date -u '+%Y-%m-%dT%H:%M:%SZ'`

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	${PSQL} -d ${trash_reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} <<__ENABLE_TRASHFOLDER_SQL__

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		CREATE TABLE divy_trash_info (
			TR_RS_ID_C             char(12),
			TR_DELETION_BI         bigint         not null,
			TR_DELETER_ID_VC       varchar(60)    not null,
			constraint PK_divy_trash_info PRIMARY KEY(TR_RS_ID_C)
		);

		INSERT INTO dav_resource
			(rs_rs_id_c, rs_uri_txt, rs_dispname_vc, rs_create_bi,
			 rs_get_cont_lang_vc, rs_get_cont_len_bi, rs_get_cont_type_vc,
			 rs_get_etag_txt, rs_get_lastmodified_bi, rs_resourcetype_i, rs_depth_i,
			 rs_isversioned_i, rs_checkin_i, rs_checkout_i, rs_physical_path_txt,
			 rs_creator_usr_id_vc, rs_lastmodifier_usr_id_vc)
		SELECT lpad(nextval('res_seq')::text,12,'0'), rs_uri_txt || '/Trash_Folder', 'Trash_Folder',
			 extract(epoch from timestamp '${gmttime}'), NULL, 0, 'httpd/trash-directory',
			 NULL, extract(epoch from timestamp '${gmttime}'), 1, rs_depth_i + 1,
			 0, -1, -1, NULL,
			 'root', 'root'
		FROM dav_resource WHERE rs_rs_id_c IN (SELECT usr_rs_id_c FROM divy_usr);

		INSERT INTO dav_resource
			(rs_rs_id_c, rs_uri_txt, rs_dispname_vc, rs_create_bi,
			 rs_get_cont_lang_vc, rs_get_cont_len_bi, rs_get_cont_type_vc,
			 rs_get_etag_txt, rs_get_lastmodified_bi, rs_resourcetype_i, rs_depth_i,
			 rs_isversioned_i, rs_checkin_i, rs_checkout_i, rs_physical_path_txt,
			 rs_creator_usr_id_vc, rs_lastmodifier_usr_id_vc)
		SELECT lpad(nextval('res_seq')::text,12,'0'), rs_uri_txt || '/Trash_Folder', 'Trash_Folder',
		 	extract(epoch from timestamp '${gmttime}'), NULL, 0, 'httpd/trash-directory',
			NULL, extract(epoch from timestamp '${gmttime}'), 1, rs_depth_i + 1,
			0, -1, -1, NULL,
			'root', 'root'
		FROM dav_resource WHERE rs_rs_id_c IN (SELECT grp_rs_id_c FROM divy_grp);

		COMMIT;

__ENABLE_TRASHFOLDER_SQL__

	RETVAL=$?
	if test "${RETVAL}" != "0"; then
        	echo "Failed to create table and insert data. (ret =${RETVAL})"
		wait_enter
		return 1
	fi


	#-------------------------
	# Edit configuration file
	#-------------------------
	$ECHO_N "Do you want to edit configuration file ?(y/n) (default: y) : "$ECHO_C
	read tmp
	if test -z "${tmp}" || test "${tmp}" = "y"; then
		echo "* Search configuration file ..."
		get_location_name ${trash_reposdbname} ${PGHOST} ${PGPORT} ${PGUSER}

		if test -n "${LOCATION_NAME}"; then
			search_configuration_files
			for f in ${CONFIGFILE_LIST}; do
				tmp=`grep "\<Location[ ][ ]*${LOCATION_NAME}\>" ${f}`
				if test -z "${tmp}"; then
					continue
				else
					echo "* Please write \"TfTrashFolder on\" entry in Location directive file."
					$ECHO_N "* Press any key to edit \"${f}\"."$ECHO_C
					read tmp

					# insert "TfTrashFolder on" text in configuration file
					cat - > ${tmp_script} <<__LOCATION_REPLACE_SCRIPT_TEXT__
/^<Location[ ][ ]*\\${LOCATION_NAME}>/a\\
	##### Please edit the following script. #####\\
	TfTrashFolder on
__LOCATION_REPLACE_SCRIPT_TEXT__
					sed -f ${tmp_script} ${f} > ${tmp_config}
					mv ${tmp_config} ${f}
					vi ${f}

					rm -f ${tmp_script}
				fi
			done
			echo "Success. "
			echo "* Please ADD \"tf-enabletrash=on\" to \"BrowserMatch\" directive and "
			echo "* RESTART TeamFile server."
		else
			echo "Success. "
			echo "* Please ADD \"TfTrashFolder on\" entry in Location directive and "
			echo "* ADD \"tf-enabletrash=on\" to \"BrowserMatch\" directive and "
			echo "* RESTART TeamFile server."
		fi
	else
		echo "Success. "
		echo "* Please ADD \"TfTrashFolder on\" entry in Location directive and "
		echo "* ADD \"tf-enabletrash=on\" to \"BrowserMatch\" directive and "
		echo "* RESTART TeamFile server."
	fi

	wait_enter
}

#--------------------------------------
# Setup Extended User status function
#--------------------------------------
enable_extendeduserstatus_function() {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	#-------------------
	# setup dbenv
	#-------------------
	NEED_SERVER=0
	NO_PGDATABASE=1

	setup_dbenv
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		wait_enter
		return 1
	fi

	#-------------------
	# show database name
	#-------------------
	USE_INNER=1
	show_all_database
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to get database list."
		wait_enter
		return 1
	fi

	# input db username
	$ECHO_N "Input or Select database or schema name that you want to change : "$ECHO_C
	read extstatus_reposdbname
	if test -z "${extstatus_reposdbname}"; then
		echo "Database name is EMPTY !!"
		wait_enter
		return 1
	fi

	# check valid repository database
	echo ""
	echo "Checking for \"${extstatus_reposdbname}\" repository database ..."

	${PSQL} -d ${extstatus_reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "select rs_rs_id_c from dav_resource limit 1" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to find valid repository database."
		echo "Please check the name of repository database. (${extstatus_reposdbname})"
		wait_enter
		return 1
	fi
	echo "OK."

	# create table and insert data
	echo "Creating TABLE (divy_resourcestate) and Inserting data. Please wait for a while ..."
	gmttime=`date -u '+%Y-%m-%dT%H:%M:%SZ'`

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	${PSQL} -d ${extstatus_reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "\d divy_resourcestate" >/dev/null 2>&1
	RETVAL=$?

	# create table
	if test "${RETVAL}" != "0"; then
		${PSQL} -d ${extstatus_reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} <<__ENABLE_EXTSTATUS_SQL1__

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		CREATE TABLE divy_resourcestate (
			RT_URI_TXT     varchar(1000),
			RT_TYPE_I      integer,
			RT_DEPTH_I     integer    not null,
			RT_HIERARCHY_I integer    not null,
			RT_EFFECTIVE_I integer    default 1 not null,
			constraint PK_divy_resourcestate PRIMARY KEY(RT_URI_TXT, RT_TYPE_I)
		);

		CREATE INDEX divy_resourcestate_x0 ON divy_resourcestate (RT_URI_TXT, RT_TYPE_I, RT_DEPTH_I, RT_EFFECTIVE_I);

		COMMIT;

__ENABLE_EXTSTATUS_SQL1__

		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to create \"divy_resourcestate\" table. (ret =${RETVAL})"
			wait_enter
			return 1
		fi
	fi

	# alter table
	${PSQL} -d ${extstatus_reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "select usr_expiration_bi, usr_extended_status_c from divy_usr limit 0" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		${PSQL} -d ${extstatus_reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} <<__ENABLE_EXTSTATUS_SQL2__

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		ALTER TABLE divy_usr ADD COLUMN USR_EXPIRATION_BI bigint;

		ALTER TABLE divy_usr ALTER COLUMN USR_EXPIRATION_BI SET default 0;

		ALTER TABLE divy_usr ADD COLUMN USR_EXTENDED_STATUS_C char(32);

		REINDEX TABLE divy_usr;

		COMMIT;

		VACUUM FULL ANALYZE divy_usr;

__ENABLE_EXTSTATUS_SQL2__

		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to update \"divy_usr\" table. (ret =${RETVAL})"
			wait_enter
			return 1
		fi

		# update data
		${PSQL} -d ${extstatus_reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} <<__ENABLE_EXTSTATUS_SQL3__

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		UPDATE divy_usr
		SET usr_expiration_bi=0,
		usr_extended_status_c='a--wvt----**********************'
		WHERE usr_usr_id_vc IS NULL;

		UPDATE divy_usr
		SET usr_expiration_bi=0,
		usr_extended_status_c='a--w--s---**********************'
		WHERE usr_usr_id_vc = '${TF_SYSEXEC_USER}';

		COMMIT;

__ENABLE_EXTSTATUS_SQL3__
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to update data. (ret =${RETVAL})"
			wait_enter
			return 1
		fi
	fi

	#-------------------------
	# Edit configuration file
	#-------------------------
	$ECHO_N "Do you want to edit configuration file ?(y/n) (default: y) : "$ECHO_C
	read tmp
	if test -z "${tmp}" || test "${tmp}" = "y"; then
		echo "* Search configuration file ..."

		tmp_config="${TMP_BASE_DIR}/__config.tmp.conf"
		tmp_script="${TMP_BASE_DIR}/script.sed"
		get_location_name ${extstatus_reposdbname} ${PGHOST} ${PGPORT} ${PGUSER}

		if test -n "${LOCATION_NAME}"; then
			search_configuration_files
			for f in ${CONFIGFILE_LIST}; do
				tmp=`grep "\<Location[ ][ ]*${LOCATION_NAME}\>" ${f}`
				if test -z "${tmp}"; then
					continue
				else
					echo "* Please write \"TfExtendUserStatus on\" entry in Location directive file."
					$ECHO_N "* Press any key to edit \"${f}\"."$ECHO_C
					read tmp

					# insert "TfExtendUserStatus on" text in configuration file
					cat - > ${tmp_script} <<__LOCATION_REPLACE_SCRIPT_TEXT__
/^<Location[ ][ ]*\\${LOCATION_NAME}>/a\\
	##### Please edit the following script. #####\\
	TfExtendUserStatus on
__LOCATION_REPLACE_SCRIPT_TEXT__
					sed -f ${tmp_script} ${f} > ${tmp_config}
					mv ${tmp_config} ${f}
					vi ${f}

					rm -f ${tmp_script}
				fi
			done
			echo "Success. "
			echo "* Please restart TeamFile server."
		else
			echo "Success. "
			echo "* Please append \"TfExtendUserStatus on\" entry in Location directive and "
			echo "* restart TeamFile server."
		fi
	else
		echo "Success. "
		echo "* Please append \"TfExtendUserStatus on\" entry in Location directive and "
		echo "* restart TeamFile server."
	fi

	wait_enter
}


#--------------------------------------
# Change TfSyncGroupUri value
#--------------------------------------
change_tfsyncgroupuri_value() {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	#-----------------------------
	# Get option of migration
	#-----------------------------
	$ECHO_N "Is the CURRENT value of \"TfSycGroupUri\" \"OFF\" ?(y/n) (default: n) : "$ECHO_C
	read tmp
	if test "${tmp}" != "y"; then
		echo "OK, we could not continue this operation."
		wait_enter
		return 1
	fi

	#-------------------
	# setup dbenv
	#-------------------
	NEED_SERVER=0
	NO_PGDATABASE=1

	setup_dbenv
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		wait_enter
		return 1
	fi

	#-------------------
	# show database name
	#-------------------
	USE_INNER=1
	show_all_database
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to get database list."
		wait_enter
		return 1
	fi

	# input db username
	$ECHO_N "Input or Select database or schema name that you want to change : "$ECHO_C
	read reposdbname
	if test -z "${reposdbname}"; then
		echo "Database name is EMPTY !!"
		wait_enter
		return 1
	fi

	# check whether same group name found
	echo ""
	echo "Checking for \"${reposdbname}\" repository database ..."

	gcnt1=`${PSQL} -d ${reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "select count(grp_name_vc) from divy_grp"`
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to find valid repository database."
		echo "Please check the name of repository database. (${reposdbname})"
		wait_enter
		return 1
	fi

	gcnt2=`${PSQL} -d ${reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "select count(distinct grp_name_vc) from divy_grp"`
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to find valid repository database."
		echo "Please check the name of repository database. (${reposdbname})"
		wait_enter
		return 1
	fi

	if test "$gcnt1" != "$gcnt2"; then
		echo "* Same group name were found."
		echo "* We could not change group name."
		wait_enter
		return 1
	fi
	echo "OK."

	# final answer
	$ECHO_N "Are you OK ?(y/n) (default: n) : "$ECHO_C
	read tmp
	if test "${tmp}" != "y"; then
		echo "OK, abort"
		wait_enter
		return 1
	fi

	#-----------------------------
	# change uri
	#-----------------------------
	# (Tables)
	#   * dav_lock            (lk_uri_txt, lk_lockkey_txt)
	#   * divy_mailwatch      (mw_rs_uri_txt)
	#   * divy_resourcestate  (rt_uri_txt)
	#   * dav_resource        (rs_uri_txt)

	# グループフォルダトップのURIを取得する
	# (任意のグループを1つ取り出してfinal path segment を削り取って算出)
	any_groupuri=`${PSQL} -d ${reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -t -c 'SELECT r.rs_uri_txt FROM dav_resource r INNER JOIN divy_grp g ON r.rs_rs_id_c = g.grp_rs_id_c limit 1'`
	if test -z "${any_groupuri}"; then
		echo "* There was no group folder."
		wait_enter
		return 0
	fi
	groupfolder_uri=`echo "X${any_groupuri}" | sed -e '1s/^X[ ]*//' -e 's%/[^/]*$%%'`

	# UPDATE 文を生成する
	UPDATE_SQL="${TMP_BASE_DIR}/_update_resource.sql"
	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING
	${PSQL} -d ${reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} <<_UPDATE_RESOURCE_URI_SQL_

	\t
	\o ${UPDATE_SQL}
	SELECT 'UPDATE dav_resource SET rs_uri_txt = ''${groupfolder_uri}/' || g.grp_name_vc || ''' || substring(rs_uri_txt, char_length(''' || r.rs_uri_txt || ''') + 1) WHERE rs_uri_txt = ''' || r.rs_uri_txt || ''' OR rs_uri_txt LIKE ''' || r.rs_uri_txt || '/%'';' AS sql FROM dav_resource r INNER JOIN divy_grp g ON r.rs_rs_id_c = g.grp_rs_id_c;

	SELECT 'UPDATE dav_lock SET lk_uri_txt = ''${groupfolder_uri}/' || g.grp_name_vc || ''' || substring(lk_uri_txt, char_length(''' || r.rs_uri_txt || ''') + 1) WHERE lk_uri_txt = ''' || r.rs_uri_txt || ''' OR lk_uri_txt LIKE ''' || r.rs_uri_txt || '/%'';' AS sql FROM dav_resource r INNER JOIN divy_grp g ON r.rs_rs_id_c = g.grp_rs_id_c;

	SELECT 'UPDATE dav_lock SET lk_lockkey_txt = ''${groupfolder_uri}/' || g.grp_name_vc || ''' || substring(lk_lockkey_txt, char_length(''' || r.rs_uri_txt || ''') + 1) WHERE lk_lockkey_txt = ''' || r.rs_uri_txt || ''' OR lk_lockkey_txt LIKE ''' || r.rs_uri_txt || '/%'';' AS sql FROM dav_resource r INNER JOIN divy_grp g ON r.rs_rs_id_c = g.grp_rs_id_c;

	SELECT 'UPDATE divy_mailwatch SET mw_rs_uri_txt = ''${groupfolder_uri}/' || g.grp_name_vc || ''' || substring(mw_rs_uri_txt, char_length(''' || r.rs_uri_txt || ''') + 1) WHERE mw_rs_uri_txt = ''' || r.rs_uri_txt || ''';' AS sql FROM dav_resource r INNER JOIN divy_grp g ON r.rs_rs_id_c = g.grp_rs_id_c;

	SELECT 'UPDATE divy_resourcestate SET rt_uri_txt = ''${groupfolder_uri}/' || g.grp_name_vc || ''' || substring(rt_uri_txt, char_length(''' || r.rs_uri_txt || ''') + 1) WHERE rt_uri_txt = ''' || r.rs_uri_txt || ''' OR rt_uri_txt LIKE ''' || r.rs_uri_txt || '/%'';' AS sql FROM dav_resource r INNER JOIN divy_grp g ON r.rs_rs_id_c = g.grp_rs_id_c;

_UPDATE_RESOURCE_URI_SQL_

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING
	${PSQL} -d ${reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} <<_UPDATE_DAV_RESOURCE_URI_

	\set ON_ERROR_STOP 0
	\set LO_TRANSACTION "rollback"

	BEGIN;

	\i ${UPDATE_SQL}

	COMMIT;
_UPDATE_DAV_RESOURCE_URI_
	RETVAL=$?

	rm -f ${UPDATE_SQL}
	if test "${RETVAL}" != 0; then
		echo "Failed to update data."
		wait_enter
		return 1
	fi

	#-------------------------
	# Edit configuration file
	#-------------------------
	$ECHO_N "Do you want to edit configuration file ?(y/n) (default: y) : "$ECHO_C
	read tmp
	if test -z "${tmp}" || test "${tmp}" = "y"; then
		echo "* Search configuration file ..."

		tmp_config="${TMP_BASE_DIR}/__config.tmp.conf"
		tmp_script="${TMP_BASE_DIR}/script.sed"
		get_location_name ${reposdbname} ${PGHOST} ${PGPORT} ${PGUSER}

		if test -n "${LOCATION_NAME}"; then
			search_configuration_files
			for f in ${CONFIGFILE_LIST}; do
				tmp=`grep "\<Location[ ][ ]*${LOCATION_NAME}\>" ${f}`
				if test -z "${tmp}"; then
					continue
				else
					echo "* Please write \"TfSyncGroupUri middle\" entry in Location directive file."
					$ECHO_N "* Press any key to edit \"${f}\"."$ECHO_C
					read tmp

					# insert "TfSyncGroupUri middle" text in configuration file
					cat - > ${tmp_script} <<__LOCATION_REPLACE_SCRIPT_TEXT__
/^<Location[ ][ ]*\\${LOCATION_NAME}>/a\\
	##### Please edit the following script. #####\\
	TfSyncGroupUri middle
__LOCATION_REPLACE_SCRIPT_TEXT__
					sed -f ${tmp_script} ${f} > ${tmp_config}
					mv ${tmp_config} ${f}
					vi ${f}

					rm -f ${tmp_script}
				fi
			done
			echo "Success. "
			echo "* Please restart TeamFile server."
		else
			echo "Success. "
			echo "* Please append \"TfSyncGroupUri middle\" entry in Location directive and "
			echo "* restart TeamFile server."
		fi
	else
		echo "Success. "
		echo "* Please append \"TfSyncGroupUri middle\" entry in Location directive and "
		echo "* restart TeamFile server."
	fi
	echo "Success"

	wait_enter
	return 0
}

#--------------------------------------
# Update PostgreSQL 7.4.6 -> 7.4.9
#--------------------------------------
update_pg_746_to_749() {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	# show message
	$ECHO_N "Update PostgreSQL 7.4.6 -> 7.4.9 ? (y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 0
	fi

	#-------------------
	# get all respository dbname
	#-------------------
	NEED_SERVER=0
	NO_PGUSER=1
	NO_PGDATABASE=1

	setup_dbenv
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to get dbname (code : $RETVAL)"
		wait_enter
		return 1
	fi

	#-------------------
	# show database name
	#-------------------
	USE_INNER=1
	show_all_database
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to get database list."
		wait_enter
		return 1
	fi

	$ECHO_N "Are you OK ? (y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, abort."
		wait_enter
		return 0
	fi

	#---------------------------
	# update database catalog
	#---------------------------
	dblist=`${PSQL} -d template1 -h ${PGHOST} -p ${PGPORT} -U ${PG_ADMIN_USER} <<_SHOW_ALL_DBLIST_ | sed -n -e '/[|]/p' | sed -e 's/|.*$//g' -e 's/^[ ][ ]*//g' -e '/template1/d' -e '/template0/d'
	\pset tuples_only
	\pset format unaligned
	\list
_SHOW_ALL_DBLIST_
`
	dblist="template1 template0 $dblist"

	for db in ${dblist}; do
		echo "* Updating catalog (${db}) ... "

		if test "$db" = "template1"; then
			${PSQL} -d ${db} -h ${PGHOST} -p ${PGPORT} -U ${PG_ADMIN_USER} <<_UPDATE_TEMPLATE1_

	\set ON_ERROR_STOP 0
	\set LO_TRANSACTION "rollback"

	BEGIN;
	UPDATE pg_proc SET proargtypes[3] = 'internal'::regtype
	WHERE pronamespace = 11 AND pronargs = 5 AND proargtypes[2] = 'cstring'::regtype;
	UPDATE pg_database SET datallowconn = true WHERE datname = 'template0';

	COMMIT;

_UPDATE_TEMPLATE1_
		elif test "$db" = "template0"; then
			${PSQL} -d ${db} -h ${PGHOST} -p ${PGPORT} -U ${PG_ADMIN_USER} <<_UPDATE_TEMPLATE0_

	\set ON_ERROR_STOP 0
	\set LO_TRANSACTION "rollback"

	BEGIN;
	UPDATE pg_proc SET proargtypes[3] = 'internal'::regtype
	WHERE pronamespace = 11 AND pronargs = 5 AND proargtypes[2] = 'cstring'::regtype;
	UPDATE pg_database SET datallowconn = false WHERE datname = 'template0';

	COMMIT;
_UPDATE_TEMPLATE0_
		else
			${PSQL} -d ${db} -h ${PGHOST} -p ${PGPORT} -U ${PG_ADMIN_USER} <<_UPDATE_REPOSITORY_

	\set ON_ERROR_STOP 0
	\set LO_TRANSACTION "rollback"

	BEGIN;
	UPDATE pg_proc SET proargtypes[3] = 'internal'::regtype
	WHERE pronamespace = 11 AND pronargs = 5 AND proargtypes[2] = 'cstring'::regtype;

	COMMIT;
_UPDATE_REPOSITORY_
		fi

		RETVAL=$?
		if test "${RETVAL}" = "0"; then
			echo "OK."
		else
			echo "NG."
		fi
	done

	echo "Success."
	wait_enter
	return 0
}

#--------------------------------------
# Enable Password-Policy function
#--------------------------------------
enable_passpolicy_function() {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	#-------------------
	# setup dbenv
	#-------------------
	NEED_SERVER=0
	NO_PGDATABASE=1

	setup_dbenv
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		wait_enter
		return 1
	fi

	#-------------------
	# show database name
	#-------------------
	USE_INNER=1
	show_all_database
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to get database list."
		wait_enter
		return 1
	fi

	# input db username
	$ECHO_N "Input or Select database or schema name that you want to change : "$ECHO_C
	read reposdbname
	if test -z "${reposdbname}"; then
		echo "Database name is EMPTY !!"
		wait_enter
		return 1
	fi

	# check valid repository database
	echo ""
	echo "Checking for \"${reposdbname}\" repository database ..."

	${PSQL} -d ${reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "select rs_rs_id_c from dav_resource limit 1" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to find valid repository database."
		echo "Please check the name of repository database. (${reposdbname})"
		wait_enter
		return 1
	fi
	echo "OK."

	# create table and insert data
	echo "Creating TABLE and Inserting data. Please wait for a while ..."
	gmttime=`date -u '+%Y-%m-%dT%H:%M:%SZ'`

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	${PSQL} -d ${reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "\d divy_passpolicy" >/dev/null 2>&1
	RETVAL=$?

	# create table
	if test "${RETVAL}" != "0"; then
		${PSQL} -d ${reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} <<__ENABLE_SQL1__

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		CREATE TABLE divy_passpolicy (
			PP_POLICY_ID_I           integer,
			PP_STATUS_I              integer,
			PP_STARTDT_BI            bigint,
			PP_MINLEN_I              integer,
			PP_CHANGE_CYCLE_I        integer,
			PP_PROBATION_I           integer,
			PP_CHANGE_HISTORY_I      integer,
			PP_NG_USERID_I           integer,
			PP_NG_WORD_I             integer,
			PP_MUST_SYMBOL_I         integer,
			PP_MUST_NUMERIC_I        integer,
			PP_MUST_UALPHA_I         integer,
			PP_MUST_LALPHA_I         integer,
			PP_CYCLECHAR_I           integer,
			PP_FIRSTLOGIN_LIMITDAY_I integer,
			constraint PK_divy_passpolicy PRIMARY KEY(PP_POLICY_ID_I)
		);

		COMMIT;

__ENABLE_SQL1__

		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to create \"divy_passpolicy\" table. (ret =${RETVAL})"
			wait_enter
			return 1
		fi
	fi

	${PSQL} -d ${reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "\d divy_passngword" >/dev/null 2>&1
	RETVAL=$?

	# create table
	if test "${RETVAL}" != "0"; then
		${PSQL} -d ${reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} <<__ENABLE_SQL1__

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		CREATE TABLE divy_passngword (
			PW_POLICY_ID_I  integer,
			PW_WORD_VC      varchar(50),
			constraint PK_divy_passngword PRIMARY KEY(PW_POLICY_ID_I,PW_WORD_VC)
		);

		COMMIT;

__ENABLE_SQL1__

		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to create \"divy_passngword\" table. (ret =${RETVAL})"
			wait_enter
			return 1
		fi
	fi

	${PSQL} -d ${reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "\d divy_passpolicystatus" >/dev/null 2>&1
	RETVAL=$?

	# create table
	if test "${RETVAL}" != "0"; then
		${PSQL} -d ${reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} <<__ENABLE_SQL1__

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		CREATE TABLE divy_passpolicystatus (
			PS_POLICY_ID_I             integer,
			PS_USR_USR_ID_VC           varchar(60),
			PS_SEND_EXPIREDMAIL_BI     bigint,
			PS_LAST_CHANGE_BI          bigint,
			PS_FIRSTLOGIN_BI           bigint,
			PS_SPECIAL_START_BI        bigint,
			constraint PK_divy_passpolicystatus PRIMARY KEY(PS_POLICY_ID_I,PS_USR_USR_ID_VC)
		);

		COMMIT;

__ENABLE_SQL1__

		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to create \"divy_passpolicystatus\" table. (ret =${RETVAL})"
			wait_enter
			return 1
		fi

		# update data
		${PSQL} -d ${reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} <<__ENABLE_SQL2__

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		INSERT INTO divy_passpolicystatus
		(PS_POLICY_ID_I, PS_USR_USR_ID_VC, PS_SEND_EXPIREDMAIL_BI, PS_LAST_CHANGE_BI, PS_FIRSTLOGIN_BI, PS_SPECIAL_START_BI)
		(SELECT 1, usr_usr_id_vc, 0, extract(epoch from timestamp '${gmttime}'), usr_last_access_bi, 0 FROM divy_usr);

		COMMIT;

__ENABLE_SQL2__

		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to update data. (ret =${RETVAL})"
			wait_enter
			return 1
		fi
	fi

	${PSQL} -d ${reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} -c "\d divy_passhistory" >/dev/null 2>&1
	RETVAL=$?

	# create table
	if test "${RETVAL}" != "0"; then
		${PSQL} -d ${reposdbname} -h ${PGHOST} -p ${PGPORT} -U ${PGUSER} <<__ENABLE_SQL1__

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		CREATE TABLE divy_passhistory (
			PH_USR_ID_VC    varchar(60),
			PH_PASSWD_VC    varchar(64),
			PH_PASSWD_ID_I  integer not null,
			constraint PK_divy_passhistory PRIMARY KEY(PH_USR_ID_VC,PH_PASSWD_VC)
		);

		COMMIT;

__ENABLE_SQL1__

		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to create \"divy_passhistory\" table. (ret =${RETVAL})"
			wait_enter
			return 1
		fi
	fi

	#-------------------------
	# Edit configuration file
	#-------------------------
	$ECHO_N "Do you want to edit configuration file ?(y/n) (default: y) : "$ECHO_C
	read tmp
	if test -z "${tmp}" || test "${tmp}" = "y"; then
		echo "* Search configuration file ..."

		tmp_config="${TMP_BASE_DIR}/__config.tmp.conf"
		tmp_script="${TMP_BASE_DIR}/script.sed"
		get_location_name ${reposdbname} ${PGHOST} ${PGPORT} ${PGUSER}

		if test -n "${LOCATION_NAME}"; then
			search_configuration_files
			for f in ${CONFIGFILE_LIST}; do
				tmp=`grep "\<Location[ ][ ]*${LOCATION_NAME}\>" ${f}`
				if test -z "${tmp}"; then
					continue
				else
					echo "* Please write \"TfPassPolicy on\" entry in Location directive file."
					$ECHO_N "* Press any key to edit \"${f}\"."$ECHO_C
					read tmp

					# insert "TfExtendUserStatus on" text in configuration file
					cat - > ${tmp_script} <<__LOCATION_REPLACE_SCRIPT_TEXT__
/^<Location[ ][ ]*\\${LOCATION_NAME}>/a\\
	##### Please edit the following script. #####\\
	TfPassPolicy on
__LOCATION_REPLACE_SCRIPT_TEXT__
					sed -f ${tmp_script} ${f} > ${tmp_config}
					mv ${tmp_config} ${f}
					vi ${f}

					rm -f ${tmp_script}
				fi
			done
			echo "Success. "
			echo "* Please restart TeamFile server."
		else
			echo "Success. "
			echo "* Please append \"TfPassPolicy on\" entry in Location directive and "
			echo "* restart TeamFile server."
		fi
	else
		echo "Success. "
		echo "* Please append \"TfPassPolicy on\" entry in Location directive and "
		echo "* restart TeamFile server."
	fi

	wait_enter
}

#--------------------------------------
# Enable Autodelete function
#--------------------------------------
enable_autodelete_function() {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	# show notice msg
	$ECHO_N "This operation UPDATE a location data. Are you quite sure ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	else
		echo "OK, continue."
	fi

	echo "* Search configuration files ..."
	search_configuration_files
	for cf in ${CONFIGFILE_LIST}; do
		grep '[ 	]*TfAutoDelete' ${cf} >/dev/null 2>&1
		RETVAL=$?
		if test -s ${cf} && test "${RETVAL}" = 1; then
			echo ${cf}
		elif test -s ${cf} && test "${RETVAL}" = 0; then
			sed -e 's/^[\t ][\t ]*//g' ${cf} | grep -i '^TfAutoDelete[ 	][ 	]*off' >/dev/null 2>&1
			RETVAL=$?
			if test "${RETVAL}" = 0; then
				echo ${cf}
			fi
		fi
	done

	echo ""
	$ECHO_N "* Please select location configuration file that you want to update : "$ECHO_C
	read f
	if test -z "${f}"; then
		echo "The path of configuration is EMPTY."
		wait_enter
		return 1
	elif test ! -f "${f}"; then
		echo "The \"${f}\" file did not exists."
		wait_enter
		return 1
	fi

	# parse location config
	parse_locationconf ${f}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to parse configuration file."
		wait_enter
		return 1
	fi

	if test -z "${ENV_LocationName}"; then
		echo "Failed to get location name. Please check configuration file."
		wait_enter
		return 1
	fi

	echo "----------------------------------------"
	echo "* Location          : ${ENV_LocationName}"
	echo "* Database Name     : ${ENV_TfDbDbname}"
	echo "* Database Host     : ${ENV_TfDbHostname}"
	echo "* Database Port     : ${ENV_TfDbHostport}"
	echo "* Database User     : ${ENV_TfDbUsername}"
	echo "* Database Password : ${ENV_TfDbPassword}"
	echo "----------------------------------------"
	if test -z "${ENV_TfDbDbname}"   || test -z "${ENV_TfDbHostname}" || \
	   test -z "${ENV_TfDbHostport}" || test -z "${ENV_TfDbUsername}" || \
	   test -z "${ENV_TfDbPassword}"; then
		echo "Some values were emtpy. Please check configuration file."
		wait_enter
		return 1
	fi
	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	# check valid repository database and sys-exec user
	echo ""
	echo "Checking for \"${ENV_TfDbDbname}\" repository database ..."

	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select rs_rs_id_c from dav_resource limit 1" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to find valid repository database."
		echo "Please check the name of repository database. (${ENV_TfDbDbname})"
		wait_enter
		return 1
	fi

	SYSEXEC_CNT=`${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select 'COUNT=' || count(*) from divy_usr where usr_usr_id_vc = '$TF_SYSEXEC_USER'" | grep '[ ][ ]*COUNT=' | sed -e 's/[ ][ ]*COUNT=//g'`
	if test `expr "${SYSEXEC_CNT}"` -gt 0; then
		echo "Already updated. (${ENV_LocationName})"
		wait_enter
		return 1
	fi
	echo "OK"

	# insert data
	echo "Inserting data. Please wait for a while ..."
	gmttime=`date -u '+%Y-%m-%dT%H:%M:%SZ'`

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	RES_URI="/${ENV_LocationName}/${TF_SYSEXEC_USER}"
	if test "${ENV_TfEncryptPassword}" = "on"; then
		USER_PW=`$TF_MD5 ${TF_SYSEXEC_USERPW}`
	else
		USER_PW="${TF_SYSEXEC_USERPW}"
	fi

	EXTRA_SQL=""
	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "\d divy_passpolicystatus" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		EXTRA_SQL="INSERT INTO divy_passpolicystatus(ps_policy_id_i, ps_usr_usr_id_vc, ps_send_expiredmail_bi, ps_last_change_bi, ps_firstlogin_bi, ps_special_start_bi) VALUES (1, '${TF_SYSEXEC_USER}', 0, extract(epoch from timestamp '${gmttime}'), extract(epoch from timestamp '${gmttime}'), 0);"
	fi

	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} <<_INSERT_SYSEXEC_USER_

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		INSERT INTO dav_resource
		(rs_rs_id_c, rs_uri_txt, rs_dispname_vc, 
		 rs_create_bi, rs_get_cont_lang_vc, rs_get_cont_len_bi, rs_get_cont_type_vc,
		 rs_get_etag_txt, rs_get_lastmodified_bi, rs_resourcetype_i,
		 rs_depth_i, rs_isversioned_i, rs_checkin_i, rs_checkout_i, rs_physical_path_txt,
		 rs_creator_usr_id_vc, rs_lastmodifier_usr_id_vc)
		VALUES
		(lpad(nextval('res_seq')::text,12,'0'), '${RES_URI}', '${TF_SYSEXEC_USER}', extract(epoch from timestamp '${gmttime}'), NULL,
		0, 'httpd/unix-directory', NULL, extract(epoch from timestamp '${gmttime}'), 1, 2, 0, -1, -1, NULL,
		'root','root');

		INSERT INTO divy_usr
		(usr_usr_id_vc, usr_passwd_vc, usr_fullname_vc, 
		 usr_mailaddr_vc, usr_admin_mod_i, 
		 usr_rs_id_c, 
		 usr_usr_seq_i, usr_last_access_bi, usr_last_accesscl_vc, usr_comment_vc,
		 usr_expiration_bi,usr_extended_status_c,
		 usr_regist_c, usr_update_c)
		VALUES('${TF_SYSEXEC_USER}','${USER_PW}','${TF_SYSEXEC_USER}',NULL, 0, 
		(SELECT rs_rs_id_c FROM dav_resource WHERE rs_uri_txt = '${RES_URI}'),
		 nextval('usr_seq'), extract(epoch from timestamp '${gmttime}'), NULL, NULL,
		 0, 'a--w--s---**********************',
		'${gmttime}', '${gmttime}');

		INSERT INTO divy_usrdiskquota
		(usqt_usr_id_vc, usqt_used_st_bi,usqt_max_st_bi,usqt_used_res_bi,usqt_max_res_bi)
		VALUES
		('${TF_SYSEXEC_USER}', 0, 1, 0, 1);

		INSERT INTO dav_resource 
		(rs_rs_id_c, rs_uri_txt, rs_dispname_vc, 
		 rs_create_bi, rs_get_cont_lang_vc, rs_get_cont_len_bi, rs_get_cont_type_vc,
		 rs_get_etag_txt, rs_get_lastmodified_bi, rs_resourcetype_i,
		 rs_depth_i, rs_isversioned_i, rs_checkin_i, rs_checkout_i, rs_physical_path_txt,
		 rs_creator_usr_id_vc, rs_lastmodifier_usr_id_vc)
		VALUES
		(lpad(nextval('res_seq')::text,12,'0'), '${RES_URI}/Trash_Folder', 'Trash_Folder', extract(epoch from timestamp '${gmttime}'), NULL,
		0, 'httpd/trash-directory', NULL, extract(epoch from timestamp '${gmttime}'), 1, 3, 0, -1, -1, NULL,
		'root','root');

		${EXTRA_SQL}

		COMMIT;

_INSERT_SYSEXEC_USER_
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to insert data into \"divy_user\" table. (ret =${RETVAL})"
		wait_enter
		return 1
	fi

	#-------------------------
	# Edit configuration file
	#-------------------------
	$ECHO_N "Do you want to edit configuration file ?(y/n) (default: y) : "$ECHO_C
	read ANS
	if test "${tmp}" != "n"; then
		tmp_config="${TMP_BASE_DIR}/__config.tmp.conf"
		tmp_script="${TMP_BASE_DIR}/script.sed"

		echo "* Please write \"TfAutoDelete on\" entry in Location directive file."
		$ECHO_N "* Press any key to edit \"${f}\". If this operation was failed, Please use \"/tmp/location.bak\" file."$ECHO_C
		read tmp

		cat - > ${tmp_script} <<__LOCATION_REPLACE_SCRIPT_TEXT__
/^<Location[ ][ ]*\\/${ENV_LocationName}>/a\\
	##### Please edit the following script. #####\\
	# Use Autodelete function\\
	TfAutoDelete on\\
	TfAutoDeleteAllowIP 127.0.0.1/32\\

/^<Location[ ][ ]*\/${ENV_LocationName}>/,/^<\/Location>/{
	s/\(^[\t ][\t ]*TfLDAPAllowUser[\t ].*\)/#\1 ${TF_SYSEXEC_USER}/g
}
__LOCATION_REPLACE_SCRIPT_TEXT__
		sed -f ${tmp_script} ${f} > ${tmp_config}
		RETVAL=$?
		if test "${RETVAL}" = "0"; then
			mv ${f} /tmp/location.bak
			mv ${tmp_config} ${f}
			vi ${f}

			rm -f ${tmp_script}
			echo "Success. "
			echo "* Please restart TeamFile server."
		else
			echo "* Failed to update Location directive."
			echo "* Please append \"TfAutoDelete on\" entry in Location directive and "
			echo "* restart TeamFile server."
		fi
	else
		echo "* Please append \"TfAutoDelete on\" entry in Location directive and "
		echo "* restart TeamFile server."
	fi

	wait_enter
}

#--------------------------------------
# Enable Group-leader function
#--------------------------------------
enable_groupleader_function() {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	# show notice msg
	$ECHO_N "This operation UPDATE a location data. Are you quite sure ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	else
		echo "OK, continue."
	fi

	echo "* Search configuration files ..."
	search_configuration_files
	for cf in ${CONFIGFILE_LIST}; do
		grep '[ 	]*TfGroupLeader' ${cf} >/dev/null 2>&1
		RETVAL=$?
		if test -s ${cf} && test "${RETVAL}" = 1; then
			echo ${cf}
		elif test -s ${cf} && test "${RETVAL}" = 0; then
			sed -e 's/^[\t ][\t ]*//g' ${cf} | grep -i '^TfGroupLeader[ 	][ 	]*off' >/dev/null 2>&1
			RETVAL=$?
			if test "${RETVAL}" = 0; then
				echo ${cf}
			fi
		fi
	done

	echo ""
	$ECHO_N "* Please select location configuration file that you want to update : "$ECHO_C
	read f
	if test -z "${f}"; then
		echo "The path of configuration is EMPTY."
		wait_enter
		return 1
	elif test ! -f "${f}"; then
		echo "The \"${f}\" file did not exists."
		wait_enter
		return 1
	fi

	# parse location config
	parse_locationconf ${f}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to parse configuration file."
		wait_enter
		return 1
	fi

	if test -z "${ENV_LocationName}"; then
		echo "Failed to get location name. Please check configuration file."
		wait_enter
		return 1
	fi

	echo "----------------------------------------"
	echo "* Location          : ${ENV_LocationName}"
	echo "* Database Name     : ${ENV_TfDbDbname}"
	echo "* Database Host     : ${ENV_TfDbHostname}"
	echo "* Database Port     : ${ENV_TfDbHostport}"
	echo "* Database User     : ${ENV_TfDbUsername}"
	echo "* Database Password : ${ENV_TfDbPassword}"
	echo "----------------------------------------"
	if test -z "${ENV_TfDbDbname}"   || test -z "${ENV_TfDbHostname}" || \
	   test -z "${ENV_TfDbHostport}" || test -z "${ENV_TfDbUsername}" || \
	   test -z "${ENV_TfDbPassword}"; then
		echo "Some values were emtpy. Please check configuration file."
		wait_enter
		return 1
	fi
	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	# check valid repository database
	echo ""
	echo "Checking for \"${ENV_TfDbDbname}\" repository database ..."

	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select rs_rs_id_c from dav_resource limit 1" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to find valid repository database."
		echo "Please check the name of repository database. (${ENV_TfDbDbname})"
		wait_enter
		return 1
	fi

	# checking for "usr_extended_status_c" column
	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select usr_extended_status_c from divy_usr where false;" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" != 0; then
		echo "Please execute \"Enable Extended User status Function\" before this migration. (${ENV_LocationName})"
		wait_enter
		return 1
	fi

	# checking for "usr_owner_usr_id_vc" column (already updated)
	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select usr_owner_usr_id_vc from divy_usr where false;" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" = 0; then
		echo "Already updated. (${ENV_LocationName})"
		wait_enter
		return 1
	fi

	# checking for "TfSyncGroupUri off"
	sed -e 's/^[\t ][\t ]*//g' ${f} | grep -i '^TfSyncGroupUri[ 	][ 	]*off' >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" = 0; then
		echo "Please execute \"Change TfSyncGroupUri value\" before this migration. (${ENV_LocationName})"
		wait_enter
		return 1
	fi

	MIGRATE_GRPCONSTRAINTS=1
	# checking for "grp_extended_status_c" column
	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select grp_extended_status_c from divy_grp where false;" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" = 0; then
		MIGRATE_GRPCONSTRAINTS=0
	fi
	echo "OK"

	# insert data
	echo "Change \"divy_grp\",\"divy_usr\" table and \"TfSyncGroupUri on\" directive. Please wait for a while ..."

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	if test "${MIGRATE_GRPCONSTRAINTS}" = 1; then
		${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} <<_UPDATE_DIVY_GRP_

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		ALTER TABLE divy_grp ADD COLUMN GRP_EXTENDED_STATUS_C char(32);

		ALTER TABLE divy_grp ADD COLUMN GRP_OWNER_USR_ID_VC varchar(60);

		ALTER TABLE divy_usr ADD COLUMN USR_OWNER_USR_ID_VC varchar(60);

		ALTER TABLE divy_usr ADD COLUMN USR_MAXCREATION_I integer;


		UPDATE divy_grp
		SET grp_extended_status_c = '---a****************************',
			grp_owner_usr_id_vc = NULL;

		UPDATE divy_usr
		SET usr_extended_status_c = substring(usr_extended_status_c, 1, 7) || '---**********************',
			usr_owner_usr_id_vc = NULL,
			usr_maxcreation_i = 0
		WHERE usr_extended_status_c IS NOT NULL;

		UPDATE divy_usr
		SET usr_extended_status_c = 'a--wvt----**********************'
		WHERE usr_extended_status_c IS NULL;

		UPDATE divy_sql
		SET sql_stmt_txt = 'SELECT gm.grpm_grp_id_c, grp.grp_name_vc  FROM divy_grpmem gm INNER JOIN divy_grp grp ON gm.grpm_grp_id_c = grp.grp_grp_id_c WHERE gm.grpm_usr_id_vc = \$\$Buserid AND (grp.grp_extended_status_c NOT LIKE \'___-%\' OR grp.grp_extended_status_c IS NULL)'
		WHERE sql_sub_name_vc = '\$\$SMgroupid';

		COMMIT;

		VACUUM FULL ANALYZE divy_usr;

		VACUUM FULL ANALYZE divy_grp;

_UPDATE_DIVY_GRP_
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to update \"divy_usr\" or \"divy_grp\" table. (ret =${RETVAL})"
			wait_enter
			return 1
		fi
	else

		${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} <<_UPDATE_DIVY_GRP_

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		ALTER TABLE divy_grp ADD COLUMN GRP_OWNER_USR_ID_VC varchar(60);

		ALTER TABLE divy_usr ADD COLUMN USR_OWNER_USR_ID_VC varchar(60);

		ALTER TABLE divy_usr ADD COLUMN USR_MAXCREATION_I integer;

		UPDATE divy_grp
		SET grp_extended_status_c = substring(grp_extended_status_c, 1, 3) || 'a****************************',
			grp_owner_usr_id_vc = NULL
		WHERE grp_extended_status_c IS NOT NULL;

		UPDATE divy_grp
		SET grp_extended_status_c = '---a****************************'
		WHERE grp_extended_status_c IS NULL;

		UPDATE divy_usr
		SET usr_extended_status_c = substring(usr_extended_status_c, 1, 8) || '--**********************',
			usr_owner_usr_id_vc = NULL,
			usr_maxcreation_i = 0
		WHERE usr_extended_status_c IS NOT NULL;

		UPDATE divy_usr
		SET usr_extended_status_c = 'a--wvt----**********************'
		WHERE usr_extended_status_c IS NULL;

		UPDATE divy_sql
		SET sql_stmt_txt = 'SELECT gm.grpm_grp_id_c, grp.grp_name_vc  FROM divy_grpmem gm INNER JOIN divy_grp grp ON gm.grpm_grp_id_c = grp.grp_grp_id_c WHERE gm.grpm_usr_id_vc = \$\$Buserid AND (grp.grp_extended_status_c NOT LIKE \'___-%\' OR grp.grp_extended_status_c IS NULL)'
		WHERE sql_sub_name_vc = '\$\$SMgroupid';

		COMMIT;

		VACUUM FULL ANALYZE divy_usr;

		VACUUM FULL ANALYZE divy_grp;

_UPDATE_DIVY_GRP_
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to update \"divy_usr\" or \"divy_grp\" table. (ret =${RETVAL})"
			wait_enter
			return 1
		fi
	fi
	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	#-------------------------
	# Edit configuration file
	#-------------------------
	$ECHO_N "Do you want to edit configuration file ?(y/n) (default: y) : "$ECHO_C
	read ANS
	if test "${tmp}" != "n"; then
		tmp_config="${TMP_BASE_DIR}/__config.tmp.conf"
		tmp_script="${TMP_BASE_DIR}/script.sed"

		echo "* Please write \"TfGroupLeader on\" and \"TfSyncGroupUri middle\" entry in Location directive file."
		$ECHO_N "* Press any key to edit \"${f}\". If this operation was failed, Please use \"/tmp/location.bak\" file."$ECHO_C
		read tmp

		cat - > ${tmp_script} <<__LOCATION_REPLACE_SCRIPT_TEXT__
/^<Location[ ][ ]*\\/${ENV_LocationName}>/a\\
	##### Please edit the following script. #####\\
	# Use Group-Leader function\\
	TfGroupLeader on\\
	TfSyncGroupUri middle\\

/^<Location[ ][ ]*\/${ENV_LocationName}>/,/^<\/Location>/{
	/[\t ][\t ]*# Use Group-Constraints function/d
	/[\t ][\t ]*TfGroupConstraints/d
	s/\(^[\t ][\t ]*TfSyncGroupUri[\t ]\)/#\1/g
}
__LOCATION_REPLACE_SCRIPT_TEXT__
		sed -f ${tmp_script} ${f} > ${tmp_config}
		RETVAL=$?
		if test "${RETVAL}" = "0"; then
			mv ${f} /tmp/location.bak
			mv ${tmp_config} ${f}
			vi ${f}

			rm -f ${tmp_script}
			echo "Success. "
			echo "* Please restart TeamFile server."
		else
			echo "* Failed to update Location directive."
			echo "* Please append \"TfGroupLeader on\" and \"TfSyncGroupUri middle\" entry in Location directive and "
			echo "* restart TeamFile server."
		fi
	else
		echo "* Please append \"TfGroupLeader on\" and \"TfSyncGroupUri middle\" entry in Location directive and "
		echo "* restart TeamFile server."
	fi

	wait_enter
}

#--------------------------------------
# Clear Group-leader state
#--------------------------------------
clear_groupleader_state() {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	# show notice msg
	$ECHO_N "This operation INITIALIZE a location data for groupleader. Are you quite sure ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	else
		echo "OK, continue."
	fi

	echo "* Search configuration files ..."
	search_configuration_files
	for cf in ${CONFIGFILE_LIST}; do
		sed -e 's/^[\t ][\t ]*//g' ${cf} | grep -i '^TfGroupLeader[ 	][ 	]*on' >/dev/null 2>&1
		RETVAL=$?
		if test -s ${cf} && test "${RETVAL}" = 0; then
			echo ${cf}
		fi
	done

	echo ""
	$ECHO_N "* Please select location configuration file that you want to initialize : "$ECHO_C
	read f
	if test -z "${f}"; then
		echo "The path of configuration is EMPTY."
		wait_enter
		return 1
	elif test ! -f "${f}"; then
		echo "The \"${f}\" file did not exists."
		wait_enter
		return 1
	fi

	# parse location config
	parse_locationconf ${f}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to parse configuration file."
		wait_enter
		return 1
	fi

	if test -z "${ENV_LocationName}"; then
		echo "Failed to get location name. Please check configuration file."
		wait_enter
		return 1
	fi

	echo "----------------------------------------"
	echo "* Location          : ${ENV_LocationName}"
	echo "* Database Name     : ${ENV_TfDbDbname}"
	echo "* Database Host     : ${ENV_TfDbHostname}"
	echo "* Database Port     : ${ENV_TfDbHostport}"
	echo "* Database User     : ${ENV_TfDbUsername}"
	echo "* Database Password : ${ENV_TfDbPassword}"
	echo "----------------------------------------"
	if test -z "${ENV_TfDbDbname}"   || test -z "${ENV_TfDbHostname}" || \
	   test -z "${ENV_TfDbHostport}" || test -z "${ENV_TfDbUsername}" || \
	   test -z "${ENV_TfDbPassword}"; then
		echo "Some values were emtpy. Please check configuration file."
		wait_enter
		return 1
	fi
	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	# check valid repository database
	echo ""
	echo "Checking for \"${ENV_TfDbDbname}\" repository database ..."

	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select rs_rs_id_c from dav_resource limit 1" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to find valid repository database."
		echo "Please check the name of repository database. (${ENV_TfDbDbname})"
		wait_enter
		return 1
	fi

	# checking for "usr_extended_status_c" column
	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select usr_extended_status_c from divy_usr where false;" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" != 0; then
		echo "Please execute \"Enable Extended User status Function\" before this migration. (${ENV_LocationName})"
		wait_enter
		return 1
	fi

	# checking for "usr_owner_usr_id_vc" column (already updated)
	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select usr_owner_usr_id_vc from divy_usr where false;" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" != 0; then
		echo "Please execute \"Enable Group-leader Function\" before this migration. (${ENV_LocationName})"
		wait_enter
		return 1
	fi

	# checking for "TfSyncGroupUri off"
	sed -e 's/^[\t ][\t ]*//g' ${f} | grep -i '^TfSyncGroupUri[ 	][ 	]*off' >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" = 0; then
		echo "Please execute \"Change TfSyncGroupUri value\" before this migration. (${ENV_LocationName})"
		wait_enter
		return 1
	fi
	echo "OK"

	# insert data
	echo "Change \"divy_grp\",\"divy_usr\" table. Please wait for a while ..."

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} <<_UPDATE_DIVY_GRP_

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		UPDATE divy_grp
		SET grp_owner_usr_id_vc = NULL;

		UPDATE divy_usr
		SET usr_owner_usr_id_vc = NULL;

		COMMIT;

_UPDATE_DIVY_GRP_
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to update \"divy_grp\" or \"divy_usr\" table. (ret =${RETVAL})"
		wait_enter
		return 1
	fi
	
	echo "Success. "
	wait_enter
}

#--------------------------------------
# Enable Confirm-Reading function
#--------------------------------------
enable_confirmreading_function() {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	# show notice msg
	$ECHO_N "This operation UPDATE a location data. Are you quite sure ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	else
		echo "OK, continue."
	fi

	echo "* Search configuration files ..."
	search_configuration_files
	for cf in ${CONFIGFILE_LIST}; do
		grep '[ 	]*TfConfirmReading' ${cf} >/dev/null 2>&1
		RETVAL=$?
		if test -s ${cf} && test "${RETVAL}" = 1; then
			echo ${cf}
		elif test -s ${cf} && test "${RETVAL}" = 0; then
			sed -e 's/^[\t ][\t ]*//g' ${cf} | grep -i '^TfConfirmReading[ 	][ 	]*off' >/dev/null 2>&1
			RETVAL=$?
			if test "${RETVAL}" = 0; then
				echo ${cf}
			fi
		fi
	done

	echo ""
	$ECHO_N "* Please select location configuration file that you want to update : "$ECHO_C
	read f
	if test -z "${f}"; then
		echo "The path of configuration is EMPTY."
		wait_enter
		return 1
	elif test ! -f "${f}"; then
		echo "The \"${f}\" file did not exists."
		wait_enter
		return 1
	fi

	# parse location config
	parse_locationconf ${f}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to parse configuration file."
		wait_enter
		return 1
	fi

	if test -z "${ENV_LocationName}"; then
		echo "Failed to get location name. Please check configuration file."
		wait_enter
		return 1
	fi

	echo "----------------------------------------"
	echo "* Location          : ${ENV_LocationName}"
	echo "* Database Name     : ${ENV_TfDbDbname}"
	echo "* Database Host     : ${ENV_TfDbHostname}"
	echo "* Database Port     : ${ENV_TfDbHostport}"
	echo "* Database User     : ${ENV_TfDbUsername}"
	echo "* Database Password : ${ENV_TfDbPassword}"
	echo "----------------------------------------"
	if test -z "${ENV_TfDbDbname}"   || test -z "${ENV_TfDbHostname}" || \
	   test -z "${ENV_TfDbHostport}" || test -z "${ENV_TfDbUsername}" || \
	   test -z "${ENV_TfDbPassword}"; then
		echo "Some values were emtpy. Please check configuration file."
		wait_enter
		return 1
	fi
	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	# check valid repository database
	echo ""
	echo "Checking for \"${ENV_TfDbDbname}\" repository database ..."

	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select rs_rs_id_c from dav_resource limit 1" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to find valid repository database."
		echo "Please check the name of repository database. (${ENV_TfDbDbname})"
		wait_enter
		return 1
	fi

	# checking for "usr_extended_status_c" column
	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select usr_extended_status_c from divy_usr where false;" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" != 0; then
		echo "Please execute \"Enable Extended User status Function\" before this migration. (${ENV_LocationName})"
		wait_enter
		return 1
	fi

	# checking for "divy_confirmreading" table (already updated)
	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "\d divy_confirmreading" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" = 0; then
		echo "Already updated. (${ENV_LocationName})"
		wait_enter
		return 1
	fi

	SYSEXEC_CNT=`${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select 'COUNT=' || count(*) from divy_usr where usr_usr_id_vc = '$TF_SYSEXEC_USER'" | grep '[ ][ ]*COUNT=' | sed -e 's/[ ][ ]*COUNT=//g'`
	echo "OK"

	# insert data
	echo "Create \"divy_confirmreading\" table. Please wait for a while ..."

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING
	gmttime=`date -u '+%Y-%m-%dT%H:%M:%SZ'`

	if test `expr "${SYSEXEC_CNT}"` -gt 0; then
		${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} <<_INSERT_DIVY_CONFIRMREADING_

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		CREATE TABLE divy_confirmreading (
			CR_URI_TXT                 varchar(1000),
			CR_USR_ID_VC               varchar(60),
			CR_CREATION_BI             bigint   not null,
			constraint PK_divy_confirmreading PRIMARY KEY(CR_URI_TXT,CR_USR_ID_VC)
		);

		INSERT INTO divy_sql
		(sql_id_c, sql_label_name_vc, sql_sub_name_vc, sql_type_i, sql_cachemode_i, sql_relative_uri_txt,
		sql_stmt_txt, sql_active_i, sql_ds_id_c,
		sql_comment_vc,
		sql_regist_c, sql_update_c)
		VALUES (
		lpad(nextval('sql_seq')::text,8,'0'), '自分の開封通知が付いたファイル一覧', NULL, 1, 0, '/自分の開封通知が付いたファイル一覧',
		'SELECT rs_uri_txt, rs_dispname_vc, rs_get_lastmodified_bi, rs_resourcetype_i, rs_get_cont_len_bi, rs_get_cont_type_vc, rs_create_bi, usr1.usr_fullname_vc as rs_creator_vc, usr2.usr_fullname_vc as rs_lastmodifier_vc FROM dav_resource rs LEFT JOIN divy_usr usr1 ON rs.rs_creator_usr_id_vc = usr1.usr_usr_id_vc LEFT JOIN divy_usr usr2 ON rs.rs_lastmodifier_usr_id_vc = usr2.usr_usr_id_vc INNER JOIN divy_confirmreading cr ON rs_uri_txt = cr.cr_uri_txt WHERE rs_resourcetype_i=0 AND cr.cr_usr_id_vc = \$\$Buserid', 1, (SELECT ds_ds_id_c FROM divy_dbms WHERE ds_id_name_vc='${ENV_TfDbDbname}'),
		'自分自身が開封通知を付けたファイル一覧を探す検索',
		'${gmttime}', '${gmttime}');

		INSERT INTO divy_sqlcontent
		(sqlc_id_c, sqlc_where_id_i, sqlc_where_contype_i,
		sqlc_where_name_vc, sqlc_where_colname_vc, sqlc_where_fmt_vc,
		sqlc_where_sql_position_i, sqlc_depsql_sub_name_vc, sqlc_depsql_mode_i)
		VALUES (
		(SELECT sql_id_c FROM divy_sql WHERE sql_relative_uri_txt='/自分の開封通知が付いたファイル一覧'), 1, 1,
		'ユーザID', 'cr.cr_usr_id_vc', '文字列',
		506, '\$\$Buserid', 1);

		INSERT INTO divy_sqldepend
		(sqld_top_sql_id_c,
		sqld_pt_subname_vc,
		sqld_cl_subname_vc)
		VALUES (
		(SELECT sql_id_c FROM divy_sql WHERE sql_relative_uri_txt='/自分の開封通知が付いたファイル一覧'),
		(SELECT sql_id_c FROM divy_sql WHERE sql_relative_uri_txt='/自分の開封通知が付いたファイル一覧'),
		'\$\$Buserid');

		COMMIT;

_INSERT_DIVY_CONFIRMREADING_
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to create \"divy_confirmreading\" table. (ret =${RETVAL})"
			wait_enter
			return 1
		fi
	else
		RES_URI="/${ENV_LocationName}/${TF_SYSEXEC_USER}"
		if test "${ENV_TfEncryptPassword}" = "on"; then
			USER_PW=`$TF_MD5 ${TF_SYSEXEC_USERPW}`
		else
			USER_PW="${TF_SYSEXEC_USERPW}"
		fi

		EXTRA_SQL=""
		${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "\d divy_passpolicystatus" >/dev/null 2>&1
		RETVAL=$?
		if test "${RETVAL}" = "0"; then
			EXTRA_SQL="INSERT INTO divy_passpolicystatus(ps_policy_id_i, ps_usr_usr_id_vc, ps_send_expiredmail_bi, ps_last_change_bi, ps_firstlogin_bi, ps_special_start_bi) VALUES (1, '${TF_SYSEXEC_USER}', 0, extract(epoch from timestamp '${gmttime}'), extract(epoch from timestamp '${gmttime}'), 0);"
		fi
		
		${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} <<_INSERT_DIVY_CONFIRMREADING2_

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		INSERT INTO dav_resource
		(rs_rs_id_c, rs_uri_txt, rs_dispname_vc, 
		 rs_create_bi, rs_get_cont_lang_vc, rs_get_cont_len_bi, rs_get_cont_type_vc,
		 rs_get_etag_txt, rs_get_lastmodified_bi, rs_resourcetype_i,
		 rs_depth_i, rs_isversioned_i, rs_checkin_i, rs_checkout_i, rs_physical_path_txt,
		 rs_creator_usr_id_vc, rs_lastmodifier_usr_id_vc)
		VALUES
		(lpad(nextval('res_seq')::text,12,'0'), '${RES_URI}', '${TF_SYSEXEC_USER}', extract(epoch from timestamp '${gmttime}'), NULL,
		0, 'httpd/unix-directory', NULL, extract(epoch from timestamp '${gmttime}'), 1, 2, 0, -1, -1, NULL,
		'root','root');

		INSERT INTO divy_usr
		(usr_usr_id_vc, usr_passwd_vc, usr_fullname_vc, 
		 usr_mailaddr_vc, usr_admin_mod_i, 
		 usr_rs_id_c, 
		 usr_usr_seq_i, usr_last_access_bi, usr_last_accesscl_vc, usr_comment_vc,
		 usr_expiration_bi,usr_extended_status_c,
		 usr_regist_c, usr_update_c)
		VALUES('${TF_SYSEXEC_USER}','${USER_PW}','${TF_SYSEXEC_USER}',NULL, 0, 
		(SELECT rs_rs_id_c FROM dav_resource WHERE rs_uri_txt = '${RES_URI}'),
		 nextval('usr_seq'), extract(epoch from timestamp '${gmttime}'), NULL, NULL,
		 0, 'a--w--s---**********************',
		'${gmttime}', '${gmttime}');

		INSERT INTO divy_usrdiskquota
		(usqt_usr_id_vc, usqt_used_st_bi,usqt_max_st_bi,usqt_used_res_bi,usqt_max_res_bi)
		VALUES
		('${TF_SYSEXEC_USER}', 0, 1, 0, 1);

		INSERT INTO dav_resource 
		(rs_rs_id_c, rs_uri_txt, rs_dispname_vc, 
		 rs_create_bi, rs_get_cont_lang_vc, rs_get_cont_len_bi, rs_get_cont_type_vc,
		 rs_get_etag_txt, rs_get_lastmodified_bi, rs_resourcetype_i,
		 rs_depth_i, rs_isversioned_i, rs_checkin_i, rs_checkout_i, rs_physical_path_txt,
		 rs_creator_usr_id_vc, rs_lastmodifier_usr_id_vc)
		VALUES
		(lpad(nextval('res_seq')::text,12,'0'), '${RES_URI}/Trash_Folder', 'Trash_Folder', extract(epoch from timestamp '${gmttime}'), NULL,
		0, 'httpd/trash-directory', NULL, extract(epoch from timestamp '${gmttime}'), 1, 3, 0, -1, -1, NULL,
		'root','root');

		${EXTRA_SQL}

		CREATE TABLE divy_confirmreading (
			CR_URI_TXT                 varchar(1000),
			CR_USR_ID_VC               varchar(60),
			CR_CREATION_BI             bigint   not null,
			constraint PK_divy_confirmreading PRIMARY KEY(CR_URI_TXT,CR_USR_ID_VC)
		);

		INSERT INTO divy_sql
		(sql_id_c, sql_label_name_vc, sql_sub_name_vc, sql_type_i, sql_cachemode_i, sql_relative_uri_txt,
		sql_stmt_txt, sql_active_i, sql_ds_id_c,
		sql_comment_vc,
		sql_regist_c, sql_update_c)
		VALUES (
		lpad(nextval('sql_seq')::text,8,'0'), '自分の開封通知が付いたファイル一覧', NULL, 1, 0, '/自分の開封通知が付いたファイル一覧',
		'SELECT rs_uri_txt, rs_dispname_vc, rs_get_lastmodified_bi, rs_resourcetype_i, rs_get_cont_len_bi, rs_get_cont_type_vc, rs_create_bi, usr1.usr_fullname_vc as rs_creator_vc, usr2.usr_fullname_vc as rs_lastmodifier_vc FROM dav_resource rs LEFT JOIN divy_usr usr1 ON rs.rs_creator_usr_id_vc = usr1.usr_usr_id_vc LEFT JOIN divy_usr usr2 ON rs.rs_lastmodifier_usr_id_vc = usr2.usr_usr_id_vc INNER JOIN divy_confirmreading cr ON rs_uri_txt = cr.cr_uri_txt WHERE rs_resourcetype_i=0 AND cr.cr_usr_id_vc = \$\$Buserid', 1, (SELECT ds_ds_id_c FROM divy_dbms WHERE ds_id_name_vc='${ENV_TfDbDbname}'),
		'自分自身が開封通知を付けたファイル一覧を探す検索',
		'${gmttime}', '${gmttime}');

		INSERT INTO divy_sqlcontent
		(sqlc_id_c, sqlc_where_id_i, sqlc_where_contype_i,
		sqlc_where_name_vc, sqlc_where_colname_vc, sqlc_where_fmt_vc,
		sqlc_where_sql_position_i, sqlc_depsql_sub_name_vc, sqlc_depsql_mode_i)
		VALUES (
		(SELECT sql_id_c FROM divy_sql WHERE sql_relative_uri_txt='/自分の開封通知が付いたファイル一覧'), 1, 1,
		'ユーザID', 'cr.cr_usr_id_vc', '文字列',
		506, '\$\$Buserid', 1);

		INSERT INTO divy_sqldepend
		(sqld_top_sql_id_c,
		sqld_pt_subname_vc,
		sqld_cl_subname_vc)
		VALUES (
		(SELECT sql_id_c FROM divy_sql WHERE sql_relative_uri_txt='/自分の開封通知が付いたファイル一覧'),
		(SELECT sql_id_c FROM divy_sql WHERE sql_relative_uri_txt='/自分の開封通知が付いたファイル一覧'),
		'\$\$Buserid');

		COMMIT;

_INSERT_DIVY_CONFIRMREADING2_
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to create \"divy_confirmreading\" table. (ret =${RETVAL})"
			wait_enter
			return 1
		fi
	fi

	#-------------------------
	# Edit configuration file
	#-------------------------
	$ECHO_N "Do you want to edit configuration file ?(y/n) (default: y) : "$ECHO_C
	read ANS
	if test "${tmp}" != "n"; then
		tmp_config="${TMP_BASE_DIR}/__config.tmp.conf"
		tmp_script="${TMP_BASE_DIR}/script.sed"

		echo "* Please write \"TfConfirmReading on\" entry in Location directive file."
		$ECHO_N "* Press any key to edit \"${f}\". If this operation was failed, Please use \"/tmp/location.bak\" file."$ECHO_C
		read tmp

		cat - > ${tmp_script} <<__LOCATION_REPLACE_SCRIPT_TEXT__
/^<Location[ ][ ]*\/${ENV_LocationName}>/,/^<\/Location>/{
	/[\t ][\t ]*# Use Confirm-Reading function/d
	/[\t ][\t ]*TfConfirmReading/d
	/[\t ][\t ]*TfConfirmReadingReservedDay/d
}

/^<Location[ ][ ]*\\/${ENV_LocationName}>/a\\
	##### Please edit the following script. #####\\
	# Use Confirm-Reading function\\
	TfConfirmReading on\\
	TfConfirmReadingReservedDay 30\\

__LOCATION_REPLACE_SCRIPT_TEXT__
		sed -f ${tmp_script} ${f} > ${tmp_config}
		RETVAL=$?
		if test "${RETVAL}" = "0"; then
			mv ${f} /tmp/location.bak
			mv ${tmp_config} ${f}
			vi ${f}

			rm -f ${tmp_script}
			echo "Success. "
			echo "* Please restart TeamFile server."
		else
			echo "* Failed to update Location directive."
			echo "* Please append \"TfConfirmReading on\" entry in Location directive and "
			echo "* restart TeamFile server."
		fi
	else
		echo "* Please append \"TfConfirmReading on\" entry in Location directive and "
		echo "* restart TeamFile server."
	fi

	wait_enter
}
enable_extenedsysmsg_function(){
	echo ""


	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	# show notice msg
	$ECHO_N "This operation UPDATE a location data. Are you quite sure ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	else
		echo "OK, continue."
	fi

	echo "* Search configuration files ..."
	search_configuration_files
	for cf in ${CONFIGFILE_LIST}; do
		grep '[ 	]*TfExtendSysMsg' ${cf} >/dev/null 2>&1
		RETVAL=$?
		if test -s ${cf} && test "${RETVAL}" = 1; then
			echo ${cf}
		elif test -s ${cf} && test "${RETVAL}" = 0; then
			sed -e 's/^[\t ][\t ]*//g' ${cf} | grep -i '^TfExtendSysMsg[ 	][ 	]*off' >/dev/null 2>&1
			RETVAL=$?
			if test "${RETVAL}" = 0; then
				echo ${cf}
			fi
		fi
	done

	echo ""
	$ECHO_N "* Please select location configuration file that you want to update : "$ECHO_C
	read f
	if test -z "${f}"; then
		echo "The path of configuration is EMPTY."
		wait_enter
		return 1
	elif test ! -f "${f}"; then
		echo "The \"${f}\" file did not exists."
		wait_enter
		return 1
	fi

	# parse location config
	parse_locationconf ${f}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to parse configuration file."
		wait_enter
		return 1
	fi

	if test -z "${ENV_LocationName}"; then
		echo "Failed to get location name. Please check configuration file."
		wait_enter
		return 1
	fi

	echo "----------------------------------------"
	echo "* Location          : ${ENV_LocationName}"
	echo "* Database Name     : ${ENV_TfDbDbname}"
	echo "* Database Host     : ${ENV_TfDbHostname}"
	echo "* Database Port     : ${ENV_TfDbHostport}"
	echo "* Database User     : ${ENV_TfDbUsername}"
	echo "* Database Password : ${ENV_TfDbPassword}"
	echo "----------------------------------------"
	if test -z "${ENV_TfDbDbname}"   || test -z "${ENV_TfDbHostname}" || \
	   test -z "${ENV_TfDbHostport}" || test -z "${ENV_TfDbUsername}" || \
	   test -z "${ENV_TfDbPassword}"; then
		echo "Some values were emtpy. Please check configuration file."
		wait_enter
		return 1
	fi
	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	# check valid repository database
	echo ""
	echo "Checking for \"${ENV_TfDbDbname}\" repository database ..."

	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select rs_rs_id_c from dav_resource limit 1" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to find valid repository database."
		echo "Please check the name of repository database. (${ENV_TfDbDbname})"
		wait_enter
		return 1
	fi

	MIGRATE_EXTENDSYSMSG=1
	# checking for "grp_extended_status_c" column
	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select smsg_subject_vc from divy_sysmsg where false;" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" = 0; then
		MIGRATE_EXTENDSYSMSG=0
	fi
	echo "OK"

	# update data
	echo "Change \"divy_sysmsg\" table and \"TfExtendSysmsg on\" directive. Please wait for a while ..."

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	if test "${MIGRATE_EXTENDSYSMSG}" = 1; then
		${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} <<_UPDATE_DIVY_SYSMSG_

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		ALTER TABLE divy_sysmsg ADD COLUMN SMSG_LANG_C CHAR(2);
		
		ALTER TABLE divy_sysmsg ADD COLUMN SMSG_SCOPE_C CHAR(1);

		ALTER TABLE divy_sysmsg ADD COLUMN SMSG_OPEN_BI BIGINT;

		ALTER TABLE divy_sysmsg ADD COLUMN SMSG_CLOSE_BI BIGINT;

		ALTER TABLE divy_sysmsg ADD COLUMN SMSG_SUBJECT_VC VARCHAR(80);

		COMMIT;

		VACUUM FULL ANALYZE divy_sysmsg;

_UPDATE_DIVY_SYSMSG_
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to update \"divy_sysmsg\" table. (ret =${RETVAL})"
			wait_enter
			return 1
		fi
	fi
	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	#-------------------------
	# Edit configuration file
	#-------------------------
	$ECHO_N "Do you want to edit configuration file ?(y/n) (default: y) : "$ECHO_C
	read ANS
	if test "${tmp}" != "n"; then
		tmp_config="${TMP_BASE_DIR}/__config.tmp.conf"
		tmp_script="${TMP_BASE_DIR}/script.sed"

		echo "* Please write \"TfExtendSysMsg on\" entry in Location directive file."
		$ECHO_N "* Press any key to edit \"${f}\". If this operation was failed, Please use \"/tmp/location.bak\" file."$ECHO_C
		read tmp

		cat - > ${tmp_script} <<__LOCATION_REPLACE_SCRIPT_TEXT__
/^<Location[ ][ ]*\\/${ENV_LocationName}>/a\\
	##### Please edit the following script. #####\\
	# Use Extened SystemMessage function\\
	TfExtendSysMsg on\\

__LOCATION_REPLACE_SCRIPT_TEXT__
		sed -f ${tmp_script} ${f} > ${tmp_config}
		RETVAL=$?
		if test "${RETVAL}" = "0"; then
			mv ${f} /tmp/location.bak
			mv ${tmp_config} ${f}
			vi ${f}

			rm -f ${tmp_script}
			echo "Success. "
			echo "* Please restart TeamFile server."
		else
			echo "* Failed to update Location directive."
			echo "* Please append \"TfExtendSysMsg on\" entry in Location directive and "
			echo "* restart TeamFile server."
		fi
	else
		echo "* Please append \"TfExtendSysMsg on\" entry in Location directive and "
		echo "* restart TeamFile server."
	fi

	wait_enter
}


enable_browser_session_function(){
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	# show notice msg
	$ECHO_N "This operation UPDATE a location data. Are you quite sure ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	else
		echo "OK, continue."
	fi

	echo "* Search configuration files ..."
	echo ""
	search_configuration_files
	for cf in ${CONFIGFILE_LIST}; do
		RETVAL=$?
		if test -s ${cf} ; then
			echo ${cf}
		fi
	done

	echo ""
	$ECHO_N "* Please select location configuration file that you want to update : "$ECHO_C
	read f
	if test -z "${f}"; then
		echo "The path of configuration is EMPTY."
		wait_enter
		return 1
	elif test ! -f "${f}"; then
		echo "The \"${f}\" file did not exists."
		wait_enter
		return 1
	fi

	# parse location config
	parse_locationconf ${f}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to parse configuration file."
		wait_enter
		return 1
	fi

	if test -z "${ENV_LocationName}"; then
		echo "Failed to get location name. Please check configuration file."
		wait_enter
		return 1
	fi

	echo "----------------------------------------"
	echo "* Location          : ${ENV_LocationName}"
	echo "* Database Name     : ${ENV_TfDbDbname}"
	echo "* Database Host     : ${ENV_TfDbHostname}"
	echo "* Database Port     : ${ENV_TfDbHostport}"
	echo "* Database User     : ${ENV_TfDbUsername}"
	echo "* Database Password : ${ENV_TfDbPassword}"
	echo "----------------------------------------"
	if test -z "${ENV_TfDbDbname}"   || test -z "${ENV_TfDbHostname}" || \
	   test -z "${ENV_TfDbHostport}" || test -z "${ENV_TfDbUsername}" || \
	   test -z "${ENV_TfDbPassword}"; then
		echo "Some values were emtpy. Please check configuration file."
		wait_enter
		return 1
	fi
	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	# check valid repository database
	echo ""
	echo "Checking for \"${ENV_TfDbDbname}\" repository database ..."

	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select rs_rs_id_c from dav_resource limit 1" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to find valid repository database."
		echo "Please check the name of repository database. (${ENV_TfDbDbname})"
		wait_enter
		return 1
	fi

	MIGRATE_SESSION=1
	# checking for "ses_sid_c" column
	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select ses_sid_c from divy_session where false;" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" = 0; then
		MIGRATE_SESSION=0
	fi

	if test "${MIGRATE_SESSION}" = 0; then
		echo "The table \"divy_session\" already exist."
		wait_enter
		return 1
	fi

	echo "OK"

	# create table data
	echo "create \"divy_session\" table. Please wait for a while ..."

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	if test "${MIGRATE_SESSION}" = 1; then
		${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} <<_INSERT_DIVY_SESSION_

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		CREATE TABLE divy_session (
			SES_SID_C                  char(32) not null,
			SES_USR_USR_ID_VC          varchar(60),
			SES_LOGIN_BI               bigint,
			SES_USR_PASSWORD_VC        varchar(64),
			constraint PK_divy_session PRIMARY KEY(SES_SID_C,SES_USR_USR_ID_VC)
		);
	    
		COMMIT;

_INSERT_DIVY_SESSION_
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to create \"divy_session\" table. (ret =${RETVAL})"
			wait_enter
			return 1
		fi
	fi
	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	echo "OK"

	#-------------------------
	# Edit configuration file
	#-------------------------
	$ECHO_N "Do you want to edit configuration file ?(y/n) (default: y) : "$ECHO_C
	read ANS
	if test "${ANS}" != "n"; then
		tmp_config="${TMP_BASE_DIR}/__config.tmp.conf"
		tmp_script="${TMP_BASE_DIR}/script.sed"

		echo "* Please write \"TfUseSettion on\" entry in Location directive file."
		$ECHO_N "* Press any key to edit \"${f}\". If this operation was failed, Please use \"/tmp/location.bak\" file."$ECHO_C
		read tmp

		cat - > ${tmp_script} <<__LOCATION_REPLACE_SCRIPT_TEXT__
/^<Location[ ][ ]*\\/${ENV_LocationName}>/a\\
	##### Please edit the following script. #####\\
	# Use browser session function\\
	TfUseSession on\\
\\
	# Session time out (default 0 = INFINITY)\\
	#TfSessionTimeOut 0\\

__LOCATION_REPLACE_SCRIPT_TEXT__
		sed -f ${tmp_script} ${f} > ${tmp_config}
		RETVAL=$?
		if test "${RETVAL}" = "0"; then
			mv ${f} /tmp/location.bak
			mv ${tmp_config} ${f}
			vi ${f}

			rm -f ${tmp_script}
			echo "Success. "
			echo "* Please restart TeamFile server."
		else
			echo "* Failed to update Location directive."
			echo "* Please append \"TfUseSession on\" entry in Location directive and "
			echo "* restart TeamFile server."
		fi
	else
		echo "* Please append \"TfUseSession on\" entry in Location directive and "
		echo "* restart TeamFile server."
	fi

	wait_enter
}

enable_access_control_function () {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	# show notice msg
	$ECHO_N "This operation UPDATE a location data. Are you quite sure ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	else
		echo "OK, continue."
	fi

	echo "* Search configuration files ..."
	echo ""
	search_configuration_files
	for cf in ${CONFIGFILE_LIST}; do
		RETVAL=$?
		if test -s ${cf} ; then
			echo ${cf}
		fi
	done

	echo ""
	$ECHO_N "* Please select location configuration file that you want to update : "$ECHO_C
	read f
	if test -z "${f}"; then
		echo "The path of configuration is EMPTY."
		wait_enter
		return 1
	elif test ! -f "${f}"; then
		echo "The \"${f}\" file did not exists."
		wait_enter
		return 1
	fi

	# parse location config
	parse_locationconf ${f}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to parse configuration file."
		wait_enter
		return 1
	fi

	if test -z "${ENV_LocationName}"; then
		echo "Failed to get location name. Please check configuration file."
		wait_enter
		return 1
	fi

	echo "----------------------------------------"
	echo "* Location          : ${ENV_LocationName}"
	echo "* Database Name     : ${ENV_TfDbDbname}"
	echo "* Database Host     : ${ENV_TfDbHostname}"
	echo "* Database Port     : ${ENV_TfDbHostport}"
	echo "* Database User     : ${ENV_TfDbUsername}"
	echo "* Database Password : ${ENV_TfDbPassword}"
	echo "----------------------------------------"
	if test -z "${ENV_TfDbDbname}"   || test -z "${ENV_TfDbHostname}" || \
	   test -z "${ENV_TfDbHostport}" || test -z "${ENV_TfDbUsername}" || \
	   test -z "${ENV_TfDbPassword}"; then
		echo "Some values were emtpy. Please check configuration file."
		wait_enter
		return 1
	fi
	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	# check valid repository database
	echo ""
	echo "Checking for \"${ENV_TfDbDbname}\" repository database ..."

	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select rs_rs_id_c from dav_resource limit 1" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to find valid repository database."
		echo "Please check the name of repository database. (${ENV_TfDbDbname})"
		wait_enter
		return 1
	fi

	MIGRATE_ACCESSCONTROL=1
	# checking for "usr_allowhosts_vc" column
	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select usr_allowhosts_vc from divy_usr where false;" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" = 0; then
		MIGRATE_ACCESSCONTROL=0
	fi

	# update data
	echo "Change \"divy_usr\" table and \"TfAccessControl on\" directive. Please wait for a while ..."

	echo "OK"

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	if test "${MIGRATE_ACCESSCONTROL}" = 1; then
		${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} <<_INSERT_DIVY_USR_

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		ALTER TABLE divy_usr ADD COLUMN USR_ALLOWHOSTS_VC VARCHAR(255);

		COMMIT;

		VACUUM FULL ANALYZE divy_usr;

_INSERT_DIVY_USR_
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to update \"divy_usr\" table. (ret =${RETVAL})"
			wait_enter
			return 1
		fi
	fi
	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	#-------------------------
	# Edit configuration file
	#-------------------------
	$ECHO_N "Do you want to edit configuration file ?(y/n) (default: y) : "$ECHO_C
	read ANS
	if test "${ANS}" != "n"; then
		tmp_config="${TMP_BASE_DIR}/__config.tmp.conf"
		tmp_script="${TMP_BASE_DIR}/script.sed"

		echo "* Please write \"TfAccessControl on\" entry in Location directive file."
		$ECHO_N "* Press any key to edit \"${f}\". If this operation was failed, Please use \"/tmp/location.bak\" file."$ECHO_C
		read tmp

		cat - > ${tmp_script} <<__LOCATION_REPLACE_SCRIPT_TEXT__
/^<Location[ ][ ]*\\/${ENV_LocationName}>/a\\
	##### Please edit the following script. #####\\
	# Use Access Control function\\
	TfAccessControl on\\
    # allow(default) or deny\\
	#TfDefaultAccessRule allow\\

__LOCATION_REPLACE_SCRIPT_TEXT__
		sed -f ${tmp_script} ${f} > ${tmp_config}
		RETVAL=$?
		if test "${RETVAL}" = "0"; then
			mv ${f} /tmp/location.bak
			mv ${tmp_config} ${f}
			vi ${f}

			rm -f ${tmp_script}
			echo "Success. "
			echo "* Please restart TeamFile server."
		else
			echo "* Failed to update Location directive."
			echo "* Please append \"TfAccessControl on\" entry in Location directive and "
			echo "* restart TeamFile server."
		fi
	else
		echo "* Please append \"TfAccessControl\" entry in Location directive and "
		echo "* restart TeamFile server."
	fi

	wait_enter
}

enable_failed_login_control_function () {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	# show notice msg
	$ECHO_N "This operation UPDATE a location data. Are you quite sure ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	else
		echo "OK, continue."
	fi

	echo "* Search configuration files ..."
	echo ""
	search_configuration_files
	for cf in ${CONFIGFILE_LIST}; do
		RETVAL=$?
		if test -s ${cf} ; then
			echo ${cf}
		fi
	done

	echo ""
	$ECHO_N "* Please select location configuration file that you want to update : "$ECHO_C
	read f
	if test -z "${f}"; then
		echo "The path of configuration is EMPTY."
		wait_enter
		return 1
	elif test ! -f "${f}"; then
		echo "The \"${f}\" file did not exists."
		wait_enter
		return 1
	fi

	# parse location config
	parse_locationconf ${f}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to parse configuration file."
		wait_enter
		return 1
	fi

	if test -z "${ENV_LocationName}"; then
		echo "Failed to get location name. Please check configuration file."
		wait_enter
		return 1
	fi

	echo "----------------------------------------"
	echo "* Location          : ${ENV_LocationName}"
	echo "* Database Name     : ${ENV_TfDbDbname}"
	echo "* Database Host     : ${ENV_TfDbHostname}"
	echo "* Database Port     : ${ENV_TfDbHostport}"
	echo "* Database User     : ${ENV_TfDbUsername}"
	echo "* Database Password : ${ENV_TfDbPassword}"
	echo "----------------------------------------"
	if test -z "${ENV_TfDbDbname}"   || test -z "${ENV_TfDbHostname}" || \
	   test -z "${ENV_TfDbHostport}" || test -z "${ENV_TfDbUsername}" || \
	   test -z "${ENV_TfDbPassword}"; then
		echo "Some values were emtpy. Please check configuration file."
		wait_enter
		return 1
	fi
	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	# check valid repository database
	echo ""
	echo "Checking for \"${ENV_TfDbDbname}\" repository database ..."

	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select rs_rs_id_c from dav_resource limit 1" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to find valid repository database."
		echo "Please check the name of repository database. (${ENV_TfDbDbname})"
		wait_enter
		return 1
	fi

	MIGRATE_FAILDLOGINCONTROL=1
	# checking for "usr_allowhosts_vc" column
	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select usr_failed_access_count_i from divy_usr where false;" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" = 0; then
		MIGRATE_FAILDLOGINCONTROL=0
	fi

	# update data
	echo "Change \"divy_usr\" table and \"TfFailedLoginControl\" directive. Please wait for a while ..."

	echo "OK"

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	if test "${MIGRATE_FAILDLOGINCONTROL}" = 1; then
		${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} <<_INSERT_DIVY_USR_

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		ALTER TABLE divy_usr ADD COLUMN USR_FAILED_ACCESS_COUNT_I INTEGER;

		COMMIT;

		VACUUM FULL ANALYZE divy_usr;

_INSERT_DIVY_USR_
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to update \"divy_usr\" table. (ret =${RETVAL})"
			wait_enter
			return 1
		fi
	fi
	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	#-------------------------
	# Edit configuration file
	#-------------------------
	$ECHO_N "Do you want to edit configuration file ?(y/n) (default: y) : "$ECHO_C
	read ANS
	if test "${ANS}" != "n"; then
		tmp_config="${TMP_BASE_DIR}/__config.tmp.conf"
		tmp_script="${TMP_BASE_DIR}/script.sed"

		echo "* Please write \"TfFailedLoginControl 10 60 3\" entry in Location directive file."
		$ECHO_N "* Press any key to edit \"${f}\". If this operation was failed, Please use \"/tmp/location.bak\" file."$ECHO_C
		read tmp

		cat - > ${tmp_script} <<__LOCATION_REPLACE_SCRIPT_TEXT__
/^<Location[ ][ ]*\\/${ENV_LocationName}>/a\\
	##### Please edit the following script. #####\\
	# Use Failed login Control function\\
	TfFailedLoginControl 10 60 3\\

__LOCATION_REPLACE_SCRIPT_TEXT__
		sed -f ${tmp_script} ${f} > ${tmp_config}
		RETVAL=$?
		if test "${RETVAL}" = "0"; then
			mv ${f} /tmp/location.bak
			mv ${tmp_config} ${f}
			vi ${f}

			rm -f ${tmp_script}
			echo "Success. "
			echo "* Please restart TeamFile server."
		else
			echo "* Failed to update Location directive."
			echo "* Please append \"TfFailedLoginControl\" entry in Location directive and "
			echo "* restart TeamFile server."
		fi
	else
		echo "* Please append \"TfFailedLoginControl\" entry in Location directive and "
		echo "* restart TeamFile server."
	fi

	wait_enter
}

enable_box_function_and_create_guest_user() {
	echo ""

	# check type of repository
	if test "${REPOS_DBTYPE}" = "ora"; then
		echo "This function not supported under Oracle database"
		wait_enter
		return 1
	fi

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	# show notice msg
	$ECHO_N "This operation UPDATE a location data. Are you quite sure ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	else
		echo "OK, continue."
	fi

	echo "* Search configuration files ..."
	echo ""
	search_configuration_files
	for cf in ${CONFIGFILE_LIST}; do
		RETVAL=$?
		if test -s ${cf} ; then
			echo ${cf}
		fi
	done

	echo ""
	$ECHO_N "* Please select location configuration file that you want to update : "$ECHO_C
	read f
	if test -z "${f}"; then
		echo "The path of configuration is EMPTY."
		wait_enter
		return 1
	elif test ! -f "${f}"; then
		echo "The \"${f}\" file did not exists."
		wait_enter
		return 1
	fi

	# parse location config
	parse_locationconf ${f}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to parse configuration file."
		wait_enter
		return 1
	fi

	if test -z "${ENV_LocationName}"; then
		echo "Failed to get location name. Please check configuration file."
		wait_enter
		return 1
	fi

	echo "----------------------------------------"
	echo "* Location          : ${ENV_LocationName}"
	echo "* Database Name     : ${ENV_TfDbDbname}"
	echo "* Database Host     : ${ENV_TfDbHostname}"
	echo "* Database Port     : ${ENV_TfDbHostport}"
	echo "* Database User     : ${ENV_TfDbUsername}"
	echo "* Database Password : ${ENV_TfDbPassword}"
	echo "----------------------------------------"
	if test -z "${ENV_TfDbDbname}"   || test -z "${ENV_TfDbHostname}" || \
	   test -z "${ENV_TfDbHostport}" || test -z "${ENV_TfDbUsername}" || \
	   test -z "${ENV_TfDbPassword}"; then
		echo "Some values were emtpy. Please check configuration file."
		wait_enter
		return 1
	fi
	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	# check tfenvvar parameter TF_GUEST_USER ...
	# build target filename
	TFENVVARS="${TF_BINDIR}/tfenvvars"
	grep 'TF_GUEST_USER' "${TFENVVARS}">/dev/null 2>&1
	RETVAL=$?
	if test ${RETVAL} = "1";then 
		grep 'TF_GUEST_USER' "${TFENVVARS}".default>/dev/null 2>&1
		RETVAL=$?
	fi
	
	# check valid repository database
	echo ""
	echo "Checking for \"${ENV_TfDbDbname}\" repository database ..."

	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select rs_rs_id_c from dav_resource limit 1" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to find valid repository database."
		echo "Please check the name of repository database. (${ENV_TfDbDbname})"
		wait_enter
		return 1
	fi
	MIGRATE_ENABLEGUESTUSER=1
	haveguest=`${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select 'COUNT=' || count(*) from divy_usr where usr_usr_id_vc = '${TF_GUEST_USER}'" | grep '[ ][ ]*COUNT=' | sed -e 's/[ ][ ]*COUNT=//g'`

	RETVAL=$?
	if test "${RETVAL}" = 0; then
		MIGRATE_ENABLEGUESTUSER=0
	fi

	if test "${haveguest}" -gt 0; then
		echo "FOUND !! Guest user. It it net necessary to continue."
		wait_enter
		return 1;
	fi

	# insert data
	echo "Inserting data. Please wait for a while ..."
	gmttime=`date -u '+%Y-%m-%dT%H:%M:%SZ'`

	PGCLIENTENCODING="UTF-8"
	export PGCLIENTENCODING

	RES_URI="/${ENV_LocationName}/${TF_GUEST_USER}"
	if test "${ENV_TfEncryptPassword}" = "on"; then
		guest_pw=`$TF_MD5 ${TF_GUEST_USERPW}`
	else
		guest_pw="${TF_GUEST_USERPW}"
	fi

	EXTRA_SQL=""
	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "\d divy_passpolicystatus" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		EXTRA_SQL="INSERT INTO divy_passpolicystatus(ps_policy_id_i, ps_usr_usr_id_vc, ps_send_expiredmail_bi, ps_last_change_bi, ps_firstlogin_bi, ps_special_start_bi) VALUES (1, '${TF_GUEST_USER}', 0, extract(epoch from timestamp '${gmttime}'), extract(epoch from timestamp '${gmttime}'), 0);"
	fi

	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} <<_INSERT_GUEST_USER_

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;

		CREATE TABLE divy_box (
			BOX_URI_TXT               varchar(1000) not null,
			BOX_ALLOWED_ORIGIN_C      varchar(255),
			BOX_SHORTEN_C             char(8),
			BOX_FLAG_I                integer,
			BOX_PASSWD_VC             varchar(64),
			BOX_CREATE_BI             bigint default 0 not null,
			BOX_EXPIRATION_BI         bigint default 0 not null,
			BOX_CREATOR_USR_ID_VC     varchar(60) not null,
			BOX_GREETING_VC           varchar(64),
			BOX_MESSAGE_VC            varchar(1000),
			BOX_VIEWCOUNT_BI          bigint default 0 not null,
			constraint PK_divy_box PRIMARY KEY(box_uri_txt)
		);

		INSERT INTO dav_resource
		(rs_rs_id_c, rs_uri_txt, rs_dispname_vc, 
		 rs_create_bi, rs_get_cont_lang_vc, rs_get_cont_len_bi, rs_get_cont_type_vc,
		 rs_get_etag_txt, rs_get_lastmodified_bi, rs_resourcetype_i,
		 rs_depth_i, rs_isversioned_i, rs_checkin_i, rs_checkout_i, rs_physical_path_txt,
		 rs_creator_usr_id_vc, rs_lastmodifier_usr_id_vc)
		VALUES
		(lpad(nextval('res_seq')::text,12,'0'), '${RES_URI}', '${TF_GUEST_USER}', extract(epoch from timestamp '${gmttime}'), NULL,
		0, 'httpd/unix-directory', NULL, extract(epoch from timestamp '${gmttime}'), 1, 2, 0, -1, -1, NULL,
		'root','root');

		INSERT INTO divy_usr
		(usr_usr_id_vc, usr_passwd_vc, usr_fullname_vc, 
		 usr_mailaddr_vc, usr_admin_mod_i, 
		 usr_rs_id_c, 
		 usr_usr_seq_i, usr_last_access_bi, usr_last_accesscl_vc, usr_comment_vc,
		 usr_expiration_bi,usr_extended_status_c,
		 usr_regist_c, usr_update_c)
		VALUES('${TF_GUEST_USER}','${guest_pw}','${TF_GUEST_USER}',NULL, 0, 
		(SELECT rs_rs_id_c FROM dav_resource WHERE rs_uri_txt = '${RES_URI}'),
		 nextval('usr_seq'), extract(epoch from timestamp '${gmttime}'), NULL, NULL,
		 0, 'a--w--s---**********************',
		'${gmttime}', '${gmttime}');

		INSERT INTO divy_usrdiskquota
		(usqt_usr_id_vc, usqt_used_st_bi,usqt_max_st_bi,usqt_used_res_bi,usqt_max_res_bi)
		VALUES
		('${TF_GUEST_USER}', 0, 1, 0, 1);

		INSERT INTO dav_resource 
		(rs_rs_id_c, rs_uri_txt, rs_dispname_vc, 
		 rs_create_bi, rs_get_cont_lang_vc, rs_get_cont_len_bi, rs_get_cont_type_vc,
		 rs_get_etag_txt, rs_get_lastmodified_bi, rs_resourcetype_i,
		 rs_depth_i, rs_isversioned_i, rs_checkin_i, rs_checkout_i, rs_physical_path_txt,
		 rs_creator_usr_id_vc, rs_lastmodifier_usr_id_vc)
		VALUES
		(lpad(nextval('res_seq')::text,12,'0'), '${RES_URI}/Trash_Folder', 'Trash_Folder', extract(epoch from timestamp '${gmttime}'), NULL,
		0, 'httpd/trash-directory', NULL, extract(epoch from timestamp '${gmttime}'), 1, 3, 0, -1, -1, NULL,
		'root','root');

		${EXTRA_SQL}

		COMMIT;

_INSERT_GUEST_USER_

	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to insert data into \"divy_user\" table. (ret =${RETVAL})"
		wait_enter
		return 1
	fi

	#-------------------------
	# Edit configuration file
	#-------------------------
	$ECHO_N "Do you want to edit configuration file ?(y/n) (default: y) : "$ECHO_C
	read ANS
	if test "${ANS}" != "n"; then
		tmp_config="${TMP_BASE_DIR}/__config.tmp.conf"
		tmp_script="${TMP_BASE_DIR}/script.sed"

		echo "* Please write \"TfBox\" entry in Location directive file."
		$ECHO_N "* Press any key to edit \"${f}\". If this operation was failed, Please use \"/tmp/location.bak\" file."$ECHO_C
		read tmp

		cat - > ${tmp_script} <<__LOCATION_REPLACE_SCRIPT_TEXT__
/^<Location[ ][ ]*\\/${ENV_LocationName}>/a\\
	##### Please edit the following script. #####\\
	# Use BOX function\\
	TfShortenUrl On\\
	TfBOX On

__LOCATION_REPLACE_SCRIPT_TEXT__
		sed -f ${tmp_script} ${f} > ${tmp_config}
		RETVAL=$?
		if test "${RETVAL}" = "0"; then
			mv ${f} /tmp/location.bak
			mv ${tmp_config} ${f}
			vi ${f}

			rm -f ${tmp_script}
			echo "Success. "
			echo "* Please restart TeamFile server."
		else
			echo "* Failed to update Location directive."
			echo "* Please append \"TfBOX\" entry in Location directive and "
			echo "* restart TeamFile server."
		fi
	else
		echo "* Please append \"TfBOX\" entry in Location directive and "
		echo "* restart TeamFile server."
	fi
	wait_enter

}

enable_saml_function() {
	echo ""

	# check type of repository
	if test "${REPOS_DBTYPE}" = "ora"; then
		echo "This function not supported under Oracle database"
		wait_enter
		return 1
	fi

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	else
		echo "OK, continue."
	fi

	echo "* Search configuration files ..."
	echo ""
	search_configuration_files
	for cf in ${CONFIGFILE_LIST}; do
		RETVAL=$?
		if test -s ${cf} ; then
			echo ${cf}
		fi
	done

	echo ""
	$ECHO_N "* Please select location configuration file that you want to update : "$ECHO_C
	read f
	if test -z "${f}"; then
		echo "The path of configuration is EMPTY."
		wait_enter
		return 1
	elif test ! -f "${f}"; then
		echo "The \"${f}\" file did not exists."
		wait_enter
		return 1
	fi

	# parse location config
	parse_locationconf ${f}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to parse configuration file."
		wait_enter
		return 1
	fi

	if test -z "${ENV_LocationName}"; then
		echo "Failed to get location name. Please check configuration file."
		wait_enter
		return 1
	fi

	echo "----------------------------------------"
	echo "* Location          : ${ENV_LocationName}"
	echo "* Database Name     : ${ENV_TfDbDbname}"
	echo "* Database Host     : ${ENV_TfDbHostname}"
	echo "* Database Port     : ${ENV_TfDbHostport}"
	echo "* Database User     : ${ENV_TfDbUsername}"
	echo "* Database Password : ${ENV_TfDbPassword}"
	echo "----------------------------------------"
	if test -z "${ENV_TfDbDbname}"   || test -z "${ENV_TfDbHostname}" || \
	   test -z "${ENV_TfDbHostport}" || test -z "${ENV_TfDbUsername}" || \
	   test -z "${ENV_TfDbPassword}"; then
		echo "Some values were emtpy. Please check configuration file."
		wait_enter
		return 1
	fi
	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	#-------------------------
	# Edit configuration file
	#-------------------------
	$ECHO_N "Do you want to edit configuration file ?(y/n) (default: y) : "$ECHO_C
	read ANS
	if test "${ANS}" != "n"; then
		tmp_config="${TMP_BASE_DIR}/__config.tmp.conf"
		tmp_script="${TMP_BASE_DIR}/script.sed"

		echo "* Please write \"TfUseSAML\" entry in Location directive file."
		$ECHO_N "* Press any key to edit \"${f}\". If this operation was failed, Please use \"/tmp/location.bak\" file."$ECHO_C
		read tmp

		cat - > ${tmp_script} <<__LOCATION_REPLACE_SCRIPT_TEXT__
/^<Location[ ][ ]*\\/${ENV_LocationName}>/a\\
	##### Please edit the following script. #####\\
	# Use SAML function\\
	TfUseSAML Off\\
\\
	#TfSAMLIdPMetaDataPath "/usr/local/teamfile/www/conf/conf.d/saml/meta.xml" \\
	#TfSAMLXMLPrivateKeyPath "/usr/local/teamfile/www/conf/conf.d/saml/priv.key" \\
	#TfSAMLXMLPublicCertificatePath "/usr/local/teamfile/www/conf/conf.d/saml/pub.crt" \\
\\
	# NameID the e-mail address \\
	#TfSAMLMatchedMailAddr Off \\

__LOCATION_REPLACE_SCRIPT_TEXT__
		sed -f ${tmp_script} ${f} > ${tmp_config}
		RETVAL=$?
		if test "${RETVAL}" = "0"; then
			mv ${f} /tmp/location.bak
			mv ${tmp_config} ${f}
			vi ${f}

			rm -f ${tmp_script}
			echo "Success. "
			echo "* Please restart TeamFile server."
		else
			echo "* Failed to update Location directive."
			echo "* Please append \"TfUseSAML\" entry in Location directive and "
			echo "* restart TeamFile server."
		fi
	else
		echo "* Please append \"TfUseSAML\" entry in Location directive and "
		echo "* restart TeamFile server."
	fi
	wait_enter
}

enable_upload_policy_function() {
	echo ""

	# check type of repository
	if test "${REPOS_DBTYPE}" = "ora"; then
		echo "This function not supported under Oracle database"
		wait_enter
		return 1
	fi

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	else
		echo "OK, continue."
	fi

	echo "* Search configuration files ..."
	echo ""
	search_configuration_files
	for cf in ${CONFIGFILE_LIST}; do
		RETVAL=$?
		if test -s ${cf} ; then
			echo ${cf}
		fi
	done

	echo ""
	$ECHO_N "* Please select location configuration file that you want to update : "$ECHO_C
	read f
	if test -z "${f}"; then
		echo "The path of configuration is EMPTY."
		wait_enter
		return 1
	elif test ! -f "${f}"; then
		echo "The \"${f}\" file did not exists."
		wait_enter
		return 1
	fi

	# parse location config
	parse_locationconf ${f}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to parse configuration file."
		wait_enter
		return 1
	fi

	if test -z "${ENV_LocationName}"; then
		echo "Failed to get location name. Please check configuration file."
		wait_enter
		return 1
	fi

	echo "----------------------------------------"
	echo "* Location          : ${ENV_LocationName}"
	echo "* Database Name     : ${ENV_TfDbDbname}"
	echo "* Database Host     : ${ENV_TfDbHostname}"
	echo "* Database Port     : ${ENV_TfDbHostport}"
	echo "* Database User     : ${ENV_TfDbUsername}"
	echo "* Database Password : ${ENV_TfDbPassword}"
	echo "----------------------------------------"
	if test -z "${ENV_TfDbDbname}"   || test -z "${ENV_TfDbHostname}" || \
	   test -z "${ENV_TfDbHostport}" || test -z "${ENV_TfDbUsername}" || \
	   test -z "${ENV_TfDbPassword}"; then
		echo "Some values were emtpy. Please check configuration file."
		wait_enter
		return 1
	fi
	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "\d divy_uploadpolicy" >/dev/null 2>&1
	RETVAL=$?

	# create table
	if test "${RETVAL}" = "0"; then
		echo "The table \"divy_uploadpolicy\" already exitst."
	else

		${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} <<_CREATE_UPLOADPOLICY_

		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;
		CREATE TABLE divy_uploadpolicy (
			UPLOAD_GRP_ID_C           char(8) not null,
			UPLOAD_FLAG_I             integer default 1 not null,
			UPLOAD_RULES_FILENAME_VC  varchar(3000) not null,
			UPLOAD_RULES_SUFFIX_VC    varchar(3000) not null,
			UPLOAD_RULES_CHARTYPE_I   integer default 0 not null,
			UPLOAD_RULES_LENGTH_VC    varchar(512) not null,
			UPLOAD_RULES_MATCHTYPE_I  integer default 0 not null,
			UPLOAD_RULES_HIDDEN_I     integer default 0 not null,
			UPLOAD_UPDATE_BI          bigint default 0 not null,
			constraint PK_divy_uploadpolicy PRIMARY KEY(UPLOAD_GRP_ID_C)
		);

		COMMIT;

_CREATE_UPLOADPOLICY_

		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to create table table. (ret =${RETVAL})"
			wait_enter
			return 1
		fi
	fi 

	#-------------------------
	# Edit configuration file
	#-------------------------
	$ECHO_N "Do you want to edit configuration file ?(y/n) (default: y) : "$ECHO_C
	read ANS
	if test "${ANS}" != "n"; then
		tmp_config="${TMP_BASE_DIR}/__config.tmp.conf"
		tmp_script="${TMP_BASE_DIR}/script.sed"

		echo "* Please write \"TfUploadPolicy\" entry in Location directive file."
		$ECHO_N "* Press any key to edit \"${f}\". If this operation was failed, Please use \"/tmp/location.bak\" file."$ECHO_C
		read tmp
		cat - > ${tmp_script} <<__LOCATION_REPLACE_SCRIPT_TEXT__
/^<Location[ ][ ]*\\/${ENV_LocationName}>/a\\
	##### Please edit the following script. #####\\
	# Use Upload Policy function\\
	TfUseUploadPolicy On\\
__LOCATION_REPLACE_SCRIPT_TEXT__
		sed -f ${tmp_script} ${f} > ${tmp_config}
		RETVAL=$?
		if test "${RETVAL}" = "0"; then
			mv ${f} /tmp/location.bak
			mv ${tmp_config} ${f}
			vi ${f}

			rm -f ${tmp_script}
			echo "Success. "
			echo "* Please restart TeamFile server."
		else
			echo "* Failed to update Location directive."
			echo "* Please append \"TfUseUploadPolicy\" entry in Location directive and "
			echo "* restart TeamFile server."
		fi
	else
		echo "* Please append \"TfUseUploadPolicy\" entry in Location directive and "
		echo "* restart TeamFile server."
	fi
	wait_enter
}

enable_two_factor_authentication_function() {
	echo ""

	# check type of repository
	if test "${REPOS_DBTYPE}" = "ora"; then
		echo "This function not supported under Oracle database"
		wait_enter
		return 1
	fi

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	else
		echo "OK, continue."
	fi

	echo "* Search configuration files ..."
	echo ""
	search_configuration_files
	for cf in ${CONFIGFILE_LIST}; do
		RETVAL=$?
		if test -s ${cf} ; then
			echo ${cf}
		fi
	done

	echo ""
	$ECHO_N "* Please select location configuration file that you want to update : "$ECHO_C
	read f
	if test -z "${f}"; then
		echo "The path of configuration is EMPTY."
		wait_enter
		return 1
	elif test ! -f "${f}"; then
		echo "The \"${f}\" file did not exists."
		wait_enter
		return 1
	fi

	# parse location config
	parse_locationconf ${f}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to parse configuration file."
		wait_enter
		return 1
	fi

	if test -z "${ENV_LocationName}"; then
		echo "Failed to get location name. Please check configuration file."
		wait_enter
		return 1
	fi

	echo "----------------------------------------"
	echo "* Location          : ${ENV_LocationName}"
	echo "* Database Name     : ${ENV_TfDbDbname}"
	echo "* Database Host     : ${ENV_TfDbHostname}"
	echo "* Database Port     : ${ENV_TfDbHostport}"
	echo "* Database User     : ${ENV_TfDbUsername}"
	echo "* Database Password : ${ENV_TfDbPassword}"
	echo "----------------------------------------"
	if test -z "${ENV_TfDbDbname}"   || test -z "${ENV_TfDbHostname}" || \
	   test -z "${ENV_TfDbHostport}" || test -z "${ENV_TfDbUsername}" || \
	   test -z "${ENV_TfDbPassword}"; then
		echo "Some values were emtpy. Please check configuration file."
		wait_enter
		return 1
	fi
	$ECHO_N "Are these values correct ?(y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} -c "select box_to_mailaddr_vc from divy_box limit 0" >/dev/null 2>&1
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		${PSQL} -d ${ENV_TfDbDbname} -h ${ENV_TfDbHostname} -p ${ENV_TfDbHostport} -U ${ENV_TfDbUsername} <<__TWE_FACTOR_AUTHENTICATION_SQL__
		\set ON_ERROR_STOP 0
		\set LO_TRANSACTION "rollback"

		BEGIN;
		ALTER TABLE divy_box ADD COLUMN box_to_mailaddr_vc VARCHAR(128);

		ALTER TABLE divy_box ALTER COLUMN box_message_vc TYPE VARCHAR(3000);

		REINDEX TABLE divy_box;

		COMMIT;

		VACUUM FULL ANALYZE divy_box;
__TWE_FACTOR_AUTHENTICATION_SQL__
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to update \"divy_box\" table. (ret =${RETVAL})"
			wait_enter
			return 1
		fi

		#-------------------------
		# Edit configuration file
		#-------------------------
		$ECHO_N "Do you want to edit configuration file ?(y/n) (default: y) : "$ECHO_C
		read tmp
		if test -z "${tmp}" || test "${tmp}" = "y"; then
			echo "* Search configuration file ..."
	
			tmp_config="${TMP_BASE_DIR}/__config.tmp.conf"
			tmp_script="${TMP_BASE_DIR}/script.sed"
			get_location_name ${ENV_TfDbDbname} ${ENV_TfDbHostname} ${ENV_TfDbHostport} ${ENV_TfDbUsername}

			if test -n "${LOCATION_NAME}"; then
				search_configuration_files
				for f in ${CONFIGFILE_LIST}; do
					tmp=`grep "\<Location[ ][ ]*${LOCATION_NAME}\>" ${f}`
					if test -z "${tmp}"; then
						continue
					else
						echo "* Please write \"TfTwoFactorAuthentication On\" entry in Location directive file."
						$ECHO_N "* Press any key to edit \"${f}\"."$ECHO_C
						read tmp

						# insert "TfExtendUserStatus on" text in configuration file
						cat - > ${tmp_script} <<__LOCATION_REPLACE_SCRIPT_TEXT__
/^<Location[ ][ ]*\\${LOCATION_NAME}>/a\\
\\
	##### Please edit the following script. #####\\
	# Two Factor Authentication function \\
	TfTwoFactorAuthentication On \\
	TfTwoFactorAuthenticationCycle 9 6m \\
	TfTwoFactorAuthenticationType default \\
	TfTwoFactorAuthenticationStage box \\
\\
__LOCATION_REPLACE_SCRIPT_TEXT__
						sed -f ${tmp_script} ${f} > ${tmp_config}
						RETVAL=$?
						if test "${RETVAL}" = "0"; then
							mv ${f} /tmp/location.bak
							mv ${tmp_config} ${f}
							vi ${f}

							rm -f ${tmp_script}
							echo "Success. "
							echo "* Please restart TeamFile server."
						else 
							echo "* Failed to update Location directive."
							echo "* Please append Two factor authentication directeve and"
							echo "* restart TeamFile server"
						fi
					fi
				done
				echo "Success. "
				echo "* Please restart TeamFile server."
			fi
		fi
	else
		echo "Found column \"box_to_mailaddr_vc\""
	fi
	wait_enter
}

#-------------------------------------------------------------------------------
# Show migration operation menu
#-------------------------------------------------------------------------------
display_migration_menu() {
	clear
	echo " +--------------${TITLE_LINE}---+"
	echo " | [ Migration operation menu ]                                       |"
	echo " |                                                                    |"
	echo " | please select this number. (Be careful)                            |"
	echo " |                                                                    |"
	echo " | 1  : Change Storage path                             [ root only ] |"
	echo " | 2  : Enable Trash-Folder Function                    [ root only ] |"
	echo " | 3  : Enable Extended User status Function            [ root only ] |"
	echo " | 4  : Change \"TfSyncGroupUri\" value                   [ root only ] |"
	echo " | 5  : Update PostgreSQL (7.4.6 -> 7.4.9)              [ root only ] |"
	echo " | 6  : Enable Password-Policy Function                 [ root only ] |"
	echo " | 7  : Enable Autodelete Function                      [ root only ] |"
	echo " | 8  : Enable Group-leader Function                    [ root only ] |"
	echo " | 9  : Clear  Group-leader state                       [ root only ] |"
	echo " |10  : Enable Confirm-Reading Function                 [ root only ] |"
	echo " |11  : Enable Extend System Message Function           [ root only ] |"
	echo " |12  : Enable Browser Session Function                 [ root only ] |"
	echo " |13  : Enable Access Control Function                  [ root only ] |"
	echo " |14  : Enable Failed login Control Function            [ root only ] |"
	echo " |15  : Enable BOX function and Create Guest User ID    [ root only ] |"
	echo " |16  : Enable SAML function                            [ root only ] |"
	echo " |17  : Enable Upload Policy function                   [ root only ] |"
	echo " |18  : Enable Two-Factor Authentication function       [ root only ] |"
	echo " |                                                                    |"
	echo " | r  : Return to main menu                                           |"
	echo " | q  : Quit                                                          |"
	echo " +------------------------------------------------------ Migration ---+"
}

show_migration_menu() {
	while [ 1 ];
	do
		display_migration_menu
		$ECHO_N "  Input number : "$ECHO_C
		read ANS
		case "$ANS" in
			1)
				change_storage_path
				;;
			2)
				enable_trashfolder_function
				;;
			3)
				enable_extendeduserstatus_function
				;;
			4)
				change_tfsyncgroupuri_value
				;;
			5)
				update_pg_746_to_749
				;;
			6)
				enable_passpolicy_function
				;;
			7)
				enable_autodelete_function
				;;
			8)
				enable_groupleader_function
				;;
			9)
				clear_groupleader_state
				;;
			10)
				enable_confirmreading_function
				;;
			11)
				enable_extenedsysmsg_function
				;;
			12)
				enable_browser_session_function
				;;
			13)
				enable_access_control_function
				;;
			14)
				enable_failed_login_control_function
				;;
			15)
				enable_box_function_and_create_guest_user
				;;
			16)
				enable_saml_function
				;;
			17)
				enable_upload_policy_function
				;;
			18)
				enable_two_factor_authentication_function
				;;
			r)
				return
				;;
			q)
				echo "bye"
				exitscript 0
				;;
		esac
	done
}

#--------------------------------------
# Show installed TeamFile modules
#--------------------------------------
show_installed_modules() {

	getOsType
	OSTYPE=$?
	# Solaris
	if test "${OSTYPE}" = "${OS_SOLARIS}"; then
		/usr/bin/pkginfo ${SPKG_INSTALLED_PKGNAME_LIST} 2>/dev/null
	# MacOSX
	elif test "${OSTYPE}" = "${OS_MACOSX102}" || test "${OSTYPE}" = "${OS_MACOSX103}"; then
		PACKAGE_BASE="/Library/Receipts"

		# readline
		plist="${PACKAGE_BASE}/readline.pkg/Contents/Info.plist"
		if test -f "${plist}"; then
			grep 'readline [0-9]*' ${plist} | sed -e 's/<string>//g' -e 's/<\/string>//g' | sort -u
		fi

		# libxslt
		plist="${PACKAGE_BASE}/libxslt.pkg/Contents/Info.plist"
		if test -f "${plist}"; then
			grep 'libxslt [0-9]*' ${plist} | sed -e 's/<string>//g' -e 's/<\/string>//g' | sort -u
		fi

		# libxml2
		plist="${PACKAGE_BASE}/libxml2.pkg/Contents/Info.plist"
		if test -f "${plist}"; then
			grep 'libxml2 [0-9]*' ${plist} | sed -e 's/<string>//g' -e 's/<\/string>//g' | sort -u
		fi

		# libiconv
		plist="${PACKAGE_BASE}/libiconv.pkg/Contents/Info.plist"
		if test -f "${plist}"; then
			grep 'libiconv [0-9]*' ${plist} | sed -e 's/<string>//g' -e 's/<\/string>//g' | sort -u
		fi

		# Apache2
		plist="${PACKAGE_BASE}/Apache2.pkg/Contents/Info.plist"
		if test -f "${plist}"; then
			grep 'Apache [0^9]*' ${plist} | sed -e 's/<string>//g' -e 's/<\/string>//g' | sort -u
		fi

		# PostgreSQL
		plist="${PACKAGE_BASE}/PostgreSQL.pkg/Contents/Info.plist"
		if test -f "${plist}"; then
			grep 'PostgreSQL [0-9]*' ${plist} | sed -e 's/<string>//g' -e 's/<\/string>//g' | sort -u
		fi

		# mod_encoding
		plist="${PACKAGE_BASE}/mod_encoding.pkg/Contents/Info.plist"
		if test -f "${plist}"; then
			grep 'mod_encoding-[0-9]*' ${plist} | sed -e 's/<string>//g' -e 's/<\/string>//g' | sort -u
		fi

		# mod_dav_tf
		plist="${PACKAGE_BASE}/mod_dav_tf.pkg/Contents/Info.plist"
		if test -f "${plist}"; then
			grep 'mod_dav_tf [0-9]*' ${plist} | sed -e 's/<string>//g' -e 's/<\/string>//g' | sort -u
		fi
	# Linux
	else
		RPM_LIST="${TMP_BASE_DIR}/__rpm_list"
		rpm -aq > ${RPM_LIST}
		RETVAL=$?
		if test "${RETVAL}" = "0"; then
			grep pk-openssl- ${RPM_LIST}
			grep pk-xerces-c- ${RPM_LIST}
			grep pk-onion- ${RPM_LIST}
			grep pk-pcre- ${RPM_LIST}
			grep pk-libxml2- ${RPM_LIST}
			grep pk-libxslt- ${RPM_LIST}
			grep pk-cyrus-sasl- ${RPM_LIST}
			grep pk-openldap-client- ${RPM_LIST}
			grep pk-postgresql- ${RPM_LIST}
			grep pk-httpd- ${RPM_LIST}
			grep pk-mod_ssl- ${RPM_LIST}
			grep pk-mod_encoding- ${RPM_LIST}
			grep pk-ePs1k- ${RPM_LIST}
			grep pk-tfsconfigd- ${RPM_LIST}
			grep pk-tfsplugin- ${RPM_LIST}
			grep pk-mod_dav_tf- ${RPM_LIST}
			grep pk-fsscipher- ${RPM_LIST}
		fi

		rm -f ${RPM_LIST}
	fi
}

#--------------------------------------
# Install or Update TeamFile for Linux
# [ args ]
#	$1: package directory
#--------------------------------------
install_teamfile_linux() {

	PRODUCT_PKG_DIR="$1"
	errlist="${TMP_BASE_DIR}/__err__"

	currentpwd=`pwd`
	cd ${PRODUCT_PKG_DIR}

	# search dependency package
	getOsType
	OSTYPE=$?

	echo "Checking for module dependency ... "

	deps_modules=""
	perl_modules0="perl perl-URI perl-Crypt-SSLeay perl-HTML-Tagset perl-HTML-Parser perl-HTML-Template perl-libwww-perl perl-libxml-enno perl-XML-Parser perl-XML-Encoding perl-XML-Dumper perl-DateManip perl-Parse-Yapp"
	perl_modules1="perl-CPAN perl-CGI"
	perl_modules2="perl-Filter"
	other_modules0="zlib-devel"
	other_modules1="compat-libstdc++-33"
	if test "${OSTYPE}" = "${OS_LINUX_RHEL4}" || \
	   test "${OSTYPE}" = "${OS_LINUX_WBEL4}" || \
	   test "${OSTYPE}" = "${OS_LINUX_CENT4}"; then
		deps_modules="${perl_modules0} ${perl_modules2} ${other_modules0} ${other_modules1}"
	elif test "${OSTYPE}" = "${OS_LINUX_RHEL5}" || \
		 test "${OSTYPE}" = "${OS_LINUX_CENT5}" || \
		 test "${OSTYPE}" = "${OS_LINUX_RHEL6}" || \
		 test "${OSTYPE}" = "${OS_LINUX_CENT6}" || \
		 test "${OSTYPE}" = "${OS_LINUX_RHEL7}"; then
		deps_modules="${perl_modules0} ${other_modules0} ${other_modules1}"
	else
		deps_modules="${perl_modules0} ${perl_modules1} ${perl_modules2} ${other_modules0}"
	fi

	RETVAL=0
	for m in ${deps_modules}; do
		_list=`rpm -q $m`
		if test "$?" != "0"; then
			echo ${_list}
			RETVAL=1
		fi
	done
	if test "${RETVAL}" != "0"; then
		echo "Some package files were not installed."
		echo "Please install these packages before this installation."
		return 1
	fi
	echo "ok"

	# search DB provider (Install)
	$ECHO_N "Search Repository Database Package ... "$ECHO_C
	dbtype=""
	pkg_pg=`ls *-pg-* 2>/dev/null`
	pkg_ora=`ls *-ora-* 2>/dev/null`
	if test -n "${pkg_pg}"; then
		$ECHO_N "[pg] "$ECHO_C
		dbtype="pg"
	elif test -n "${pkg_ora}"; then
		$ECHO_N "[ora] "$ECHO_C
		dbtype="ora"
	else
		echo "Valid package not found. Please check setup files."
		return 1
	fi
	echo "ok"

	# search install list
	$ECHO_N "Search install list ... "$ECHO_C

	install_list=`ls pk-openssl-* pk-xerces-c-* pk-onion-* pk-pcre-* pk-libxml2-* pk-libxslt-* pk-cyrus-sasl-* pk-openldap-client-* pk-postgresql-7* pk-postgresql-docs* pk-postgresql-devel* pk-postgresql-libs* pk-postgresql-debuginfo* pk-httpd-* pk-mod_ssl* pk-mod_encoding-* pk-tfsplugin* pk-mod_dav_tf-${dbtype}-* 2>${errlist}`

	if test -s "${errlist}"; then
		echo "We found missing modules"
		cat ${errlist}
		echo ""
		$ECHO_N "Ignore it and Continue this installation ? (y/n) "$ECHO_C
		read ANS
		if test "${ANS}" != "y"; then
			echo "OK, aborted."
			rm -f ${errlist}
			return 1
		fi
	else
		echo "ok"
	fi
	[ -f "${errlist}" ] && rm -f ${errlist}

	# show install list
	echo ""
	echo "----- install modules -----"
	for pkg in ${install_list}; do
		echo "${pkg}"
	done

	echo ""
	$ECHO_N "Do you want to install it ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != 'y'; then
		echo "OK, install operation stopped."
		return 1
	fi

	rpm -ivh ${install_list}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to install TeamFile server modules. "
		echo "Please check error message."
		return 1
	fi

	cd ${currentpwd}
	return 0
}

#--------------------------------------
# Install TeamFile for Solaris
# [ args ]
#	$1: package directory
#--------------------------------------
install_teamfile_solaris() {

	PRODUCT_PKG_DIR="$1"

	currentpwd=`pwd`
	cd ${PRODUCT_PKG_DIR}

	for pkg in ${SPKG_INSTALL_PKG_LIST};
	do
		echo "Installing ${pkg}"
		pkgadd -d ${pkg}
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to install package. Please check it."
			return 1
		fi
	done

	cd ${currentpwd}
	return 0
}

#--------------------------------------
# Install TeamFile
#--------------------------------------
install_teamfile() {

	echo ""
	
	# check OS privilege
	getOsType
	OSTYPE=$?
	if test "${OSTYPE}" = "${OS_MACOSX102}" || test "${OSTYPE}" = "${OS_MACOSX103}"; then
		echo "Sorry, MacOSX does not support this operation."
		wait_enter
		return 0
	fi

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	$ECHO_N "Do you install TeamFile now ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "Ok, aborted."
		wait_enter
		return 0
	fi

	# input setup file path
	if test -z "${PRODUCT_PKG_DIR}"; then
		get_product_pkg_dir
	fi

	$ECHO_N "Input product directory (default: ${PRODUCT_PKG_DIR}) : "$ECHO_C
	read tmp
	if test -n "${tmp}"; then
		PRODUCT_PKG_DIR="${tmp}"
	fi

	# check PRODUCT_PKG_DIR directory
	if test ! -d ${PRODUCT_PKG_DIR}; then
		echo "${PRODUCT_PKG_DIR} is not directory. Please check it"
		PRODUCT_PKG_DIR=""
		wait_enter
		return 1
	fi

	# input license file
	license_key_path="${PRODUCT_PKG_DIR}/../../configuration/tf_license.conf"
	$ECHO_N "Input license key file path (default: ${license_key_path}) : "$ECHO_C
	read tmp
	if test -n "${tmp}"; then
		license_key_path="${tmp}"
	fi

	if test ! -f ${license_key_path}; then
		echo "${license_key_path} is not file. Please check it."
		wait_enter
		return 1
	fi
	__licensekey=`grep '^TfServerLicenseKey' ${license_key_path}`
	__dblicensekey=`grep '^TfDbLicenseKey' ${license_key_path}`
	if test -z "${__licensekey}" || test -z "${__dblicensekey}"; then
		echo "${license_key_path} dose not have valid information. Please check it."
		wait_enter
		return 1
	fi

	if test "${OSTYPE}" = "${OS_SOLARIS}"; then
		install_teamfile_solaris ${PRODUCT_PKG_DIR}
	else
		install_teamfile_linux ${PRODUCT_PKG_DIR}
	fi
	RETVAL=$?

	# copy license file
	if test "${RETVAL}" = "0" && test -d ${TF_CONFDIR}; then
		cp -p ${license_key_path} ${TF_CONFDIR}/
	fi

	wait_enter
}

#--------------------------------------
# Install PostgreSQL Server for Linux
#--------------------------------------
install_postgresql_server_linux() {

	errlist="${TMP_BASE_DIR}/__err__"

	# check client library
	echo "Search installed PostgreSQL library ... "

	RPM_LIST="${TMP_BASE_DIR}/__rpm_list"
	rpm -aq > ${RPM_LIST}

	grep pk-postgresql ${RPM_LIST}

	pg_main=`grep pk-postgresql-7 ${RPM_LIST} 2>/dev/null`
	pg_doc=`grep pk-postgresql-docs ${RPM_LIST} 2>/dev/null`
	pg_devel=`grep pk-postgresql-devel ${RPM_LIST} 2>/dev/null`
	pg_libs=`grep pk-postgresql-libs ${RPM_LIST} 2>/dev/null`

	rm -f ${RPM_LIST}
	if test -z "${pg_main}" || test -z "${pg_doc}" || \
	   test -z "${pg_devel}" || test -z "${pg_libs}"; then
	   	echo "Some libraries were not installed. please check it."
		return 1
	fi
	echo "ok"

	# search DB provider
	$ECHO_N "Search PostgreSQL Server Package ... "$ECHO_C
	install_list=`ls pk-postgresql-server-* pk-postgresql-contrib-* pk-postgresql-test-* 2>${errlist}`
	if test -s "${errlist}"; then
		echo "NG"
		echo "We found missing modules."
		cat ${errlist}
		echo ""
		$ECHO_N "Ignore it and Continue this installation ? (y/n) "$ECHO_C
		read ANS
		if test "${ANS}" != "y"; then
			echo "OK, aborted."
			rm -f ${errlist}
			return 1
		fi
	else
		echo "ok"
	fi
	[ -f "${errlist}" ] && rm -f ${errlist}

	# show install list
	echo "----- Install modules -----"
	for pkg in ${install_list}; do
		echo "${pkg}"
	done

	echo ""
	$ECHO_N "Do you want to install it ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != 'y'; then
		echo "OK, install operation stopped."
		return 1
	fi

	rpm -ivh ${install_list}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to install TeamFile server. Please check error message."
		return 1
	fi
	return 0
}

#--------------------------------------
# Install PostgreSQL Server for Solaris
#--------------------------------------
install_postgresql_server_solaris() {

	for pkg in ${SPKG_INSTALL_PKG_LIST};
	do
		case ${pkg} in
			postgresql*)
				echo "Installing ${pkg}"
				pkgadd -d ${pkg}
				RETVAL=$?
				if test "${RETVAL}" != "0"; then
					echo "Failed to install package. Please check it."
					return 1
				fi
				break
				;;
		esac
	done
}

#--------------------------------------
# Install PostgreSQL server
#--------------------------------------
install_postgresql_server() {

	echo ""

	# check OS privilege
	getOsType
	OSTYPE=$?
	if test "${OSTYPE}" = "${OS_MACOSX102}" || test "${OSTYPE}" = "${OS_MACOSX103}"; then
		echo "Sorry, MacOSX does not support this operation."
		wait_enter
		return 0
	fi

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	$ECHO_N "Do you install PostgreSQL server on this machine ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "Ok, aborted."
		wait_enter
		return 0
	fi

	# input setup file path
	if test -z "${PRODUCT_PKG_DIR}"; then
		get_product_pkg_dir
	fi

	$ECHO_N "Input product directory (default: ${PRODUCT_PKG_DIR}) : "$ECHO_C
	read tmp
	if test -n "${tmp}"; then
		PRODUCT_PKG_DIR="${tmp}"
	fi

	# check PRODUCT_PKG_DIR directory
	if test ! -d ${PRODUCT_PKG_DIR}; then
		echo "${PRODUCT_PKG_DIR} is not directory. Please check it"
		wait_enter
		return 1
	fi

	currentpwd=`pwd`
	cd ${PRODUCT_PKG_DIR}

	if test "${OSTYPE}" = "${OS_SOLARIS}"; then
		install_postgresql_server_solaris ${PRODUCT_PKG_DIR}
	else
		install_postgresql_server_linux ${PRODUCT_PKG_DIR}
	fi

	cd ${currentpwd}

	wait_enter
}


#--------------------------------------
# Install USB token device
# (2007/03/26 Mon) この関数は利用されていません
#--------------------------------------
install_usbtoken_library() {

	echo ""

	# check OS privilege
	getOsType
	OSTYPE=$?
	if test "${OSTYPE}" = "${OS_MACOSX102}" || test "${OSTYPE}" = "${OS_MACOSX103}" || \
	   test "${OSTYPE}" = "${OS_SOLARIS}"; then
		echo "Sorry, MacOSX, Solaris does not support this operation."
		wait_enter
		return 0
	fi

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	$ECHO_N "Do you install USB toek device library on this machine ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "Ok, aborted."
		wait_enter
		return 0
	fi

	# input setup file path
	if test -z "${PRODUCT_PKG_DIR}"; then
		get_product_pkg_dir
	fi

	$ECHO_N "Input product directory (default: ${PRODUCT_PKG_DIR}) : "$ECHO_C
	read tmp
	if test -n "${tmp}"; then
		PRODUCT_PKG_DIR="${tmp}"
	fi

	# check PRODUCT_PKG_DIR directory
	if test ! -d ${PRODUCT_PKG_DIR}; then
		echo "${PRODUCT_PKG_DIR} is not directory. Please check it"
		wait_enter
		return 1
	fi

	currentpwd=`pwd`
	cd ${PRODUCT_PKG_DIR}

	errlist="${TMP_BASE_DIR}/__err__"

	# check client library
	echo "Search installed USB toke device library ... "

	RPM_LIST="${TMP_BASE_DIR}/__rpm_list"
	rpm -aq > ${RPM_LIST}

	grep pk-ePs1k ${RPM_LIST}
	grep pk-tfsconfigd ${RPM_LIST}

	epass=`grep pk-ePs1k ${RPM_LIST} 2>/dev/null`
	tfsconfigd=`grep pk-tfsconfigd ${RPM_LIST} 2>/dev/null`

	rm -f ${RPM_LIST}
	if test -z "${epass}" || test -z "${tfsconfigd}"; then
	   	echo "Some libraries were not installed. please check it."
		wait_enter
		return 1
	fi
	echo "ok"

	# search DB provider
	$ECHO_N "Search USB token device Package ... "$ECHO_C
	install_list=`ls pk-ePs1k-drv* pk-tfsconfigd-1* 2>${errlist}`
	if test -s "${errlist}"; then
		echo "NG"
		echo "We found missing modules."
		cat ${errlist}
		echo ""
		$ECHO_N "Ignore it and Continue this installation ? (y/n) "$ECHO_C
		read ANS
		if test "${ANS}" != "y"; then
			echo "OK, aborted."
			rm -f ${errlist}
			wait_enter
			return 1
		fi
	else
		echo "ok"
	fi
	[ -f "${errlist}" ] && rm -f ${errlist}

	# show install list
	echo "----- Install modules -----"
	for pkg in ${install_list}; do
		echo "${pkg}"
	done

	echo ""
	$ECHO_N "Do you want to install it ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != 'y'; then
		echo "OK, install operation stopped."
		wait_enter
		return 1
	fi

	rpm -ivh ${install_list}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to install TeamFile server. Please check error message."
		return 1
	fi
	cd ${currentpwd}

	wait_enter
	return 0
}

#--------------------------------------
# Initialize Repository DB
#--------------------------------------
initialize_reposdb() {
	echo ""

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	# show notice
	echo "This operation initialize (and destroy) repository database."
	$ECHO_N "Do you want to initialize database ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	# create "PGDATA" directory
	PGDATA="/var/lib/tfpgsql/PGDATA"
	$ECHO_N "Input DB DATA path (default: ${PGDATA}) : "$ECHO_C
	read pg_data
	if test -n "${pg_data}"; then
		PGDATA="`echo ${pg_data}`"
	fi

	if test "${PGDATA}" = "/"; then
		echo "The root directory could not use for repository storage."
		wait_enter
		return 1
	elif test -d "${PGDATA}"; then
		$ECHO_N "The directory \"${PGDATA}\" already exist. Do you delete it ? (y/n): "$ECHO_C
		read ANS
		if test "${ANS}" != "y"; then
			echo "OK, but we could not continue this operation."
			wait_enter
			return 1
		fi
		rm -rf "${PGDATA}"
	else
		echo "* Create database cluster (${PGDATA})"
	fi

	mkdir -p "${PGDATA}"
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to create database cluster director."
		wait_enter
		return 1
	fi
	chown ${PG_ADMIN_USER}:${PG_ADMIN_GROUP} "${PGDATA}"
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to change directory owner."
		rmdir "${PGDATA}"
		wait_enter
		return 1
	fi

	#-------------------
	# setup dbenv
	#-------------------
	NEED_SERVER=1
	NO_PGUSER=1
	NO_PGDATABASE=1
	USE_INIT=1

	setup_dbenv
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		wait_enter
		return 1
	fi

	# execute initdb
	su - ${PG_ADMIN_USER} -c "${PG_HOME}/bin/initdb --encoding=UNICODE --no-locale -D ${PGDATA}"
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to initialize database cluster (${PGDATA})."
		rmdir "${PGDATA}"
		wait_enter
		return 1
	fi

	# copy sample configuration
	sample_base="/var/lib/tfpgsql/samples"
	if test -d ${sample_base} && test -f ${sample_base}/pg_hba.conf.sample; then
		cp -p ${sample_base}/pg_hba.conf.sample ${PGDATA}/pg_hba.conf
	fi

	if test -d ${sample_base} && test -f ${sample_base}/postgresql.conf.sample; then
		cp -p ${sample_base}/postgresql.conf.sample ${PGDATA}/postgresql.conf
	fi

	# write PGDATA to script_config
	if test -f "/var/lib/tfpgsql/script_config"; then
		backup_PGDATA=`echo ${PGDATA}`

		# read configuration
		. /var/lib/tfpgsql/script_config
		if test "${PGDATA}" != "${backup_PGDATA}"; then
			echo "save \"${backup_PGDATA}\" to /var/lib/tfpgsql/script_config"
			cat /var/lib/tfpgsql/script_config | \
			sed -e 's:^PGDATA=.*:'"PGDATA=\"${backup_PGDATA}\""':g' \
			> /var/lib/tfpgsql/script_config_tmp

			if test -f /var/lib/tfpgsql/script_config_tmp; then
				mv /var/lib/tfpgsql/script_config_tmp /var/lib/tfpgsql/script_config
				chown ${PG_ADMIN_USER}:${PG_ADMIN_GROUP} /var/lib/tfpgsql/script_config
			fi
		fi
	fi

	wait_enter
}


#--------------------------------------
# create custom configuration
#--------------------------------------
create_custom_configuration() {

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	# build target filename
	TFENVVARS="${TF_BINDIR}/tfenvvars"

	# show notice
	echo ""
	echo "The following files are changed by this operation."
	echo " * ${TFENVVARS}"
	echo " * crontab"
	$ECHO_N "Do you want to continue this operation ? (y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "OK, aborted."
		wait_enter
		return 1
	fi

	if test -f "${TFENVVARS}"; then
		. ${TFENVVARS}
	fi

	#-------------------------
	# create "tfenvvars"
	#-------------------------
	$ECHO_N "Input support Account ID (default: ${TF_DL_USERID}) : "$ECHO_C
	read tmp
	if test -n "${tmp}"; then
		TF_DL_USERID="${tmp}"
	fi

	$ECHO_N "Input support Account Password (default: ${TF_DL_PASSWD}) : "$ECHO_C
	read tmp
	if test -n "${tmp}"; then
		TF_DL_PASSWD="${tmp}"
	fi

	$ECHO_N "Do you use HTTP-proxy from this server ? (on/off) (default: ${TF_DL_USEPROXY}) : "$ECHO_C
	read tmp
	if test -n "${tmp}"; then
		TF_DL_USEPROXY="${tmp}"
	fi

	if test "${TF_DL_USEPROXY}" = "on"; then
		$ECHO_N "Input proxy server hostname (default: ${TF_DL_PROXYHOST}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_DL_PROXYHOST=${tmp}
		fi

		$ECHO_N "Input proxy server port (default: ${TF_DL_PROXYPORT}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_DL_PROXYPORT=${tmp}
		fi

		$ECHO_N "Input proxy server account (default: ${TF_DL_PROXYUSERID}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_DL_PROXYUSERID=${tmp}
		fi

		$ECHO_N "Input proxy server password (default: ${TF_DL_PROXYPASSWD}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			TF_DL_PROXYPASSWD=${tmp}
		fi
	else
		TF_DL_USEPROXY="off"
		TF_DL_PROXYHOST=
		TF_DL_PROXYPORT=
		TF_DL_PROXYUSERID=
		TF_DL_PROXYPASSWD=
	fi

	# TeamFile storage root directory
	$ECHO_N "Input Path of file storage-root (default: ${STORAGE_BASE}) : "$ECHO_C
	read tmp
	if test -n "${tmp}"; then
		STORAGE_BASE=${tmp}
	fi

	$ECHO_N "Input Path of backup-root (default: ${BACKUP_ROOT}) : "$ECHO_C
	read tmp
	if test -n "${tmp}"; then
		BACKUP_ROOT=${tmp}
	fi

	$ECHO_N "Input DB Hostname (default: ${TfDbHostname}) : "$ECHO_C
	read tmp
	if test -n "${tmp}"; then
		TfDbHostname=${tmp}
	fi

	TF_LOCATION="teamfile"
	$ECHO_N "Input Location Name that you want to backup (default: ${TF_LOCATION}) : "$ECHO_C
	read tmp
	if test -n "${tmp}"; then
		TF_LOCATION=${tmp}
	fi

	$ECHO_N "Input DB Name that you want to backup (default: ${PGDATABASE}) : "$ECHO_C
	read tmp
	if test -n "${tmp}"; then
		PGDATABASE=${tmp}
	fi

	$ECHO_N "Input DB User Name that you want to backup (default: ${PGUSER}) : "$ECHO_C
	read tmp
	if test -n "${tmp}"; then
		PGUSER=${tmp}
	fi

	#------------------------
	# setup crontab
	#------------------------

	A_LINE=
	# Read current crontab entry
	TMP_CRONTAB="${TMP_BASE_DIR}/_crontab_"
	/usr/bin/crontab -l > ${TMP_CRONTAB} 2>/dev/null
	RETVAL=$?
	if test "${RETVAL}" = "0" && test -s ${TMP_CRONTAB}; then
		sed -e '/\/usr\/local\/teamfile\/www\/bin\/tfscheduler/d' \
			-e '/^#/d' \
		${TMP_CRONTAB} > ${TMP_CRONTAB}.tmp
		RETVAL=$?
		if test "${RETVAL}" != 0; then
			echo "Failed to parse crontab entry."
			rm -f ${TMP_BASE_DIR}
			wait_enter
			return 1
		fi
		A_LINE=`grep 'dailybat.sh' ${TMP_CRONTAB}.tmp | head -1`
		if test -n "${A_LINE}"; then
			sed -e 's/\(.*dailybat.sh.*\)/#\1/g' ${TMP_CRONTAB}.tmp > ${TMP_CRONTAB}
		else
			A_LINE=`grep 'tfupdater' ${TMP_CRONTAB}.tmp | head -1`
			if test -n "${A_LINE}"; then
				sed -e 's/\(.*tfupdater.*\)/#\1/g' ${TMP_CRONTAB}.tmp > ${TMP_CRONTAB}
			else
				mv ${TMP_CRONTAB}.tmp ${TMP_CRONTAB}
			fi
		fi
	else
		touch ${TMP_CRONTAB}
	fi

	echo "* search current crontab entry ..."
	echo "-------------------------------------------------------------------------"
	grep '/usr/local/teamfile' ${TMP_CRONTAB}.tmp 2>/dev/null
	echo "-------------------------------------------------------------------------"
	echo "* OK"
	rm -f ${TMP_CRONTAB}.tmp

	# extract maintenance time
	MT_HOUR=
	MT_MIN=
	if test -n "${A_LINE}"; then
		MT_HOUR=`echo "${A_LINE}" | awk '{print $2}'`
		MT_MIN=`echo "${A_LINE}" | awk '{print $1}'`
	fi
	if test -z "${MT_HOUR}"; then
		MT_HOUR="05"
	fi
	if test -z "${MT_MIN}"; then
		MT_MIN="00"
	fi

	DAILYBAT_OPT=""
	$ECHO_N "Do you setup server maintenance ? (y/n) (default: y) : "$ECHO_C
	read run_maintenance
	if test "${run_maintenance}" != "n"; then

		$ECHO_N "Do you want to backup data? (y/n) (default: y) : "$ECHO_C
		read tmp
		if test "${tmp}" = "n"; then
			DAILYBAT_OPT="-N"
		fi

		$ECHO_N "Input maintenance hour (default: ${MT_HOUR}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			MT_HOUR=${tmp}
		fi

		$ECHO_N "Input maintenance minute (default: ${MT_MIN}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			MT_MIN=${tmp}
		fi
	fi

	$ECHO_N "Do you want to use server auto-updater ? (y/n) (default: y): "$ECHO_C
	read use_updater
	if test "${use_updater}" != "n"; then
		if test "${run_maintenance}" = "n"; then
			$ECHO_N "Input run hour (default: ${MT_HOUR}) : "$ECHO_C
			read tmp
			if test -n "${tmp}"; then
				MT_HOUR=${tmp}
			fi

			$ECHO_N "Input run minute (default: ${MT_MIN}) : "$ECHO_C
			read tmp
			if test -n "${tmp}"; then
				MT_MIN=${tmp}
			fi
		fi
	fi

	echo "OK"
	echo "Creating \"${TFENVVARS}\" file ..."
	cat - > ${TFENVVARS} <<_TFENVVARS_CONTENT_
#-------------------------------------------------------------------------------
# These defined values are used as default value by maintenance scripts.
# If you want to define value, please insert this file instead of "tfenvvars.default".
#-------------------------------------------------------------------------------

#--------------------------------
# TeamFile
#--------------------------------

# TeamFile STORAGE root
STORAGE_BASE="${STORAGE_BASE}"

# TeamFile backup path
BACKUP_ROOT="${BACKUP_ROOT}"

#--------------------------------
# for PostgreSQL repository
#--------------------------------
PGDATABASE="${PGDATABASE}"
PGUSER="${PGUSER}"

#--------------------------------
# for "dailybat.sh" script
#--------------------------------
TfFsRootPath="\${STORAGE_BASE}/${TF_LOCATION}"
TfDbDbname="${PGDATABASE}"
TfDbHostname="${TfDbHostname}"

#-------------------------------------------------------------------------------
# for "tfdownloader" script
#
# [ replace parameters ]
#     @os@        : The type of Operating System listed by `uname -s` (Linux/SunOS)
#     @platform@  : The name of Platform listed by `uname -i` (i386/SUNW,Sun-Fire-V240)
#     @arch@      : The name of architecture listed by `uname -p` (i686/sparc)
#     @release@   : The type of OS release (RH9.0/RHEL3/RHEL4/RHEL5/RHEL6/RHEL7/WBEL3)
#-------------------------------------------------------------------------------
TF_DL_USESSL="on"

TF_DL_USERID="${TF_DL_USERID}"
TF_DL_PASSWD="${TF_DL_PASSWD}"
TF_DL_LOCATION="/server/@release@/@platform@/@tfversion@/"

# use proxy server ("on" = yes / "off" = no)
TF_DL_USEPROXY="${TF_DL_USEPROXY}"
TF_DL_PROXYHOST="${TF_DL_PROXYHOST}"
TF_DL_PROXYPORT="${TF_DL_PROXYPORT}"
TF_DL_PROXYUSERID="${TF_DL_PROXYUSERID}"
TF_DL_PROXYPASSWD="${TF_DL_PROXYPASSWD}"

_TFENVVARS_CONTENT_
	echo "Creating crontab ..."

	# setup crontab
	CMD_STR=""
	if test "${use_updater}" != "n" && test "${run_maintenance}" != "n"; then
		CMD_STR="(/bin/sh ${APACHE_HOME}/bin/dailybat.sh ${DAILYBAT_OPT}; /bin/sh ${TF_UPDATER} -I -s)"
	elif test "${use_updater}" != "n" && test "${run_maintenance}" = "n"; then
		CMD_STR="/bin/sh ${TF_UPDATER} -I -s"
	elif test "${use_updater}" = "n" && test "${run_maintenance}" != "n"; then
		CMD_STR="/bin/sh ${APACHE_HOME}/bin/dailybat.sh ${DAILYBAT_OPT}"
	fi

	cat - >> ${TMP_CRONTAB} <<_CRONTAB_SCRIPT_
# min hour day month week command
#-------------------------------------------------------------------------
_CRONTAB_SCRIPT_

	if test -n "${CMD_STR}"; then
		cat - >> ${TMP_CRONTAB} <<_CRONTAB_SCRIPT_
${MT_MIN}   ${MT_HOUR}   *    *    *    ${CMD_STR}
_CRONTAB_SCRIPT_
	fi

	cat - >> ${TMP_CRONTAB} <<_CRONTAB_SCRIPT_
*    *    *    *    *    /usr/local/teamfile/www/bin/tfscheduler
_CRONTAB_SCRIPT_

	crontab ${TMP_CRONTAB}
	rm -f ${TMP_CRONTAB}

	$ECHO_N "* Press any key for checking crontab ..."$ECHO_C
	read tmp
	crontab -e

	wait_enter
	return 0
}

#--------------------------------------
# Create SSL Self Signing
#--------------------------------------
create_ssl_self_signing() {
	echo ""

	# check directory permission
	isRightPermission "${APACHE_HOME}/conf"
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Need to write permission for \"${APACHE_HOME}/conf\" directory."
		wait_enter
		return 1
	fi

	KEY_DIR="${APACHE_HOME}/conf/ssl.key"
	CRT_DIR="${APACHE_HOME}/conf/ssl.crt"
	CSR_DIR="${APACHE_HOME}/conf/ssl.csr"

	PRIVATE_KEY_FILE="${KEY_DIR}/server.protected.key"
	NOPASS_PRIVATE_KEY_FILE="${KEY_DIR}/server.nopass.key"
	CSR_FILE="${CSR_DIR}/server.csr"
	CRT_SELF_FILE="${CRT_DIR}/server.crt"
	CRT_DER_FILE="${CRT_DIR}/server.der"
	VALID_DAYS="3650"

	$ECHO_N "Do you want to create new SSL self-signing key ? (y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "Ok, aborted."
		wait_enter
		return 1
	fi

	#------------------
	# create key dir and check files
	#------------------
	[ ! -d ${KEY_DIR} ] && mkdir -p ${KEY_DIR}
	[ ! -d ${CRT_DIR} ] && mkdir -p ${CRT_DIR}
	[ ! -d ${CSR_DIR} ] && mkdir -p ${CSR_DIR}

	if test -f ${PRIVATE_KEY_FILE} || test -f ${NOPASS_PRIVATE_KEY_FILE} || \
	   test -f ${CSR_FILE} || test -f ${CRT_SELF_FILE} || \
	   test -f ${CRT_DER_FILE}; then
		echo "Found same files in \"${KEY_DIR}\" or \"${CRT_DIR}\" or \"${CSR_DIR}\"."
		$ECHO_N "May I overwrite these file ? (y/n) (default: n) : "$ECHO_C
		read ANS
		if test "${ANS}" != "y"; then
			echo "OK, aborted."
			wait_enter
			return 1
		fi
	fi

	#--------------------
	# create server key
	#--------------------
	dummy_file="${TMP_BASE_DIR}/dummy.dat"
	# make random seed
	date > ${dummy_file}
	openssl md5 /usr/include/*.h >> ${dummy_file}

	echo "** create private key **"
	openssl genrsa -rand dummy.dat -des3 2048 > ${PRIVATE_KEY_FILE}

	echo "** create no-pass private key **"
	openssl rsa -in ${PRIVATE_KEY_FILE} -out ${NOPASS_PRIVATE_KEY_FILE}

	getOsType
	OSTYPE=$?
	if test "${OSTYPE}" = "${OS_SOLARIS}"; then
		echo "** create self-signing **"
		openssl req -new -x509 -days ${VALID_DAYS} -key ${PRIVATE_KEY_FILE} -out ${CRT_SELF_FILE}
	else
		echo "** create CSR key **"
		openssl req -new -key ${PRIVATE_KEY_FILE} -out ${CSR_FILE}

		echo "** create self-signing **"
		openssl x509 -in ${CSR_FILE} -out ${CRT_SELF_FILE} -req -days ${VALID_DAYS} -signkey ${PRIVATE_KEY_FILE}
	fi
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to create self-signing key.(${RETVAL})"
		wait_enter
		return 1
	fi

	echo "** convert PEM format to DER format **"
	openssl x509 -inform PEM -outform DER -in ${CRT_SELF_FILE} -out ${CRT_DER_FILE}

	rm -f  ${dummy_file}

	echo "Success. "
	echo "Ths SSL self-signing file is \"${CRT_SELF_FILE}\"."
	echo "Ths private key (with password) file is \"${PRIVATE_KEY_FILE}\"."
	echo "Ths private key (without password) file is \"${NOPASS_PRIVATE_KEY_FILE}\"."
	echo "Ths CSR (Certificate Signing Reques) file is \"${CSR_FILE}\"."

	wait_enter
}

#--------------------------------------
# Unistall TeamFile for Linux
#--------------------------------------
uninstall_teamfile_linux() {

	$ECHO_N "Search uninstall list ... "$ECHO_C

	RPM_LIST="${TMP_BASE_DIR}/__rpm_list"
	rpm -aq > ${RPM_LIST}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "NG"
		echo "Failed to search uninstalling package."
		return 1
	fi

	openssl=`grep pk-openssl- ${RPM_LIST}`
	xerces_c=`grep pk-xerces-c- ${RPM_LIST}`
	onion=`grep pk-onion- ${RPM_LIST}`
	pcre_list=`grep pk-pcre- ${RPM_LIST}`
	libxml2_list=`grep pk-libxml2- ${RPM_LIST}`
	libxslt_list=`grep pk-libxslt- ${RPM_LIST}`
	sasl_list=`grep pk-cyrus-sasl- ${RPM_LIST}`
	openldap_list=`grep pk-openldap-client- ${RPM_LIST}`
	postgres_list=`grep pk-postgresql- ${RPM_LIST}`
	apache_list=`grep pk-httpd- ${RPM_LIST}`
	modssl_list=`grep pk-mod_ssl- ${RPM_LIST}`
	modenc_list=`grep pk-mod_encoding- ${RPM_LIST}`
	epass_list=`grep pk-ePs1k- ${RPM_LIST}`
	tfsconfigd_list=`grep pk-tfsconfigd- ${RPM_LIST}`
	tfsplugin_list=`grep pk-tfsplugin- ${RPM_LIST}`
	teamfile_list=`grep pk-mod_dav_tf ${RPM_LIST}`
	pkcmd_list=`grep pk-cmd ${RPM_LIST}`
	curl_list=`grep pk-curl ${RPM_LIST}`
	distcache_list=`grep pk-distcache ${RPM_LIST}`
	xmlsec_list=`grep pk-xmlsec1 ${RPM_LIST}`
	aprutil_list=`grep pk-apr ${RPM_LIST}`
	pgpool2_list=`grep pk-pgpool ${RPM_LIST}`
	backtrace_list=`grep pk-mod_backtrace ${RPM_LIST}`

	flex_list=`grep pk-flex ${RPM_LIST}`
	lua_list=`grep pk-lua ${RPM_LIST}`
	libevent_list=`grep pk-libevent ${RPM_LIST}`
	memcached_list=`grep pk-memcached ${RPM_LIST}`

	# for plugin
	fsscipher_list=`grep pk-fsscipher- ${RPM_LIST}`

	rm -f ${RPM_LIST}
	echo "ok"

	# show uninstall list
	uninstall_list="${openssl} ${xerces_c} ${onion} ${pcre_list} ${libxml2_list} ${libxslt_list} ${sasl_list} ${openldap_list} ${postgres_list} ${apache_list} ${modssl_list} ${modenc_list} ${epass_list} ${tfsconfigd_list} ${tfsplugin_list} ${teamfile_list} ${pkcmd_list} ${curl_list} ${distcache_list} ${xmlsec_list} ${aprutil_list} ${pgpool2_list} ${fsscipher_list} ${backtrace_list} ${flex_list} ${lua_list} ${libevent_list} ${memcached_list}"
	tmp_list=`echo ${uninstall_list} | sed -e 's/ //g'`
	if test -z "${tmp_list}"; then
		echo "TeamFile server modules were not installed."
		wait_enter
		return 0
	fi

	echo "----- Uninstall modules -----"
	for pkg in ${uninstall_list}; do
		echo "${pkg}"
	done

	$ECHO_N "Do you uninstall it ? (y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != 'y'; then
		echo "OK, uninstall operation stopped."
		wait_enter
		return 1
	fi

	rpm -e ${uninstall_list}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo "Failed to uninstall TeamFile server modules. Please check error message."
		return 1
	fi

	# remove crontab entry
	TMP_CRONTAB="${TMP_BASE_DIR}/_crontab_"
	/usr/bin/crontab -l > ${TMP_CRONTAB} 2>/dev/null
	RETVAL=$?
	if test "${RETVAL}" = "0" && test -s ${TMP_CRONTAB}; then
		sed -e '/# min hour day month week command/d' \
			-e '/#-------------------------------------------------------------------------/d' \
			-e '/\/tfscheduler/d' \
			-e '/\/tfupdater/d' \
			-e '/\/*dailybat.sh/d' \
			-e '/\/autoimp.sh/d' \
			-e '/\/usr\/local\/teamfile\/bin/d' \
			-e '/\/usr\/local\/teamfile\/www\/bin/d' \
		${TMP_CRONTAB} > ${TMP_CRONTAB}.tmp
		RETVAL=$?
		if test "${RETVAL}" != 0; then
			echo "Failed to parse crontab entry. Please edit crontab manually."
			rm -f ${TMP_BASE_DIR}
		fi
		crontab ${TMP_CRONTAB}.tmp
		rm -f ${TMP_CRONTAB}.tmp
	fi
	rm -f ${TMP_CRONTAB}

	echo "Please remove these data files manually."
	echo "path is ${TF_DATA_HOME}, ${APACHE_HOME} and postgresql data directory."
	echo "Thanks."

	wait_enter
}

#--------------------------------------
# Unistall TeamFile for MacOSX
#--------------------------------------
uninstall_teamfile_macosx() {

	echo "Search uninstall list ..."
	show_installed_modules

	$ECHO_N "Do you want to uninstall it ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != 'y'; then
		echo "OK, uninstall operation stopped."
		wait_enter
		return 1
	fi

	#----------------------
	# remove all files
	#----------------------
	echo "We remove all files. Please wait for a while."
	MPKG_INSTALLED_PKG_LIST=""
	if test "${OSTYPE}" = "${OS_MACOSX103}"; then
		MPKG_INSTALLED_PKG_LIST=${MPKG_INSTALLED_PKG_LIST103}
	else
		MPKG_INSTALLED_PKG_LIST=${MPKG_INSTALLED_PKG_LIST102}
	fi

	pushd / > /dev/null 2>&1

	#------------------------------------
	# backup important configuration file
	#------------------------------------
	if test -f ${APACHE_HOME}/conf/httpd.conf; then
		mv ${APACHE_HOME}/conf/httpd.conf ${APACHE_HOME}/conf/httpd.conf.rmtmp
	fi

	if test -f ${APACHE_HOME}/conf/ssl.conf; then
		mv ${APACHE_HOME}/conf/ssl.conf ${APACHE_HOME}/conf/ssl.conf.rmtmp
	fi

	if test -f ${TF_CONFDIR}/mod_dav_tf.conf; then
		mv ${TF_CONFDIR}/mod_dav_tf.conf ${TF_CONFDIR}/mod_dav_tf.conf.rmtmp
	fi

	if test -f ${TF_BINDIR}/tfenvvars; then
		mv ${TF_BINDIR}/tfenvvars ${TF_BINDIR}/tfenvvars.rmtmp
	fi

	MPKG_UNINSTALL_LIST="${TMP_BASE_DIR}/teamfile_uninstall_list"
	MPKG_NONE_UNINSTALL_LIST="${TMP_BASE_DIR}/teamfile_none_uninstall_list"

	echo "" > ${MPKG_NONE_UNINSTALL_LIST}
	for pkg in ${MPKG_INSTALLED_PKG_LIST}; do
		if test -r ${MPKG_INSTALLED_PKG_ROOT}/${pkg}/Contents/Archive.bom; then
			# show status
			$ECHO_N "Uninstall ${pkg} ..."$ECHO_C

			# get filelist
			lsbom -f -l -p f ${MPKG_INSTALLED_PKG_ROOT}/${pkg}/Contents/Archive.bom \
				> ${MPKG_UNINSTALL_LIST}

			# create none-uninstalled directory list
			lsbom -d -p f ${MPKG_INSTALLED_PKG_ROOT}/${pkg}/Contents/Archive.bom \
				>> ${MPKG_NONE_UNINSTALL_LIST}

			cat ${MPKG_UNINSTALL_LIST} | \
			sed -e 's:^\./:rm -f /:g' > "${MPKG_UNINSTALL_LIST}_tmp"
			mv ${MPKG_UNINSTALL_LIST}_tmp ${MPKG_UNINSTALL_LIST}
			sh ${MPKG_UNINSTALL_LIST}
			rm -f ${MPKG_UNINSTALL_LIST}

			#---------------------------
			# remove install information
			#---------------------------
			rm -rf ${MPKG_INSTALLED_PKG_ROOT}/${pkg}

			echo "done"
		fi
	done
	popd > /dev/null 2>&1

	#----------------------
	# remove startup files
	#----------------------
	for pkg in ${MPKG_INSTALLED_STARTUP_LIST}; do
		if test -d ${MPKG_INSTALLED_STARTUP_ROOT}/${pkg}; then
			rm -rf ${MPKG_INSTALLED_STARTUP_ROOT}/${pkg}
		fi
	done

	#-----------------------
	# show none-uninstalled list
	#-----------------------
	cat ${MPKG_NONE_UNINSTALL_LIST} | \
	sed -e '/^\.\/Library/d' \
	    -e '/^\.\/usr$/d' \
	    -e '/^\.\/usr\/local$/d' \
	    -e '/^\.\/usr\/local\/lib$/d' \
	    -e '/^\.\/usr\/local\/bin$/d' \
	    -e '/^\.\/usr\/local\/info$/d' \
	    -e '/^\.\/usr\/local\/man/d' \
	    -e '/^\.\/usr\/local\/include$/d' \
	    -e '/^\.\/usr\/local\/share$/d' \
	    -e '/^\.\/usr\/local\/lib\/pkgconfig$/d' \
	    -e '/^\.\/usr\/share$/d' \
	    -e '/^\.\/usr\/share\/doc$/d' \
	    -e '/^\.\/private$/d' \
	    -e '/^\.\/private\/var$/d' \
	    -e '/^\.\/private\/var\/lib$/d' \
	    -e 's:^\.::g' | \
	sort -u > ${TMP_BASE_DIR}/__tmp__ && \
	mv ${TMP_BASE_DIR}/__tmp__ ${MPKG_NONE_UNINSTALL_LIST}

	echo "Please remove these directory manually. (list file = ${MPKG_NONE_UNINSTALL_LIST})"
	echo "-------------------------------------------------------------"
	cat ${MPKG_NONE_UNINSTALL_LIST}
	echo "-------------------------------------------------------------"
	echo "Thanks."

	wait_enter
}

#--------------------------------------
# Unistall TeamFile for Solaris
#--------------------------------------
uninstall_teamfile_solaris() {

	echo "Search uninstall list ..."
	show_installed_modules

	$ECHO_N "Do you want to uninstall it ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != 'y'; then
		echo "OK, uninstall operation stopped."
		wait_enter
		return 1
	fi

	echo "We uninstall all files. Please wait for a while."
	#------------------------------------
	# backup important configuration file
	#------------------------------------
	if test -f ${APACHE_HOME}/conf/httpd.conf; then
		mv ${APACHE_HOME}/conf/httpd.conf ${APACHE_HOME}/conf/httpd.conf.rmtmp
	fi

	if test -f ${APACHE_HOME}/conf/ssl.conf; then
		mv ${APACHE_HOME}/conf/ssl.conf ${APACHE_HOME}/conf/ssl.conf.rmtmp
	fi

	if test -f ${TF_CONFDIR}/mod_dav_tf.conf; then
		mv ${TF_CONFDIR}/mod_dav_tf.conf ${TF_CONFDIR}/mod_dav_tf.conf.rmtmp
	fi

	if test -f ${TF_BINDIR}/tfenvvars; then
		mv ${TF_BINDIR}/tfenvvars ${TF_BINDIR}/tfenvvars.rmtmp
	fi

	# uninstall packages
	echo "" > ${SPKG_UNINSTALL_LIST}
	for pkg in ${SPKG_INSTALLED_PKGNAME_LIST}; do
		echo "* Uninstalling ${pkg}..."
		pkgrm ${pkg}
	done

	echo "Thanks."

	wait_enter
}

#--------------------------------------
# Update TeamFile
#--------------------------------------
update_teamfile() {
	echo ""

	getOsType
	OSTYPE=$?

	if test "${OSTYPE}" = "${OS_MACOSX102}" || \
	   test "${OSTYPE}" = "${OS_MACOSX103}" || \
	   test "${OSTYPE}" = "${OS_SOLARIS}"; then
		echo "Sorry, MacOSX or Solaris does not support this operation."
		wait_enter
		return 1
	fi

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	$ECHO_N "Do you UPDATE TeamFile now ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "Ok, aborted."
		wait_enter
		return 0
	fi

	OPT_STR=
	$ECHO_N "Do you download TeamFile modules via Network ? (y/n) (default: n) : "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		# input setup file path
		get_product_pkg_dir

		$ECHO_N "Input product directory (default: ${PRODUCT_PKG_DIR}) : "$ECHO_C
		read tmp
		if test -n "${tmp}"; then
			PRODUCT_PKG_DIR="${tmp}"
		fi

		# check PRODUCT_PKG_DIR directory
		if test ! -d ${PRODUCT_PKG_DIR}; then
			echo "${PRODUCT_PKG_DIR} is not directory. Please check it"
			wait_enter
			return 1
		fi
		OPT_STR="-l"
	else
		PRODUCT_PKG_DIR=${TF_DOWNLOAD_PATH}
	fi
	
	BACKUP_BASE_DIR="${TMP_BASE_DIR}/backup_`date +%Y%m%d_%H%M%S`"

	$TF_UPDATER -d "${PRODUCT_PKG_DIR}" -b "${BACKUP_BASE_DIR}" ${OPT_STR}
	wait_enter
	return 0
}

#--------------------------------------
# Unistall TeamFile
#--------------------------------------
uninstall_teamfile() {

	echo ""

	getOsType
	OSTYPE=$?

	# check root privilege
	isRootPrivilege
	RETVAL=$?
	if test "${RETVAL}" = "0"; then
		echo "Need to root privilege !"
		wait_enter
		return 1
	fi

	$ECHO_N "Do you UNINSTALL TeamFile now ? (y/n) "$ECHO_C
	read ANS
	if test "${ANS}" != "y"; then
		echo "Ok, aborted."
		wait_enter
		return 0
	fi

	# Stop TeamFile and Postgres
	stop_teamfile
	stop_postgresql

	# backup setting data and data files
	echo ""
	$ECHO_N "Do you want to backup previous files before removing TeamFile ? (y/n) (default: y) : "$ECHO_C
	read ANS
	if test "${ANS}" != 'n'; then
		backup_setting_data
		RETVAL=$?
		if test "${RETVAL}" != "0"; then
			echo "Failed to backup operation."
			wait_enter
			return 1
		fi
	fi

	#
	# (note) 2007/10/09 Tue
	# The MacOSX and Solaris environment had been not supported by TeamFile server.

	# MacOSX
	if test "${OSTYPE}" = "${OS_MACOSX102}" || test "${OSTYPE}" = "${OS_MACOSX103}"; then
		uninstall_teamfile_macosx
	# Solaris
	elif test "${OSTYPE}" = "${OS_SOLARIS}"; then
		uninstall_teamfile_solaris
	# Linux
	else
		uninstall_teamfile_linux
	fi

	return 0
}

#-------------------------------------------------------------------------------
# Show setup operation menu
#-------------------------------------------------------------------------------
display_setup_menu() {
	clear
	echo " +--------------${TITLE_LINE}---+"
	echo " | [ Setup operation menu ]                                           |"
	echo " |                                                                    |"
	echo " | please select this number. (Be careful)                            |"
	echo " |                                                                    |"
	echo " | 1  : Show installed modules                                        |"
	echo " | 2  : Install   TeamFile                              [ root only ] |"
	echo " | 3  : Install   PostgreSQL Server                     [ root only ] |"
	echo " | *  : Install   USB Token library                     [ root only ] |"
	echo " | 5  : Initialize Repository DB                        [ root only ] |"
	echo " | 6  : Create custom configuration                     [ root only ] |"
	echo " | 7  : Create SSL self-signing                                       |"
	echo " | 8  : Update    TeamFile                              [ root only ] |"
	echo " | 9  : Uninstall TeamFile                              [ root only ] |"
	echo " |                                                                    |"
	echo " | r  : Return to main menu                                           |"
	echo " | q  : Quit                                                          |"
	echo " +---------------------------------------------------------- Setup ---+"
}

show_setup_menu() {
	while [ 1 ];
	do
		display_setup_menu
		$ECHO_N "  Input number : "$ECHO_C
		read ANS
		case "$ANS" in
			1)
				show_installed_modules
				wait_enter
				;;
			2)
				install_teamfile
				;;
			3)
				install_postgresql_server
				;;
			5)
				initialize_reposdb
				;;
			6)
				create_custom_configuration
				;;
			7)
				create_ssl_self_signing
				;;
			8)
				update_teamfile
				;;
			9)
				uninstall_teamfile
				;;
			r)
				return
				;;
			q)
				echo "bye"
				exitscript 0
				;;
		esac
	done
}

#--------------------------------------
# Show main menu
#--------------------------------------
display_main_menu() {
	clear
	echo " +--------------${TITLE_LINE}---+"
	echo " | [ Maintenance main menu ]                                          |"
	echo " |                                                                    |"
	echo " | please select these value.                                         |"
	echo " |                                                                    |"
	echo " | t  : Start & Stop                                 (Go To submenu)  |"
	echo " | m  : Management                                   (Go To submenu)  |"
	echo " | e  : Enterprize                                   (Go To submenu)  |"
	echo " | b  : Backup & Restore                             (Go To submenu)  |"
	echo " | o  : Optimize                                     (Go To submenu)  |"
	echo " | i  : Migration                                    (Go To submenu)  |"
	echo " | s  : Setup                                        (Go To submenu)  |"
	echo " |                                                                    |"
	echo " | q  : Quit                                                          |"
	echo " +---------------------------------------------------- Maintenance ---+"
}

show_main_menu() {
	while [ 1 ];
	do
		display_main_menu
		$ECHO_N "  Input value : "$ECHO_C
		read ANS
		case "$ANS" in
			t)
				show_startup_menu
				;;
			m)
				show_management_menu
				;;
			e)
				show_enterprize_menu
				;;
			b)
				show_backup_menu
				;;
			o)
				show_optimize_menu
				;;
			i)
				show_migration_menu
				;;
			s)
				show_setup_menu
				;;
			q)
				echo "bye"
				exitscript 0
				;;
		esac
	done
}


#-------------------------------------------------------------------------------
# main loop
#-------------------------------------------------------------------------------

# check OS type
getOsType
OSTYPE=$?
if test "${OSTYPE}" = "${OS_UNKNOWN}"; then
	echo "Sorry, this operating system is not supported."
	exitscript 0
fi

# lock
lockscript "${EXCLUSIVE_LOCKFILE}"
RETVAL=$?
if test "${RETVAL}" != "0"; then
	exit 1
fi

TYPE_CREATENEWLOCATION=
IS_SILENT=0
# Process argument
while getopts o:f:sh OPT;
do
	case $OPT in
		o)
			if test "$OPTARG" = "newlocation"; then
				TYPE_CREATENEWLOCATION=1
			fi
			;;
		f)
			NEWLOCATION_INI="$OPTARG"
			;;
		h)
			show_usage
			exitscript 0
			;;
		s)
			IS_SILENT=1
			;;
		\?)
			show_usage
			exitscript 1
			;;
	esac
done
shift `expr $OPTIND - 1`

if test -n "${TYPE_CREATENEWLOCATION}"; then
	if test ! -r "${NEWLOCATION_INI}"; then
		echo "\"${NEWLOCATION_INI}\" is not valid file path."
		exitscript 10
	fi

	create_location ${IS_SILENT} ${NEWLOCATION_INI}
else
	# build title line string
	build_title_line

	# show main menu
	show_main_menu
fi

# unlock and exit
exitscript 0

