#!/bin/sh

# $Id$
# postgres dump all script (postgres7 only)

# Copyright (c) 2013 COMPUTER HI-TECH INC., TeamFile team All rights reserved.

#------------------
# set env
#------------------
if test -d "${TF_HOME}"; then
	MT_FUNCTION_HOME="${TF_HOME}/www/bin"
	MT_FUNCTION="${MT_FUNCTION_HOME}/mt-lib"
else
	if test -f "./mt-lib"; then
		MT_FUNCTION_HOME="."
	else
		MT_FUNCTION_HOME="/usr/local/teamfile/www/bin"
	fi
	MT_FUNCTION="${MT_FUNCTION_HOME}/mt-lib"
fi

if test ! -f ${MT_FUNCTION}; then
	echo "The configuration script \"${MT_FUNCTION}\" was missing. Please check it."
	exit 1
fi

# read functions and configuration
. ${MT_FUNCTION}

PGDUMPALL="${PG_HOME}/bin/pg_dumpall"
DUMPFILE="dump.sql.$$"

if [ "X${BACKUP_ROOT}" = "X" ]; then
	DUMPFILE="${TMP_BASE_DIR}/dump.sql.$$"
else
	DUMPFILE="${BACKUP_ROOT}/dump.sql.$$"
fi

PGVER=`rpm -q --queryformat '%{version}' pk-postgresql | cut -c1`

PGCLIENTENCODING="UTF-8"
export PGCLIENTENCODING

$PGDUMPALL -c -U${PG_ADMIN_USER} > ${DUMPFILE}
if [[ $? -ne 0 ]]; then
	echo "failed to TeamFile Backup."
	exit 1;
fi

echo "dump ok"
exit 0

