#!/usr/bin/perl
#
# $Id$
#-------------------------------------------------------------------------------
# Mail sending script
#-------------------------------------------------------------------------------
use strict;
use Net::SMTP;
use Socket;
use Getopt::Long;
use MIME::Base64;
require "/usr/local/teamfile/www/bin/mt-lib.pl";

my $fromaddr     = undef;
my $toaddr       = undef;
my $subject      = undef;
my $smtphost     = undef;
my $smtpport     = undef;
my $atfilepaths  = undef;
my $msgtext      = undef;
my $msgfilepath  = undef;
my $opt_h        = 0;
my @atfilepathl  = ();

# Get command line options
my $result = GetOptions(
					"from=s" => \$fromaddr,
					"to=s" => \$toaddr,
					"subject=s" => \$subject,
					"host=s" => \$smtphost,
					"port=s" => \$smtpport,
					"msg=s" => \$msgtext,
					"msgf=s" => \$msgfilepath,
					"attachf=s" => \$atfilepaths,
					"h" => \$opt_h);

# check argument
if (!$result || $opt_h || !$fromaddr || !$toaddr || !$subject ||
	!$smtphost || !$smtpport || (!$msgfilepath && !$msgtext)) {
	&usage();
}
if ($msgfilepath && ! -r $msgfilepath) {
	print("Failed to read \"$msgfilepath\".");
	exit(1);
}
if ($atfilepaths) {
	@atfilepathl = split(/,/, $atfilepaths);
	foreach my $f (@atfilepathl) {
		$f = &strim($f);
		if (! -r $f) {
			print("Failed to read attachment file \"$f\".");
			exit(2);
		}
	}
}

# prepare SMTP connection
my $smtp = Net::SMTP->new($smtphost,
                       Port => $smtpport,
                       Hello => 'teamfile.com',
                       Timeout => 60);
$smtp->mail($fromaddr);
$smtp->to($toaddr);

$smtp->data();

# create boundary string
my $boundary = &get_boundary_str();

&build_mail_header($toaddr, $fromaddr, $subject, $boundary, \@atfilepathl);
&build_mail_body($smtp, $msgfilepath, $msgtext, $boundary, \@atfilepathl);

$smtp->dataend();
$smtp->quit;

exit(0);

#-------------------------------------------------------------------------------
# Show usage and exit
#-------------------------------------------------------------------------------
sub usage {
	print <<"_EOF_";
Usage: sendmail.pl [--from=from addr] [--to=to addr] [--subject=subject string] 
                   [--host=SMTP host] [--port=SMTP port]
                   [--msg=message text | --msgf=message text filepath]
                   [--attach=filepath1,filepath2,...filepathN] [-h]
_EOF_
	exit(1);
}

#-------------------------------------------------------------------------------
# Build mail header
#-------------------------------------------------------------------------------
sub build_mail_header($$$$$) {
	my ($to, $from, $subject, $boundary, $atfilel) = @_;

	$smtp->datasend("To: $to\n");
	$smtp->datasend("From: $from\n");
	$smtp->datasend("Subject: $subject\n");
	$smtp->datasend("X-Mailer: TeamFile status sender [en]\n");

	if (@$atfilel) {
		$smtp->datasend("MIME-Version: 1.0\n");
		$smtp->datasend("Content-Type: multipart/mixed; boundary=\"$boundary\"\n");
		$smtp->datasend("Content-Transfer-Encoding: 7bit\n");
	}
	$smtp->datasend("\n");

	return 0;
}

#-------------------------------------------------------------------------------
# Build mail body
# [ arg ]
#	$1: $smtp
#	$2: message file path
#	$3: message text
#	$4: boundary string
#	@5: attachment file paths
#-------------------------------------------------------------------------------
sub build_mail_body($$$$$) {
	my ($smtp, $msgfilepath, $msgtext, $boundary, $atfilel) = @_;
	my $msg_separator = "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n";
	my $line;

	# write text/plain part
	if (@$atfilel) {
		$smtp->datasend("--$boundary\n");
		$smtp->datasend("Content-Type: text/plain; charset=\"ISO-8859-1\"\n");
		$smtp->datasend("Content-Transfer-Encoding: 7bit\n");
		$smtp->datasend("\n");
	}

	# write message text
	if ($msgtext) {
		$smtp->datasend("$msgtext\n");
		$smtp->datasend("\n");
	}
	# write message file content
	elsif ($msgfilepath) {
		open(FBODY_IN, $msgfilepath) or die("Failed to open message text file.\n");

		while ($line = <FBODY_IN>) {
			chop($line);
			$smtp->datasend("$line\n");
		}
		$smtp->datasend("\n");
		close(FBODY_IN);
	}

	# write attachment file
	if (@$atfilel) {
		foreach my $f (@$atfilel) {
			&attach_file($smtp, $boundary, $f);
		}
		&attach_file_end($smtp, $boundary);
	}

	return 1;
}

#-------------------------------------------------------------------------------
# Attach file to mail body
# [ arg ]
#	$1: $smtp
#	$2: boundary string
#	$3: attachment file path
#-------------------------------------------------------------------------------
sub attach_file($$$) {
	my ($smtp, $boundary, $atfile) = @_;

	if (open(ATFILE_IN, $atfile)) {
		my $buf;
		my $name = $atfile;
		$name =~ s|^.*/||;

		$smtp->datasend("--$boundary\n");
		$smtp->datasend("Content-Type: application/octet-stream; name=\"$name\"\n");
		$smtp->datasend("Content-Disposition: attachment; filename=\"$name\"\n");
		$smtp->datasend("Content-Transfer-Encoding: base64\n");
		$smtp->datasend("\n");
	
		# base64 encoding
		while (read(ATFILE_IN, $buf, 57*10)) {
			$smtp->datasend(&encode_base64($buf));
		}
		$smtp->datasend("\n");

		close(ATFILE_IN);
		return 1;
	}
	else {
		return 0;
	}
}

#-------------------------------------------------------------------------------
# set last boundary data
# [ arg ]
#	$1: $smtp
#	$2: boundary string
#-------------------------------------------------------------------------------
sub attach_file_end($$) {
	$smtp->datasend("--$boundary\n");
	$smtp->datasend("\n");

	return 1;
}

#-------------------------------------------------------------------------------
# get boundary string
#-------------------------------------------------------------------------------
sub get_boundary_str {
	my $time0 = time;

	return "------_" . $time0 . $time0 . "_MULTIPART_MIXED_";
}

