#!/bin/sh
#
# $Id$
#-------------------------------------------------------------------------------
# テープ並びにホストへのrsyncバックアップスクリプト
#
# (note) dailybat.sh との違い
#	* Tapeや他のマシンにバックアップファイルを保存すること
#	dailybat.shを処理してから行ないますのでサーバの起動はバックアップ終了を
#	待ちません。
#
# Usage: ./ydailybat.sh [--with-tape]
#	--with-tape : テープにデータをバックアップする
#   --with-host [host] [path]: [host]にrsyncを利用して[path]にバックアップする
#-------------------------------------------------------------------------------

ARG1="$1"
BKHOST="$2"
BKPATH="$3"
MODE=
#----------------------
# execute dailybat.sh
#----------------------
/usr/local/teamfile/www/bin/dailybat.sh

if test -z "${ARG1}"; then
	exit 0
fi

case "${ARG1}" in
--with-tape)
	MODE=1
	;;
--with-host)
	MODE=2
	;;
esac

if test -z "${MODE}"; then
	exit 0
fi 

if test ${MODE} = 2 && test -z ${BKHOST} || test -z ${BKPATH}; then
	exit 0
fi

#----------------------
# env setting
#----------------------
MT_FUNCTION_HOME="/usr/local/teamfile/www/bin"

MT_FUNCTION="${MT_FUNCTION_HOME}/mt-lib"
if test ! -f ${MT_FUNCTION}; then
        echo "The configuration script \"${MT_FUNCTION}\" was missing. Please check it."
        exit 1
fi

# read functions and configuration
. ${MT_FUNCTION}

if test "${STORAGE_BACKUPMETHOD}" = "tar"; then
	MMDATE=`date '+%d'`
	BACKUP_PREFIX_DIR="`expr ${MMDATE} % ${ROTATE_RATE}`"
else
	BACKUP_PREFIX_DIR="n"
fi

# check backup directory
if test ! -d ${BACKUP_ROOT}/${BACKUP_PREFIX_DIR}; then
	echo `date -R`": The \"${BACKUP_ROOT}/${DAILYBAT_LOGFILE}\" directory is missing." >> ${DAILYBAT_LOGFILE}
	exit 0
fi

# check look
lockscript "${DAILYBAT_LOOKFILE}" >> ${DAILYBAT_LOGFILE}

#----------------------
# write data to tape
#----------------------
if test ${MODE} = 1; then
	echo `date -R`": Write data to tape. START *" >> ${DAILYBAT_LOGFILE}

	# rewind
	mt -f /dev/nst0 rewind >> ${DAILYBAT_LOGFILE}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo `date -R`": Failed to rewind tape (RETVAL=$RETVAL)." >> ${DAILYBAT_LOGFILE}
		unlockscript "${DAILYBAT_LOOKFILE}" >> ${DAILYBAT_LOGFILE}
		exit 1
	fi

	tar -C ${BACKUP_ROOT}/${BACKUP_PREFIX_DIR} -cpf /dev/st0 . >> ${DAILYBAT_LOGFILE}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo `date -R`": Failed to write tape (RETVAL=$RETVAL)." >> ${DAILYBAT_LOGFILE}
		unlockscript "${DAILYBAT_LOOKFILE}" >> ${DAILYBAT_LOGFILE}
		exit 1
	fi

	mt -f /dev/nst0 offline
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo `date -R`": Failed to offline tape (RETVAL=$RETVAL)." >> ${DAILYBAT_LOGFILE}
	fi

	echo `date -R`": Write data to tape. END *" >> ${DAILYBAT_LOGFILE}
fi

#----------------------
# write data to host by rsync
#----------------------
if test ${MODE} = 2; then
	echo `date -R`": Write data to host(target host = ${BKHOST}). START *" >> ${DAILYBAT_LOGFILE}
	ping -c 1 ${BKHOST}>/dev/null 2>&1
	RETVAL=$?
	if test ${RETVAL} != "0"; then
		echo `date -R`": host check failed. Target host=${BKHOST}." >> ${DAILYBAT_LOGFILE}
		unlockscript "${DAILYBAT_LOOKFILE}" >> ${DAILYBAT_LOGFILE}
		exit 1
	fi

	rsync -av --delete -e ssh ${BACKUP_ROOT}/${BACKUP_PREFIX_DIR} ${BKHOST}:${BKPATH}>> ${DAILYBAT_LOGFILE}
	RETVAL=$?
	if test "${RETVAL}" != "0"; then
		echo `date -R`": Failed to rsync backup (RETVAL=$RETVAL)." >> ${DAILYBAT_LOGFILE}
		unlockscript "${DAILYBAT_LOOKFILE}" >> ${DAILYBAT_LOGFILE}
		exit 1
	fi

	echo `date -R`": Write data to host. END *" >> ${DAILYBAT_LOGFILE}
fi

# unlock
unlockscript "${DAILYBAT_LOOKFILE}" >> ${DAILYBAT_LOGFILE}

exit 0

