package AutodelGroupList;
#------------------------------------------------------------------------------
# $Id$
#------------------------------------------------------------------------------
# The module of AutoDelete setting CGI
#
# Copyright (c) BAYBITS LLC, All rights reserved.
#------------------------------------------------------------------------------

# TF::GroupListを継承する
use TF::GroupList;
@ISA = qw( TF::GroupList );

use strict;
use utf8;
use XML::DOM;
use TF::XMLUtils;

#
# [Derived] Constructor 
#
sub new  {
	my $class = shift;
	return $class->SUPER::new(@_);	# 一度shiftしてから@_を使う
}

#
# [Derived] makeSureItem GROUPID
#
sub makeSureItem {
	my $this = shift;
	my $retval = $this->SUPER::makeSureItem(@_); # 一度shiftしてから@_を使う

	my $groupid = shift || die;

	if( $retval ) {
		$this->{$groupid}->{state}->{hasAutodeleteSettings} = 0;
		$this->{$groupid}->{action}->{isDeleteFolder} = 0;
		$this->{$groupid}->{keepday} = "";
	}

	return $retval;
}

#
# loadAutodeleteSettings PATHNAME
#
sub loadAutodeleteSettings {
	my $this = shift;
	my $pathname = shift || die;

	if( ! stat($pathname) ) {
		return 0;
	}

	my $xml = new XML::DOM::Parser;
	my $doc = $xml->parsefile($pathname);

	for my $elem ( $doc->getElementsByTagName("autodeletefolder") )  {
		my $groupid  = TF::XMLUtils::getText($elem, "groupid");
		my $keepday  = TF::XMLUtils::getText($elem, "preservationperiod") || '0';
		my $nodelist = $elem->getElementsByTagName("deletefolder");
		my $isDeleteFolder = 0;
		if ($nodelist && $nodelist->getLength > 0) {
			$isDeleteFolder = 1;
		}

		if( $groupid ) {
			$this->makeSureItem($groupid);
			$this->{$groupid}->{state}->{hasAutodeleteSettings} = 1;
			$this->{$groupid}->{action}->{isDeleteFolder} = $isDeleteFolder;
			$this->{$groupid}->{keepday} = $keepday;
		}
	}

	return 1;
}

#
# storeAutodeleteSettings PATHNAME
#
sub storeAutodeleteSettings {
	my $this = shift;
	my $pathname = shift || die;

	my $result = 0;

	my $doc = new XML::DOM::Document;
	my $pi_decl = $doc->createXMLDecl('1.0','utf-8','yes');
	$doc->setXMLDecl($pi_decl);

	my $e_fsscipher = $doc->createElement("autodelete");

	for my $groupid ( keys %$this ) {
		if( $this->{$groupid}->{state}->{hasAutodeleteSettings} ) {

			my $e_cipherfolder = $doc->createElement("autodeletefolder");

			TF::XMLUtils::appendTextElement($doc, $e_cipherfolder, "groupid", $groupid);
			my $e = $doc->createElement("specialaction");
			if ($this->{$groupid}->{action}->{isDeleteFolder}) {
				my $e1 = $doc->createElement("deletefolder");
				$e->appendChild($e1);
			}
			$e_cipherfolder->appendChild($e);
			TF::XMLUtils::appendTextElement($doc, $e_cipherfolder, "preservationperiod", $this->{$groupid}->{keepday});

			$e_fsscipher->appendChild($e_cipherfolder);
		}
	}

	$doc->appendChild($e_fsscipher);

	if( $doc->printToFile($pathname) ) {
		$result = 1;
	}

	$doc->dispose;

	return $result;
}

#
# hasAutodeleteSettings GROUPID
#
sub hasAutodeleteSettings {
	my $this = shift;
	my $id = shift || die;

	return $this->{$id}->{state}->{hasAutodeleteSettings};
}

#
# getKeepDay GROUPID
#
sub getKeepDay {
	my $this = shift;
	my $id = shift || die;

	return $this->{$id}->{keepday};
}

#
# isDeleteFolder GROUPID
#
sub isDeleteFolder {
	my $this = shift;
	my $id = shift || die;

	return $this->{$id}->{action}->{isDeleteFolder};
}

# End of module
1;
