#!/bin/sh
#-------------------------------------------------------------------------------
# 指定されたファイル名のスタイルシートファイルを編集するための
# EUCにエンコード変換するためのスクリプト
#-------------------------------------------------------------------------------

#--------------------------------------
# setenv
#--------------------------------------
LV="/usr/bin/lv"
VI="/usr/bin/vim"
TMPFILE=".__tmp"

if test ! -f $LV; then
	echo "$LV was missing. Please install it."
	exit 1
fi

if test ! -f $VI; then
	VI="/bi/vi"
	if test ! -f $VI; then
		echo "$VI was missing. Please install it."
	fi
	exit 1
fi

#--------------------------------------
# check argument.
#--------------------------------------
if test -z "$1"; then
	echo "Usage: $0 [ stylesheet-filename ]"
	exit 1
fi

#--------------------------------------
# Edit
#--------------------------------------
$LV -Iu8 -Oej $1 > $TMPFILE
sleep 1

if test ! -s $TMPFILE; then
	echo "Failed to conver \"$1\" to EUC-JP."
	exit 1
fi

$VI $TMPFILE
$LV -Iej -Ou8 $TMPFILE > $1
#rm -f $TMPFILE

exit 0
