//------------------------------------------------------------------------------
// Copyright (c) 2023 BAYBITS LLC, All rights reserved.
//------------------------------------------------------------------------------

var calendar;

$(function() {

	if (gMsie5mac) {
		var f = document.getElementsByTagName("form");
		f[0].style.display = "block";
	}
	else {
		$("form").fadeIn(300);
	}

	if ($('#expiredday').attr('data-iso8601') != "") {
		var local = convertUTCtoLocal($('#expiredday').attr('data-iso8601'));
		if (local) {
			var fmt = local.tfformat('Y/m/d H:i:s').split(' ');
			$('#expiredday').val(fmt[0]);
			$('#expiredtime').val(fmt[1]);
			$('#expiredday').attr('disabled', false);
			$('#expiredtime').attr('disabled', false);
		}
	}

	if ($('#publicationdate').attr('data-iso8601') != "") {
		var pubdate = convertUTCtoLocal($('#publicationdate').attr('data-iso8601'));
		$('#publicationdate').val(pubdate.tfformat('Y/m/d H:i:s'));
	}

	if ($('#sealingwax').prop('checked')) {
		$('#infofield').delay(200).slideDown(200);	
		$('#privacy').attr('disabled', false);
		$('#lbl-privacy').removeClass('gray');
	}
	calendar = new TfCalendar('calarea').create();
	calendar.onclickdate = function(id, year, month, date) {
		var d = new Date([year,month,date].join('/'));
		$('#expiredday').val(d.tfformat('Y/m/d H:i:s').split(' ')[0]);
		if ($('#expiredtime').val() === "") {
			$('#expiredtime').val("23:59:59");
		}

		this.hide();
		return false;
	}

	$('#copylink').click(function() {
			var tt = $('#tooltip');
			if (tt.is(':animated')) return;
			
			var linkurl = $('#linkurl');
			var accesscode = $('#accesscode');
			var codestr = "";
			if (accesscode.val().length>0) {
				codestr = "\n" + _X('Access Code') + ":" + accesscode.val() + "\n"
			}
			var y = linkurl.position().top - linkurl.height() * 2 - 5;
			var x = linkurl.width() / 2;

			var ta = $('<textarea>');
			$('body').append(ta);
			ta.val("\n" + linkurl.val() + codestr);
			ta.select();

			var result = document.execCommand('copy');
			if (result) {

				$('#tooltip div').text(_X('Copied to Clipboard'));

				tt.css({position: 'absolute', top: y, left: x})
                  .fadeIn(500).delay(1000).fadeOut(500);
			}

			ta.remove();
	});

	$('#detail').keypress(function(e) {
		var len = 0;
		if ($(this).val().length>0 && (e.which == 13 || e.KeyCode == 13)) {
			len = $(this).val().match(/\n/g).length;
			if (len > 2) { e.preventDefault(); }
		}
	});

	$('#sealingwax').click(function() {
		$('#privacy').attr('disabled', !this.checked);
		$('#lbl-privacy').toggleClass('gray');
	});

	$('#openmail').click(function() {
		location.href="mailto:?body=" + $('#linkurl').val();
	});

	$('#confirmlink').click(function() {
		window.open($('#linkurl').val(), '_blank');
	});

	$('#allorigin').click(function() {
		$('#allowedorigin').attr('disabled', this.checked);
	});

	$('#expiredday').click(function() {
		return calendarCtl(true, this.value);	
	});

	$('#expiredtime').timeEntry({show24Hours: true, showSeconds: true});

	$('#deleteBox').click(function() {
		document.frmCGI.hidCmd.value = "delete";
		$('#container').css('display', 'none');

		document.frmCGI.submit();
	});

	$('#close').click(function() {
		$('#container').fadeOut(500);
		var url = document.frmCGI.hidParentFolderUri.value;

		if (url) {
			location.href = url;
		}

	});

	$(document).on("click", "#pub-ok", function() {
		$('#modal').remove();
		document.frmCGI.hidCmd.value = "update";
		document.frmCGI.submit();
	});

	$(document).on("click", "[id^=modal-close]", function() {
		$('#modal').remove();
		$('#sideinfo').empty().removeClass("sideinfo-show");
	});

});

function calendarCtl(isshow, date) {

	if (date != "") {
		var val = date.match(/(\d+)\/(\d+)\/\d+/);
		calendar.update(null, val[1], val[2]);
	}

	$('#calarea').css('display', (isshow)?'block':'none');
}

function boxlimitwarning(boxlimit) {

	if (boxlimit == 0) return "";
	var msg;

	if (boxlimit/60<1) {
		msg = boxlimit + _X(" sec");
	}
	else if (boxlimit/60/24<60) {
		msg = parseInt(boxlimit/60) + _X(" min");
	}
	else if (boxlimit/60/60/24<3600) {
		msg = parseInt(boxlimit/60/60) + _X(" hour");
	}
	else {
		msg = parseInt(boxlimit/60/60/24) + _X(" days");
	}

	return _X("within") + " " + msg;

}

function publishDialog(withoutmail) {
	var modal = $('<div>').attr({id: 'modal', class: "modal"});
	var content = $('<div>').addClass("modal-content rad4").appendTo(modal);
	var header = $('<div>').addClass("modal-header").appendTo(content);
	var message = "";
	var title = _X("Would you like to save the settings?");

	if ($('#tomailaddr').val() != '' && $('#sealingwax').prop('checked')) {
		message = _X("Sent to the recipient's email address.");
	}

	if ($('#sealingwax').prop('checked')) {
		title = _X("Would you like to Publish it?");
	}

	var title = $('<label>').addClass("modal-title")
							.text(title)
							.appendTo(header);

	var close = $('<svg width="16" height="16"><line x1="16" y1="16" x2="0" y2="0" stroke="gray" stroke-width="1" /><line x1="0" y1="16" x2="16" y2="0" stroke="gray" stroke-width="1" /></svg>').attr({id: 'modal-closebtn', class: 'pointer'}).appendTo(header);

	var res = $('<div>').attr({
							id: 'del-resource',
							class: 'mt20 ti20 weak-color'
							}).text(message)
	if (withoutmail == 'off') {
		res.appendTo(content);
	}

	var msg = $('<div>').attr({
							id: 'modal-msg',
							class: 'modal-msg weak-color'
							}).text("")
							.appendTo(content);

	var act = $('<div>').attr({
							id: 'modal-act',
							class: 'modal-act mt20'
							});

	var ok = $('<button>').attr({
							id: 'pub-ok',
							class: 'button primary mr20',
							}).text(_X("Yes")).appendTo(act);

	var cal = $('<button>').attr({
							id: 'modal-close',
							class: 'button',
							}).text(_X("Cancel")).appendTo(act);;
	act.appendTo(content);
	$('body').append(modal);

}
