//------------------------------------------------------------------------------
// $Id$
// JavaScript tablesort functions
// Copyright (c) 2006,2007 BAYBITS LLC, All rights reserved.
//------------------------------------------------------------------------------

// for Browser
var _ua = navigator.userAgent.toLowerCase();
var _msie5mac = (_ua.indexOf("msie 5") != -1 && _ua.indexOf("mac_powerpc") != -1);

// Define global constant
var ORDER_ASC  = true;
var ORDER_DESC = false;
var TARGET_TYPE_STRING = 0;
var TARGET_TYPE_KBSTRING = 1;
var TARGET_TYPE_DATESTRING = 2;
var gNodeArray   = undefined;
var gNodeTopArray = undefined;
var gINodeArray  = 0;
var gSearchColId = -1;
var gSearchColId_old = 0;
var gSortOrders  = undefined;
var gTargetType  = TARGET_TYPE_STRING;

// -----------------------------------------------------------------------------
//
// -----------------------------------------------------------------------------
function initTableSortData() {
	var obj;
	
	if (typeof(gNodeArray) != 'undefined') {
		return;
	}
	
	gNodeArray    = new Array();
	gNodeTopArray = new Array();
	gSortOrders   = new Array();
	
	obj = document.getElementById('IdSortTblTarget');
	if (obj) {
		var lines = obj.getElementsByTagName('tr');
		if (lines) {
			var attr, n=0, m=0;
			for(var i = 0; i < lines.length; i++) {
				attr = lines[i].getAttribute("isTopLine");
				if (typeof(attr) != 'undefined' && attr == 'true') {
					gNodeTopArray[n++] = lines[i];
				}
				else {
					gNodeArray[m++] = lines[i];
				}
			}
			gINodeArray = gNodeArray.length;
		}
	}
}

// -----------------------------------------------------------------------------
//
// -----------------------------------------------------------------------------
function showTable(colId)
{
	var tdNodeList;
	var tbody = document.getElementById('IdSortTblTarget');

	initTableSortData();
	for (var i = 0; i < gINodeArray; i++) {
		if (_msie5mac) {
			gNodeArray[i].childNodes[gSearchColId].style.backgroundColor = "#e2e2ff";
			if (typeof(gSearchColId_old) != 'undefined' && gSearchColId_old != -1 && gSearchColId != gSearchColId_old) {
				gNodeArray[i].childNodes[gSearchColId_old].style.backgroundColor = "#f5f5ff";
			}
		}
		else {
			tdNodeList = gNodeArray[i].getElementsByTagName('td');

			tdNodeList[gSearchColId].style.backgroundColor = "#e2e2ff";
			if (gSearchColId_old != -1 && gSearchColId != gSearchColId_old) {
				tdNodeList[gSearchColId_old].style.backgroundColor = "inherit";
			}
		}
		tbody.appendChild(gNodeArray[i]);
	}
}

// -----------------------------------------------------------------------------
//
// -----------------------------------------------------------------------------
function clearTable()
{
	var tbody = document.getElementById('IdSortTblTarget');
	
	initTableSortData();
	for (var i = 0; i < gINodeArray; i++) {
		tbody.removeChild(gNodeArray[i]);
	}
}

// -----------------------------------------------------------------------------
//
// -----------------------------------------------------------------------------
function hasNodeValue(node)
{
	if (typeof(node.firstChild) != 'undefined' && node.firstChild &&
		typeof(node.firstChild.nodeValue) != 'undefined' && node.firstChild.nodeValue) {
		return true;
	}
	return false;
}

// -----------------------------------------------------------------------------
//
// -----------------------------------------------------------------------------
function sortComparator(a,b)
{
	var aNode, bNode, aNode2, bNode2;

	if (_msie5mac) {
		aNode = a.childNodes[gSearchColId];
		bNode = b.childNodes[gSearchColId];
	}
	else {
		aNode = a.getElementsByTagName('td')[gSearchColId];
		bNode = b.getElementsByTagName('td')[gSearchColId];
	}

	if (aNode) {
		aNode2 = aNode.getElementsByTagName('a')[0];
		if (aNode2) {
			aNode = aNode2;
		}
	}
	if (bNode) {
		bNode2 = bNode.getElementsByTagName('a')[0];
		if (bNode2) {
			bNode = bNode2;
		}
	}

	if (hasNodeValue(aNode) && hasNodeValue(bNode)) {
		var a2, b2;

		a2 = aNode.firstChild.nodeValue;
		b2 = bNode.firstChild.nodeValue;

		if (gTargetType == TARGET_TYPE_KBSTRING) {
			a2 = parseFloat(a2.replace(/[,KB\ ]/g,''));
			b2 = parseFloat(b2.replace(/[,KB\ ]/g,''));
		}
		else if (gTargetType == TARGET_TYPE_DATESTRING) {
			a2 = parseFloat(a2.replace(/[\/:\ ]/g,''));
			b2 = parseFloat(b2.replace(/[\/:\ ]/g,''));
		}

		if (a2 > b2) {
			return 1;
		}
		else if (a2 == b2) {
			return 0;
		}
		return -1;
	}
	else if (hasNodeValue(aNode) && !hasNodeValue(bNode)) {
		return 1;
	}
	else if (!hasNodeValue(aNode) && hasNodeValue(bNode)) {
		return -1;
	}
	return 0;
}

// -----------------------------------------------------------------------------
//
// -----------------------------------------------------------------------------
function sortStringColumn(colId)
{
	if (_msie5mac) {
		return false;
	}

	gTargetType = TARGET_TYPE_STRING;
	clearTable();
	showNotice();
	setTimeout('innerSortColumn(' + colId + ')', 100);

	return false;
}

// -----------------------------------------------------------------------------
//
// -----------------------------------------------------------------------------
function sortKBStringColumn(colId)
{
	if (_msie5mac) {
		return false;
	}

	gTargetType = TARGET_TYPE_KBSTRING;
	clearTable();
	showNotice();
	setTimeout('innerSortColumn(' + colId + ')', 100);

	return false;
}

// -----------------------------------------------------------------------------
//
// -----------------------------------------------------------------------------
function sortDateStringColumn(colId)
{
	if (_msie5mac) {
		return false;
	}

	gTargetType = TARGET_TYPE_DATESTRING;
	clearTable();
	showNotice();
	setTimeout('innerSortColumn(' + colId + ')', 100);

	return false;
}

// -----------------------------------------------------------------------------
//
// -----------------------------------------------------------------------------
function innerSortColumn(colId)
{
	var sortOrder;
	
	gSearchColId_old = gSearchColId;
	gSearchColId = colId;
	
	initTableSortData();
	gNodeArray.sort(sortComparator);
	
	sortOrder = gSortOrders[colId];
	if (typeof(sortOrder) == 'undefined' || sortOrder == ORDER_DESC) {
		gNodeArray.reverse();
		gSortOrders[colId] = ORDER_ASC;
	}
	else {
		gSortOrders[colId] = ORDER_DESC;
	}

	showTable(colId);
	clearNotice();
}

// -----------------------------------------------------------------------------
//
// -----------------------------------------------------------------------------
function showNotice()
{
	var oWin = document.getElementById('noticewindow');
	if (oWin) {
		oWin.style.display = "block";
	}
}

// -----------------------------------------------------------------------------
//
// -----------------------------------------------------------------------------
function clearNotice()
{
	var oWin = document.getElementById('noticewindow');
	if (oWin) {
		oWin.style.display = "none";
	}
}

function submitMail(uri)
{
	document.frmSubmit.action = uri;
	document.frmSubmit.mlsend.disabled = true;
	document.frmSubmit.submit();
	return false;
}

function cancelMail(uri)
{
	document.frmCancel.action = uri;
	document.frmCancel.method = 'GET';
	document.frmCancel.submit();
	return false;
}
