//------------------------------------------------------------------------------
// $Id$
// JavaScript common functions
// Copyright (c) 2003 - 2023 BAYBITS LLC, All rights reserved.
//------------------------------------------------------------------------------

// Define global constant

var gUa = navigator.userAgent.toLowerCase();

// for OS
var gWin = (gUa.indexOf("windows") != -1);

// for Browser
var gMsie5mac = (gUa.indexOf("msie 5") != -1 && gUa.indexOf("mac_powerpc") != -1);
var gMsie     = ((gUa.indexOf("msie") != -1) && (gUa.indexOf("opera") == -1) && (gUa.indexOf("windows") != -1));
var gGecko    = (gUa.indexOf("gecko") != -1);
var gOpera    = (gUa.indexOf("opera") != -1);

var gHost = location.protocol + "//" + location.host;

// ie11 findIndex support
if (!Array.prototype.findIndex) {
	Array.prototype.findIndex = function(predicate) {
		if (this === null) {
			throw new TypeError('Array.prototype find called on null or undefined');
		}
		if (typeof predicate !== 'function') {
			throw new TypeError('predicate must be a function');
		}
		var list = Object(this);
		var length = list.length >>> 0;
		var thisArg = arguments[1];
		var value;

		for (var i = 0; i < length; i++) {
			value = list[i];
			if (predicate.call(thisArg, value, i, list)) {
				return value;
			}
		}
		return undefined;
	};
}

window.onload = function() {
	try {
		/* old login page */
		if (document.body.id == "oldlogin") {
			document.input.id.focus();
		}
	} catch (e) {}
}

window.onclick = function(e) {
	var modal = document.getElementById("modal");
	if (modal && e.target == modal) {
		$('#modal').remove();
		$('#sideinfo').empty().removeClass("sideinfo-show");
	}
}

window.onkeyup = function(e) {
	var modal = document.getElementById("modal");
	if (modal && e.keyCode == 27) {
		$('#modal').remove();
		$('#sideinfo').empty().removeClass("sideinfo-show");
	}
}

function encodeUTF8str(src) {
	var enc = "";	
	var i, len, ch, cd;

	if (src == "") {
		return "";
	}

	len = src.length;
	for (i = 0; i < len; i++) {
		ch = src.charAt(i);
		uc = src.charCodeAt(i);


		// 1 byte string for UTF-8
		if (uc >= 0x0000 && uc <= 0x007f) {
		
			if (ch == " ") {
				enc += "%20";
			}
			// -_. 0123456789 abcdefghijklmnopqrstuvwxyzz ABCDEFGHIJKLMNOPQRSTUVWXYZ
			else if (ch == "-" || ch == "_" || ch == "." || (uc >= 0x30 && uc <= 0x39) || (uc >= 0x61 && uc <= 0x7a) || (uc >= 0x41 && uc <= 0x5a)) {
				enc += ch;
			}
			else {
				if (uc < 0x0f) {
					enc += "%0" + uc.toString(16);
				}
				else {
					enc += "%" + uc.toString(16);
				}
			}
		}
		// 2 byte string for UTF-8
		else if (uc >= 0x0080 && uc <= 0x07ff) {
			// xxxxx xxxxxx (Unicode) -> 110xxxxx + 10xxxxxx (UTF-8)
			sH = 0xc0 + ((uc & 0x07c0) >> 6);
			sL = 0x80 +  (uc & 0x003f);

			enc += "%" + sH.toString(16) + "%" + sL.toString(16);
		}
		// 3 byte string for UTF-8
		else if (uc >= 0x0800 && uc <= 0xffff) {
			// xxxx xxxxxx xxxxxx (Unicode) -> 1110xxxx + 10xxxxxx + 10xxxxxx (UTF-8)
			sH = 0xe0 + ((uc & 0xf000) >> 12);
			sM = 0x80 + ((uc & 0x0fc0) >> 6);
			sL = 0x80 +  (uc & 0x003f);

			enc += "%" + sH.toString(16) + "%" + sM.toString(16) + "%" + sL.toString(16);
		}
		// 4 byte string for UTF8 (Not supported)
		else {
			alert('Sorry, TeamFile does not support UCS4 character set.');
			return "";
		}
	}

	return enc;
}

function openwebfolder()
{
	alert('Sorry, this browser does not support this operation.');
}

// -----------------------------------------------------------------------------
// Check single byte character for SJIS
//
// @param c0 int previous character code. (0x00 -> ignore)
// @param c  int target charcter code.
// @return true / false
// -----------------------------------------------------------------------------
function isSjisSingleByte(c0, c)
{
	if ((c >= 0x00 && c <= 0x1F) || c == 0x7F) {
		return true;
	}
	else if (c >= 0x20 && c <= 0x3F) {
		return true;
	}
	else if (c >= 0x40 && c <= 0x7E) {
		if (!((c0 >= 0x81 && c0 <= 0x9F) || (c0 >= 0xE0 && c0 <= 0xFC))) {
			return true;
		}
	}
	else if (c >= 0xA1 && c <= 0xDF) {
		if (!((c0 >= 0x81 && c0 <= 0x9F) || (c0 >= 0xE0 && c0 <= 0xFC))) {
			return true;
		}
	}

	return false;
}

// -----------------------------------------------------------------------------
// Extract final path segment from path string.
//
// @param path String path-string
// @return String
// -----------------------------------------------------------------------------
function extractFileName(path)
{
	var fname;

	if (path == null || path == "") {
		return "";
	}

	if (gWin) {
		fname = path.split("\\");
		if (fname.legnth == 0) {
			return fname[0];
		}
		else {
			return fname[fname.length - 1];
		}
	}
	else {
		fname = path.split("/");
		if (fname.legnth == 0) {
			return fname[0];
		}
		else {
			return fname[fname.length - 1];
		}
	}
}

// -----------------------------------------------------------------------------
// get Parent URI from uri string.
//
// @param path String path-string 
// @return String
// -----------------------------------------------------------------------------
function getParentURI(path)
{
	var pos = path.lastIndexOf("/");

	if (pos>0) {
		return path.substring(0, pos+1);
	}

	return path;

}
// -----------------------------------------------------------------------------
// Check including KINSOKU character (see getKinsokuString())
//
// @param name String
// @return true: include KINSOKU  / false : NOT include KINSOKU
// -----------------------------------------------------------------------------
function isKinsokuName(name)
{
	var i, ch, len, c0, c;
	if (name == null || name == "") {
		return false;
	}

	c0 = 0x00;
	for (i = 0; i < name.length; i++) {
		ch = name.charAt(i);
		if (gMsie5mac) {
			if (i > 0) {
				c0 = name.charAt(i-1);
			}
			c  = ch.charCodeAt(0);

			if (!isSjisSingleByte(c0, c)) {
				i++;
				continue;
			}
		}

		if (ch == "\\" || (gWin && ch == "/") || (gWin && ch == ":") || (gWin && ch == "*") ||
			ch == "?"  || ch == "\"" || ch == "<" || ch == ">" || ch == "|") {
			return true;
		}
	}

	return false;
}

// -----------------------------------------------------------------------------
// Get KINSOKU string
//
// @return string
// -----------------------------------------------------------------------------
var gKinsokuStr = '\\ / : * ? " < > |';

function getKinsokuString()
{
	return gKinsokuStr;
}

// -----------------------------------------------------------------------------
// Get UTC To LocalTime
//
// @param  UTC string (Format ISO 8601 only)
// @return Date Object
// -----------------------------------------------------------------------------
function convertUTCtoLocal(utcstr)
{
	var d;
	var epoch = 0;
	var offset = 0;

	if (utcstr == null || utcstr == "") return null;

	// local offset
	offset =  new Date().getTimezoneOffset() * (60 * 1000);

	// ISO8601 format
	d = utcstr.match(/(\d+)-(\d+)-(\d+)T(\d+):(\d+):(\d+)Z/);
	if (d == null) { return null; }

	// UTC epoch
	epoch = new Date(d[1], d[2]-1, d[3], d[4], d[5], d[6]).getTime();

	var local = new Date();
	local.setTime(epoch - offset);

	return local;
}

// -----------------------------------------------------------------------------
// Local To UTC object
//
// @param  localdate ( format: yyyy/mm/dd )
// @param  localtime ( format: HH/MM/SS )
//
// @return Date Object
// -----------------------------------------------------------------------------
function convertLocalToUTC(localtime)  
{
	var d;
	var utc = new Date();
	var epoch;

	// japanease style
	d = localtime.match(/(\d+)\/(\d+)\/(\d+) (\d+):(\d+):(\d+)/);
	if (d == null) { return null; }

	epoch = new Date(d[1], d[2]-1, d[3], d[4], d[5], d[6]).getTime() + (utc.getTimezoneOffset()*60*1000);
	
	utc.setTime(epoch);

	return utc;
}

// -----------------------------------------------------------------------------
// Change TR color, Recover TR color
// 
// -----------------------------------------------------------------------------
var _gOrigColors;
function onFocusLine(obj)
{
	if (obj) {
		var tdNodeList = obj.getElementsByTagName('td');
		if (typeof(tdNodeList) != 'undefined' && tdNodeList) {
			_gOrigColors = new Array();
			for (var i = 0; i < tdNodeList.length; i++) {
				_gOrigColors[i] = tdNodeList[i].style.backgroundColor;
				tdNodeList[i].style.backgroundColor = "#d4ecff";
			}
		}
		
		var spanList = obj.getElementsByTagName('span');
		if (typeof(spanList) != 'undefined' && spanList && spanList.length != 0) {
			for (var i = 0; i < spanList.length; i++) {
				spanList[i].style.visibility = "visible";
			}
		}

	}
	return true;
}

function onBlurLine(obj)
{
	if (obj) {
		var tdNodeList = obj.getElementsByTagName('td');
		if (typeof(tdNodeList) != 'undefined' && tdNodeList) {
			for (var i = 0; i < tdNodeList.length; i++) {
				if (_gOrigColors) {
					tdNodeList[i].style.backgroundColor = _gOrigColors[i];
				}
				else {
					tdNodeList[i].style.backgroundColor = "#f5f5ff";
				}
			}
			_gOrigColors = null;
		}

		var spanList = obj.getElementsByTagName('span');
		if (typeof(spanList) != 'undefined' && spanList && spanList.length != 0) {
			for (var i = 0; i < spanList.length; i++) {
				spanList[i].style.visibility = "hidden";
			}
		}
	}
	return true;
}

function inFolder(id) 
{
	location.href = document.getElementById(id).href;
}

//
//
//
Date.prototype.tfformat = function(format) {
	var me = this;
	var t = {
		Y:function() { return me.getFullYear() } ,
		m:function() { return ('0' + (me.getMonth()+1)).slice(-2)},
		d:function() { return ('0' + me.getDate()).slice(-2)   },
		H:function() { return ('0' + me.getHours()).slice(-2)  },
		i:function() { return ('0' + me.getMinutes()).slice(-2)},
		s:function() { return ('0' + me.getSeconds()).slice(-2)}
	};

	return format.replace(/[YmdHis]/g, function(l) { return t[l].apply(me); });

}

Date.prototype.tfformatISO8601 = function() {

}


// -----------------------------------------------------------------------------
// calendar UI
//
// @param parent Element
// @return void
// -----------------------------------------------------------------------------
function TfCalendar(parent) {
	this.parent = document.getElementById(parent);
};

TfCalendar.prototype = {
	create: function(year, month, lang) {
		var me = this;
		me.lang = lang || 'ja';

		var table = document.createElement('table');
		table.className = 'tfcalendar';
		me.table = table;
		table.onclick = function(e) {
			var evt = e || window.event;
			var target = evt.target || evt.srcElement;
			if (target.tagName === 'A') {
				if (target.hash.indexOf('#tfcal-m-') === 0) {
					return me.update.apply(me, target.hash.match(/tfcal-m-(\d+)-(\d+)/));
				}
				else if (target.hash.indexOf('#tfcal-d-') === 0) {
					return me.onclickdate.apply(me, target.hash.match(/tfcal-d-(\d+)-(\d+)-(\d+)/));
				}
				else if (target.hash.indexOf('#tfcal-today-') === 0) {
					return me.update.apply(me, target.hash.match(/tfcal-today-(\d+)-(\d+)-(\d+)/));
				}
			}
			if (target.tagName === 'IMG') {
				me.hide();
			}
		}
		me.setDate(year, month);
		me.setCaption(me.year, me.month);
		me.setBody(me.year, me.month, me.lang);
		me.setFooter();
		this.parent.appendChild(me.table);

		return me;
	},
	hide: function() {
		this.parent.style.display = 'none';
	},
	remove: function() {
		this.parent.removeChild(this.table);
	},
	update: function(id, year, month) {
		this.remove();
		this.create(year, month);
		return false;
	},
	onclickdate: function(id, year, month, date) {
		return false;
	},
	setCaption: function(year, month) {
		var me = this;
		var caption = document.createElement('caption');
		var div   = document.createElement('div');
		var next  = document.createElement('a');
		var prev  = document.createElement('a');
		var close = document.createElement('img');

		close.src = '/icons/teamfile/tf_close.png';
		next.href = '#tfcal-m-' + ((month === 12) ? year+1 : year) + '-' + (month===12?1:month+1);
		prev.href = '#tfcal-m-' + ((month === 1) ? year-1 : year) + '-' + (month===1?12:month-1);
		next.innerHTML = '&rarr;';
		next.className = 'next';
		prev.innerHTML = '&larr;';
		prev.className = 'prev';

		var current = document.createElement('span');
		var text = document.createTextNode((me.lang == 'ja')?year + '/' + month:month + '/' + year);
		current.appendChild(text);
		div.appendChild(prev);
		div.appendChild(current);
		div.appendChild(close);
		div.appendChild(next);
		caption.appendChild(div);
		me.table.appendChild(caption);
	},
	setDate: function(year, month) {
		var me    = this;
		var today = new Date();
		me.year = parseInt(year,  10) || today.getFullYear();
		me.month= parseInt(month, 10) || today.getMonth()+1;
	},
	setBody: function(year, month) {
		var me    = this;
		var tbody = document.createElement('tbody');
		var first = new Date(year, month - 1, 1);
		var last  = new Date(year, month, 0);
		var first_day = first.getDay();
		var last_date = last.getDate();
		var today = new Date();
		var today_year  = today.getFullYear();
		var today_month = today.getMonth()+1;
		var today_date  = today.getDate();
		var date  = 1;
		var skip  = true;

		for (var row=0; row<7; row++) {
			var tr = document.createElement('tr');
			for (var col=0;col<7; col++) {
				if (row === 0) {
					var th = document.createElement('th');
					var day_ja = ['日', '月', '火', '水', '木', '金', '土'];
					var day_en = ['SUN', 'MON', 'TUE', 'WED', 'THR', 'FRI', 'SAT'];
					var day = eval("day_" + me.lang + "[col]");
					th.appendChild(document.createTextNode(day));
					th.className = 'header-day' + col;
					tr.appendChild(th);
				}
				else {
					if (row === 1 && first_day === col) { skip = false; }
					if (date > last_date) { skip = true; }

					var td = document.createElement('td');
					td.className = 'tfcal-day' + col;
					if (!skip) {
						var a = document.createElement('a');
						a.href = '#tfcal-d-' + year + '-' + month + '-' + date;
						a.appendChild(document.createTextNode(date));

						if (year === today_year && month === today_month && date === today_date) {
							a.className = 'tfcal-today';
						}
						td.appendChild(a);
						date++;
					}
					else {
						td.innerHTML='<span>&nbsp;</span>';
					}
					tr.appendChild(td);
				}
				tbody.appendChild(tr);
			}
		}
		me.table.appendChild(tbody);
	},
	setFooter: function() {
		var me    = this;
		var today = new Date();
		var tr    = document.createElement('tr');
		var td    = document.createElement('td');
		var div   = document.createElement('div');
		var a     = document.createElement('a');
		a.href    = "#tfcal-today-" + today.getFullYear() + '-' + parseInt(today.getMonth()+1) + '-' + today.getDate();
		a.appendChild(document.createTextNode((me.lang=='ja')?'本日':'Today'));
		div.appendChild(a);
		td.colSpan = 7;
		td.appendChild(div);
		tr.appendChild(td);
		me.table.appendChild(tr);
	}
};

// -----------------------------------------------------------------------------
//  show notify message
// -----------------------------------------------------------------------------
function showNotifyMessage(status, bgcode) {

	var msg;
	/* examples
	 * #009900 green success
	 * #ff6666 red   fail
	 */
	var bg = (bgcode === undefined) ? "#ff6666" : bgcode; // default error red!

	switch(status) {
		case 404:
			msg = _X("Could not find this folder or file.");
			break;

		case 412:
			msg = _X("File already exist.");
			break;

		case 423:
			msg = _X("File is Locked.");
			break;

		default:
			msg = status;
	}

	var elem = $("<div id='noticeboard'><table cellspacing='0' cellpadding='0' border='0'><td id='mainNoticeboardWindow'><div class='noticeboardContent'/></td></table></div>");
	$('body').append(elem);

	$('#mainNoticeboardWindow > div').css('background-color', bg).css('color', '#ffffff').html(msg);
	$('#noticeboard').animate({'top' : "4px"}, 500).delay(3000)
					 .animate({'top' : "-42px"}, {'duration':500,
					                              'complete': function() {
												  	elem.remove();
												  }});
	return false;

}

// -----------------------------------------------------------------------------
// GUID Generator
//
//
// -----------------------------------------------------------------------------
function guid() {
	var s4 = function() {
		return (((1+Math.random())*0x10000)|0).toString(16).substring(1);
	}
	return (s4()+s4()+"-"+s4()+"-"+s4()+"-"+s4()+"-"+s4()+s4()+s4());
}

// -----------------------------------------------------------------------------
// escape HTML
// -----------------------------------------------------------------------------
function escapeHTML(str) {
	return str.replace(/[&"'<>]/g, function(c) {
		return {
			"&": "&amp;",
			'"': "&quot;",
			"'": '&#x27;',
			"<": "&lt",
			">": "&gt;"
		}[c];
	});
}

// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------
RegExp.quote = function(str) {
	return (str+'').replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1");
}

function DragStart(event) 
{
	event.dataTransfer.setData("text", event.target.id);
}

function fixedEncodeURIComponent(str) {
	return encodeURIComponent(str).replace(/[!'()*]/g, function(c) {
								return '%' + c.charCodeAt(0).toString(16);
	});
}

// -----------------------------------------------------------------------------
// supportd localStorage
// -----------------------------------------------------------------------------
function availablelocalStorage() {
	try {
		if (typeof localStorage == 'undefined') {
			return false;
		}
	} catch(e) {
		return false;
	}

	return true;
}

// -----------------------------------------------------------------------------
// store local storage value
// -----------------------------------------------------------------------------
function storeLocalStorage(key, val) {
	if (availablelocalStorage()) {
		if (typeof(val) === 'boolean') {
			val = (val == true) ? 1 : 0;
		}
		window.localStorage.setItem(key, val);
	}
}

// -----------------------------------------------------------------------------
// expaneded fullname
// -----------------------------------------------------------------------------
function isExpandedfullname() {
	if (availablelocalStorage()) {
		var isExpanded = window.localStorage.getItem("isExpandedfullname");
		if (isNaN(isExpanded)) {
			return false;
		}
		return (isExpanded === "1");
	}
	return false;
}

// -----------------------------------------------------------------------------
// download URL
// -----------------------------------------------------------------------------
function downloadfile(url) {
	var fname = url.match(/name=(.*?)(&|$)/)[1];
	if (!fname) {
		alert("not found. filename param");
		return;
	}
	document.location = url;
}

// -----------------------------------------------------------------------------
// notify dialog
// -----------------------------------------------------------------------------
function notifydialog(title, message, lists) {

	let defer = $.Deferred();

	var modal = $('<div>').attr({id: 'modal', class: "modal"});
	var content = $('<div>').addClass("modal-content rad4").appendTo(modal);
	var header = $('<div>').addClass("modal-header").appendTo(content);

	$('<label>').addClass("modal-title").text(title).appendTo(header);
	$('<div>').attr({id: 'modal-msg',
					class: 'modal-msg weak-color'
					}).html(message).appendTo(content);

	if (typeof lists !== undefined) {
		lists.forEach(function(value) {
			$('<p>').text(value).appendTo(content);
		});
	}

	var act = $('<div>').attr({
							id: 'modal-act',
							class: 'modal-act mt20'
							})
							.appendTo(content);
	
	$('<button>').attr({id: 'confirm-ok',
						class: 'button mr20 primary',
						})
						.on('click', function() {
							modal.remove();
							defer.resolve();
						})
						.text("OK").appendTo(act);


	$('body').append(modal);

	return defer.promise();
}

// -----------------------------------------------------------------------------
// delete resource(delete)
// -----------------------------------------------------------------------------
function deleteResource(displayname) {

	var modal = $('<div>').attr({id: 'modal', class: "modal"});
	var content = $('<div>').addClass("modal-content rad4").appendTo(modal);
	var header = $('<div>').addClass("modal-header").appendTo(content);

	var title = $('<label>').addClass("modal-title")
							.text(_X("Would you like to delete it?"))
							.appendTo(header);

	var close = $('<svg width="16" height="16"><line x1="16" y1="16" x2="0" y2="0" stroke="gray" stroke-width="1" /><line x1="0" y1="16" x2="16" y2="0" stroke="gray" stroke-width="1" /></svg>').attr({id: 'modal-closebtn', class: 'pointer'}).appendTo(header);

	var res = $('<div>').attr({
							id: 'del-resource',
							class: 'mt20 ti20 weak-color'
							}).text(displayname)
							.appendTo(content);

	var msg = $('<div>').attr({
							id: 'modal-msg',
							class: 'modal-msg weak-color'
							}).text("")
							.appendTo(content);

	var act = $('<div>').attr({
							id: 'modal-act',
							class: 'modal-act mt20'
							});

	var ok = $('<button>').attr({
							id: 'del-ok',
							class: 'button primary mr20',
							}).text(_X("Yes")).appendTo(act);

	var cal = $('<button>').attr({
							id: 'modal-close',
							class: 'button',
							}).text(_X("Cancel")).appendTo(act);;
	act.appendTo(content);
	$('body').append(modal);

}

// -----------------------------------------------------------------------------
// delete multiple resource(delete)
// -----------------------------------------------------------------------------
function deleteMultipleResource(files) {

	var modal = $('<div>').attr({id: 'modal', class: "modal"});
	var content = $('<div>').addClass("modal-content rad4").appendTo(modal);
	var header = $('<div>').addClass("modal-header").appendTo(content);

	var title = $('<label>').addClass("modal-title")
							.text(_X("Delete These files?"))
							.appendTo(header);
	let fileCnt = files.length;

	var close = $('<svg width="16" height="16"><line x1="16" y1="16" x2="0" y2="0" stroke="gray" stroke-width="1" /><line x1="0" y1="16" x2="16" y2="0" stroke="gray" stroke-width="1" /></svg>').attr({id: 'modal-closebtn', class: 'pointer'}).appendTo(header);

	var res = $('<div>').attr({
							id: 'del-resource',
							class: 'mt20 ti20 weak-color'
							}).text(fileCnt + _X(" of the files will be removed."))
							.appendTo(content);
	var msg = $('<div>').attr({
							id: 'modal-msg',
							class: 'modal-msg weak-color'
							}).text("")
							.appendTo(content);

	var act = $('<div>').attr({
							id: 'modal-act',
							class: 'modal-act mt20'
							});

	var ok = $('<button>').attr({
							id: 'del-multi-ok',
							class: 'button primary mr20',
							}).text(_X("Yes")).appendTo(act);

	var cal = $('<button>').attr({
							id: 'modal-close',
							class: 'button',
							}).text(_X("Cancel")).appendTo(act);;
	act.appendTo(content);
	$('body').append(modal);

}

// -----------------------------------------------------------------------------
// create folder(mkcol)
// -----------------------------------------------------------------------------
function mkcollection() {

	var modal = $('<div>').attr({id: 'modal', class: "modal"});
	var content = $('<div>').addClass("modal-content rad4").appendTo(modal);
	var header = $('<div>').addClass("modal-header").appendTo(content);

	var title = $('<label>').addClass("modal-title")
							.text(_X("Create Folder"))
							.appendTo(header);

	var close = $('<svg width="16" height="16"><line x1="16" y1="16" x2="0" y2="0" stroke="gray" stroke-width="1" /><line x1="0" y1="16" x2="16" y2="0" stroke="gray" stroke-width="1" /></svg>').attr({id: 'modal-closebtn', class: 'pointer'}).appendTo(header);

	var txt = $('<input>').attr({
							type: 'text',
							id: 'mkcol-name',
							name: 'mkcol-name',
							placeholder: _X("New Folder"),
							class: 'input-basic wide mt20',
							maxlength: '60'
							}).appendTo(content);

	var msg = $('<p>').attr({
							id: 'mkcol-msg',
							class: 'modal-msg',
							}).appendTo(content);

	var act = $('<div>').attr({
							id: 'modal-act',
							class: 'modal-act mt20'
							});

	var ok = $('<button>').attr({
							id: 'mkcol-ok',
							class: 'button mr20 disabled',
							disabled: true
							}).text(_X("Create")).appendTo(act);

	var cal = $('<button>').attr({
							id: 'modal-close',
							class: 'button',
							}).text(_X("Cancel")).appendTo(act);;
	act.appendTo(content);

	$('body').append(modal);
	txt.focus();
}

// -----------------------------------------------------------------------------
// rename
// -----------------------------------------------------------------------------
function rename(id, img) {

	var obj = $("#f" + id);
	var objd= $("#d" + id);
	var oldname = obj.text();
	var point = oldname.lastIndexOf('.');
	var filename, ext;

	if (point>0) {
		ext = oldname.substring(point);
		filename = oldname.substring(0, point);
	} else {
		filename = oldname;
		ext = "";
	}
	var parent = document.frmSubmit.hidCurrentFolderUri.value.split('?', 1)[0] + "/";

	var ischange = false;
	var edit = $("<input id='renamebox' type='text' style='margin-right: 2px; margin-left: -4px;' size='20' maxlength='255'/>");
	var loader = $("<img src='/icons/teamfile/tf_loader.gif'/>");
	edit.keypress(function(e) {
		if (e.which == 13) { 
			this.blur();
		}
	})

	obj.before(edit).html(ext);
	$(img).css('display', 'none');
	edit.focus();
	edit.val(filename);

    /* name update */
	edit.blur(function() {
		var prefix = $.trim($(this).val());
		var newname = $(this).val() + ext;
		var hidtoken = document.frmSubmit.hidtoken || '';

		if (prefix != "" && prefix != filename) { ischange = true; }

		if (isKinsokuName(newname)) {
			// kinsoku error
			ischange = false;
			showNotifyMessage(_X("You can not use following character. \\ / : * ? \" > < |"));
		}

		if (ischange === false) {
			obj.text(oldname);
			$(this).remove();
			$(img).css('display', 'inline');

			return false;
		}

		$(this).remove();
		obj.before(loader);

		var encfoldname;
		var encfnewname;
		if (typeof(encodeURIComponent) == 'undefined') {
			encfoldname = encodeUTF8str(oldname);
			encfnewname = encodeUTF8str(newname);
		}
		else {
			encfoldname = fixedEncodeURIComponent(oldname);
			encfnewname = fixedEncodeURIComponent(newname);
		}
		$.ajax({
			url: parent + encfoldname,
			type: 'MOVE',
			cache: false,
			async: true,
			beforeSend: function(xhr) {
				xhr.setRequestHeader("Destination", gHost + parent + encfnewname);
				xhr.setRequestHeader("Overwrite", "F");
				xhr.setRequestHeader("TF-Client-Info", "mb11111");
				xhr.setRequestHeader("X-Content-Type-Options", "nosniff");
				xhr.setRequestHeader("X-CSRF-Token", hidtoken.value);
			},
			success: function(data, dataType) {
				obj.attr('href', parent+encfnewname);

			},
			error: function(xhr, text, err) {
			},
			complete: function(xhr, status) {
				if (status === 'error') {
					obj.text(oldname);
					loader.remove();
					$(img).css('display', 'inline');
					showNotifyMessage(xhr.status);
				}
				else if (status === 'success') {
					document.frmSubmit.method = "GET";
					document.frmSubmit.action = $("[name='hidCurrentFolderUri']").val();
					document.frmSubmit.submit();
				}
			}
		});
	});

	return false;
}


function fileContentsInit() {

	$(document).on("click", "[id^=modal-close]", function() {
		$('#modal').remove();
		$('#sideinfo').empty().removeClass("sideinfo-show");
	});

	$(document).on("focus", "#mkcol-name", function() {
		$('#mkcol-msg').text("");
		return false;
	});

	$('input[name="btnMkcol"]').on('click', function() {
		mkcollection();
	});

	var ws = "nowrap"; var ww = "normal";
	if (isExpandedfullname()) {
		ws = "normal"; ww = "break-word";
	}
	$("[id^='#f']").css('white-space', ws).css('word-wrap', ww);

	$('#fname-text-expanded').change(function() {
		storeLocalStorage("isExpandedfullname", $(this).is(':checked'));
		var ws = "nowrap"; var ww = "normal";
		if (isExpandedfullname()) {
			ws = "normal"; ww = "break-word";
		}
		$("[id^='#f']").css('white-space', ws).css('word-wrap', ww);
	})
	.prop('checked', isExpandedfullname());

	$(document).on('keyup', "#mkcol-name", function() {
		var foldername = $(this).val();
		var errmsg = " ";
		if (foldername.length == 0) {
			$('#mkcol-ok').prop('disabled', true).addClass('disabled').removeClass('primary');
		}
		else {
			if (isKinsokuName(foldername)) {
				errmsg = _X("You can not use following character. \\ / : * ? \" > < |");

				$('#mkcol-ok').prop('disabled', true).addClass('disabled').removeClass('primary');
			}
			else {
				$('#mkcol-ok').prop('disabled', false).removeClass('disabled').addClass('primary');
			}
		}

		$('#mkcol-msg').text(errmsg);
	});

	$(document).on("click", "#del-ok", function() {
		var delname = $('#del-resource').text();
		var currentfolder = document.frmSubmit.hidCurrentFolderUri.value.split('?', 1);
		var hidtoken = document.frmSubmit.hidtoken || '';
		var encfname;
		if (typeof(encodeURIComponent) == 'undefined') {
			encfname = encodeUTF8str(delname);
		}
		else {
			encfname = encodeURIComponent(delname);
		}


		$.ajax({
			url: currentfolder + "/" + encfname,
			type: 'DELETE',
			cache: false,
			async: true,
			statusCode: {
				403: function() {
					$('#modal-msg').text(_X("Access denied."));
				},
				423: function() {
					$('#modal-msg').text(_X("The resource has locked."));
				},
				404: function() {
					$('#modal').remove();
					location.href = document.frmSubmit.hidCurrentFolderUri.value;
				}
			},
			beforeSend: function(xhr) {
				xhr.setRequestHeader("TF-Client-Info", "mb11111");
				xhr.setRequestHeader("X-CSRF-Token", hidtoken.value);
			}
		})
		.done(function(data) {
			$('#modal').remove();
			location.href = document.frmSubmit.hidCurrentFolderUri.value;
		})
		.fail(function() {
			$('#mkcol-msg').text(_X('Failed to deleted.'));
		});

	});

	$(document).on("click", "#del-multi-ok", function() {

		$(this).attr('disabled', true);
		let currentfolder = document.frmSubmit.hidCurrentFolderUri.value.split('?', 1);
		var hidtoken = document.frmSubmit.hidtoken || '';
		let files = [];

		$('[data-pos]').each((i, v) => {
			let encname;
			if ($(v).is(':checked')) {
				if (typeof(encodeURIComponent) == 'undefined') {
					encfname = encodeUTF8str($(v).data('resource'));
				}
				else {
					encfname = encodeURIComponent($(v).data('resource'));
				}

				files.push(currentfolder + "/" + encfname);
			}
		});

		let total = files.length;

		let progress = $('<progress>').attr({
											id: 'del-progress',
											class: 'wide',
											max: total,
											value: total,
											style: 'height: 8px'
											})
											.appendTo($('#modal-msg'));

		const exec = (async() => {
			let i = 1;
			let failCnt = 0;
			let headers = {"X-CSRF-Token" : hidtoken.value};

			for (const file of files) {
				const result = await fetch(file , {	method: 'DELETE',
													headers: headers})
									 .then((response) => {
										if (!response.ok) {
											failCnt++;
										}
									 });

				$('#del-progress').attr('value', total - i++);
			}
			location.href = document.frmSubmit.hidCurrentFolderUri.value;
		})();

		exec();

	});

	$(document).on("click", "#mkcol-ok", function() {
		var foldername = $('#mkcol-name').val();
		var hidtoken = document.frmSubmit.hidtoken || '';
		if (foldername == null || foldername == "") {
			$('#modal').remove();
			return false;
		}

		if (isKinsokuName(foldername)) {
			$('#mkcol-msg').text(_X("You can not use following character. \\ / : * ? \" > < |"));
			return;
		}

		var encfname;
		if (typeof(encodeURIComponent) == 'undefined') {
			encfname = encodeUTF8str(foldername);
		}
		else {
			encfname = encodeURIComponent(foldername);
		}

		var currentfolder = document.frmSubmit.hidCurrentFolderUri.value.split('?', 1);
		$.ajax({
			url: currentfolder + "/" + encfname,
			type: 'MKCOL',
			cache: false,
			async: true,
			statusCode: {
				403: function() {
					$('#modal-msg').text(_X("Access denied."));
				},
				405: function() {
					$('#mkcol-msg').text(_X("The folder already exists."));
				}
			},
			beforeSend: function(xhr) {
				xhr.setRequestHeader("TF-Client-Info", "mb11111");
				xhr.setRequestHeader("X-CSRF-Token", hidtoken.value);
			}
		})
		.done(function(data) {
			$('#modal').remove();
			location.href = document.frmSubmit.hidCurrentFolderUri.value;
		})
		.fail(function() {
			$('#mkcol-msg').text(_X('Failed to deleted.'));
		});

	});

	$('#listContent img[data-showbox]').on('click', function() {

		$('#filelist').fadeOut(500);

		var target = document.frmSubmit.hidRootFolderUri.value;
		var uri = document.frmSubmit.hidCurrentFolderUri.value.split("?");
		var encname;
		if (typeof(encodeURIComponent) == 'undefined') {
			encname = encodeUTF8str($(this).data('showbox'));
		}
		else {
			encname = fixedEncodeURIComponent($(this).data('showbox'));
		}

		document.frmSubmit.hidCurrentFolderUri.value
					= uri[0] + "/" + encname + "?" + uri[1];

		document.frmSubmit.action = target + "/.cgi-bin/box";
		document.frmSubmit.submit();
		return false;

	});

	$('#listContent img[data-resource]').on('click', function() {
		deleteResource($(this).data('displayname'));

	});

	$('#listContent img[data-shorten]').on('click', function() {

		var tt = $('#tooltip');
		var url = document.frmSubmit.hidRootUri.value + $(this).data('shorten');
		var e = $('<input>'); e.val(url);
		e.css({position: 'absolute', top: -100});
		$('body').append(e); e.select();
		var result = document.execCommand('copy');
		if (result) {
			$('#tooltip div').text(_X('Copied to Clipboard'));
			tt.css({position: 'absolute', top: $(this).offset().top - 60, left: $(this).offset().left - 20})
			  .fadeIn(500).delay(1000).fadeOut(200);

		}
		e.remove();

	});

	$('#allresource').change(function() {
		let delbtn = $('#btnDelete');
		if ($(this).prop("checked")) {
			$('[data-pos]').prop('checked', true);
			delbtn.prop('disabled', false);
		}
		else {
			$('[data-pos]').prop('checked', false);
			delbtn.prop('disabled', true);
		}
	});

	$('[data-pos]').change(function() {
		let ischecked = $(this).is(':checked');
		let res = $('[data-pos]');
		let cntOn = cntOff = 0;


		res.each(function(i, v) {
			if ($(v).is(':checked') == true) {
				cntOn++;
			}
			else {
				cntOff++;
			}
		});
		$('#btnDelete').prop('disabled', cntOn == 0);
		$('#allresource').prop('checked', cntOn == $('[data-pos]').length);
	});

	$('#btnDelete').click(function() {
		let files = [];

		$('[data-pos]').each(function(i, v) {
			if ($(v).is(':checked')) {
				files.push(v);
			}
		});

		deleteMultipleResource(files);
	});
}

function decipherNumericValue(code) {
	var ary = code.split('');
	var tbl = ['F','J','w','m','E','h','c','k','a','z'];
	var val = "";

	ary.forEach(function(v, i) {
		val += tbl.findIndex(function(item) {
			return item === v;
		});
	});

	return val;
}

function checkServerInfo() {

	$.ajax({
		url: location.href.split('?', 1),
		type: 'OPTIONS',
		cache: false,
		async: true,
		beforeSend: function(xhr) {
			xhr.setRequestHeader("TF-Client-Info", "mb11111");
		},
		success: function(data, dataType, xhr) {
			var state = xhr.getResponseHeader("TF-RESULTSTATE");
			if (state != null && state != "") {
				notifyresultstate(state);
			}
		}
	});
}
