//------------------------------------------------------------------------------
// $Id$
// JavaScript upload policy functions
// Copyright (c) 2003 - 2023 BAYBITS LLC, All rights reserved.
//------------------------------------------------------------------------------

$(function() {

	$('div[data-tag-name]').on('mouseover', function() {
		var tt = $('#tooltip');
		var val = $(this).data('tag-name');
		$('#tooltip div').text(val);
		tt.css({position: 'absolute', top: $(this).offset().top - tt.height() - 17, left: $(this).offset().left}).show();
	})
	.on('mouseleave', function() {
		var tt = $('#tooltip');
		tt.hide();
	}).on('click', function() { 
		edituploadpolicy(document.frmSubmit.hidRootFolderUri.value, $(this).data('uploadpolicy-group'));
	});

	$(document).on('click', '#uploadpolicy-ok', function() {
		$(this).prop('disabled', true);
		var groupcoluri = decodeURI($('#hiddengroupcoluri').val());
		var webdav = new WebDAV(document.frmSubmit.hidRootFolderUri.value, document.frmSubmit.hidtoken.value);

		webdav.group_search_by_groupcoluri(groupcoluri)
		.then(function(xml) {
			var href = $(xml).find('D\\:href').text();

			var defxml = build_group_property(xml, builduploadpolicyXML());
			webdav.patch_group_uploadpolicy(groupcoluri, href, defxml)
			.then(function() {
				location.href = document.frmSubmit.hidCurrentFolderUri.value;
			});
		})
	})
	.on('focus', '#rulefname', function() {
		var tt = $('#alertinfo');
		$('#alertinfo div').html(_X("ex: <br/>Sales report*<br/><br/>${Userid}(user id)<br/>${groupname}(group name)<br/>${parentfolder}(upload folder)"));
		tt.css({position: 'absolute',
			    top: $(this).position().top - tt.height() - 12,
				left: $(this).position().left + 180}
		).show();
	})
	.on('focusout', '#rulefname', function() {
		$('#alertinfo').hide();
	})
	.on('mouseover', 'div[data-target-id]', function() {
		var val = $(this).data('target-id');
		$("#" + val).addClass('hlborder');
	})
	.on('mouseleave', 'div[data-target-id]', function() {
		var val = $(this).data('target-id');
		$("#" + val).removeClass('hlborder');
	})
	.on('keyup', '#rulelen', function() {
		var val = $(this).val();
		var len = val.length;
		if (len<1) {
			$('#alertinfo').hide();
			$('#uploadpolicy-ok').prop({'disabled': false})
								 .addClass('primary')
								 .removeClass('disabled');
			return;
		}

		var res = val.match(/[0-9,-]+/);
		if (res != null) {
			if (res[0].length == val.length) {
				$('#alertinfo').hide();
				$('#uploadpolicy-ok').prop({'disabled': false})
									 .addClass('primary')
									 .removeClass('disabled');
				return;
			}
		}
		$('#uploadpolicy-ok').prop({'disabled': true})
							 .addClass('disabled')
							 .removeClass('primary');
		var tt = $('#alertinfo');
		$('#alertinfo div').text(_X("number , - and comma-separated only"));
		tt.css({position: 'absolute',
			    top: $(this).position().top - tt.height() - 12,
				left: $(this).position().left + 180}
		).show();
	});

});

// Edit upload policy 
function edituploadpolicy(rooturi, groupuri) {

	let uri = groupuri.split('?')[0];
	let uid = document.frmSubmit.hiduserid.value;
	let token = document.frmSubmit.hidtoken.value;

	var webdav = new WebDAV(rooturi, token);

	webdav.isEditAble(uid)
	.done(function(isEditAble) {
			webdav.group_search_by_groupcoluri(decodeURI(uri))
			.done(function(data) {
				if (!isEditAble) {
					let stratum = $(data).find('D\\:href').text().split('/').length;
					isEditAble = stratum > 6 && $(data).find('TF\\:ownerid').text() == uid;
				}
				buildPolicyDialog(data, isEditAble);
			});
	})
	.fail(function(data) {
		notifydialog("Error", "Failed to Group Information.");
	});

}

function buildPolicyDialog(xmldoc, isEditAble) {

	let doc;
	let ary = [];

	let readonly = !isEditAble;
	let actprimary = (isEditAble)?"primary":"disabled";
	let actremove = (isEditAble)?"remove":"disabled";

	let updatedate = "";
	let filenames = "";
	let suffix = "";
	let lenstr = "";

	let rulechar_chk = false;
	let rulenumber_chk = false;

	let matchall_chk = false;
	let matchany_chk = false;

	let rulehidden_chk = false;
	let active_chk = false;

	var ele;
	ele = $(xmldoc).find('TF\\:uploadpolicy').find('TF\\:updatedate');

	if (ele.length > 0 && $(ele).text()) {
		updatedate = convertUTCtoLocal($(ele).text()).tfformat('Y/m/d H:i:s');
	}

	/* group name */
	let gname = ($(xmldoc).find('TF\\:name')).text();

	/* hidden */
	rulehidden_chk = ($(xmldoc).find('TF\\:hidden').length>0);

	let targeturi = $(xmldoc).find('TF\\:groupcollectionuri').text();

	active_chk = ($(xmldoc).find('TF\\:rulestate').find('TF\\:active').length>0);

	ele = $(xmldoc).find('TF\\:rule');
	if (ele.length>0) {
		/* filename */
		ele.find('TF\\:filename').each(function(i, e) {
				ary.push($(e).text());
		});
		filenames = ary.join('\n');

		ary = [];
		/* suffix */
		ele.find('TF\\:suffix').each(function(i, e) {
				ary.push($(e).text());
		});
		suffix = ary.join(',');
		/* length */
		lenstr = ele.find('TF\\:length').text();

		/* char type */
		if (ele.find('TF\\:chartype').find('TF\\:number').length>0) {
			rulenumber_chk = true;
		}
		if (ele.find('TF\\:chartype').find('TF\\:alphabet').length>0) {
			rulechar_chk = true;
		}

		/* match type */
		if (ele.find('TF\\:matchtype').find('TF\\:all').length>0) {
			matchall_chk = true;
		} else if (ele.find('TF\\:matchtype').find('TF\\:any').length>0) {
			matchany_chk = true;
		}

	}
	else {
		matchall_chk = true;
	}

	let modal = $('<div>').attr({id: 'modal', class: "modal"});
	let content = $('<div>').addClass("modal-content rad4").appendTo(modal);
	let header = $('<div>').addClass("modal-header").appendTo(content);

	$('<label>').addClass("modal-title")
				.text(_X("Upload Policy") + " [" + gname + "]")
				.appendTo(header);

	$('<svg width="16" height="16"><line x1="16" y1="16" x2="0" y2="0" stroke="gray" stroke-width="1" /><line x1="0" y1="16" x2="16" y2="0" stroke="gray" stroke-width="1" /></svg>').attr({id: 'modal-closebtn', class: 'pointer'}).appendTo(header);

	let divactive = $('<div>').attr('id', 'zone-active').addClass("modal-title mb10 mt20").appendTo(content);

	$('<input>').addClass("pointer").attr({
									id: "active",
									type: "checkbox",
									checked: active_chk,
									readonly: readonly,
	}).prop('disabled', readonly).appendTo(divactive);

	$('<label>').addClass("chklabel").attr({
									for: "active",
	}).text(_X("Active")).appendTo(divactive);

	let conddiv = $('<div>').attr('id', 'zone-cond').addClass("modal-title mb10 mt20").appendTo(content);
	$('<input>').attr({id: "matchall", type: "radio",
					   name: "matchtype", checked: matchall_chk,
					   value: "all",
	}).appendTo(conddiv);

	$('<label>').addClass("radio-normal").attr({
									for: "matchall"
	}).text(_X("All")).appendTo(conddiv);

	$('<input>').attr({ id: "matchany",
						type: "radio",
						name: "matchtype",
						checked: matchany_chk,
						value: "any",
	}).prop('disabled', readonly).text(_X("All")).appendTo(conddiv);

	$('<label>').addClass("radio-normal").attr({
									for: "matchany"
	}).text(_X("Any")).appendTo(conddiv);


	let fnamediv  = $('<div>').attr('id', 'zone-filename').appendTo(content);

	$('<p>').addClass("modal-title")
	.text(_X("File Name(1line 1rule, 1000 byte)"))
	.attr({class: 'mb10 mt20'}) .appendTo(fnamediv);

	$('<textarea>').attr({type: 'text',
						  id: 'rulefname',
						  name: 'rulefname',
						  class: 'textarea-basic wide resize-v',
						  readonly: readonly,
						  maxlength: 1000,
	}).css({'height' : '90px', 'min-height': '90px'}).text(filenames)
	.appendTo(fnamediv);

	let extentiondiv = $('<div>').attr('id', 'zone-extention').appendTo(content);
	$('<p>').addClass("modal-title")
	.text(_X("Extention(comma-separated)"))
	.attr({class: 'mb10 mt20'}).appendTo(extentiondiv);

	$('<input>').attr({ type: 'text', id: 'rulesuffix',
						name: 'rulesuffix',
						placeholder: _X("pdf,ppt,xls*,doc*"),
						class: 'input-basic wide',
						maxlength: '60',readonly: readonly,
						value: suffix, maxlength: 1000,
	}).prop('disabled', readonly).appendTo(extentiondiv);

	let lengthdiv = $('<div>').attr('id', 'zone-length').appendTo(content);

	$('<p>').addClass("modal-title")
			.text(_X("Length(comma-separated)"))
			.attr({class: 'mb10 mt20'})
			.appendTo(lengthdiv);

	$('<input>').attr({ type: 'text',
						id: 'rulelen',
						name: 'rulelen',
						placeholder: _X("8,9,10"),
						class: 'input-basic wide',
						maxlength: '60',
						readonly: readonly,
						value: lenstr
						})
	.prop('disabled', readonly).appendTo(lengthdiv);

	let chardiv = $('<div>').addClass("modal-title")
							.text(_X("Char Type"))
							.attr({'id': 'zone-char', class: 'mb10 mt20'})
							.appendTo(content);

	let rulechar = $('<input>').addClass("pointer")
							   .attr({
									id: "rulechar",
									type: "checkbox",
									checked: rulechar_chk,
									readonly: readonly,
							   })
							   .prop('disabled', readonly)
							   .appendTo(chardiv);

	let rulechar_l = $('<label>').addClass("chklabel")
								 .attr({
									for: "rulechar"
								 })
								 .text(_X("Alphabet"))
								 .appendTo(chardiv);

	let rulenum = $('<input>').addClass("pointer")
							   .attr({
									id: "rulenumber",
									type: "checkbox",
									checked: rulenumber_chk,
									readonly: readonly,
							    })
							   .prop('disabled', readonly)
							   .appendTo(chardiv);

	let rulenum_l = $('<label>').addClass("chklabel")
							   .attr({
									for: "rulenumber",
							   })
							   .text(_X("Number"))
							   .appendTo(chardiv);

	let divhidden = $('<div>').addClass("modal-title mb10 mt20")
							  .attr('id', 'zone-hidden').appendTo(content);

	let rulehidden = $('<input>').addClass("pointer")
							   .attr({
									id: "rulehidden",
									type: "checkbox",
									checked: rulehidden_chk,
									readonly: readonly,
							    })
							   .prop('disabled', readonly)
							   .appendTo(divhidden);

	let rulehidden_l = $('<label>').addClass("chklabel")
							   .attr({
									for: "rulehidden",
							   })
							   .text(_X("hidden"))
							   .appendTo(divhidden);

	let divdate = $('<div>').addClass("modal-title mb10 mt20")
							.text(_X("Appli date"))
							.appendTo(content);

	$('<div>').addClass("mr20").text(updatedate).appendTo(divdate);

	var act = $('<div>').attr({id: 'modal-act', class: 'modal-act mt20' });

	if (!isEditAble) {
		$('<span>').attr("class", "mr20").text(_X('not authorized.')).appendTo(act);
	}
	$('<button>').attr({id: 'uploadpolicy-ok',
						class: 'button mr20 ' + actprimary,
	}).prop('disabled', readonly).text(_X("Set")).appendTo(act);

	$('<button>').attr({id: 'modal-close',
						class: 'button',
	}).text(_X("Cancel")).appendTo(act);;

	act.appendTo(content);

	$('<input>').attr({ id: 'hiddengroupcoluri',
						type: 'hidden',
						value: targeturi,
	}).appendTo(content);

	var dialoginfo = $('<div>').attr({id: 'alertinfo',
									class: 'tooltip'
	}).appendTo(content);

	$('<div>').attr({class: 'inner'}).appendTo(dialoginfo);

	$('<b>').appendTo(dialoginfo);

	$('body').append(modal);

	if (!isEditAble) return;

	let sideinfo = $('#sideinfo');
	$('<div>').addClass("strong bb1e8").text(_X("Upload Policy")).appendTo(sideinfo);
	$('<div>').html(_X("Set an upload policy to restrict the types of files that can be uploaded to the group.<br/><br/>When this rule is set, all members of the group will be notified by email of the rule settings.")).appendTo($('#sideinfo'));
	$('<div>').addClass('strong bb1e8').attr('data-target-id', 'zone-active').text(_X("Active")).appendTo(sideinfo);
	$('<div>').text(_X('Check this box if you want to apply the rule.')).appendTo(sideinfo);
	$('<div>').addClass('strong bb1e8').attr('data-target-id', 'zone-cond').text(_X('Conditions')).appendTo(sideinfo);
	$('<div>').text(_X('Specify whether files must match all of the set rules or any of the conditions to be permitted.')).appendTo(sideinfo);
	$('<div>').addClass('strong bb1e8').attr('data-target-id', 'zone-filename').text(_X('File Name')).appendTo(sideinfo);
	$('<div>').text(_X('You can set each condition on a separate line. Each line will be evaluated as "OR."')).appendTo(sideinfo);
	$('<div>').addClass('strong bb1e8').attr('data-target-id', 'zone-extention').text(_X('Extentions')).appendTo(sideinfo);
	$('<div>').text(_X('Specify the allowed file extensions separated by commas.')).appendTo(sideinfo);
	$('<div>').addClass('strong bb1e8').attr('data-target-id', 'zone-length').text(_X('Length(comma-separated)')).appendTo(sideinfo);
	$('<div>').text(_X('Specify the length of the file name (excluding the extension) separated by commas. You can also specify a range like 1-8. Half-width characters count as 1 character, and full-width characters count as 3 characters.')).appendTo(sideinfo);
	$('<div>').addClass('strong bb1e8').attr('data-target-id', 'zone-char').text(_X('Char Type')).appendTo(sideinfo);
	$('<div>').text(_X('You can specify alphabets, numbers, or both.')).appendTo(sideinfo);
	$('<div>').addClass('strong bb1e8').attr('data-target-id', 'zone-hidden').text(_X('Hidden')).appendTo(sideinfo);
	$('<div>').text(_X('Do not disclose the above rules to group members.')).appendTo(sideinfo);

	$('#sideinfo').addClass('sideinfo-show sidelg');
}

function build_group_property(xml, policyelement) {
	var webdav = new WebDAV();
	var doc = $.parseXML(
		'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><D:propertyupdate xmlns:D="DAV:" xmlns:TF="http://www.teamfile.com/DTD/TF/"><D:set><D:prop><TF:groupdiscovery><TF:groupinfo></TF:groupinfo></TF:groupdiscovery></D:prop></D:set></D:propertyupdate>'
	);
	var ginfo = $(doc).find('TF\\:groupinfo');
	var val_comment = $(xml).find('TF\\:comment').text();
	var comment = $(_N('comment')).append(doc.createCDATASection(val_comment));
	ginfo.append(comment);
	var val_mailwatch = $(xml).find('TF\\:groupmailwatch').find(
		'TF\\:triggermethod').text();
	var mailwatch;
	if (val_mailwatch) {
		mailwatch = $(xml).find('TF\\:groupmailwatch');
	} else {
		mailwatch = $(_N('groupmailwatch'));
	}
	ginfo.append(mailwatch);
	var constraints = $(xml).find('TF\\:constraints');
	constraints = webdav.build_constraints(webdav.parse_constraints(constraints));
	ginfo.append(constraints);
	var state = $(xml).find('TF\\:state');
	ginfo.append(state);
	var box = $(xml).find('TF\\:box').find('TF\\:active');
	if (box.length) {
		ginfo.append(($(xml).find('TF\\:box'))[0]);
	}
	if (policyelement != null) {
		ginfo.append(policyelement);
	} else {
		ginfo.append(_N('uploadpolicyrule'));
	}
	return $(doc);
}

function builduploadpolicyXML() {
	var node;
	var p = _N('uploadpolicyrule');
	var rulestate = $(_N('rulestate')).appendTo(p);
	if ($('#active').prop('checked')) {
		$(_N('active')).appendTo(rulestate);
	} else {
		$(_N('inactive')).appendTo(rulestate);
	}
	var fnames = $('#rulefname').val();
	if (fnames.length) {
		fnames = fnames.split('\n');
		$.each(fnames, function(idx, fname) {
			$(_N('filename')).text(fname).appendTo(p);
		});
	}
	var suffixs = $('#rulesuffix').val();
	if (suffixs.length) {
		suffixs = suffixs.replace(/\s+/, '').split(',');
		$.each(suffixs, function(idx, suffix) {
			$(_N('suffix')).text(suffix).appendTo(p);
		});
	}
	var lens = $('#rulelen').val();
	if (lens.length) {
		lens = lens.replace(' ', '');
		lens = lens.split(',').join(' ');
		$(_N('length')).text(lens).appendTo(p);
	}
	var typechar_e = $(_N('chartype')).appendTo(p);
	if ($('#rulechar').prop('checked')) {
		$(_N('alphabet')).appendTo(typechar_e);
	}
	if ($('#rulenumber').prop('checked')) {
		$(_N('number')).appendTo(typechar_e);
	}
	var matchtype_e = $(_N('matchtype')).appendTo(p);
	if ($('input[name="matchtype"]:checked')) {
		var matchtype = $('input[name="matchtype"]:checked').val();
		if (matchtype) {
			$(_N(matchtype)).appendTo(matchtype_e);
		}
	}
	if ($('#rulehidden').prop('checked')) {
		$(_N('hidden')).appendTo(p);
	}
	return p;
}
