//------------------------------------------------------------------------------
// $Id$
// JavaScript TeamFile WebDAV functions
// Copyright (c) 2003 - 2023 BAYBITS LLC, All rights reserved.
//------------------------------------------------------------------------------

var _N = function (name) {
	let TFNS = "http://www.teamfile.com/DTD/TF/";
	name = name.replace('TF:', '');
	return document.createElementNS(TFNS, name);
}

function WebDAV(rooturi, token) {
	this.rooturi = rooturi;
	this.csrftoken = token;
};

WebDAV.prototype = {
	clientinfo	: "mb111111",
	con : {'TF:write':0x01, 'TF:operationlog':0x02, 'TF:showproperty':0x04},
	group_search_by_groupcoluri : function(groupcoluri) {
		let me = this;
		let defer = $.Deferred();
		let xmldoc = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><D:searchrequest xmlns:D="DAV:" xmlns:TF="http://www.teamfile.com/DTD/TF/"><TF:groupinformationsearch><TF:groupcollectionuri><![CDATA[' + groupcoluri + ']]></TF:groupcollectionuri><TF:content/></TF:groupinformationsearch></D:searchrequest>';
		$.ajax({
			url: me.rooturi + "/.management/GROUP/",
			type: "SEARCH",
			cache: false,
			contentType: "text/xml",
			data: xmldoc,
			beforeSend: function(xhr) {
				xhr.setRequestHeader("TF-Client-Info", me.clientinfo);
				xhr.setRequestHeader("X-Content-Type-Options", "nosniff");
				xhr.setRequestHeader("X-CSRF-Token", me.csrftoken);
			},
		})
		.done(function(data) {
			defer.resolve(data);
		})
		.fail(function(data) {
			defer.reject(data);
		})

		return defer.promise();
	},
	isEditAble : function(uid) {
		let me = this;
		let defer = $.Deferred();
		let xmldoc = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><D:searchrequest xmlns:D="DAV:" xmlns:TF="http://www.teamfile.com/DTD/TF/"><TF:userinformationsearch><TF:userid>' + uid + '</TF:userid><TF:content/></TF:userinformationsearch></D:searchrequest>';

		$.ajax({
			url: me.rooturi + "/.management/USER/",
			type: "SEARCH",
			cache: false,
			contentType: "text/xml",
			data: xmldoc,
			beforeSend: function(xhr) {
				xhr.setRequestHeader("TF-Client-Info", this.clientinfo);
				xhr.setRequestHeader("X-Content-Type-Options", "nosniff");
				xhr.setRequestHeader("X-CSRF-Token", me.csrftoken);
			},
		})
		.done(function(data) {
			defer.resolve($(data).find('TF\\:usertype').find('TF\\:admin').length);
		})
		.fail(function(data) {
			defer.reject(data);
		});

		return defer.promise();
	},
	patch_group_uploadpolicy : function(groupcoluri, href, xml) {
		let me = this;
		let defer = $.Deferred();
		let xmlstr = (new XMLSerializer()).serializeToString(xml[0]);
		let rooturi = me.rooturi;
		let clientinfo = me.clientinfo;

		me.group_search_by_groupcoluri(groupcoluri)
		.then(function(data) {
			$.ajax({
				type: "PROPPATCH",
				url: href,
				contentType: "text/xml",
				data: xmlstr,
				beforeSend: function(xhr) {
					xhr.setRequestHeader("TF-Client-Info", clientinfo);
					xhr.setRequestHeader("X-Content-Type-Options", "nosniff");
					xhr.setRequestHeader("X-CSRF-Token", me.csrftoken);
				},
			})
			.done(function(data) {
				defer.resolve(data);
			})
			.fail(function(data) {
				defer.reject(data);
			});
		})

		return defer.promise();
	},
	parse_constraints : function(xml) {
		let me = this;
		var constraints = me.con;
		var ret = 0;
		$(xml).children().each(function(i, tag) {
			ret |= constraints[$(tag).prop('tagName')];
		});
		return ret;
	},
	build_constraints : function(number) {
		let me = this;
		let e = _N('constraints');
		let c = me.con;
		$.each(c, function(tag, key) {
			if (key & number) {
				$(e).append(_N(tag));
			}
		});

		return e;
	}
}

