/**
 * $Id$
 *
 * 入力された文字列をMD5 (hexダンプ)するコマンド
 */
#include <stdio.h>
#if HAVE_STRING_H
#include <string.h>
#endif	/* HAVE_STRING_H */
#if HAVE_STDLIB_H
#include <stdlib.h>
#endif	/* HAVE_STDLIB_H */
#include "openssl/md5.h"

static const char hex[16] = "0123456789abcdef";

int main(int argc, char* argv[])
{
        unsigned char   md[MD5_DIGEST_LENGTH+1];

        int             i;
        unsigned char   ch;
        char            *ret = NULL, *first = NULL;

        if (argc < 2) return 1;

        /* md5 */
        if (!MD5((const unsigned char*)argv[1], strlen(argv[1]), md)) return 1;

        first = ret = malloc(MD5_DIGEST_LENGTH * 2 + 1);
        if (!ret) return 1;

        for (i=0;i < MD5_DIGEST_LENGTH; i++) {
                ch = (unsigned char)md[i];
                *ret++ = hex[ch >> 4];
                *ret++ = hex[ch & 0xF];
        }
        *ret++ = '\0';

        printf("%s", first);
        free(first);

        return 0;
}

