/**
 * auth.h
 * $Id$
 *
 * 認証ヘッダファイル
 *
 * 変更履歴
 *
 * 2003/03/04 Tue yonekura
 *
 */
#ifndef INCLUDE_AUTH_H
#define INCLUDE_AUTH_H

#include "httpd.h"
#include "tfr.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*--------------------------------------------------------------
  Define fixed value
  --------------------------------------------------------------*/
#define DIVY_AUTH_TYPE_DIGEST	"Digest"
#define DIVY_AUTH_TYPE_BASIC	"Basic"
#define DIVY_AUTH_TYPE_BEARER   "Bearer"

/*--------------------------------------------------------------
  Declare public function
  --------------------------------------------------------------*/

extern const authn_provider  authn_teamfile_provider;

/**
 * mod_dav_divy.cよりフックされる認証関数
 * conf->divyauthが設定(1)されている場合のみ動作する。
 *
 * @param r request_rec *
 * @return int (HTTP_STATUS)
 */
DIVY_DECLARE(int) dav_divy_authenticate_user(request_rec *r);

/**
 * Authorization ヘッダをパースしてパスワード文字列を取得する.
 *
 * @param r request_rec *
 * @return char * パースされたパスワード. パースできなかったり、無ければNULL
 */
DIVY_DECLARE(char *) divy_parse_authorization_header(request_rec *r);

DIVY_DECLARE(int) dav_divy_hook_tf_auth_failure(request_rec *r, const char* auth_type);

#ifdef __cplusplus
}
#endif

#endif /* INCLUDE_AUTH_H */
