/**
 * $Id$
 *
 * liveprop.h
 *
 * Live property・プロバイダ (ヘッダファイル)
 *
 * 変更履歴
 *
 * 2003/02/13 Thu takehara NEW
 *
 */
#ifndef INCLUDE_LIVEPROP_H
#define INCLUDE_LIVEPROP_H

/* Apache header files */
#include "httpd.h"
#include "apr.h"
#include "apr_pools.h"
#include "apr_xml.h"

#include "tfr.h"
#include "tf_rdbo.h"
#include "tf_folder.h"
#include "tf_validator.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*--------------------------------------------------------------
  Define Fixed values
  --------------------------------------------------------------*/
/**
 * デフォルトのネームスペースURI
 */
#define DIVY_NS_DEFAULT_URI "http://www.teamfile.com/DTD/TF/"

/**
 * ネームスペースプレフィックス
 */
#define DIVY_NS_PREFIX "TF"

/**
 * DAV ネームスペースプレフィックス
 */
#define DAV_NS_PREFIX "D"

/**
 * ネームスペースプレフィックス番号
 * (note)
 *	このプレフィックス番号は配列dav_divy_namespace_uris と対応しています。
 *	番号を変える時には配列と対応させて下さい。
 */
#define DAV_NS_PREFIX_IDX	0	/* DAV_NS_PREFIX のプレフィックス番号 */
#define DIVY_NS_PREFIX_IDX	1	/* DIVY_NS_PREFIX のプレフィックス番号 */

/**
 * 関数divy_make_liveprop_ns のwant に指定するビット値
 */
#define DIVY_GET_DAV_NS		0x01	/* DAVのネームスペース文字列  */
#define DIVY_GET_DIVY_NS	0x02	/* DIVYのネームスペース文字列 */

/**
 * 関数 divy_insert_prop_user_privilege_grant_set のmode に指定するビット値
 */
#define DIVY_GET_ALL_PRIVILEGE  0x00	/* 全てのエレメントの取得をトライする   */
#define DIVY_DEL_VIEW_PRIVILEGE	0x01	/* append-view, remove-viewを取得しない */
#define DIVY_DEL_BOX_PRIVILEGE  0x02	/* append-box, remove-boxを取得しない */

/*--------------------------------------------------------------
  Declar live property Hook structure
  --------------------------------------------------------------*/
extern const dav_liveprop_group dav_divy_liveprop_group;

/*--------------------------------------------------------------
  Declar prototype functions
  --------------------------------------------------------------*/
/*
   以下2つの関数は、Liveプロパティ・プロバイダが定義している3つの
   独自フックハンドラのうちの2つ。(定義はmod_dav.c, mod_dav.h)
   Catacombは、この2つだけをLiveプロパティ・プロバイダとして
   提供している。
 */
DIVY_DECLARE(void) dav_divy_insert_all_liveprops(request_rec * r,
                                   		const dav_resource * resource,
                                   		dav_prop_insert what,
                                   		apr_text_header * phdr);

DIVY_DECLARE(int) dav_divy_find_liveprop(const dav_resource * resource, 
               		            const char *ns_uri,
				    const char *name,
				    const dav_hooks_liveprop ** hooks);

/**
 * プロパティID の dav_liveprop_spec 構造体を取得し、戻り値として
 * ネームスペースID のインデックス番号を返却する。
 *
 * この関数は、mod_dav.h で宣言されたdav_get_liveprop_info と同じ
 * 動きをします。(実装が違うだけです。性能は向上しているはず。)
 * (note)
 *    この関数は、初期化時にinit_mutex というmutex を使用して
 *    ロックを掛けています。呼び出し元はinit_mutex を使用した
 *    ロックを掛けてからこの関数を呼び出してはなりません。
 *
 * @param propid int プロパティID
 * @param r request_rec *
 * @param group const dav_liveprop_group * dav_liveprop_group へのポインタ
 * @param info  const dav_liveprop_spec *info に取得結果を戻す
 * @return ネームスペースID のインデックス番号
 */
DIVY_DECLARE(int) divy_get_liveprop_info(int propid,
                                        request_rec *r,
                                        const dav_liveprop_group *group,
                                        const dav_liveprop_spec **info);

/**
 * レスポンスで使用するLiveプロパティのネームスペース文字列を組み立てて返却する。
 * (note)
 * 	この関数は主としてLiveプロパティプロバイダ以外のプロバイダがネームスペース
 * 	URIを必要とするときに使われます。mod_dav のフレームワークにのっている
 * 	Liveプロパティプロバイダ自身はこの関数を使わなくても算出できるはずなので
 * 	使ってはなりません。
 *
 * @param p apr_pool_t *
 * @param want int 欲しいプロパティのビット値(OR も可能)
 * 		DIVY_GET_DAV_NS : DAVのネームスペース文字列が欲しい
 * 		DIVY_GET_DIVY_NS: DIVYのネームスペース文字列が欲しい
 * @return const char * ネームスペース文字列
 */
DIVY_DECLARE(const char *) divy_make_liveprop_ns(apr_pool_t *p, int want);

/**
 * プロパティID DAV_DIVY_PROPID_user_privilege_grant_set のエレメントを作成して
 * phdr につめて返却する。(SEARCH専用のバックドア)
 *
 * * ユーザ拡張ステータスがサポートされていなければ何もしません。
 * * rdb_r 必須項目: rstate_pr(あれば), uri
 *
 * (note) バックドアが必要な言い訳
 * 	この関数は、SEARCHから利用されます。
 * 	原理原則を言えばLiveプロパティは、一連のLiveプロパティプロバイダ
 * 	フレームワークを通じて利用すべきであり、この関数のように裏からエレメント
 * 	文字列を生成してしまうのは反則です。
 * 	ただ、SEARCHと同じLiveプロパティを返さなければならないときに両者で同じ
 * 	文字列生成ロジックを利用したいと思うのは自然な流れで、ソースコードの
 * 	観点からは必要な方法です。
 * 	そもそもmod_dav のSEARCHプロバイダフレームワークがこの仕様を取り込んで
 * 	いないことの方が問題なのですが、それは仕方のない話なので、ここでは
 * 	実装上の考慮の方がより重要であると考えて、裏口によるロジックの共通化
 * 	を図りました。
 * 	mod_dav フレームワーク上でSEARCHプロバイダがLiveプロパティプロバイダ
 * 	フレームワークを利用できるようになったら、その時に見直してください。
 *
 * @param r request_rec *
 * @param nsname const char * ネームスペースプレフィックス文字列("TF" など)
 * 	NULL ならばデフォルトのネームスペースを利用します
 * @param mode int 取得方法を現すビット値
 * 			DIVY_DEL_VIEW_PRIVILEGE : append-view, remove-viewを取らない
 * @param rdb_r divy_rdbo_resource * このプロパティのリソース
 * @param phdr apr_text_header * 生成したLiveプロパティを入れる入れ物(NOT NULL)
 */
DIVY_DECLARE(void) divy_insert_prop_user_privilege_grant_set(request_rec *r,
						const char *nsname,
						int mode,
						divy_rdbo_resource *rdb_r,
						apr_text_header *phdr);

#ifdef DIVY_SUPPORT_PASSPOLICY
/**
 * デフォルトのユーザパスワードポリシー状態を生成して返却する.
 * デフォルト値を入れるだけです. 必要であれば後で置き換えてください.
 */
DIVY_DECLARE(divy_rdbo_passpolicystatus *)
	divy_create_user_passwordpolicy(apr_pool_t *p, const char *userid);
#endif	/* DIVY_SUPPORT_PASSPOLICY */


#ifdef __cplusplus
}
#endif

#endif	/* INCLUDE_LIVEPROP_H */

