/**
 * $Id$
 *
 * lock.h
 *
 * Locking・プロバイダ用ヘッダファイル
 *
 * 変更履歴
 *
 * 2003/02/17 Mon takehara NEW
 *
 */
#ifndef INCLUDE_LOCK_H
#define INCLUDE_LOCK_H

#include "httpd.h"
#include "apr.h"
#include "apr_time.h"
#include "mod_dav.h"

#if APR_HAVE_TIME_H
#include <time.h>
#endif	/* APR_HAVE_TIME_H */

#include "tfr.h"
#include "util_db.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*--------------------------------------------------------------
  Define incomplete type structure
  --------------------------------------------------------------*/

/*
 * (see mod_dav.h)
 */
struct dav_locktoken
{
	const char *uuid;
};

/* 
 * mod_davで定義されているロックディスカバリー構造体
 */

/*
typedef struct dav_divy_lock_discovery_fixed
{
	char scope;
	char type;
	int depth;
	time_t timeout;
}
dav_divy_lock_discovery_fixed;
*/

#define	APPEND_TOKEN	"APPEND_TOKEN"
#define	EXPIRED_TOKEN	"EXPIRED_TOKEN"
#define	REMOVE_LOCKNULL "REMOVE_LOCKNULL"
#define DIRECT_INDIRECT	"DIRECT_INDIRECT"
#define REFRESH_TOKEN	"REFRESH_TOKEN"
#define LOCK_STATE	"LOCK_STATE"

#define DAV_CREATE_LIST		23
#define DAV_APPEND_LIST		24

#define DAV_LOCK_DIRECT		1
#define DAV_LOCK_INDIRECT	2

#define DIVY_LOCK_READ_NOMAL	30
#define DIVY_LOCK_READ_RESOLVED	31

/**
 * ロックの状態をチェックする。
 * @param expires apr_int64_t
 * @return 1(ture) ロックはされていない。（過去に解除された）0(ロック）
 *
 */
DIVY_DECLARE(int) dav_divy_lock_expired(time_t expires);

/**
 * ロックプロバイダが正常にCLOSEをしたか確認する
 *
 * @param r request_rec *
 * @return 0: 正常 1:失敗
 *
 */
DIVY_DECLARE(int) dav_divy_lock_close_status(request_rec *r);

/**
 * 指定されたユーザID userid のユーザが持っていた全てのロック及び
 * ロックNULLリソースを削除する。
 * (note)
 * 	トランザクションが継続中であれば引き継ぎます。
 *
 * @param r request_rec *
 * @param userid const char * 対象ユーザ
 * @param ts_ctx divy_db_transaction_ctx * トランザクションコンテキスト
 * @return int 処理ステータス (0: 成功 /1: 失敗)
 * 	削除すべきロックやロックNULLリソースが存在しなくても成功扱いとします。
 */
DIVY_DECLARE(int) divy_lock_remove_user_lock(request_rec *r, const char *userid,
						divy_db_transaction_ctx *ts_ctx);

#ifdef __cplusplus
}
#endif

#endif /* INCLUDE_LOCK_H */
