/**
 * $Id$
 *
 * mod_dav_tf.h
 *
 * 変更履歴
 *
 * 2003/01/30 Thu takehara 新規作成
 */
#ifndef INCLUDE_MOD_DAV_DIVY_H
#define INCLUDE_MOD_DAV_DIVY_H

#ifdef HAVE_CONFIG_H
#ifndef INCLUDE_TF_CONFIG_H
#define INCLUDE_TF_CONFIG_H
#include "tf_config.h"
#endif	/* INCLUDE_TF_CONFIG_H */
#endif	/* HAVE_CONFIG_H */

#ifdef DIVY_SUPPORT_PLUGIN
#ifndef TFSP_CORE_PRIVATE
#define TFSP_CORE_PRIVATE
#endif	/* TFSP_CORE_PRIVATE */
#endif	/* DIVY_SUPPORT_PLUGIN */

/* Apache header files */
#include "apr.h"
#include "apr_pools.h"
#include "apr_hash.h"
#include "apr_thread_mutex.h"
#include "httpd.h"
#if APR_HAVE_UNISTD_H
#include <unistd.h>
#endif

/* mod_dav header files */
#include "mod_dav.h"
#include "mod_auth.h"
#include "tfr.h"
#include "tf_errno.h"
#include "tf_env.h"
#include "tf_folder.h"
#include "util_common.h"
#include "tf_valuecache.h"
#include "tf_logger.h"
#include "tf_cset.h"
#include "tf_array.h"
#include "tf_memcache.h"
#include "util_saml.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*
 * グローバル変数の定義と宣言の調整を行うためのdefine 値を定義
 *
 * (note)
 * 外部変数の宣言にextern の代わりにDIVY_GLOBALを使用すれば、
 * 必ず１箇所(mod_dav_divy.c) でのみ定義され、その他のファイルでは
 * 外部参照されるようになります。
 * また、DIVY_GLOBAL_VALUE_DEFINE を使用することで、宣言と定義を
 * 同時に記述することも可能となります。
 */ 
#ifdef DIVY_GLOBAL_VALUE_DEFINE
#define DIVY_GLOBAL	/* 空にする */
#else
#define DIVY_GLOBAL extern
#endif	/* DIVY_GLOBAL_VALUE_DEFINE */

/*--------------------------------------------------------------
  Fixed value 
  --------------------------------------------------------------*/
/**
 * Quota のデフォルト値
 */
#define DIVY_QUOTA_MAX_STORAGE  DIVY_UNLIMITED_USRQUOTA_BYTES	/* 上限容量のデフォルト       */
#define DIVY_QUOTA_MAX_RESOURCE DIVY_UNLIMITED_USRQUOTA_FILES	/* 上限ファイル数のデフォルト */

/**
 * 最大RequiredSQLの連鎖数(ネスト数)
 * (例) $$SSxxx1 -> $$SSxxxx2 -> $$SSxxxx3 という依存関係があるとき
 *      連鎖数は３ということになります。
 */
#define DIVY_REQSQL_MAX_CHAIN 30

/**
 * RequiredSQLのSELECT句に指定されるカラム数
 * (note)
 * 	ここの値を変えてもロジックを変えなければカラム数を増減させることは
 * 	出来ません。但し、エラーチェックには掛かるようになります。
 */
#define DIVY_REQSQL_MAX_SELECT_COLUMN 2

/**
 * 通常 SQL の SELECT句に指定されるカラム数(最低数と最大数)
 * (note)
 * 	ここの値を変えてもロジックを変えなければカラム数を増減させることは
 * 	出来ません。但し、エラーチェックには掛かるようになります。
 *
 * 	変数の値より少ないまたは多い場合はエラーになります。
 * 	(以上・以下ではないので注意)
 */
#define DIVY_NORMALSQL_MIN_SELECT_COLUMN 2
#define DIVY_NORMALSQL_MAX_SELECT_COLUMN 11

/*
 * Server ヘッダに記述されるこのモジュールを表す名称 (see brandname)
 * (note)
 *	デフォルト名称なのでディレクティブによって置き換えられる
 * 	こともあります。
 */
#define DIVY_PRODUCT_NAME "TeamFile"

/*
 * divy_usr に登録されるlastaccesscl の最大長さ(byte)
 */
#define DIVY_LAST_ACCESSCL_MAXLEN 100

/*
 * LDAPの共有メモリを作成する場合のパス名の一部
 */
#define DIVY_LDAP_SHM_PATH	"/tmp/.tf_shm."

/**
 * 送信可能なメールボディの最大サイズ(byte)
 */
#define DIVY_MAX_MAILBODY_SIZE    104857600

/**
 * PUT処理において、ストリームを読み込む前にQuota処理を行うかどうかの
 * 境界サイズ(バイト)
 * この値よりも大きい場合、PUT前のQuotaチェックを実施します。
 */
#define DIVY_BOUNDARY_BYTE APR_INT64_C(1048576)

/**
 * 無制限ユーザQuotaサイズの値 (Unlimited ユーザQuota対応)
 */
#define DIVY_UNLIMITED_USRQUOTA_BYTES	APR_INT64_C(0)

/**
 * 無制限ユーザQuotaファイル数の値 (Unlimited ユーザQuota対応)
 */
#define DIVY_UNLIMITED_USRQUOTA_FILES	APR_INT64_C(0)

/**
 * 無制限システムQuotaサイズの値 (システムQuota対応)
 */
#define DIVY_UNLIMITED_SYSQUOTA_BYTES	APR_INT64_C(0)

/**
 * 無制限システムQuotaファイル数の値 (システムQuota対応)
 */
#define DIVY_UNLIMITED_SYSQUOTA_FILES	APR_INT64_C(0)

/**
 * 無制限グループQuotaサイズの値（グループQuota対応）
 */
#define DIVY_UNLIMITED_GRPQUOTA_BYTES	APR_INT64_C(0)

/**
 * 無制限グループQuotaファイル数の値（グループQuota対応）
 */
#define DIVY_UNLIMITED_GRPQUOTA_FILES	APR_INT64_C(0)


/**
 * デフォルトの言語タグ
 * (note)
 *   ディレクティブTfDefaultResponseLanguage や 環境変数prefer-language が
 *   指定されなかった場合に使用されるデフォルトの言語タグ
 */
#define DIVY_DEFAULT_LANGPARAM	"ja"

/**
 * 関数 divy_build_supportedfunc_str で使用する機能を表すビット値
 */
#define DIVY_SUPPORTEDFUNC_OWNERMLWATCH		0x01	/* 自分自身が設定したメール監視状態を見る機能 */
#define DIVY_SUPPORTEDFUNC_GROUPCONSTRAINTS	0x02	/* グループ制約機能 */
#define DIVY_SUPPORTEDFUNC_GROUPLEADER		0x04	/* グループリーダ機能 */
#define DIVY_SUPPORTEDFUNC_UTYPE_ADMIN			0x08	/* 管理者ユーザであること */
#define DIVY_SUPPORTEDFUNC_UTYPE_GROUPLEADER	0x20	/* グループリーダであること */
#define DIVY_SUPPORTEDFUNC_UTYPE_NORMAL			0x40	/* 一般ユーザであること */
#define DIVY_SUPPORTEDFUNC_UTYPE_LIMITED		0x80	/* 制限ユーザであること */
#define DIVY_SUPPORTEDFUNC_FILETICKET			0x100	/* ファイルticketをサポートしているかどうか */
#define DIVY_SUPPORTEDFUNC_CONTROLOTHERUSER		0x200	/* Otherユーザを管理下に置くことができるかどうか */
#define DIVY_SUPPORTEDFUNC_CONFIRMREADING		0x400	/* 開封通知機能 */
#define DIVY_SUPPORTEDFUNC_GROUPQUOTA			0x800	/* グループクォータ機能 */
#define DIVY_SUPPORTEDFUNC_ACCESS_CONTROL		0x1000	/* アクセス制御機能 */
#define DIVY_SUPPORTEDFUNC_BOX					0x2000  /* BOX機能 */
#define DIVY_SUPPORTEDFUNC_UPLOADPOLICY			0x4000	/* アップロードポリシー機能をサポートしているかどうか */
#define DIVY_SUPPORTEDFUNC_2FA					0x8000 	/* Two Factor Authentication(2FA)をサポートしているかどうか */

/**
 * 削除されたユーザが保持していたファイルの作成者、最終更新者を表すユーザID
 * (note)
 *   削除ユーザのユーザIDを再利用することにより、Quotaの不正減算の問題が
 *   発生する.これを回避するため、ユーザを削除すると同時に、保持していた
 *   ファイル、フォルダの作成者ID及び最終更新者IDを全て、以下の固定値に
 *   書き換えてしまいます.
 *   作成者IDや最終更新者IDはNOT NULL なので仕方の無い対応です.
 *   以降、このIDは禁則(予約語)となります.
 */
#define DIVY_DELETED_USER_ID	".unknown_user"

/*--------------------------------------------------------------
  Define macro
  --------------------------------------------------------------*/
/*
 * Apache 環境変数がOn かどうかを判定するマクロ
 * [ on と判定する条件(AND 条件) ]
 *   * 対応するディレクティブが存在していること
 *   * "on"(大小文字無視)を持っていること (offではないこと)
 *
 * @param val const char * Apache環境変数の値
 * @return Onかどうか (1: on だった / 0: off だった)
 */
#define DIVY_APENV_IS_ON(val)	\
		(val != NULL && strcasecmp(val, "on") == 0)



/*--------------------------------------------------------------
  Declare values
  --------------------------------------------------------------*/
/**
 * スタティックな変数の初期化排他処理に使用するMutex
 * このmutexは、mod_dav_divyのchild_initの際に生成＆初期化され
 * child_exitの際に、破棄されます.
 */
DIVY_GLOBAL apr_thread_mutex_t *init_mutex;

/**
 * sqlparser を呼び出す際に排他アクセスを行う目的で利用するmutex.
 * (note)
 * 	lex 生成scanner はマルチスレッド対応ではありません。。
 * 	そういう仕様のようです。
 */
DIVY_GLOBAL apr_thread_mutex_t *scanner_mutex;

/**
 * autoindex 処理の排他処理に利用するmutex.
 * (note)
 * 	libxsl, libxml はグローバル変数を利用しているため排他処理する
 * 	必要があります。
 */
DIVY_GLOBAL apr_thread_mutex_t *autoindex_mutex;

/**
 * ライセンス情報の変更を排他処理するためのmutex.
 */
DIVY_GLOBAL apr_thread_mutex_t *license_mutex;

/*--------------------------------------------------------------
  Declar live property Hook structure
  --------------------------------------------------------------*/
extern const dav_liveprop_group dav_divy_liveprop_group;

extern const authn_provider authn_tf_provider;
extern const authz_provider authz_tf_provider;

/*--------------------------------------------------------------
  Define Public enum and structure
  --------------------------------------------------------------*/
/**
 * 関数divy_get_clientinfo の引数に渡す値
 * (ヘッダに文字が並ぶ順番と対応しています)
 */
enum __divy_clfunc_type {
	DIVY_CLFUNC_PRODUCTTYPE = 0,		/* プロダクト種別(TeamFile or OEM) */
	DIVY_CLFUNC_CLIENTTYPE = 1,			/* クライアント種別(Explorer or CommandLine) */
	DIVY_CLFUNC_GROUPCONSTRAINTS = 2,	/* グループ制約属性機能の有無 */
	DIVY_CLFUNC_GROUPLEADER = 3,		/* グループ管理者機能の有無 */
	DIVY_CLFUNC_GROUPQUOTA = 4,			/* グループクォータ機能の有無 */
	DIVY_CLFUNC_ACCESSCONTROL = 5,		/* アクセス制御機能の有無 */
	DIVY_CLFUNC_BOX = 6,				/* BOX機能の有無 */
	DIVY_CLFUNC_UPLOADPOLICY = 7,		/* アップロードポリシー機能の有無 */
	DIVY_CLFUNC_2FA = 8,				/* 2FA機能の有無 */

	DIVY_CLFUNC_END,					/* (sentinel) */
};
typedef enum __divy_clfunc_type	divy_clfunc_type;

/**
 * show_group の列挙型
 */
enum {
	DIVY_SHOWGROUP_UNSET = 0,	/* show_group が未設定 */
	DIVY_SHOWGROUP_OFF,		/* show_group が OFF   */
	DIVY_SHOWGROUP_ON		/* show_group が ON    */
};

/**
 * auth_on の列挙型
 */
enum {
	DIVY_AUTH_UNSET = 0,		/* auth_on が未設定 */
	DIVY_AUTH_OFF,			/* auth_on が OFF   */
	DIVY_AUTH_ON			/* auth_on が ON    */
};

/**
 * autoindex の列挙型
 */
enum {
	DIVY_AUTOINDEX_UNSET = 0,	/* autoindex が未設定 */
	DIVY_AUTOINDEX_OFF,		/* autoindex が OFF   */
	DIVY_AUTOINDEX_ON		/* autoindex が ON    */
};

/**
 * syncgrpuri の列挙型
 */
enum {
	DIVY_SYNCGRPURI_UNSET = 0,	/* syncgrpuri が未設定 */
	DIVY_SYNCGRPURI_OFF,		/* syncgrpuri が OFF   */
	DIVY_SYNCGRPURI_ON,		/* syncgrpuri が ON    */
	DIVY_SYNCGRPURI_MIDDLE		/* syncgrpuri が MIDDLE*/
};

/**
 * mlserversend の列挙型
 */
enum {
	DIVY_MLSERVERSEND_UNSET = 0,	/* mlserversend が未設定 */
	DIVY_MLSERVERSEND_OFF,		/* mlserversend が OFF   */
	DIVY_MLSERVERSEND_ON,		/* mlserversend が ON    */
	DIVY_MLSERVERSEND_MIDDLE	/* mlserversend が MIDDLE    */
};

/**
 * mlnotifyact の列挙型
 */
enum {
	DIVY_MLNOTIFYACT_UNSET = 0,	/* mlnotifyact が未設定 */
	DIVY_MLNOTIFYACT_OFF,		/* mlnotifyact が OFF   */
	DIVY_MLNOTIFYACTD_ON		/* mlnotifyact が ON    */
};

/**
 * mloneclickurl の列挙型
 */
enum {
	DIVY_MLONECLICKURL_UNSET = 0,	/* mloneclickurl が未設定 */
	DIVY_MLONECLICKURL_OFF,		/* mloneclickurl がOFF    */
	DIVY_MLONECLICKURL_ON		/* mloneclickurl がON     */
};

/**
 * mledit の列挙型
 */
enum {
	DIVY_MLEDIT_UNSET = 0,	/* mledit が未設定 */
	DIVY_MLEDIT_OFF,		/* mledit がOFF    */
	DIVY_MLEDITL_ON			/* mledit がON     */
};

/**
 * encryptpassword の列挙型
 */
enum {
	DIVY_ENCRYPTPASSWORD_UNSET = 0,	/* encryptpassword が未設定 	*/
	DIVY_ENCRYPTPASSWORD_OFF,	/* encryptpassword がOFF	*/
	DIVY_ENCRYPTPASSWORD_ON		/* encryptpassword がON		*/
};

/**
 * streammethod の列挙型
 */
enum {
	DIVY_STREAMMETHOD_UNSET = 0,	/* streammethod が未設定 */
	DIVY_STREAMMETHOD_OFF,		/* streammethod がOFF    */
	DIVY_STREAMMETHOD_ON		/* streammethod がON     */
};

/**
 * trashfolder の列挙型
 */
enum {
	DIVY_TRASHFOLDER_UNSET = 0,	/* trashfolder が未設定 */
	DIVY_TRASHFOLDER_OFF,		/* trashfolder がOFF    */
	DIVY_TRASHFOLDER_ON		/* trashfolder がON     */
};

/**
 * extenduserst の列挙型
 */
enum {
	DIVY_EXTENDUSERST_UNSET = 0,	/* extenduserst が未設定 */
	DIVY_EXTENDUSERST_OFF,		/* extenduserst がOFF    */
	DIVY_EXTENDUSERST_ON		/* extenduserst がON     */
};

#ifdef DIVY_SUPPORT_PRINTER
/**
 * netprint の列挙型
 */
enum {
	DIVY_NETPRINT_UNSET = 0,	/* netprint が未設定 */
	DIVY_NETPRINT_OFF,		/* netprint がOFF    */
	DIVY_NETPRINT_ON		/* netprint がON     */
};
#endif	/* DIVY_SUPPORT_PRINTER */

/**
 * useusbtoken の列挙型
 */
enum {
	DIVY_USEUSBTOKEN_UNSET = 0,	/* useusbtoken が未設定 */
	DIVY_USEUSBTOKEN_OFF,		/* useusbtoken がOFF    */
	DIVY_USEUSBTOKEN_ON			/* useusbtoken がON     */
};

/**
 * thumbnail の列挙型
 */
enum {
	DIVY_THUMBNAIL_UNSET = 0,   /* thumbnail が未設定 */
	DIVY_THUMBNAIL_OFF,         /* thumbnail がOFF    */
	DIVY_THUMBNAIL_ON           /* thumbnail がON     */
};

#ifdef DIVY_SUPPORT_PASSPOLICY
/**
 * passpolicy の列挙型
 */
enum {
	DIVY_PASSPOLICY_UNSET = 0,  /* passpolicy が未設定 */
	DIVY_PASSPOLICY_OFF,        /* passpolicy がOFF    */
	DIVY_PASSPOLICY_ON          /* passpolicy がON     */
};

/**
 * passpolicy_opt のビット値
 */
enum {
	DIVY_PASSPOLICY_OPT_UNSET = 0,
	DIVY_PASSPOLICY_OPT_BASE  = 0x01,	/* 基本機能 */
};
#endif	/* DIVY_SUPPORT_PASSPOLICY */

#ifdef DIVY_SUPPORT_LOGACCESS
/**
 * logaccess の列挙型
 */
enum {
	DIVY_LOGACCESS_UNSET = 0,  /* logaccess が未設定 */
	DIVY_LOGACCESS_OFF,        /* logaccess がOFF    */
	DIVY_LOGACCESS_ON,         /* logaccess がON     */
	DIVY_LOGACCESS_ONALL,      /* logaccess がON-ALL */
};
#endif	/* DIVY_SUPPORT_LOGACCESS */

/**
 * autodelete の列挙型
 */
enum {
	DIVY_AUTODELETE_UNSET = 0,  /* autodelete が未設定 */
	DIVY_AUTODELETE_OFF,        /* autodelete がOFF    */
	DIVY_AUTODELETE_ON          /* autodelete がON     */
};

/**
 * chunkput の列挙型
 */
enum {
	DIVY_CHUNKPUT_UNSET = 0,  /* chunkput が未設定 */
	DIVY_CHUNKPUT_OFF,        /* chunkput がOFF    */
	DIVY_CHUNKPUT_ON          /* chunkput がON     */
};

/**
 * execengine の列挙型
 */
enum {
	DIVY_EXECENGINE_UNSET = 0,  /* execengine が未設定 */
	DIVY_EXECENGINE_OFF,        /* execengine がOFF    */
	DIVY_EXECENGINE_ON          /* execengine がON     */
};

/**
 * forcedelete の列挙型
 */
enum {
	DIVY_FORCEDELETE_UNSET = 0,  /* forcedelete が未設定 */
	DIVY_FORCEDELETE_OFF,        /* forcedelete がOFF    */
	DIVY_FORCEDELETE_ON          /* forcedelete がON     */
};

/**
 * rproxyuse の列挙型
 */
enum {
	DIVY_RPROXYUSE_UNSET = 0,  /* rproxyuse が未設定 */
	DIVY_RPROXYUSE_OFF,        /* rproxyuse がOFF    */
	DIVY_RPROXYUSE_ON          /* rproxyuse がON     */
};

/*
 * rproxyschema の列挙型
 */
enum {
	DIVY_RPROXY_SCHEMA_UNSET = 0,	/* rproxyschema が未設定  */
	DIVY_RPROXY_SCHEMA_HTTP,		/* rproxyschema に"http"  */
	DIVY_RPROXY_SCHEMA_HTTPS,		/* rproxyschema に"https" */
	DIVY_RPROXY_SCHEMA_AUTO,		/* rproxyschema に"auto"  */
};

/*
 * syscgiconnectport で使用する自動認識ポート番号の値
 */
enum {
	DIVY_SYSCGI_CONNECT_PORT_AUTO = -9,	/* 自動認識 */
};

/*
 * syscgiconnectschema の列挙型
 */
enum {
	DIVY_SYSCGI_CONNECT_SCHEMA_UNSET = 0,	/* syscgiconnectschema が未設定  */
	DIVY_SYSCGI_CONNECT_SCHEMA_HTTP,		/* syscgiconnectschema に"http"  */
	DIVY_SYSCGI_CONNECT_SCHEMA_HTTPS,		/* syscgiconnectschema に"https" */
	DIVY_SYSCGI_CONNECT_SCHEMA_AUTO,		/* syscgiconnectschema に"auto"  */
};

/*
 * notifyserverport で使用する自動認識ポート番号の値
 */
enum {
	DIVY_NOTIFYSERVER_PORT_AUTO = -9,	/* 自動認識 */
};

/*
 * notifyserverschema の列挙型
 */
enum {
	DIVY_NOTIFYSERVER_SCHEMA_UNSET = 0,	/* notifyserverschema が未設定  */
	DIVY_NOTIFYSERVER_SCHEMA_HTTP,		/* notifyserverschema に"http"  */
	DIVY_NOTIFYSERVER_SCHEMA_HTTPS,		/* notifyserverschema に"https" */
	DIVY_NOTIFYSERVER_SCHEMA_AUTO,		/* notifyserverschema に"auto"  */
};

/**
 * logoperation の列挙型
 */
enum {
	DIVY_LOGOPERATION_UNSET = 0,  /* logoperation が未設定 */
	DIVY_LOGOPERATION_OFF,        /* logoperation がOFF    */
	DIVY_LOGOPERATION_ON,         /* logoperation がON     */
};

/**
 * licenseuploader の列挙型
 */
enum {
	DIVY_LICENSEUPLOADER_UNSET = 0,  /* licenseuploader が未設定 */
	DIVY_LICENSEUPLOADER_OFF,        /* licenseuploader がOFF    */
	DIVY_LICENSEUPLOADER_ON,         /* licenseuploader がON     */
};

/**
 * groupleader の列挙型
 */
enum {
	DIVY_GROUPLEADER_UNSET = 0,  /* groupleader が未設定 */
	DIVY_GROUPLEADER_OFF,        /* groupleader がOFF    */
	DIVY_GROUPLEADER_ON,         /* groupleader がON     */
};

/**
 * confirmreading の列挙型
 */
enum {
	DIVY_CONFIRMREADING_UNSET = 0,  /* confirmreading が未設定 */
	DIVY_CONFIRMREADING_OFF,        /* confirmreading がOFF    */
	DIVY_CONFIRMREADING_ON,         /* confirmreading がON     */
};

/**
 * extendsysmsg の列挙型
 */
enum {
	DIVY_EXTENDSYSMSG_UNSET = 0,	/* extendsysmsg が未設定	*/
	DIVY_EXTENDSYSMSG_OFF,			/* extendsysmsg がOFF		*/
	DIVY_EXTENDSYSMSG_ON,			/* extendsysmsg がON		*/
};

/**
 * groupquota の列挙型
 */
enum {
	DIVY_GROUPQUOTA_UNSET = 0,		/* groupquota が未設定		*/
	DIVY_GROUPQUOTA_OFF,			/* groupquota がOFF			*/
	DIVY_GROUPQUOTA_ON,				/* groupquota がON			*/
};

/**
 * disablewebfolderlink の列挙型
 * UNSET と OFFはWebFolderが表示される事に注意してください
 */
enum {
	DIVY_DISABLE_WEBFOLDERLINK_UNSET = 0,	/* disablewebfolderlink が未設定 */
	DIVY_DISABLE_WEBFOLDERLINK_OFF,			/* disablewebfolderlink がOFF */
	DIVY_DISABLE_WEBFOLDERLINK_ON,			/* disablewebfolderlink がON */
};

/*
 * パスワード変更可否(disablechangepassword)の列挙型
 */
enum {
	DIVY_DISABLE_CHANGE_PASSWORD_UNSET = 0,	/* disablechangepassword が未設定 */
	DIVY_DISABLE_CHANGE_PASSWORD_OFF,		/* disablechangepassword がOFF    */
	DIVY_DISABLE_CHANGE_PASSWORD_ON,		/* disablechangepassword がON     */

};

/*
 * ブラウザセッション利用(TfUseSession)の列挙型
 */
enum {
	DIVY_USE_SESSION_UNSET = 0,				/* usesession が未設定 */
	DIVY_USE_SESSION_OFF,					/* usesession がOFF	   */
	DIVY_USE_SESSION_ON						/* usesession がON     */
};

/*
 * IPアドレス制限を利用するか否か？
 */
enum {
	DIVY_ACCESS_CONTROL_UNSET = 0,			/* useaccesscontrol が未設定 */
	DIVY_ACCESS_CONTROL_OFF,				/* useaccesscontrol がOFF    */
	DIVY_ACCESS_CONTROL_ON,					/* useaccesscontrol がON     */
};

/*
 * IPアドレス制限ユーザ以外のアクセス制御
 */
enum {
	DIVY_DEFAULT_ACCESS_RULE_OFF = 0,		/* defaultaccessrule がOFF  */
	DIVY_DEFAULT_ACCESS_RULE_ALLOW,			/* defaultacesssrule が許可 */
	DIVY_DEFAULT_ACCESS_RULE_DENY			/* defaultaccessrule が拒否 */
};

/*
 * ログイン失敗時のロックアウト機能を利用するか否か？
 */
enum {
	DIVY_FAILED_LOGIN_LOCKOUT_UNSET = 0,	/* failedloginlockout が未設定 */
	DIVY_FAILED_LOGIN_LOCKOUT_OFF,			/* failedloginlockout がOFF */
	DIVY_FAILED_LOGIN_LOCKOUT_ON,			/* failedloginlockout がON */
};

/*
 * ショートURLが利用できるか否か？
 */
enum {
	DIVY_SHORTEN_URL_UNSET = 0,				/* shortenurl が未設定 */
	DIVY_SHORTEN_URL_OFF,					/* shortenurl がOFF    */
	DIVY_SHORTEN_URL_ON,					/* shortenurl がON     */
};

/*
 * BOX機能が有効か否か？
 */
enum {
	DIVY_TFBOX_UNSET = 0,					/* tfbox が未設定      */
	DIVY_TFBOX_OFF,							/* tfbox がOFF         */
	DIVY_TFBOX_ON,							/* tfbox がON          */
};

/*
 * memcacheを利用するか否か？
 */
enum {
	DIVY_TFMEMCACHE_UNSET = 0,				/* memcache が未設定	*/
	DIVY_TFMEMCACHE_OFF,					/* memcache がOFF		*/
	DIVY_TFMEMCACHE_ON,						/* memcache がON		*/
};

/*
 *  SAML認証のOn/Off
 */
enum {
    DIVY_USE_SAML_UNSET = 0,                /* SAML が未設定		*/
    DIVY_USE_SAML_ON,                       /* SAML がOFF			*/
    DIVY_USE_SAML_OFF,                      /* SAML がON			*/
};

/*
 *  SAMLのメールIDとTeamFileのIDのマッチング設定
 */
enum {
	DIVY_SAML_MATCHED_MAIL_UNSET = 0,		/* 未設定				*/
	DIVY_SAML_MATCHED_MAIL_ON,				/* メールとマッチする	*/
	DIVY_SAML_MATCHED_MAIL_OFF,				/* ユーザIDとマッチ		*/
};

/*
 *  アップロードポリシーのOn/Off
 */
enum {
    DIVY_USE_UPLOAD_POLICY_UNSET = 0,		/* グループポリシーが未設定	*/
    DIVY_USE_UPLOAD_POLICY_ON,				/* グループポリシーがOFF	*/
    DIVY_USE_UPLOAD_POLICY_OFF,				/* グループポリシーがON		*/
};

/*
 * 二要素認証のOn/Off (Two Factor Authentication)
 */
enum {
	DIVY_USE_2FA_UNSET = 0,					/* 二要素認証が未設定		*/
	DIVY_USE_2FA_ON,						/* 二要素認証がOn			*/
	DIVY_USE_2FA_OFF,						/* 二要素認証がOff			*/
};

/*
 * 二要素認証の種類
 */
enum {
	DIVY_2FA_TYPE_UNSET = 0,				/* 二要素認証の種類が未設定 */
	DIVY_2FA_TYPE_DEFAULT,					/* 二要素認証の種類がデフォルト */
	DIVY_2FA_TYPE_OTP_ONLY					/* 二要素認証はOTPだけ     */ 
};

/*
 * 二要素認証を利用するステージ
 */
enum {
	DIVY_2FA_USE_STAGE_UNSET = 0,			/* 二要素認証の利用場所は未設定 */
	DIVY_2FA_USE_STAGE_ALL,					/* 二要素認証の利用場所は全て	*/
	DIVY_2FA_USE_STAGE_BOX_ONLY				/* 二要素認証の利用場所はBOX	*/
} ;

/*
 * 暗号化ストレージ利用(cipherstorage)の列挙型
 */
#ifdef TF_SUPPORT_CIPHER_STORAGE
enum {
	DIVY_CIPHER_STORAGE_UNSET = 0,			/* cipherstorage が未設定		*/
	DIVY_CIPHER_STORAGE_OFF,				/* cipherstorage がOFF		 	*/
	DIVY_CIPHER_STORAGE_ON,					/* cipherstorage がON 			*/
};
#endif

/**
 * apr_int64_t / apr_int32_t 型のコンフィグが初期化されていないことを表す値
 * (note)
 * 	この値を使って初期化されたコンフィグはDIVY_INHERIT_VALUE を使って
 * 	マージしてはなりません。マクロDIVY_INHERIT_INT32_VALUE,
 * 	DIVY_INHERIT_INT64_VALUE を利用して下さい。
 */
#define DIVY_INT32_C_UNSET  -1
#define DIVY_INT64_C_UNSET  APR_INT64_C(-1)

#ifdef DIVY_SUPPORT_PASSPOLICY
/**
 * 解析されたTfPassPolicyExclusion の内容を持つ構造体
 */
typedef struct __divy_passpolicy_exclusion	divy_passpolicy_exclusion;
struct __divy_passpolicy_exclusion {
	enum {
		DIVY_PASSPOLICY_EXCLUSION_OR = 0,	/* OR ルール (デフォルト)  */
		DIVY_PASSPOLICY_EXCLUSION_AND,		/* AND ルール */
	} cond;

	/* IPアドレスルール(apr_ipsubnet_t * の配列を持つ構造体) */
	divy_array_t *ipaddrs;

	/* ユーザIDルール */
	ap_regex_t *uid_reg;
};
#endif	/* DIVY_SUPPORT_PASSPOLICY */

/**
 * httpd.confに記録された文書管理サーバに関するConfig情報を保持する構造体
 * Server config構造体
 *
 */
struct __dav_divy_server_conf {

	/*
	 * DB 関連
	 */
	/* DBプロバイダライセンスキーを保持するハッシュ */
	apr_hash_t *dblicense_h;

	/* プールに格納されたDbConnがリフレッシュされる間隔(sec) */
	int dbrefreshinterval;

	/*
	 * サーバライセンス
	 * (svrlicensekey 以外は、これを復号して得られる値)
	 */
	char *svrlicensekey;    /* サーバライセンスキー(暗号文, オリジナル)    */
	int contract_user_cnt;  /* サーバに登録できるユーザの数の契約上の上限  */
	int allow_user_cnt;     /* 契約ユーザ数を超えて登録できるユーザの数    */
	int use_mail_opt;       /* メール送信機能の使用可否   (1: 可能)        */
	int use_db_opt;         /* DB 連携機能の使用可否      (1: 可能)        */
	int use_ldap_opt;       /* LDAP機能の使用可否         (1: 可能)        */
	int use_vsc_opt;        /* ウィルス検索機能の使用可否 (1: 可能)        */
	int use_enccipher_opt;  /* 自動暗号化機能の使用可否   (1: 可能)        */
	int use_autodel_opt;    /* 自動削除機能の使用可否     (1: 可能)        */
	int use_extcmd_opt;     /* アクション拡張Cmd使用可否  (1: 可能)        */
	char *nifname;          /* ネットワークインターフェースのデバイス名    */
	char *nip;              /* ネットワークアドレス                        */
	apr_time_exp_t *starttime_exp; /* ライセンスキー発行日時           */
	time_t ltimestamp;	/* ライセンスキー情報取得時刻 */

	/*
	 * LDAP 関連
	 */
	/* LDAP用の共有メモリ作成に利用するパス名 */
	char *ldapshmpath;
	/* LDAP用の共有メモリサイズ */
	int  ldapcachebyte;
	/* LDAP検索キャッシュの有効期間 */
	int  ldapsearch_cache_ttl;

	/* LDAP検索結果のブロック数（数）*/
	unsigned long ldap_maxmemBlocks;

	/* LDAPのパージ対象パーセンテージ */
	double ldapMarkPercentage;

	/* LDAPのパージ実行パーセンテージ */
	double ldapPurgePercentage;

	/* LDAPのURLハッシュサイズ */
	unsigned long ldapURLHashTblSize;

	/* LDAPの検索ハッシュサイズ */
	unsigned long ldapSearchHashTblSize;

	/* LDAP検索キャッシュのサイズ */
	//int  ldapsearch_cache_size;

	/* LDAP認証ファイルのパス名 */
	char *ldapcert_auth_file;

	/* LDAP接続タイプ */
	int  ldapcert_file_type;

	/*
	 * misc
	 */

	/* プロダクトの名前
	 * see DIVY_PRODUCT_NAME */
	const char *brandname;

	/* サーバのバージョン */
	const char *tfversion;

	/* USBトークを使ってライセンス管理するかどうか(UNSET/OFF/ON) */
	int useusbtoken;

#ifdef DIVY_SUPPORT_PLUGIN
	/*
	 * プラグインルートディレクトリのパス名
	 */
	char *pluginroot;
#endif	/* DIVY_SUPPORT_PLUGIN */
#ifdef DAV_SUPPORT_POST_HANDLING
	char *syscgirootpath;	/* システムCGIディレクトリパス */
#endif	/* DAV_SUPPORT_POST_HANDLING */

	/* サポートしている言語セット */
	divy_cset_t  *supported_languages;

	/* 言語タグ */
	char *default_lang;

	/* 強制言語タグ */
	char *force_lang;

	/* カスタムイメージのパス */
	char *tfcustomimagepath;
};

typedef struct __dav_divy_server_conf dav_divy_server_conf;

/**
 * Directory config 構造体
 */
struct __dav_divy_dir_conf {

	/*
	 * リソース関連
	 */
	const char *root_uri;	/* Location で指定されたURI文字列 */
	char *fsrootpath;	/* ファイル格納先のルートパス     */

	/* 1 ディレクトリに格納される最大ファイル数 */
	apr_int32_t maxresource_per_dir;

	/* １回のアップロードでアップ出来る最大サイズ(byte) */
	apr_int64_t maxfilesize;

	/*
	 * auth 関連
	 */
	/* divyで利用するauthの種類 */
	char *divyauth;

	 /* divy のauthモジュールを利用するかどうか (UNSET/OFF/ON) */
	int auth_on;

	divy_array_t *authignoreipaddrs; /* パスワードなしのログインが接続可能IP */

	/*
	 * DB 関連
	 */
	char *dbmstype;		/* DB type (DBMSの種類名)    */
	char *dbmsname;		/* DBMS 接続別の識別名 (計算して算出します) */
	char *hostname;		/* DB servername             */
	char *hostport;		/* DB ポート番号             */
	char *dbname;		/* DB データベース名         */
	char *username;		/* DB 接続ユーザ名           */
	char *password;		/* DB 接続ユーザのパスワード */

	/* DB コネクションプールを使用するかどうか (UNSET/OFF/ON/NOTHREAD) */
	apr_int32_t dbpool;
	apr_int32_t dbmaxspareconn;	/* コネクションを保持しておける最大数 */
	apr_int32_t dbminspareconn;	/* コネクションを保持しておく最小数   */

	/*
	 * メール関連
	 */
	char *mail;		/* MAIL type (MailSystemの種類) */
	char *mailhost;		/* MAIL hostname                */
	char *mailport;		/* MAIL PORT番号                */
	char *mailadminaddr;	/* MAIL 管理者のメールアドレス  */
	char *mlusername;       /* SMTP auth username */
	char *mlpassword;       /* SMTP auth password */
	char *mailencoding;	/* MAILのエンコード             */

	/* サーバ主体のメール送信を行うかどうか (UNSET/OFF/ON) */
	int mlserversend;

	/* サーバ主体のメール送信を行う時、メールテンプレートが格納されているパス */
	char *mltemplateroot;

	/* メールによるアクション通知を行うかどうか (UNSET/OFF/ON) */
	int mlnotifyact;

	/* 監視メールの本文に親フォルダのURLを付けるかどうか (UNSET/OFF/ON) */
	int mloneclickurl;

	/* メール編集機能を有功にするかどうか (UNSET/OFF/ON) */
	int mledit;

	/* 監視メールの送信アドレス(from)を変更する場合のアドレス */
	char *mlrepfromaddr;

	/* 監視メールの送信アドレス(from)を変更する場合の名前 */
	char *mlrepfromname;

	/* メールを一人一人に送信する間隔（秒） */
	int mlsendinterval;

	/*
	 * LDAP 関連
	 */
	int  ldap;		/* LDAPの利用 */
	char *ldapbasedn;	/* LDAPベースDN */
	char *ldapbinddn;	/* LDAPバインドDN */
	char *ldapbindpw;	/* LDAPバインドパスワード */
	char *ldapattr;		/* LDAP検索アトリビュート */
	char *ldapfilter;	/* LDAP検索フィルタ */
	int ldapscope;		/* LDAP検索スコープ */
	char *ldaphost;		/* LDAPホスト名 */
	int ldapport;		/* LDAPホストのポート番号 */
	char *ldapurl;		/* LDAPホストのURL */

 	/* LDAP接続にSSLを利用するか (1: 有効)*/
	int  ldapsslsupport;

	/* LDAPでTeamFileに該当するユーザIDのマップ */
	char *ldapmapuserattr;

	/* LDAPでTeamFileに該当するユーザパスワードのマップ */
	char *ldapmappasswordattr;

	/* LDAPでTeamFileに該当するフルネームのマップ */
	char *ldapmapfullnameattr;

	/* LDAPでTeamFileに該当するメールアドレスのマップ */
	char *ldapmapmailaddrattr;

	/* LDAPでTeamFileに該当するコメントのマップ */
	char *ldapmapcommentattr;

	/* LDAPに存在したときTeamFileに存在しなかったらレコードを作成する */
	int ldapfoundcreate;

	/* LDAPの内容をTeamFileのユーザテーブルに同期させるか */
	int ldapsyncproperty;

	/* LDAP管理を行なわないユーザ一覧 */
	divy_array_t *ldapallowuser;

	/* LDAP管理を行わないユーザの正規表現ルール */
	char *ldapallowuserregex;

	/* LDAP管理ユーザのアクセス権限 */
#define DIVY_LDAP_OPT_UNSET            0x00  /* 未指定                   */
#define DIVY_LDAP_OPT_NOTUSERFOLDER    0x01  /* ユーザフォルダを作らない */
#define DIVY_LDAP_OPT_NOTGROUPFOLDER   0x02  /* グループフォルダを作らない */
#define DIVY_LDAP_OPT_NOTDBFOLDER      0x04  /* DBフォルダを作らない     */
#define DIVY_LDAP_OPT_NOTREPOSDBFOLDER 0x08  /* リポジトリDBを作らない   */
	int ldapuseroptions;

	/* LDAP管理ユーザの作成するときのファイル容量 */
	apr_int64_t ldapmaxresquota;

	/* LDAP管理ユーザがいなくなった場合のTeamFileユーザの挙動 */
#define DIVY_LDAP_NOTFOUNDUSERACTION_DELETE  1 /* 削除する     */
#define DIVY_LDAP_NOTFOUNDUSERACTION_DISABLE 2 /* 非活性にする */
	int ldapusernotfoundaction;

	/*
	 * misc
	 */

	/* WebFolder, Browser 経由でグループを見せるかどうか (UNSET/OFF/ON) */
	int show_group;

	/* GET要求に対する一覧表示を有効にするかどうか (UNSET/OFF/ON) */
	int autoindex;

	/* autoindex 用StyleSheetが格納されているディレクトリの物理パス */
	char *stylesheetroot;

	/* グループURIのfinal path segmentをグループ名と同期化 (UNSET/OFF/ON) */
	int syncgrpuri;

	/* あるLocationの中に登録可能な最大ユーザ数 */
	apr_int32_t maxuser;

	/* ユーザ毎のパスワードを暗号化するか (ON/OFF) */
	int encryptpassword;

	/* ごみ箱機能を利用するかどうか(UNSET/OFF/ON) */
	int trashfolder;

	/* 拡張ユーザステータスを利用するかどうか(UNSET/OFF/ON) */
	int extenduserst;

	/* メール等によるアクション通知で利用されるURLのホスト名パート */
	char *notifyservername;

	/* Chunk PUT サポートの有無 (1: サポートする) */
	int chunkput;

	/*
	 * ウィルス検索系プロパティ
	 */

	/* ウィルス検索プロバイダの種類 (off / 名称) */
	char *vscan;

	/* ストリームAPIを利用するかどうか (UNSET/OFF/ON) */
	int streammethod;

	char *vschostname;	/* ウィルス検索エンジンのホスト名   */
	char *vschostport;	/* ウィルス検索エンジンのポート番号 */
	char *vsccmd;		/* ウィルス検索実行コマンド         */

	/* others */
#ifdef DIVY_SUPPORT_PRINTER
	/* プリンタ連携機能を利用するかどうか */
	int netprint;

	/* プリンタと関連付けられているグループ名 */
	char *printergroupname;

	/* プリンタの名前(CUPS上の名前) */
	char *printername;
#endif	/* DIVY_SUPPORT_PRINTER */
#ifdef DIVY_SUPPORT_PREFLIGHT_PLUGIN
	/* ファイル出力先のディレクトリパス(フルパス) */
	char *plrootpath;

	/* 連携グループ名の一覧 */
	divy_cset_t *plgroupset;

#endif	/* DIVY_SUPPORT_PREFLIGHT_PLUGIN */

	/* サムネイル機能が利用可能かどうか */
	int thumbnail;

#ifdef DIVY_SUPPORT_PASSPOLICY
	/*
	 * パスワードポリシー関連
	 */

	/* パスワードポリシー機能が利用可能かどうか */
	int passpolicy;

	/* パスワードポリシーサポート機能フラグ */
	int passpolicy_opt;
#endif	/* DIVY_SUPPORT_PASSPOLICY */

#ifdef DIVY_SUPPORT_LOGACCESS
	/*
	 * ログ取得機能関連
	 */
	/* ログ取得機能が利用可能かどうか */
	int logaccess;
#endif	/* DIVY_SUPPORT_LOGACCESS */

	/*
	 * 自動削除機能関連
	 */
	/* 自動削除機能が有効かどうか */
	int autodelete;

	/* 自動削除が有効なIPアドレス(apr_ipsubnet_t *) 一覧を保持する可変長配列 */
	divy_array_t *autodel_allowipaddrs;

	/*
	 * アクション拡張コマンド関連
	 */
	/* アクション拡張コマンド利用の有無 (1: 利用する) */
	int execengine;

	/* アクション拡張コマンドのコマンドライン */
	char *execoncmd;

	/* アクション拡張コマンド実行できる正規表現 */
	char *execmatch;

	/* ユーザ、グループの強制削除機能を利用するかどうか (DIVY_FORCEDELETE_ON: 利用する) */
	int forcedelete;

	/*
	 * リバースプロキシ対応
	 */
	/* リバースプロキシの存在を確認するかどうか */
	int rproxyuse;

	/* リバースプロキシのViaヘッダ名称に一致する正規表現 */
	char *rproxymatch;

	/* リバースプロキシへの接続スキーマを推測/指定するためのスキーマ名.
	 * ここにhttp/https の値が指定されると、推測せずに、その値を使います.
	 * auto の値が指定されると、rproxyhttpport / rproxyhttpsport にマッチした
	 * スキーマ名を使います */
	int rproxyschema;

	/* リバースプロキシのHTTP 受け付けポート番号 */
#define DIVY_RPROXY_HTTPPORT_DEFAULT	80
	int rproxyhttpport;

	/* リバースプロキシのHTTPS 受け付けポート番号 */
#define DIVY_RPROXY_HTTPSPORT_DEFAULT	443
	int rproxyhttpsport;

	/* システムCGIからTeamFileに接続するためのポート番号
	 * 自動認識: DIVY_SYSCGI_CONNECT_PORT_AUTO */
	int syscgiconnectport;

	/* システムCGIからTeamFileに接続するためのスキーマ(enumで値定義) */
	int syscgiconnectschema;

	/* メール等によるアクション通知で利用されるURLのポート名パート
	 * 自動認識: DIVY_NOTIFYSERVER_PORT_AUTO */
	int notifyserverport;

	/* メール等によるアクション通知で利用されるURLのスキーマパート(enumで値定義) */
	int notifyserverschema;

	/* 操作ログ機能の有効/無効(DIVY_LOGOPERATION_ON で有効) */
	int logoperation;

	/* ライセンスアップロードの有効/無効 (DIVY_LICENSEUPLOADER_ON で有効) */
	int licenseuploader;

	/* グループリーダ機能の有効/無効 (DIVY_GROUPLEADER_ON で有効) */
	int groupleader;

	/* パスワードポリシー例外規則 */
#ifdef DIVY_SUPPORT_PASSPOLICY
	divy_passpolicy_exclusion *passpolicy_exs;

#endif	/* DIVY_SUPPORT_PASSPOLICY */

	/* 開封通知機能の有効/無効 (DIVY_CONFIRMREADING_ON で有効) */
	int confirmreading;

	/* 開封通知が自動削除されるまでの期間(日) */
	int cr_reservedday;

	/* 拡張メッセージの有効/無効(DIVY_EXTENDSYSMSG_ON で有効) */
	int extendsysmsg;

	/* グループクォータ機能の有効/無効 (DIVY_GROUPQUOTA_ON で有効*/
	int groupquota;

	/* 管理者が利用できるapr_ipsubnet_t * の配列を持つ構造体  */
	divy_array_t *allowadminipaddrs;

	/* ブラウザのWebフォルダリンクを表示しない */
	int disablewebfolderlink;

	/* ブラウザのパスワード変更リンクを表示しない */
	int disablechangepassword;

	/* ロケーションのマスターパスワード */
	char *masterpassword;

	/* アップロード専用ユーザのダウンロード許容時間 */
	int uldownloadallowtime;

	/* セッションの利用の有無 */
	int usesession;

	/* ブラウザのセッションのタイムアウト（秒） */
#define DIVY_SESSION_TIMEOUT_INFINITY 0		/* 無期限 */
	int sessiontimeout;

	/* IPアドレスなどのアクセス制限利用の有無 */
	int useaccesscontrol;

	/* IPアドレス制限ユーザ以外のデフォルト動作 */
	int defaultaccessrule;

	/* ロックアウト機能利用の有無 */
	int failedloginlockout;

	/* ロックアウトまでのチャレンジ回数 */
	int lockoutlimit;

	/* ロックアウトされたユーザを解除する時間(秒) */
	int unlocktime;
	
	/* ロックアウトのチャレンジリトライ回数 */
	int unlockretrycount;

	/* ショートURLが利用できるか */
	int shortenurl;

	/* BOXが利用できるか */
	int tfbox;

	/* サーバ—ポリシーヘッダ tfboxpolicylimitを連結 */
	char *tfserverpolicyheader;

	/* サーバーポリシーの一つ BOXポリシー (boxlimit=<time>)*/
	apr_int64_t tfboxpolicylimit;

	/* サーバ—ポリシーの一つ BOX利用禁止フォーマット(boxdisableformat=<....>*/
#define DIVY_BOX_DISABLE_FORMAT_NONE	0x00
#define DIVY_BOX_DISABLE_FORMAT_LIST	0x01
#define DIVY_BOX_DISABLE_FORMAT_XML		0x02
#define DIVY_BOX_DISABLE_FORMAT_JSON	0x04
#define DIVY_BOX_DISABLE_FORMAT_RSS		0x08
	int tfboxdisableformat;

	/* memcacheを利用するか */
	int usememcache;

	/* memcachedサーバ */
	divy_memcache_t *memd;

	/* SAMLを利用するか */
	int usesaml;

	/* SAML IdP メタデータ */
	divy_saml_idp_metadata *idpmeta;

	/* SAML XML secret key */
	char *saml_privatekeypath;

	/* SAML XML public key */
	char *saml_x509certificatepath;

	/* SAMLのIDをTeamFileのメールと結びつける */
	int saml_matchedmailaddr;

	/* ブラウザのいろいろなスタイル */
#define DIVY_BROWSER_STYLE_NONE					0x00
#define DIVY_BROWSER_STYLE_INVISIBLE_BRAND		0x01
#define DIVY_BROWSER_STYLE_OLDLOGINPAGE			0x02
	int tfbrowserstyle;

	/* カスタムイメージのパス */
	char *tfcustomimagepath;

	/* アップロードポリシーを利用するか */
	int useuploadpolicy;

	/* 二要素認証を利用するか */
	int use2fa;

	/* 二要素認証のサイクル開始時間 */
	int cyclebasetime2fa;

	/* 二要素認証が有効になる期間 */
	char *cycleperiod2fa;

	/* 二要素認証の種類 */
	int type2fa;

	/* 二要素認証の利用ステージ */
	int stage2fa;

	/* サーバポリシーの一つ boxのメールにワイルドカードを指定できない */
	int boxdisablewildcardmailaddr;

#define BOX_WITHOUTMAIL_NONE 0x00	/* 未設定     */
#define BOX_WITHOUTMAIL_USER 0x01	/* ユーザのみ */
#define BOX_WITHOUTMAIL_ALL  0x02	/* 全員       */
	/* サーバポリシーの一つ BOXに登録したユーザにメールを送らない */
	int boxwithoutmail;

#ifdef TF_SUPPORT_CIPHER_STORAGE
	/* ストレージを暗号化するか否か */
	int cipherstorage;

	/* ストレージを暗号化する時に利用する鍵 */
	char *cipherstoragekey;

	/* ストレージを暗号化する種類 */
	int cipherstoragetype;
#endif
};

typedef struct __dav_divy_dir_conf dav_divy_dir_conf;


/**
 * 構造体dav_liveprop_spec の propidメンバの値 (プロパティIDの定義)
 *
 * (note)
 * 	ここの値は、Liveプロパティプロバイダの中で整合性が取れていれば
 * 	よいという(mod_dav.hの)仕様になっている。
 * 	Catacomb と dav_fs は、mod_dav.h に定義された値を使用しているが
 * 	mod_dav_tfでは独自のLiveプロパティID定義します。
 *
 * 	DAV_DIVY_PROPID_BEGIN は、標準プロパティと衝突しないようにするため
 * 	のバイアス値です。mod_dav.hでは、DAV_PROPID_BEGIN=20000としています
 * 	ので、それとも重ならない値を採用しました。
 * 	ですので、DAV_DIVY_PROPID_BEGINとDAV_DIVY_PROPID_ENDのpropidは
 * 	プロパティにマッピングされていないことに注意して下さい。
 *
 * (note)
 * 	* ここの並びは、liveprop.c の 配列dav_divy_propsとあわせています。
 * 	  変更しないで下さい。(LiveプロパティがASCIIの昇順になっているからです)
 *
 *	* 新しいLiveプロパティの追加方法についてはliveprop.c のコメントを参照
 *
 */
enum __dav_divy_propid_info {
	
	 DAV_DIVY_PROPID_BEGIN = 30000,	/*バイアス値  */
	 
	 DAV_DIVY_PROPID_analysiserrdiscovery,	/* TeamFile */
	 DAV_DIVY_PROPID_changeleader,	/* TeamFile */
	 DAV_DIVY_PROPID_changeowner,	/* TeamFile */
#ifdef DIVY_SUPPORT_PASSPOLICY
	 DAV_DIVY_PROPID_changepassword,	/* TeamFile */
#endif	/* DIVY_SUPPORT_PASSPOLICY */
	 DAV_DIVY_PROPID_confirmreading,	/* TeamFile */
	 DAV_DIVY_PROPID_creationdate,		/* RFC2518  */
	 DAV_DIVY_PROPID_creator,		/* TeamFile */
	 DAV_DIVY_PROPID_dbmsdiscovery,		/* TeamFile */
	 DAV_DIVY_PROPID_dbmserrdiscovery,	/* TeamFile */
	 DAV_DIVY_PROPID_dependsqldiscovery,	/* TeamFile */
	 DAV_DIVY_PROPID_displayname,		/* RFC2518  */
	 DAV_DIVY_PROPID_displayorder,		/* TeamFile */
	 DAV_DIVY_PROPID_foldertype,		/* TeamFile */
	 DAV_DIVY_PROPID_getcontentlanguage,	/* RFC2518  */
	 DAV_DIVY_PROPID_getcontentlength,	/* RFC2518  */
	 DAV_DIVY_PROPID_getcontenttype,	/* RFC2518  */
	 DAV_DIVY_PROPID_getetag,		/* RFC2518  */
	 DAV_DIVY_PROPID_getlastmodified,	/* RFC2518  */
	 DAV_DIVY_PROPID_groupdiscovery,	/* TeamFile */
	 DAV_DIVY_PROPID_groupstate,	/* TeamFile */
	 DAV_DIVY_PROPID_keylist,		/* TeamFile */
	 DAV_DIVY_PROPID_lastmodifier,		/* TeamFile */
	 DAV_DIVY_PROPID_linkdberrdiscovery,	/* TeamFile */
	/* Core live プロパティプロバイダに任せるので定義出来ない */
#if 0
	 DAV_DIVY_PROPID_lockdiscovery,		/* RFC2518  */
#endif
	 DAV_DIVY_PROPID_mailwatch,		/* TeamFile */
#ifdef DIVY_SUPPORT_PASSPOLICY
	 DAV_DIVY_PROPID_passwordpolicy,	/* TeamFile */
#endif	/* DIVY_SUPPORT_PASSPOLICY */
	 DAV_DIVY_PROPID_resourcestate,		/* TeamFile */
	 DAV_DIVY_PROPID_resourcetype,		/* RFC2518  */
	 DAV_DIVY_PROPID_sharedcollection,	/* TeamFile */
	 DAV_DIVY_PROPID_shorten,           /* TeamFile */
	 DAV_DIVY_PROPID_source,		/* RFC2518  */
	 DAV_DIVY_PROPID_sqldiscovery,		/* TeamFile */
	 DAV_DIVY_PROPID_sqlpreferencediscovery,/* TeamFile */
	 DAV_DIVY_PROPID_statusdiscovery,	/* TeamFile */
	/* Core live プロパティプロバイダに任せるので定義出来ない */
#if 0
	 DAV_DIVY_PROPID_supportedlock,		/* RFC2518  */
#endif
	 DAV_DIVY_PROPID_sysmsgdiscovery,	/* TeamFile */
#ifdef DIVY_SUPPORT_EXTENDQUOTA
	 DAV_DIVY_PROPID_systemquota,		/* TeamFile */
#endif	/* DIVY_SUPPORT_EXTENDQUOTA */
	 DAV_DIVY_PROPID_thumbnail,         /* TeamFile */
	 DAV_DIVY_PROPID_trashdiscovery,	/* TeamFile */
	 DAV_DIVY_PROPID_trashinformation,	/* TeamFile */
	 DAV_DIVY_PROPID_updatediscovery,	/* TeamFile */
	 DAV_DIVY_PROPID_user_privilege_grant_set,	/* TeamFile */
	 DAV_DIVY_PROPID_userdiscovery,		/* TeamFile */

	 /* 終了を表す為だけに存在する値.
	  * 新しいLiveプロパティのプロパティIDはプロパティ名が
	  * ASCIIの昇順になるように挿入すること。*/
	 DAV_DIVY_PROPID_END
};

typedef enum __dav_divy_propid_info dav_divy_propid_info;

/*--------------------------------------------------------------
  Declare Provider Hook structure
  --------------------------------------------------------------*/
extern const dav_hooks_repository dav_divy_hooks_repository;
extern const dav_hooks_propdb     dav_divy_hooks_propdb;
extern const dav_hooks_search     dav_divy_hooks_search;
extern const dav_hooks_liveprop   dav_divy_hooks_liveprop;
extern const dav_hooks_locks      dav_divy_hooks_locks;

#ifdef DIVY_SUPPORT_VERSIONING
extern const dav_hooks_vsn        dav_divy_hooks_vsn;
#endif

/*------------------------------------------------------------------------------
  Declar prototype functions
  ----------------------------------------------------------------------------*/
/**
 * mod_dav_tf のサーバコンフィグ構造体を取得する。
 *
 * @param s server_rec* server_rec構造体へのポインタ
 * @return dav_divy_server_conf*
 */
DIVY_DECLARE(dav_divy_server_conf *) dav_divy_get_server_config(server_rec *s);

/**
 * mod_dav_tf の ディレクトリコンフィグ構造体を取得する。
 *
 * @param s request_rec * request_rec 構造体へのポインタ
 * @return dav_divy_dir_conf*
 */
DIVY_DECLARE(dav_divy_dir_conf *) dav_divy_get_dir_config(request_rec *r);

/**
 * グループフォルダの表示を行っても良いかどうか。
 *
 * @param r request_rec * Apache環境変数を持つリクエストレコード
 * @return int 良いかどうか (1: OK / 0: だめ)
 */
DIVY_DECLARE(int) divy_enable_groupview(request_rec *r);

/**
 * プライベートコレクションの表示を行っても良いかどうか。
 *
 * @param r request_rec * Apache環境変数を持つリクエストレコード
 * @return int 良いかどうか (1: OK / 0: だめ)
 */
DIVY_DECLARE(int) divy_enable_userfolderview(request_rec *r);

/**
 * ごみ箱フォルダ機能をサポートしているかどうか
 * (note)
 * 	ごみ箱機能をサポートしているということは、ごみ箱プロパティを保持できる
 * 	機構(テーブル)を用意できているということになります。
 *
 * @param r request_rec * Apache環境変数を持つリクエストレコード
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_trashfolder(request_rec *r);

/**
 * ごみ箱フォルダに対するアクセスを行ってもよいかどうか。
 * (note)
 * 	ごみ箱フォルダに対するアクセスが許可されても、ごみ箱プロパティを持つ
 * 	ことが出来るかどうか分かりません。divy_support_trashfolder 関数を使って
 * 	調べてください。
 *
 * @param r request_rec * Apache環境変数を持つリクエストレコード
 * @return int 良いかどうか (1: OK / 0: だめ)
 */
DIVY_DECLARE(int) divy_enable_trashfolder_access(request_rec *r);

/**
 * 拡張ユーザステータス機能をサポートしているかどうか
 * (note)
 * 	拡張ユーザステータス機能をサポートしているということは
 * 	ユーザ情報を保持する機構が用意できていることを示します。
 *
 * @param r request_rec * Apache環境変数を持つリクエストレコード
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_extenduserstatus(request_rec *r);

#ifdef DIVY_SUPPORT_PASSPOLICY
/**
 * パスワードポリシー機能をサポートしているかどうか
 *
 * @param r request_rec * Apache環境変数を持つリクエストレコード
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_passpolicy(request_rec *r);
#endif	/* DIVY_SUPPORT_PASSPOLICY */

/**
 * メール送信をサポートしているかどうか.
 *
 * @param r request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_mail(request_rec *r);

/**
 * Chunk PUT をサポートしているかどうか.
 *
 * @param r request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_chunkput(request_rec *r);

/**
 * 操作ログ機能をサポートしているかどうか.
 *
 * @param r request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_logoperation(request_rec *r);

/**
 * グループ制約属性をサポートしているかどうか.
 * (2007/09/13 Thu)
 *   この機能はグループリーダ機能のサポート有無と同値になりました
 *
 * @param r request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_grpconstraints(request_rec *r);

/**
 * 指定されたbit 値を元に、クライアントに通知するサポート機能の有無を表す文字列を組み立てる.
 *
 * @param r request_rec *
 * @param funcbit unsigned int サポートの有無を表すビット値
 * @return char * 組み立てらた文字列 (NULLならば、設定しない)
 */
DIVY_DECLARE(char *) divy_build_supportedfunc_str(request_rec *r, unsigned int funcbit);

/**
 * 指定したタイプが専用クライアントによってサポートされている/そういう性質であるかどうか調べる.
 * (1: 機能がある or そういう性質である / 0: 機能がない or そういう性質ではない / -1: どちらでもない or 不明)
 *
 * @param r request_rec *
 * @param type divy_clfunc_type 調べたいタイプ
 * @return int サポートしているかどうか
 */
DIVY_DECLARE(int) divy_get_clientinfo(request_rec *r, divy_clfunc_type type);

/**
 * ライセンスアップローダをサポートしているかどうか.
 *
 * @param r request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_licenseuploader(request_rec *r);

/**
 * グループリーダ機能をサポートしているかどうか.
 *
 * @param r request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_groupleader(request_rec *r);

/**
 * システムメッセージ拡張をサポートしているかどうか.
 *
 * @param request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_extendsysmsg(request_rec *r);

/**
 * ログインロックアウト機能をサポートしているかどうか
 *
 * @param request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_failedlogin_lockout(request_rec *r);

/**
 * グループクォータ拡張をサポートしているかどうか.
 *
 * @param request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_groupquota(request_rec *r);

/**
 * ブラウザのWebフォルダの表示をなくすか？
 *
 * @param request_req *
 * @param int 表示しないかどうか（1: 表示しない / 0:表示する）
 */
DIVY_DECLARE(int) divy_disable_webfolerlink(request_rec *r);

/** 
 * ブラウザ セッション をサポートしているか？
 *
 * @param request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_session(request_rec *r);

/** 
 * アドレス制限機能をサポートしているか？
 *
 * @param request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_access_control(request_rec *r);

/**
 * 短縮URL機能をサポートしているか？
 *
 * @param request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_shorten(request_rec *r);

/**
 * memcache機能を有効にしているか？
 *
 * @param request_rec *
 * @return int (1: 有効 / 0: 無効)
 */
DIVY_DECLARE(int) divy_enable_memcache(request_rec *r);

/**
 * SAML機能をサポートしているか？
 *
 * @param request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_saml(request_rec *r);

/**
 * アップロードポリシーをサポートしているか？
 *
 * @param request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_upload_policy(request_rec *r);

/**
 * 二段階認証をサポートしているか？
 *
 * @param request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_2FA(request_rec *r);

#ifdef __cplusplus
}
#endif

#endif	/* INCLUDE_MOD_DAV_DIVY_H */
