/**
 * $Id$
 *
 * repos.h
 *
 * Repository・プロバイダ用ヘッダファイル
 *
 * 変更履歴
 *
 * 2003/03/07 Fri takehara 構造体dav_resource_private、dav_divy_resourceを
 *                         divy_rdbo.h に移動
 * 2003/02/18 Tue takehara NEW (empty implementation)
 *
 */
#ifndef INCLUDE_REPOS_H
#define INCLUDE_REPOS_H

/* Apache header files */
#include "httpd.h"
#include "apr.h"
#include "apr_pools.h"
#include "apr_file_io.h"
#include "mod_dav.h"

#if APR_HAVE_TIME_H
#include <time.h>
#endif	/* APR_HAVE_TIME_H */

#include "tfr.h"
#include "mod_dav_tf.h"
#include "tf_storage.h"
#include "tf_vscan.h"
#include "tf_extcmd.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*--------------------------------------------------------------
  Define fixed values and define types.
  --------------------------------------------------------------*/

/*--------------------------------------------------------------
  Define structures and enums
  --------------------------------------------------------------*/

/*--------------------------------------------------------------
  Define incomplete type structure
  --------------------------------------------------------------*/
/*
 * "STREAM" STRUCTURE (see mod_dav.h)
 *
 * resourceを取得・格納する際に、リポジトリと対話するために使用される構造体.
 * 1つのdav_streamは、1つのresourceに対応付けられています。
 * mod_davは、byte streamとしてresourceを見ます。
 * この構造体は、dav_divy_open_streamによって生成されます。
 *
 * (注意)
 * この構造体は、PUTメソッドによる書き込みrequestを処理するためだけに残されて
 * います。GETメソッドによる読み込みrequestは、Apacheのfilter機構により処理
 * されています。
 */
struct dav_stream {
	
	/* resourceをファイルとして参照するための構造体 (apr_file_openなど) */
	apr_file_t *f;
	
	/* resourceを表す構造体へのポインタ */
	dav_resource *resource;
	
	/* 現在までに読み込んだ総バイト数 */
	apr_int64_t read_size;
	
	/* 最終的に保存される物理ファイルの総バイト数
	 * (note)
	 *    read_size と同じかもしれないし、プラグインの影響により異なる値
	 *    かもしれない。だが、最終的に保存されるファイルのサイズ.
	 */
	apr_int64_t clength;

	/* 物理ファイルの抽象パス表現 */
	divy_pfile_t *pfile;
	
	/* dav_stream 操作で使用するプール(request pool) */
	apr_pool_t *p;

	/* ウィルス検索プロバイダへのポインタ */
	VscDataSource *vscds;

	/* ウィルス検索プロバイダとのセッション */
	VscSession *vscsession;

	/* ストリームファイルコンテキストへのポインタ */
	VscStreamFile *sfile;

	/* ウィルス感染が発覚した(ストリームベースAPIの場合) */
	int is_infected;	/* 0: 未感染 / 1: 感染 */

	/* Chunk モードのPUTかどうか(0: 非Chunk / 1: Chunk) */
	int is_chunkput;
};


/*------------------------------------------------------------------------------
  Declar prototype functions
  ----------------------------------------------------------------------------*/
/**
 * Etag フォーマットの文字列を作成して返却する。
 * (note)
 * 	rsid は絶対にNULLであってはなりません。
 * 	NULLの場合、「""」を返却します。(保険のため。)
 *
 * @param p apr_pool_t *
 * @param rsid char * リソースID
 * @param getcontentlength apr_int64_t Content-Length
 * @param creationdate time_t 作成日付
 * @return const char * Etag 文字列
 */
DIVY_DECLARE(const char *) dav_divy_get_etag_string(apr_pool_t *p, char *rsid,
				      apr_int64_t getcontentlength,
				      time_t creationdate);


#ifdef __cplusplus
}
#endif

#endif	/* INCLUDE_REPOS_H */

