/**
 * $Id$
 *
 * search.h
 *
 * Search・プロバイダ用ヘッダファイル
 * 
 * 変更履歴
 *
 * 2003/04/04 Fri nakayama NEW
 *
 */
#ifndef INCLUDE_SEARCH_H
#define INCLUDE_SEARCH_H

#include "apr.h"
#include "apr_pools.h"

#if APR_HAVE_TIME_H
#include <time.h>
#endif	/* APR_HAVE_TIME_H */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*--------------------------------------------------------------
 *   Define Fixed values
 *--------------------------------------------------------------*/
/* search options */
#define DIVY_SEARCH_OPT_TREELIST	1
#define DIVY_SEARCH_OPT_DETAILLIST 	2
#define DIVY_SEARCH_OPT_AVAILABLEGROUP 	3
#define DIVY_SEARCH_OPT_CONTENT 	4
#define DIVY_SEARCH_OPT_QUERYCONTENT 	5
#define DIVY_SEARCH_OPT_ALLLIST 	6
#define DIVY_SEARCH_OPT_SQLSTMT 	7
#define DIVY_SEARCH_OPT_AVAILABLEUSER 	8
#define DIVY_SEARCH_OPT_AVAILABLESQL 	9
#define DIVY_SEARCH_OPT_LINEUP 		10
#define DIVY_SEARCH_OPT_CURRENTMSG 	11
#define DIVY_SEARCH_OPT_TREELIST_TOP 	12
#define DIVY_SEARCH_OPT_DETAILLIST_TOP 	13 
#define DIVY_SEARCH_OPT_GROUPLIST 	14 
#define DIVY_SEARCH_OPT_ANALYSIS 	15 
#define DIVY_SEARCH_OPT_REPOSSQLSTMT 	16
#define DIVY_SEARCH_OPT_DEPENDSQLLIST 	17
#define DIVY_SEARCH_OPT_EXECSQLSTMT 	18
#define DIVY_SEARCH_OPT_MANAGEMENT 	19
#define DIVY_SEARCH_OPT_SQLPREFERENCE 	20
#define DIVY_SEARCH_OPT_ACTIVEDBMS 	21
#define DIVY_SEARCH_OPT_LICENSEDBMS 	22

#define DIVY_SEARCH_OPT_QUERYCONTENT_FD 50	/* Failed Dependency の場合 */
#define DIVY_SEARCH_OPT_ANALYSIS_SQLERR 51 	/* 文法エラー */

/* linkdbsearch exectypes */
#define DIVY_SEARCH_LDB_NORMAL 	1
#define DIVY_SEARCH_LDB_REPOSITORY 	2
#define DIVY_SEARCH_LDB_MLKDB 		3

/* linkdb displayname maxvalue */
#define DIVY_SEARCH_DISPN_MAXSLEN 255

/* linkdb empty displayname replacevalue */
#define DIVY_SEARCH_LKDB_EMPTYVALUE "(EMPTY)"

/* execute status(linkdbsearch) */
#define DIVY_LDB_ST_OK			0	/* 正常 */
#define DIVY_LDB_ST_ERR			1	/* 予期しないエラー */
	/* 以下の２つは1つの関数の中でステータスを使い分ける時に使用 */
#define DIVY_LDB_ST_ERR_BADREQ		2	/* 予期しないエラー(badrequest) */
#define DIVY_LDB_ST_ERR_IERR		3	/* 予期しないエラー(internal server error) */
#define DIVY_LDB_ST_MISMATCH_BINDVAL 	4	/* バインド変数とリクエストに含まれる値の数が一致しない */
#define DIVY_LDB_ST_SQL_NOT_SELECT 	5	/* SQL 文が SELECT 以外 */
#define DIVY_LDB_ST_NSQL_TOOFEW_COLUMN 	6	/* SELECT カラムが少ない(通常SQL) */
#define DIVY_LDB_ST_REQSQL_WRONG_COLUMN 7	/* SELECT カラムの数が正しくない(RequiredSQL) */
#define DIVY_LDB_ST_REPSQL_SYNTAX_ERR 	8	/* 文法が正しくない(リポジトリSQL) */
#define DIVY_LDB_ST_MISMATCH_REQVAL 	9	/* Requiredとリクエストに含まれる値の数が一致しない */
#define DIVY_LDB_ST_NSQL_TOOMANY_COLUMN 10	/* SELECT カラムが多い(通常SQL) */
#define DIVY_LDB_ST_NO_BINDVAL		11	/* バインド変数値がリクエストに含まれていない */
#define DIVY_LDB_ST_EMPTY_DBKEY		12	/* DBキーが空だった */
#define DIVY_LDB_ST_NO_REQVAL		13	/* Required値がリクエストに含まれていない */
#define DIVY_LDB_ST_ERR_DBPROVIDER	14	/* DBプロバイダがエラーを返却した */

/* basicsearch で使用する特殊な定義値 */
/**
 * リソースそのものの情報を保持するテーブルの名称を表す値
 */
#define DIVY_RESOURCE_TABLE "dav_resource"

/**
 * DIVY_RESOURCE_TABLE が表すテーブルの参照名
 */
#define DIVY_RESOURCE_TABLE_REF	"rs"

/*--------------------------------------------------------------
 *   Declare structures and enum
 *--------------------------------------------------------------*/
/**
 * [ 不完全型の宣言 ]
 *   SEARCH の種類をそれを処理する関数との対応関係を記録する構造体
 */
typedef struct __divy_search_process	divy_search_process;

typedef struct __divy_search_ldb_err	divy_search_ldb_err;
typedef struct __divy_search_bs_bind	divy_search_bs_bind;
typedef struct __divy_search_useris_iscreen	divy_search_useris_iscreen;
typedef struct __divy_search_grpis_iscreen	divy_search_grpis_iscreen;
typedef struct __divy_search_sysmsgis_iscreen	divy_search_sysmsgis_iscreen;
typedef struct __divy_search_updateis_iscreen	divy_search_updateis_iscreen;
typedef struct __divy_search_dbmsis_iscreen	divy_search_dbmsis_iscreen;
typedef struct __divy_search_ldbs_bind		divy_search_ldbs_bind;
typedef struct __divy_search_ldbs_iscreen	divy_search_ldbs_iscreen;

/**
 * linkdbsearch で発生した１つのエラー情報記述する構造体
 */
struct __divy_search_ldb_err {
	int retcd;	/* linkdbsearch 時に返却されるエラーリターン値 */
	const char *code_l;	/* ステータスコード(linkdbsearch) */
	const char *msg_l;	/* エラーメッセージ(linkdbsearch) */
	const char *code_m;	/* ステータスコード(managementlinkdbsearch) */
	const char *msg_m;	/* エラーメッセージ(managementlinkdbsearch) */
};

/**
 * basicsearch でバインドの形式をあらわす値
 */
enum __divy_search_bs_bindtype {
	DIVY_SEARCH_BIGLONG_TT = 0,	/* setBigInt(time_t) 	*/
	DIVY_SEARCH_BIGLONG_I64,	/* setBigInt(int64)	*/
	DIVY_SEARCH_STRING		/* setString		*/ 
};
typedef enum __divy_search_bs_bindtype divy_search_bs_bindtype;

/**
 * basicsearch でバインドの形式とバインド値を持つ構造体
 */
struct __divy_search_bs_bind {
	divy_search_bs_bindtype type;
	time_t ttval;
	apr_int64_t i64val;
	char *strval;
};

/**
 * userinformationsearch が発行された時に指定された値を記録する構造体
 */
struct __divy_search_useris_iscreen {
	const char *userid;	/* ユーザID */
};

/**
 * groupinformationsearch が発行されたときに指定された値を記録する構造体
 */
struct __divy_search_grpis_iscreen {
	/* param_type の種類 */
#define DIVY_SEARCH_GRPIS_NONE_PARAM	0	/* 入力パラメータなし */
#define DIVY_SEARCH_GRPIS_USE_GRPID	1	/* グループIDを使う   */
#define DIVY_SEARCH_GRPIS_USE_GRPURI	2	/* グループURIを使う  */
#define DIVY_SEARCH_GRPIS_USE_GRPCOLURI	3	/* グループコレクションURIを使う */
	int param_type;

	const char *grpid;	/* グループID  */
	const char *grpuri;	/* グループURI */
	const char *grpcol_uri;	/* グループコレクションURI */
};

/**
 * sysmsginformationsearch が発行されたときに指定された値を記録する構造体
 */
struct __divy_search_sysmsgis_iscreen {
	int msgid;	/* メッセージID */
};

/**
 * updateinformationsearch が発行されたときに指定された値を記録する構造体
 */
struct __divy_search_updateis_iscreen {
	const char *lineup;	/* ラインナップ番号 */
};

/**
 * dbmsinformationsearch が発行されたときに指定された値を記録する構造体
 */
struct __divy_search_dbmsis_iscreen {
	const char *dbmsid;	/* DBMS 識別番号 */
};

/**
 * value エレメントを表す構造体
 */
struct __divy_search_ldbs_bind {
	int id;
	char *value;
	divy_search_ldbs_bind *next;
};

/**
 * (note) search.h はtf_rdbo.h をヘッダのinclude 関係からinclude することが
 * できないので、以下を予め宣言しておく必要あり。*/
#ifndef DIVY_DECLARE_STRUCT_RSVALUE
#define DIVY_DECLARE_STRUCT_RSVALUE
typedef struct __divy_rdbo_rsvalue		divy_rdbo_rsvalue;
#endif	/* DIVY_DECLARE_STRUCT_RSVALUE */
/**
 * dbmsinformationsearch が発行されたときに指定された値を記録する構造体
 */
struct __divy_search_ldbs_iscreen {
	const char *sqlid;	/* SQLシーケンス番号 */
	divy_search_ldbs_bind *ldbs_value;	/* value の値   */
	divy_rdbo_rsvalue *ldbs_rsvalue;	/* rsvalue の値 */
	int retcd;		/* ステータスコード */
};

/*-----------------------------------------------------------------------------
 * Declare array
 *----------------------------------------------------------------------------*/
/**
 * linkdbsearch から戻されたエラーリターン値とエラーコード・メッセージの関係を
 * 持つ構造体の配列。
 */
extern const divy_search_ldb_err search_ldb_errs[];

/*--------------------------------------------------------------
 * Declare public function
 *--------------------------------------------------------------*/
/**
 * linkdbsearch の戻り値retcd から、詳細なエラー情報(divy_search_ldb_err)を
 * 取得して返却する。
 *
 * 
 * @param p apr_pool_t *
 * @param retcd int linkdbsearch の結果返却されたエラーコード
 * @return divy_search_ldb_err * 対応するエラー構造体へのポインタ
 */
DIVY_DECLARE(divy_search_ldb_err *) divy_search_get_ldb_err(apr_pool_t *p,
								int retcd);

#ifdef __cplusplus
}
#endif

#endif	/* INCLUDE_SEARCH_H */

