/**
 * $Id$
 *
 * 自動削除周りの操作を行う関数、構造体の定義&宣言
 *
 * (note)
 * 	自動削除関連の関数が散らばってしまうので、一箇所に纏めました。
 * 	それだけです。
 */
#ifndef INCLUDE_TF_AUTODELETE_H
#define INCLUDE_TF_AUTODELETE_H

#include "apr.h"
#include "apr_pools.h"
#include "httpd.h"
#include "mod_dav.h"

#include "mod_dav_tf.h"
#include "tfr.h"
#include "tf_env.h"
#include "util_common.h"
#include "tf_cset.h"
#include "tf_folder.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*------------------------------------------------------------------------------
  Fixed values and Define Macro
  ----------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------
  Declare and Define structure
  ----------------------------------------------------------------------------*/
typedef struct divy_autodel_rb_conf 	divy_autodel_rb_conf;
typedef struct divy_autodel_glist		divy_autodel_glist;
typedef struct divy_autodel_dresource	divy_autodel_dresource;

/**
 * 定期バッチ設定画面用コンフィグ構造体
 */
struct divy_autodel_rb_conf {
	int isActive;	/* 有効かどうか     */
	int hour;		/* 開始時刻(時間)   */
	int min;		/* 開始時刻(分)     */
	int delperiod;	/* 履歴保持期間(日) */
};

/**
 * 自動削除対象グループ一覧を表す構造体
 */
struct divy_autodel_glist {
	char *groupid;	/* 対象グループID */

#define DIVY_AUTODEL_ACTION_NOTHING	0x00	/* 特別なアクションなし */
#define DIVY_AUTODEL_ACTION_DELFOLDER 0x01	/* フォルダを削除する   */
	int spaction;	/* 特殊アクション */

	int pperiod;	/* 保持日数(日)   */

	divy_autodel_glist *next;	/* 次のグループ一覧へのポインタ */
};

/**
 * 削除されたリソースを表す構造体
 */
struct divy_autodel_dresource {

	char *displayname;              /* 名前   */
	apr_int64_t getcontentlength;   /* サイズ */
	char *getcontenttype;           /* 種類   */
	apr_time_t getlastmodified;     /* 更新日時(micro sec) */
	char *lastmodifier_userid;      /* 更新者ID */

	char *lastmodifier;             /* 最終更新者 */
	apr_time_t deletion;            /* 削除日時(micro sec) */

	divy_autodel_dresource *next;
};


/*------------------------------------------------------------------------------
  Declare public functions
  ----------------------------------------------------------------------------*/
/**
 * 自動削除機能がサポートされているかどうか.
 * (note)
 *   サポートされているかどうかは、ライセンスとディレクティブの有効/無効化設定で
 *   決まります.
 *
 * @param r request_rec *
 * @return int サポートされているかどうか(1: サポート済み / 0: 未サポート)
 */
DIVY_DECLARE(int) divy_support_autodelete(request_rec *r);

/**
 * 指定されたu_spec, r が示すリソースが自動削除処理リクエストを受けるのに
 * 適切かどうか.
 *
 * @param r request_rec *
 * @param u_spec divy_uri_spec *
 * @return int 1: 有効 / 0: 無効 / -1: 無効だが特に不正アクセスのケース 
 */
DIVY_DECLARE(int) divy_autodel_enable(request_rec *r, divy_uri_spec *u_spec);

/**
 * 自動削除処理のメイン
 *
 * @param r request_rec *
 * @param resource const dav_resource *
 * @return dav_error *
 */
DIVY_DECLARE(dav_error *) divy_autodel_execute(request_rec *r, const dav_resource *resource);

/**
 * 自動削除対象からグループIDの集合groupid_set のグループ群を対象外とする.
 *
 * @param r request_rec *
 * @param groupid_set divy_cset_t グループIDを要素として持つ集合
 * @return int 処理ステータス(0: 成功 / 1: 失敗)
 */
DIVY_DECLARE(int) divy_autodel_excludeTargets(request_rec *r, divy_cset_t *groupid_set);

/**
 * 指定されたグループID 文字列を自動削除済みリストアクセス用のグループIDに符号化して返却する.
 *
 * @param p apr_pool_t *
 * @param groupid const char * グループID文字列
 * @return char * 符号化したグループID
 */
DIVY_DECLARE(char *) divy_autodel_encipher_groupid(apr_pool_t *p, const char *groupid);

#ifdef __cplusplus
}
#endif

#endif	/* INCLUDE_TF_AUTODELETE_H */

