/**
 * $Id$
 *
 * BOX周りの操作を行う関数、構造体の定義&宣言
 *
 * (note)
 *  BOX対応するための関数群が定義されています.
 */
#ifndef INCLUDE_TF_BOX_H
#define INCLUDE_TF_BOX_H

#include "apr.h"
#include "apr_pools.h"
#include "apr_xml.h"

#include "httpd.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*------------------------------------------------------------------------------
  Fixed values and Define Macro
  ----------------------------------------------------------------------------*/
typedef struct __divy_boxinfo divy_boxinfo;

/*
 * box プロパティ
 */
struct __divy_boxinfo {
	char *allowed_origin; /* 許可されたオリジン */
	int flag;		/* フラグ        */
	const char *creator;      /* BOX作成者ID */
	char *password;     /* パスワード  */
	char *greeting;     /* あいさつ文  */
	char *message;      /* メッセージ  */
	char *creationdate; /* 作成日    */
	char *expiration;   /* 有効期限    */
	char *tomailaddr;	/* 相手先メールアドレス */

	char* rsid;			/* リソースID  */
};

/*------------------------------------------------------------------------------
  Declare and Define structure
  ----------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------
  Declare public functions
  ----------------------------------------------------------------------------*/
/**
 * BOX機能をサポートしているか？
 *
 * @param request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_tfbox(request_rec *r);

/**
 * BOX用の短縮URLが有効かどうか
 *
 * $root/.stへのアクセスであること
 * @param r request_rec * リクエスト構造体
 * @param resource const dav_resource *
 * @return int アクティブかどうか (1 : アクティブ / 0: 非アクティブ)
 */
DIVY_DECLARE(int) divy_enable_box_shorten(request_rec *r, const dav_resource *resource);

#ifdef __cplusplus
}
#endif

#endif	/* INCLUDE_TF_BOX_H */

