/**
 * $Id$
 *
 * 開封通知周りの操作を行う関数、構造体の定義&宣言
 *
 * (note)
 *  主として、開封通知の自動解除バッチに対応するための関数群が定義されています.
 * 	それだけです.
 */
#ifndef INCLUDE_TF_CONFIRMREADING_H
#define INCLUDE_TF_CONFIRMREADING_H

#include "apr.h"
#include "apr_pools.h"
#include "httpd.h"
#include "mod_dav.h"

#include "mod_dav_tf.h"
#include "tfr.h"
#include "tf_env.h"
#include "util_common.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*------------------------------------------------------------------------------
  Fixed values and Define Macro
  ----------------------------------------------------------------------------*/
/**
 * 開封通知の保持日数が無制限であることを表す値
 */
#define DIVY_CONFIRMREADING_INFINITY_RESERVEDDAY	0

/*
 * 開封通知の保持日数のデフォルト値
 */
#define DIVY_CONFIRMREADING_DEFAULT_RESERVEDDAY	DIVY_CONFIRMREADING_INFINITY_RESERVEDDAY

/**
 * 開封通知の保持日数の最大値
 */
#define DIVY_CONFIRMREADING_MAX_RESERVEDDAY	9999

/*------------------------------------------------------------------------------
  Declare and Define structure
  ----------------------------------------------------------------------------*/

/*------------------------------------------------------------------------------
  Declare public functions
  ----------------------------------------------------------------------------*/
/**
 * 開封通知機能をサポートしているかどうか.
 * (note)
 *   サポートされているかどうかは、ライセンスとディレクティブの有効/無効化設定で
 *   決まります.
 *
 * @param r request_rec *
 * @return int サポートしているかどうか (1: サポートしている / 0: していない)
 */
DIVY_DECLARE(int) divy_support_confirmreading(request_rec *r);

/**
 * 開封通知の有効期限(日)を取得する.
 * 
 * @param r request_rec *
 * @return int 有効期限
 */
DIVY_DECLARE(int) divy_get_confirmreading_reservedday(request_rec *r);

/**
 * 指定されたu_spec, r が示すリソースが開封通知の自動解除用リクエストを受けるのに
 * 適切かどうか.
 *
 * @param r request_rec *
 * @param u_spec divy_uri_spec *
 * @return int 1: 有効 / 0: 無効 / -1: 無効だが特に不正アクセスのケース 
 */
DIVY_DECLARE(int) divy_confirmreading_enable(request_rec *r, divy_uri_spec *u_spec);

/**
 * resource が示すリクエストに基づき、開封通知の自動解除を実行する.
 *
 * @param r request_rec *
 * @param resource const dav_resource *
 * @return dav_error *
 */
DIVY_DECLARE(dav_error *) divy_confirmreading_release(request_rec *r, const dav_resource *resource);

#ifdef __cplusplus
}
#endif

#endif	/* INCLUDE_TF_CONFIRMREADING_H */

