/**
 * $Id$
 *
 * 拡張子マッピングを扱うための関数の宣言、データの定義などを集めたヘッダ
 *
 * (note)
 *   tf_autoindex に取り込まれていた機能を他から利用しなければならなくなったので
 *   ここに出しました.
 */
#ifndef INCLUDE_TF_EXTMAP_H
#define INCLUDE_TF_EXTMAP_H

#include "apr.h"
#include "apr_pools.h"
#include "apr_time.h"
#include "apr_hash.h"

#include "httpd.h"

#include "tfr.h"
#include "util_common.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*------------------------------------------------------------------------------
  Fixed values
  ----------------------------------------------------------------------------*/
/*
 * 特殊なContent-Type の定義(画面表示用に使用する)
 */
/* グループ(in 管理者) */
#define DIVY_CONTTYPE_MGRPFOLDER	"application/x-tf-mgroupfolder"
/* クライアント更新 */
#define DIVY_CONTTYPE_UPDATEDCL		"application/x-tf-updatedclfolder"
/* システムメッセージフォルダ */
#define DIVY_CONTTYPE_SYSMSGFOLDER	"application/x-tf-sysmessagefolder"
/* システムメッセージ */
#define DIVY_CONTTYPE_SYSMSG		"application/x-tf-sysmessage"
/* グループコレクションの上 */
#define DIVY_CONTTYPE_GRPCOLFOLDER	"application/x-tf-groupcolfolder"
/* グループコレクション */
#define DIVY_CONTTYPE_GRPCOL		"application/x-tf-groupcol"
/* プライベートコレクション */
#define DIVY_CONTTYPE_PRIVCOL		"application/x-tf-privatefolder"
/* ユーザ */
#define DIVY_CONTTYPE_MUSERFOLDER	"application/x-tf-muserfolder"
/* トップページロゴ */
#define DIVY_CONTTYPE_TOPPAGE		"application/x-tf-toppage"
/* メール編集 */
#define DIVY_CONTTYPE_EDITMAIL		"application/x-tf-editmail"
/* セキュリティ保護フォルダ */
#define DIVY_CONTTYPE_SECGRPCOLFOLDER	"application/x-tf-secgroupcol"
/* ログ取得機能 */
#ifdef DIVY_SUPPORT_LOGACCESS
#define DIVY_CONTTYPE_LOGACCESS		"application/x-tf-logaccess"
#endif	/* DIVY_SUPPORT_LOGACCESS */
/* 自動削除機能 */
#define DIVY_CONTTYPE_AUTODELETE	"application/x-tf-autodelete"
/* 操作ログ機能 */
#define DIVY_CONTTYPE_LOGOPERATION	"application/x-tf-logoperation"
/* ライセンスアップローダ */
#define DIVY_CONTTYPE_LICENSEUPLOADER	"application/x-tf-licenseuploader"
/* レポート設定 */
#define DIVY_CONTTYPE_REPORTSETTINGS "application/x-tf-reportsettings"
/* 書込み禁止グループフォルダ */
#define DIVY_CONTTYPE_ROGRPCOLFOLDER	"application/x-tf-rogroupcol"
/* BOX機能有効グループフォルダ */
#define DIVY_CONTTYPE_BOXGRPCOLFOLDER		"application/x-tf-boxgroupcol"
/* 書き込み禁止BOX機能有効グループフォルダ */
#define DIVY_CONTTYPE_ROBOXGRPCOLFOLDER		"application/x-tf-roboxgroupcol"

/* BOX設定フォルダ */
#define DIVY_CONTTYPE_BOXFOLDER			"application/x-tf-boxfolder"

/**
 * Content-Type、拡張子マッピングファイルの名前
 * (note)
 *   ここの名前はautodelhistory というシステムCGIも意識しています.
 *   変更するのなら両方の修正が必要となります.
 */
/* (デフォルトファイル) */
#define DIVY_MIMEMAP_FNAME_DEFAULT	"ai_mime.types.default"

/* (ユーザ定義ファイル) */
#define DIVY_MIMEMAP_FNAME	"ai_mime.types"

/*------------------------------------------------------------------------------
  Define structures
  ----------------------------------------------------------------------------*/
typedef struct divy_cmap_elem   divy_cmap_elem;
typedef struct divy_cmap        divy_cmap;

/**
 * Content-Type、拡張子マップから取得したあるデータを表す構造体
 */
struct divy_cmap_elem {
	char *ctype;
	char *ext;
	char *img_path;
	char *ctype_name;
};

/**
 * Content-Type、拡張子マップから取得したデータ集合を表す構造体
 */
struct divy_cmap {
	apr_hash_t *map_h;	/* マップ */
	apr_time_t timestamp;	/* 更新ファイルのタイムスタンプ */
};

/*------------------------------------------------------------------------------
  Declare public functions
  ----------------------------------------------------------------------------*/
/**
 * Content-Type、拡張子マップを読み込む.
 *
 * @param r request_rec *
 * @return apr_hash_t * マップへのポインタ
 */
DIVY_DECLARE(apr_hash_t *) divy_read_mimetype_map(request_rec *r);

/**
 * Content-Type 値 ctype または 拡張子ext に一致する拡張子マッピング情報を
 * 取得する.
 *
 * @param p apr_pool_t *
 * @param map_h apr_hash_t * 拡張子マップへのポインタ
 * @param ctype const char * Content-Type の値. NULL ならば無視
 * @param ext const char * 拡張子. NULL ならば無視
 * @return const divy_cmap_elem *
 */
DIVY_DECLARE(const divy_cmap_elem *) divy_get_extmapinfo(apr_pool_t *p, apr_hash_t *map_h,
														const char *ctype, const char *ext);

/**
 * Content-Type値 ctype から対応する表示名称を取得する.
 *
 * @param p apr_pool_t *
 * @param ctype const char *
 * @param map apr_hash_t * divy_read_mimetype_map で取得したマップへのポインタ
 * @return char * 取得した表示名
 */
DIVY_DECLARE(char *) divy_get_mimetype_dispname(apr_pool_t *p,
                                                const char *ctype, apr_hash_t *map);

/**
 * Content-Type値 ctype から対応するイメージパスを取得する.
 *
 * @param p apr_pool_t *
 * @param ctype const char *
 * @param map apr_hash_t * divy_read_mimetype_map で取得したマップへのポインタ
 * @return char * 取得したイメージパス
 */
DIVY_DECLARE(char *) divy_get_mimetype_imgpath(apr_pool_t *p,
                                               const char *ctype, apr_hash_t *map);

/**
 * デフォルト拡張子マッピングファイルのパスを取得する. (ユーティリティ関数)
 * 
 * @param apr_pool_t *p
 * @param stylesheetroot const char * スタイルシートが配置されるディレクトリパス(絶対パス)
 * @param lang const char * 言語パラメータ
 * @return char * デフォルト拡張子マッピングのパス
 */
DIVY_DECLARE(char *) divy_build_default_extmappath(apr_pool_t *p, const char *stylesheetroot, const char *lang);

/**
 * ユーザが書き換えた拡張子マッピングファイルのパスを取得する. (ユーティリティ関数)
 * 
 * @param apr_pool_t *p
 * @param stylesheetroot const char * スタイルシートが配置されるディレクトリパス(絶対パス)
 * @param lang const char * 言語パラメータ
 * @return char * 拡張子マッピングのパス
 */
DIVY_DECLARE(char *) divy_build_extmappath(apr_pool_t *p, const char *stylesheetroot, const char *lang);

#ifdef __cplusplus
}
#endif

#endif	/* INCLUDE_TF_EXTMAP_H */

