/**
 * $Id$
 *
 * BOX機能関連をまとめたファイル
 *
 */
#ifndef INCLUDE_TF_RDBO_BOX_H
#define INCLUDE_TF_RDBO_BOX_H

#include "httpd.h"
#include "apr.h"
#include "apr_pools.h"
#include "apr_hash.h"
#include "mod_dav.h"

#if APR_HAVE_SYS_TIME_H
#include <sys/time.h>
#endif
#ifdef HAVE_TIME_H
#include <time.h>
#endif

#include "tfr.h"
#include "mod_dav_tf.h"
#include "tf_db.h"
#include "tf_storage.h"
#include "tf_folder.h"
#include "tf_rdbo_util.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*--------------------------------------------------------------
  Define fixed values and macros
  --------------------------------------------------------------*/


/*------------------------------------------------------------------------------
  Define public functions 
  ----------------------------------------------------------------------------*/

/*
 * 短縮URLのBOX参照カウントを+1する
 * @param r       request_rec * リクエスト構造体
 * @param shorten const char* 	短縮文字列
 * @return int                  0: 成功 / 1: 失敗
 */
DIVY_DECLARE(int) divy_rdbo_box_update_viewcount(request_rec *r, const char* shorten);

/*
 * 短縮URLの文字列を元にBOXテーブルにある情報を取得する
 * @param r       request_rec *
 * @param shorten const char* 	短縮文字列
 * @return divy_rdbo_box構造体 / NULL: 失敗
 *
 */
DIVY_DECLARE(divy_rdbo_box *) divy_rdbo_get_box_property_by_shorten(request_rec *r, const char* shorten);

/*
 * 指定したグループに対してシステム権限のユーザ(名前は._guest_)を投入する
 * トランザクションは必ずなければなりません。この関数では作りません
 * 既に存在していた場合はdivy_rdbo_insert_rusr()でエラーとなりますが、
 * 通常のオペレーションでは追加エラーはでません
 *
 * @param r              request_rec *
 * @param divy_rdbo_grp  grp_pr *
 *
 */
DIVY_DECLARE(int) divy_rdbo_box_append_guest_user(request_rec *r, const divy_rdbo_grp *grp_pr, divy_db_transaction_ctx* ts_ctx);

/*
 * 指定したグループのBOX管理システムユーザを削除する
 * @param r              request_rec *
 * @param divy_rdbo_grp  grp_pr *
 */
DIVY_DECLARE(int) divy_rdbo_box_remove_guest_user(request_rec *r, const divy_rdbo_grp *grp_pr);

#ifdef __cplusplus
}
#endif

#endif /* INCLUDE_TF_RDBO_BOX_H */

