/**
 * $Id$
 *
 * 特殊フォルダ「クライアント更新」関連の関数をまとめたヘッダファイル
 */
#ifndef INCLUDE_TF_RDBO_CLUPDATE_H
#define INCLUDE_TF_RDBO_CLUPDATE_H

#include "apr.h"
#include "apr_pools.h"
#include "tf_rdbo_util.h"
#include "tf_rdbo.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*------------------------------------------------------------------------------
  Declare public functions 
  ----------------------------------------------------------------------------*/
/**
 * 指定されたuri が示す更新クライアントの情報を取得して返却する。
 *
 * select 対象のテーブル:
 *	divy_clmodule, dav_resource
 * (note)
 *	uri = $root/.management/UPDATE/$name
 *	$name : モジュール名称
 *
 * @param r request_rec *
 * @param uri const char * uriを表す文字列
 * @param clmodule_pr divy_rdbo_clmodule ** 取得した更新クライアント
 * @return int 処理ステータス (0: 成功 / 1: 失敗)
 */
DIVY_DECLARE(int) divy_rdbo_get_clmodule_property(request_rec *r,
					const char *uri,
					divy_rdbo_clmodule **clmodule_pr);

/**
 * 指定されたclmodule_pr が表す更新クライアントの情報を新規登録する。
 *
 * insert対象のテーブル:  divy_clmodule
 * (note) clmoudle_pr の必須項目:
 *	uri, version, lineup 
 *	registdtは自動的に補完します。
 * (note)
 *	同名のクライアントモジュールは登録出来ません。
 *
 * @param r request_rec *
 * @param clmodule_pr const divy_rdbo_clmodule * する更新クライアント
 * @param ts_ctx divy_db_transaction_ctx * トランザクションコンテキスト
 * @return int 処理ステータス (0: 成功 / 1: 失敗)
 */
DIVY_DECLARE(int) divy_rdbo_insert_clmodule_property(request_rec *r,
					const divy_rdbo_clmodule *clmodule_pr,
					divy_db_transaction_ctx *ts_ctx);

/**
 * 指定されたclmodule_pr が表す内容でクライアント更新情報を更新する。
 *
 * update 対象テーブル: divy_clmodule
 *	version, lineup
 *	上記のうち、updatedtは自動的に補完します。
 * (note) 以下のデータは更新できません。
 *	name, registdt
 * (note) ts_ctxがない場合は失敗します。
 *
 * @param r request_rec *
 * @param clmodule_pr const divy_rdbo_clmodule * 更新する更新クライアント
 * @param ts_ctx divy_db_transaction_ctx * トランザクションコンテキスト
 * @return int 処理ステータス (0: 成功 / 1: 失敗)
 */
DIVY_DECLARE(int) divy_rdbo_update_clmodule_property(request_rec *r,
					const divy_rdbo_clmodule *clmodule_pr,
					divy_db_transaction_ctx *ts_ctx);


#ifdef __cplusplus
}
#endif

#endif /* INCLUDE_TF_RDBO_CLUPDATE_H */

