/**
 * $Id$
 *
 * linkdbsearch、リポジトリ検索関連の関数をまとめたヘッダファイル
 */
#ifndef INCLUDE_TF_RDBO_LINKDB_H
#define INCLUDE_TF_RDBO_LINKDB_H

#include "apr.h"
#include "apr_pools.h"
#include "tf_rdbo_util.h"
#include "tf_rdbo.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*------------------------------------------------------------------------------
  Declare public functions 
  ----------------------------------------------------------------------------*/
/**
 *  指定されたSQL文により顧客DB検索に必要なSQL情報をリポジトリDBから集め、
 *  整合性をチェックし、顧客DB検索を実行して検索結果を返却する(linkdbsearch)
 *
 * @param params divy_rdbo_search_params * 入力パラメータ
 * @param screen divy_search_ldbs_iscreen * 入力値
 * @param output divy_rdbo_search_output * 出力結果へのポインタ(アロケート済み)
 * @return int ステータスコード(see search.c)
 */
DIVY_DECLARE(int) divy_rdbo_linkdbsearch(divy_rdbo_search_params *params,
						divy_search_ldbs_iscreen *screen,
						divy_rdbo_search_output *output);

#ifdef __cplusplus
}
#endif

#endif /* INCLUDE_TF_RDBO_LINKDB_H */
